/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.graphics.AbstractInheritedAttributeKey;

public abstract class WmiIntAttributeKey
extends AbstractInheritedAttributeKey
implements WmiAttributeKey {
    private static Integer[] INTEGER_POOL = new Integer[20];
    private String name;
    private int defaultValue;

    protected WmiIntAttributeKey(String string, int n) {
        this.name = string;
        this.defaultValue = n;
    }

    public WmiIntAttributeKey(String string, int n, int n2) {
        super(n2);
        this.name = string;
        this.defaultValue = n;
    }

    public boolean getBooleanValue(WmiAttributeSet wmiAttributeSet) {
        return this.getIntValue(wmiAttributeSet) != 0;
    }

    public abstract int getIntValue(WmiAttributeSet var1);

    public float getFloatValue(WmiAttributeSet wmiAttributeSet) {
        int n = this.getIntValue(wmiAttributeSet);
        return n;
    }

    public String getStringValue(WmiAttributeSet wmiAttributeSet) {
        int n = this.getIntValue(wmiAttributeSet);
        return Integer.toString(n);
    }

    public Object getValue(WmiAttributeSet wmiAttributeSet) {
        Integer n;
        int n2 = this.getIntValue(wmiAttributeSet);
        if (n2 < INTEGER_POOL.length && n2 >= 0) {
            n = INTEGER_POOL[n2];
            if (n == null) {
                WmiIntAttributeKey.INTEGER_POOL[n2] = n = new Integer(n2);
            }
        } else {
            n = new Integer(n2);
        }
        return n;
    }

    public void setBooleanValue(WmiAttributeSet wmiAttributeSet, boolean bl) {
        this.setIntValue(wmiAttributeSet, bl ? 1 : 0);
    }

    public abstract void setIntValue(WmiAttributeSet var1, int var2);

    public void setFloatValue(WmiAttributeSet wmiAttributeSet, float f) {
        this.setIntValue(wmiAttributeSet, Math.round(f));
    }

    public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
        int n = this.getDefaultValue();
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            WmiErrorLog.log(numberFormatException);
        }
        this.setIntValue(wmiAttributeSet, n);
    }

    public void setValue(WmiAttributeSet wmiAttributeSet, Object object) {
        if (object != null) {
            this.setStringValue(wmiAttributeSet, object.toString());
        } else {
            this.setIntValue(wmiAttributeSet, this.getDefaultValue());
        }
    }

    public String getAttributeName() {
        return this.name;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public int getAttributeType() {
        return 1;
    }

    public String toString() {
        return this.getAttributeName();
    }
}

