/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMapleCodeAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiUndoManager;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;

public class WmiMapleCodeModel
extends WmiAbstractModel {
    private String code;

    public WmiMapleCodeModel(WmiMathDocumentModel wmiMathDocumentModel) {
        super(wmiMathDocumentModel);
    }

    public boolean isVisible() {
        return false;
    }

    public WmiModelTag getTag() {
        return WmiModelTag.MAPLE_CODE;
    }

    public void update(String string) throws WmiNoUpdateAccessException {
        this.verifyUpdateLock();
        WmiMapleCodeModelEdit wmiMapleCodeModelEdit = null;
        if (string != null) {
            wmiMapleCodeModelEdit = new WmiMapleCodeModelEdit(this);
            wmiMapleCodeModelEdit.setPreupdateProperties(this.parent, this.attributes, this.code);
        }
        if (this.pending != null) {
            this.code = ((WmiMapleCodeModel)this.pending).code;
            if (this.attributes != this.pending.attributes) {
                this.attributes = this.pending.attributes;
            }
            this.parent = this.pending.parent;
        }
        if (wmiMapleCodeModelEdit != null) {
            wmiMapleCodeModelEdit.setPostupdateProperties(this.parent, this.attributes, this.code);
            WmiUndoManager wmiUndoManager = this.getDocument().getUndoManager();
            wmiUndoManager.addEdit(wmiMapleCodeModelEdit);
        }
        this.pending = null;
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMapleCodeAttributeSet();
    }

    public String getCode() throws WmiNoReadAccessException {
        String string = this.code;
        this.verifyReadLock();
        if (this.usePending() && this.pending instanceof WmiMapleCodeModel) {
            string = ((WmiMapleCodeModel)this.pending).code;
        }
        return string;
    }

    public void setCode(String string) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.createPendingModel();
        if (this.pending instanceof WmiMapleCodeModel) {
            ((WmiMapleCodeModel)this.pending).code = string;
        }
    }

    protected static class WmiMapleCodeModelEdit
    implements WmiUndoableEdit {
        private WmiMapleCodeModel model = null;
        private WmiAttributeSet oldAttributes = null;
        private WmiAttributeSet newAttributes = null;
        private String oldCode = null;
        private String newCode = null;
        private WmiCompositeModel oldParent = null;
        private WmiCompositeModel newParent = null;

        public WmiMapleCodeModelEdit(WmiMapleCodeModel wmiMapleCodeModel) {
            this.model = wmiMapleCodeModel;
        }

        protected void setPreupdateProperties(WmiCompositeModel wmiCompositeModel, WmiAttributeSet wmiAttributeSet, String string) {
            this.oldParent = wmiCompositeModel;
            this.oldAttributes = wmiAttributeSet;
            this.oldCode = string;
        }

        protected void setPostupdateProperties(WmiCompositeModel wmiCompositeModel, WmiAttributeSet wmiAttributeSet, String string) {
            this.newParent = wmiCompositeModel;
            this.newAttributes = wmiAttributeSet;
            this.newCode = string;
        }

        public void redo() throws WmiNoUpdateAccessException {
            this.model.verifyUpdateLock();
            this.model.parent = this.newParent;
            this.model.attributes = this.newAttributes;
            this.model.code = this.newCode;
            try {
                this.model.getDocument().notifyModelListeners(this.model, 0);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }

        public void undo() throws WmiNoUpdateAccessException {
            this.model.verifyUpdateLock();
            this.model.parent = this.oldParent;
            this.model.attributes = this.oldAttributes;
            this.model.code = this.oldCode;
            try {
                this.model.getDocument().notifyModelListeners(this.model, 0);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }
    }
}

