/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import java.util.HashSet;

public class WmiMathDocumentHierarchyValidator {
    private static final int DEFAULT_TABLE_SIZE = 150;
    private int tableSize;
    private boolean[][] dataTable;
    private boolean[] postDeleteMergePermission;
    private HashSet wrapperTypes = new HashSet();

    public WmiMathDocumentHierarchyValidator() {
        this.addLinks();
        this.addPostDeleteMergePermissions();
    }

    protected int getDefaultTableSize() {
        return 150;
    }

    protected void addLinks() {
        int n = this.getDefaultTableSize();
        this.dataTable = new boolean[n][];
        for (int i = 0; i < n; ++i) {
            this.dataTable[i] = new boolean[n];
        }
        this.tableSize = n;
        this.addLink(WmiModelTag.DOCUMENT, WmiModelTag.PARAGRAPH);
        this.addLink(WmiModelTag.PARAGRAPH, WmiModelTag.TEXT);
        this.addLink(WmiModelTag.PARAGRAPH, WmiModelTag.PLOT);
        this.addLink(WmiModelTag.PARAGRAPH, WmiModelTag.MATH);
        this.addLink(WmiModelTag.PARAGRAPH, WmiModelTag.METATAG_WRAPPER);
        this.addLink(WmiModelTag.METATAG_WRAPPER, WmiModelTag.TEXT);
        this.addMathLinks(WmiModelTag.MATH);
        this.addMathLinks(WmiModelTag.MATH_FRAC);
        this.addMathLinks(WmiModelTag.MATH_NROOT);
        this.addMathLinks(WmiModelTag.MATH_OVER);
        this.addMathLinks(WmiModelTag.MATH_ROW);
        this.addMathLinks(WmiModelTag.MATH_SQUARE_ROOT);
        this.addMathLinks(WmiModelTag.MATH_SUB_SUP);
        this.addMathLinks(WmiModelTag.MATH_SUBSCRIPT);
        this.addMathLinks(WmiModelTag.MATH_SUPERSCRIPT);
        this.addMathLinks(WmiModelTag.MATH_TABLE_CELL);
        this.addMathLinks(WmiModelTag.MATH_UNDER);
        this.addMathLinks(WmiModelTag.MATH_UNDER_OVER);
        this.addMathLinks(WmiModelTag.MATH_FENCED);
        this.addMathLinks(WmiModelTag.MATH_STYLE);
        this.addLink(WmiModelTag.MATH_TABLE, WmiModelTag.MATH_TABLE_ROW);
        this.addLink(WmiModelTag.MATH_TABLE_ROW, WmiModelTag.MATH_TABLE_CELL);
        this.addWrapperType(WmiModelTag.METATAG_WRAPPER);
    }

    protected void addPostDeleteMergePermissions() {
        int n = this.getDefaultTableSize();
        this.postDeleteMergePermission = new boolean[n];
        this.addPostDeletePermission(WmiModelTag.TEXT);
        this.addPostDeletePermission(WmiModelTag.PARAGRAPH);
    }

    protected void addPostDeletePermission(WmiModelTag wmiModelTag) {
        this.postDeleteMergePermission[wmiModelTag.getID()] = true;
    }

    public boolean hasPostDeletePermission(WmiModelTag wmiModelTag) {
        return this.postDeleteMergePermission[wmiModelTag.getID()];
    }

    protected void addMathLinks(WmiModelTag wmiModelTag) {
        this.addLink(wmiModelTag, WmiModelTag.MATH_ACTION);
        this.addLink(wmiModelTag, WmiModelTag.MATH_FENCED);
        this.addLink(wmiModelTag, WmiModelTag.MATH_FRAC);
        this.addLink(wmiModelTag, WmiModelTag.MATH_IDENTIFIER);
        this.addLink(wmiModelTag, WmiModelTag.MATH_NROOT);
        this.addLink(wmiModelTag, WmiModelTag.MATH_NUMERIC);
        this.addLink(wmiModelTag, WmiModelTag.MATH_OPERATOR);
        this.addLink(wmiModelTag, WmiModelTag.MATH_OVER);
        this.addLink(wmiModelTag, WmiModelTag.MATH_ROW);
        this.addLink(wmiModelTag, WmiModelTag.MATH_SPACE);
        this.addLink(wmiModelTag, WmiModelTag.MATH_SQUARE_ROOT);
        this.addLink(wmiModelTag, WmiModelTag.MATH_STRING);
        this.addLink(wmiModelTag, WmiModelTag.MATH_STYLE);
        this.addLink(wmiModelTag, WmiModelTag.MATH_SUB_SUP);
        this.addLink(wmiModelTag, WmiModelTag.MATH_SUBSCRIPT);
        this.addLink(wmiModelTag, WmiModelTag.MATH_SUBSCRIPT);
        this.addLink(wmiModelTag, WmiModelTag.MATH_SUPERSCRIPT);
        this.addLink(wmiModelTag, WmiModelTag.MATH_TABLE);
        this.addLink(wmiModelTag, WmiModelTag.MATH_TEXT);
        this.addLink(wmiModelTag, WmiModelTag.MATH_UNDER);
        this.addLink(wmiModelTag, WmiModelTag.MATH_UNDER_OVER);
    }

    protected void addLink(WmiModelTag wmiModelTag, WmiModelTag wmiModelTag2) {
        int n = wmiModelTag.getID();
        int n2 = wmiModelTag2.getID();
        if (n < this.tableSize && n2 < this.tableSize) {
            this.dataTable[n][n2] = true;
        }
    }

    protected void addWrapperType(WmiModelTag wmiModelTag) {
        this.wrapperTypes.add(wmiModelTag);
    }

    public boolean isValid(WmiModelTag wmiModelTag, WmiModelTag wmiModelTag2) {
        boolean bl = false;
        int n = wmiModelTag.getID();
        int n2 = wmiModelTag2.getID();
        if (n < this.tableSize && n2 < this.tableSize) {
            bl = this.dataTable[n][n2];
        }
        return bl;
    }

    public boolean isValid(WmiModel wmiModel, WmiModel[] wmiModelArray) throws WmiNoReadAccessException {
        boolean bl = true;
        WmiModelTag wmiModelTag = wmiModel.getTag();
        block0: for (int i = 0; i < wmiModelArray.length; ++i) {
            WmiModelTag wmiModelTag2 = wmiModelArray[i].getTag();
            if (this.wrapperTypes.contains(wmiModelTag2)) {
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)wmiModelArray[i];
                for (int j = 0; j < wmiCompositeModel.getChildCount(); ++j) {
                    if (this.isValid(wmiModelTag, wmiCompositeModel.getChild(j).getTag())) continue;
                    bl = false;
                    continue block0;
                }
                continue;
            }
            if (this.isValid(wmiModelTag, wmiModelTag2)) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

