/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import java.util.Arrays;
import java.util.HashMap;

public class WmiTransferModel
extends WmiAbstractArrayCompositeMathModel
implements WmiMathModel {
    private HashMap fonts = new HashMap();
    private WmiModelTag tag = null;
    private WmiMathSemantics semantics = null;

    public WmiTransferModel(WmiMathDocumentModel wmiMathDocumentModel) {
        super(wmiMathDocumentModel);
    }

    public WmiTransferModel(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        super(wmiCompositeModel.getDocument());
        this.attributes = wmiCompositeModel.getAttributesForRead();
        this.tag = wmiCompositeModel.getTag();
    }

    public WmiTransferModel(WmiCompositeModel wmiCompositeModel, int n, int n2) throws WmiNoReadAccessException {
        this(wmiCompositeModel);
        int n3;
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = wmiCompositeModel.getChildCount() - 1;
        }
        if ((n3 = n2 - n + 1) > 0) {
            this.children = new WmiModel[n3];
            for (int i = 0; i < n3; ++i) {
                this.children[i] = wmiCompositeModel.getChild(n + i);
            }
            this.length = n3;
        } else {
            this.children = new WmiModel[0];
            this.length = 0;
        }
        this.validateArrayForMath();
    }

    private void validateArrayForMath() {
        if (this.tag == WmiModelTag.MATH_SUPERSCRIPT || this.tag == WmiModelTag.MATH_SUBSCRIPT || this.tag == WmiModelTag.MATH_FRAC || this.tag == WmiModelTag.MATH_OVER || this.tag == WmiModelTag.MATH_UNDER || this.tag == WmiModelTag.MATH_NROOT) {
            this.correctChildCount(2);
        } else if (this.tag == WmiModelTag.MATH_UNDER_OVER || this.tag == WmiModelTag.MATH_SUB_SUP) {
            this.correctChildCount(3);
        } else if (this.tag == WmiModelTag.MATH_SQUARE_ROOT) {
            this.correctChildCount(1);
        }
    }

    private void correctChildCount(int n) {
        int n2 = this.children.length;
        WmiModel[] wmiModelArray = new WmiModel[n];
        boolean bl = false;
        if (n2 < n) {
            bl = true;
            int n3 = n - n2;
            System.arraycopy(this.children, 0, wmiModelArray, 0, n2);
            WmiMathContext wmiMathContext = new WmiMathContext((WmiFontAttributeSet)this.attributes);
            for (int i = n2; i < n; ++i) {
                wmiModelArray[i] = WmiMathFactory.createMathIdentifierToken(this.getDocument(), "?", wmiMathContext);
            }
        } else if (n2 > n) {
            bl = true;
            System.arraycopy(this.children, 0, wmiModelArray, 0, n);
        }
        if (bl) {
            this.length = n;
            this.children = wmiModelArray;
        }
    }

    public WmiTransferModel(WmiModel wmiModel) throws WmiNoReadAccessException {
        super(wmiModel.getDocument());
        this.children = new WmiModel[]{wmiModel};
        this.attributes = wmiModel.getAttributesForRead();
        this.tag = wmiModel.getTag();
    }

    public WmiAttributeSet getTransferAttributes() throws WmiNoReadAccessException {
        return this.attributes;
    }

    public void trim(int n) {
        if (n == this.length - 1) {
            this.children[this.length - 1] = null;
            --this.length;
        } else if (this.length - n - 1 > 0) {
            System.arraycopy(this.children, n + 1, this.children, n, this.length - n - 1);
            --this.length;
        }
    }

    public WmiTransferModel convertToTransferModel(int n) throws WmiNoReadAccessException {
        WmiTransferModel wmiTransferModel = null;
        WmiModel wmiModel = this.getChild(n);
        if (wmiModel instanceof WmiCompositeModel) {
            wmiTransferModel = new WmiTransferModel((WmiCompositeModel)wmiModel, 0, ((WmiCompositeModel)wmiModel).getChildCount() - 1);
            this.children[n] = wmiTransferModel;
        }
        return wmiTransferModel;
    }

    public HashMap getFonts() {
        return this.fonts;
    }

    public void addFont(String string, WmiFontAttributeSet wmiFontAttributeSet) {
        this.fonts.put(string, wmiFontAttributeSet);
    }

    public void replaceFirstChild(WmiModel wmiModel) {
        if (this.length > 0) {
            this.children[0] = wmiModel;
        }
    }

    public void replaceLastChild(WmiModel wmiModel) {
        if (this.length > 0) {
            this.children[this.length - 1] = wmiModel;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void replaceChildren(WmiModel[] wmiModelArray, int n, int n2) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.verifyWriteLock();
        this.createPendingModel();
        if (!(this.pending instanceof WmiAbstractArrayCompositeModel)) throw new WmiNoWriteAccessException(this);
        WmiAbstractArrayCompositeModel wmiAbstractArrayCompositeModel = (WmiAbstractArrayCompositeModel)this.pending;
        if (n < 0 || n > wmiAbstractArrayCompositeModel.length) {
            throw new WmiModelIndexOutOfBoundsException(this, n);
        }
        if (n2 < 0) {
            throw new WmiModelIndexOutOfBoundsException(this, n2);
        }
        int n3 = wmiAbstractArrayCompositeModel.length;
        if (n + n2 > n3) {
            throw new WmiModelIndexOutOfBoundsException(this, n + n2);
        }
        int n4 = wmiAbstractArrayCompositeModel.length - n2;
        int n5 = -n2;
        if (wmiModelArray != null) {
            n4 += wmiModelArray.length;
            n5 += wmiModelArray.length;
        }
        if (n4 < 0) throw new WmiModelIndexOutOfBoundsException(this, n4);
        wmiAbstractArrayCompositeModel.ensureCapacity(n4, this);
        if (n5 > 0) {
            System.arraycopy(wmiAbstractArrayCompositeModel.children, n, wmiAbstractArrayCompositeModel.children, n + n5, wmiAbstractArrayCompositeModel.length - n);
        } else if (n5 < 0) {
            System.arraycopy(wmiAbstractArrayCompositeModel.children, n - n5, wmiAbstractArrayCompositeModel.children, n, wmiAbstractArrayCompositeModel.length - n + n5);
            Arrays.fill(wmiAbstractArrayCompositeModel.children, wmiAbstractArrayCompositeModel.length + n5, wmiAbstractArrayCompositeModel.length, null);
        }
        if (wmiModelArray != null) {
            System.arraycopy(wmiModelArray, 0, wmiAbstractArrayCompositeModel.children, n, wmiModelArray.length);
        }
        wmiAbstractArrayCompositeModel.length = n4;
    }

    public WmiModel getFirstChild() {
        return this.length > 0 ? this.children[0] : null;
    }

    public WmiModel getLastChild() {
        return this.length > 0 ? this.children[this.length - 1] : null;
    }

    public int getChildCount() {
        return this.length;
    }

    public void update(String string) {
        WmiErrorLog.log(new Exception("IncompatibleOperation"));
    }

    public WmiModelTag getTag() {
        return this.tag;
    }

    public boolean isVisible() throws WmiNoReadAccessException {
        return true;
    }

    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    public void setSemantics(WmiMathSemantics wmiMathSemantics) {
        this.semantics = wmiMathSemantics;
    }

    public boolean useScriptSize(WmiModel wmiModel) throws WmiNoReadAccessException {
        return false;
    }

    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics != null ? this.semantics.toDag(this) : null;
    }
}

