/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;

public abstract class WmiBinaryOperatorBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    private static final int LEFT_SIDE = 0;
    private static final int RIGHT_SIDE = 1;

    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        Dag dag2 = dag.getChild(0);
        Dag dag3 = dag.getChild(1);
        WmiMathModel wmiMathModel = this.createModel(dag, dag2, dag3, this.getOperator(wmiMathContext), wmiMathDocumentModel, wmiMathContext);
        return wmiMathModel;
    }

    public WmiMathModel createModel(Dag dag, Dag dag2, Dag dag3, String string, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathSpaceModel wmiMathSpaceModel;
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        WmiAbstractArrayCompositeModel wmiAbstractArrayCompositeModel = wmiInlineMathModel;
        this.buildModelForTerm(dag, wmiMathDocumentModel, wmiMathContext, wmiAbstractArrayCompositeModel, dag2);
        if (this.addMSpacePadding(wmiMathContext)) {
            wmiMathSpaceModel = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiMathSpaceModel.addAttribute("width", "0.5em");
            wmiAbstractArrayCompositeModel.appendChild(wmiMathSpaceModel);
        }
        wmiAbstractArrayCompositeModel.appendChild(WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, string, wmiMathContext));
        if (this.addMSpacePadding(wmiMathContext)) {
            wmiMathSpaceModel = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiMathSpaceModel.addAttribute("width", "0.5em");
            wmiAbstractArrayCompositeModel.appendChild(wmiMathSpaceModel);
        }
        this.buildModelForTerm(dag, wmiMathDocumentModel, wmiMathContext, wmiAbstractArrayCompositeModel, dag3);
        wmiInlineMathModel.setSemantics(this);
        return wmiInlineMathModel;
    }

    protected boolean addMSpacePadding(WmiMathContext wmiMathContext) {
        return false;
    }

    protected void buildModelForTerm(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, WmiAbstractArrayCompositeModel wmiAbstractArrayCompositeModel, Dag dag2) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
        if (WmiPrecedenceRules.areBracketsRequired(dag2, dag, this.getPrecedenceRule())) {
            wmiMathModel = WmiMathFactory.addBrackets(wmiMathModel, wmiMathContext);
        }
        wmiAbstractArrayCompositeModel.appendChild(wmiMathModel);
    }

    protected abstract String getOperator(WmiMathContext var1);

    protected int getOperationPrecedence(Dag dag) {
        return DagBuilder.getPrecedence(dag);
    }

    protected int getPrecedenceRule() {
        return 0;
    }

    public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
        WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
        int n = wmiCompositeModel.getChildCount();
        Dag dag = null;
        if (n == 3) {
            WmiMathModel wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(0);
            WmiMathModel wmiMathModel3 = (WmiMathModel)wmiCompositeModel.getChild(2);
            Dag[] dagArray = new Dag[]{wmiMathModel2.toDag(), wmiMathModel3.toDag()};
            WmiSemanticDagUtil.fillNullDags(dagArray);
            dag = Dag.createDag(this.getDagType(), dagArray, null, false);
        }
        dag = WmiSemanticDagUtil.handleNullDag(dag, wmiMathModel);
        return dag;
    }

    public abstract int getDagType();
}

