/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiProcBuilder;

public class WmiForStatementBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    private static final int FOR_MINIMUM_MODEL_CHILDREN = 3;
    public static final String FOR_KEYWORD = "for";
    public static final String FROM_KEYWORD = "from";
    public static final String BY_KEYWORD = "by";
    public static final String TO_KEYWORD = "to";
    public static final String WHILE_KEYWORD = "while";
    public static final String IN_KEYWORD = "in";
    public static final String DO_KEYWORD = "do";
    public static final String OD_KEYWORD = "od";
    public static final String END_DO_KEYWORD = "end do";
    private static final int LONG_FORM_LENGTH = 6;
    private static final int FOR_MODEL_LENGTH = 5;
    private static final int LONG_FORM_STATEMENT_INDEX = 5;
    private static final int SHORT_FORM_STATEMENT_INDEX = 3;
    private static final int STATEMENT_MODEL_INDEX = 2;
    private static final int FOR_VAR_INDEX = 0;
    private static final int FROM_VAR_INDEX = 1;
    private static final int BY_VAR_INDEX = 2;
    private static final int LIMIT_VAR_INDEX = 3;
    private static final int CONDITIONAL_VAR_INDEX = 4;
    private static final int FOR_LINE_INDEX = 0;
    private static final int DAG_FOR_CLAUSE_INDEX = 0;
    private static final int DAG_TO_INDEX = 3;
    private static final int DAG_FROM_INDEX = 1;
    private static final int DAG_BY_INDEX = 2;
    private static final int DAG_LONG_STATESEQ_INDEX = 5;
    private static final int DAG_SHORT_STATESEQ_INDEX = 3;
    private static final int DAG_LONG_WHILE_INDEX = 4;
    private static final int DAG_SHORT_WHILE_INDEX = 2;
    private static final int DAG_IN_INDEX = 1;

    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel wmiInlineMathModel = null;
        int n = dag.getLength();
        int n2 = 0;
        WmiModel[] wmiModelArray = new WmiMathModel[5];
        if (n == 6) {
            wmiModelArray[0] = this.buildFirstLineLong(dag, wmiMathDocumentModel, wmiMathContext);
            n2 = 5;
        } else {
            wmiModelArray[0] = this.buildFirstLineShort(dag, wmiMathDocumentModel, wmiMathContext);
            n2 = 3;
        }
        wmiModelArray[1] = WmiProcBuilder.createLinebreakIndicator(wmiMathDocumentModel, WmiProcBuilder.PROC_INC_LINEBREAK_ATTR);
        wmiModelArray[2] = WmiProcBuilder.createStatementSequenceRow(dag.getChild(n2), wmiMathDocumentModel, wmiMathContext, false);
        wmiModelArray[3] = WmiProcBuilder.createLinebreakIndicator(wmiMathDocumentModel, WmiProcBuilder.PROC_DEC_LINEBREAK_ATTR);
        wmiModelArray[wmiModelArray.length - 1] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, WmiProcBuilder.getLongDelimProperty(wmiMathDocumentModel) ? END_DO_KEYWORD : OD_KEYWORD, wmiMathContext);
        try {
            wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray);
            wmiInlineMathModel.setSemantics(this);
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            WmiErrorLog.log(wmiInvalidModelInitializationException);
        }
        return wmiInlineMathModel;
    }

    private WmiMathModel buildFirstLineLong(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel wmiInlineMathModel = null;
        int n = 1;
        Dag dag2 = dag.getChild(0);
        boolean bl = !DagUtil.isNull(dag2);
        n += bl ? 4 : 0;
        Dag dag3 = dag.getChild(1);
        boolean bl2 = !DagUtil.isOne(dag3);
        n += bl2 ? 4 : 0;
        Dag dag4 = dag.getChild(2);
        boolean bl3 = !DagUtil.isOne(dag4);
        n += bl3 ? 4 : 0;
        Dag dag5 = dag.getChild(3);
        boolean bl4 = !DagUtil.isNull(dag5);
        n += bl4 ? 4 : 0;
        Dag dag6 = dag.getChild(4);
        boolean bl5 = !DagUtil.isName(dag6) || !DagUtil.isTrue(dag6);
        int n2 = bl5 ? 4 : 0;
        int n3 = 0;
        WmiModel[] wmiModelArray = new WmiMathModel[n += n2];
        if (bl) {
            wmiModelArray[n3++] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, FOR_KEYWORD, wmiMathContext);
            wmiModelArray[n3] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[n3++].addAttribute("width", "0.5em");
            wmiModelArray[n3++] = WmiProcBuilder.createStatementSequenceRow(dag2, wmiMathDocumentModel, wmiMathContext, false);
            wmiModelArray[n3] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[n3++].addAttribute("width", "0.5em");
        }
        if (bl2) {
            wmiModelArray[n3++] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, FROM_KEYWORD, wmiMathContext);
            wmiModelArray[n3] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[n3++].addAttribute("width", "0.5em");
            wmiModelArray[n3++] = WmiProcBuilder.createStatementSequenceRow(dag3, wmiMathDocumentModel, wmiMathContext, false);
            wmiModelArray[n3] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[n3++].addAttribute("width", "0.5em");
        }
        if (bl3) {
            wmiModelArray[n3++] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, BY_KEYWORD, wmiMathContext);
            wmiModelArray[n3] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[n3++].addAttribute("width", "0.5em");
            wmiModelArray[n3++] = WmiProcBuilder.createStatementSequenceRow(dag4, wmiMathDocumentModel, wmiMathContext, false);
            wmiModelArray[n3] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[n3++].addAttribute("width", "0.5em");
        }
        if (bl4) {
            wmiModelArray[n3++] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, TO_KEYWORD, wmiMathContext);
            wmiModelArray[n3] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[n3++].addAttribute("width", "0.5em");
            wmiModelArray[n3++] = WmiProcBuilder.createStatementSequenceRow(dag5, wmiMathDocumentModel, wmiMathContext, false);
            wmiModelArray[n3] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[n3++].addAttribute("width", "0.5em");
        }
        if (bl5) {
            wmiModelArray[n3++] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, WHILE_KEYWORD, wmiMathContext);
            wmiModelArray[n3] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[n3++].addAttribute("width", "0.5em");
            wmiModelArray[n3++] = WmiProcBuilder.createStatementSequenceRow(dag6, wmiMathDocumentModel, wmiMathContext, false);
            wmiModelArray[n3] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[n3++].addAttribute("width", "0.5em");
        }
        wmiModelArray[n3] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, DO_KEYWORD, wmiMathContext);
        try {
            wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray);
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            WmiErrorLog.log(wmiInvalidModelInitializationException);
        }
        return wmiInlineMathModel;
    }

    private WmiMathModel buildFirstLineShort(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel wmiInlineMathModel = null;
        Dag dag2 = dag.getChild(0);
        Dag dag3 = dag.getChild(1);
        Dag dag4 = dag.getChild(2);
        boolean bl = !DagUtil.isNull(dag2);
        boolean bl2 = !DagUtil.isOne(dag3);
        boolean bl3 = !DagUtil.isName(dag4) || !DagUtil.isTrue(dag4);
        int n = 0;
        int n2 = 1;
        n2 += bl ? 4 : 0;
        n2 += bl2 ? 4 : 0;
        WmiModel[] wmiModelArray = new WmiMathModel[n2 += bl3 ? 4 : 0];
        if (bl) {
            wmiModelArray[n++] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, FOR_KEYWORD, wmiMathContext);
            wmiModelArray[n] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[n++].addAttribute("width", "0.5em");
            wmiModelArray[n++] = WmiProcBuilder.createStatementSequenceRow(dag2, wmiMathDocumentModel, wmiMathContext, false);
            wmiModelArray[n] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[n++].addAttribute("width", "0.5em");
        }
        if (bl2) {
            wmiModelArray[n++] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, IN_KEYWORD, wmiMathContext);
            wmiModelArray[n] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[n++].addAttribute("width", "0.5em");
            wmiModelArray[n++] = WmiProcBuilder.createStatementSequenceRow(dag3, wmiMathDocumentModel, wmiMathContext, false);
            wmiModelArray[n] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[n++].addAttribute("width", "0.5em");
        }
        if (bl3) {
            wmiModelArray[n++] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, WHILE_KEYWORD, wmiMathContext);
            wmiModelArray[n] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[n++].addAttribute("width", "0.5em");
            wmiModelArray[n++] = WmiProcBuilder.createStatementSequenceRow(dag4, wmiMathDocumentModel, wmiMathContext, false);
            wmiModelArray[n] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[n++].addAttribute("width", "0.5em");
        }
        wmiModelArray[n] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, DO_KEYWORD, wmiMathContext);
        try {
            wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray);
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            WmiErrorLog.log(wmiInvalidModelInitializationException);
        }
        return wmiInlineMathModel;
    }

    public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
        WmiInlineMathModel wmiInlineMathModel;
        Dag dag = null;
        WmiModel wmiModel = wmiMathModel;
        while (wmiModel instanceof WmiInlineMathModel && ((WmiInlineMathModel)wmiModel).getChildCount() == 1) {
            wmiModel = ((WmiInlineMathModel)wmiModel).getChild(0);
        }
        if (wmiModel instanceof WmiInlineMathModel && (wmiInlineMathModel = (WmiInlineMathModel)wmiModel).getChildCount() > 3) {
            WmiModel wmiModel2;
            Dag[] dagArray = this.createDefaultForDagChildren();
            int n = 5;
            int n2 = 4;
            WmiModel wmiModel3 = this.retrieveForLine(wmiInlineMathModel);
            if (wmiModel3 instanceof WmiInlineMathModel) {
                wmiModel2 = (WmiInlineMathModel)wmiModel3;
                int n3 = ((WmiAbstractArrayCompositeModel)wmiModel2).getChildCount();
                for (int i = 0; i < n3; ++i) {
                    WmiModel wmiModel4 = ((WmiAbstractArrayCompositeModel)wmiModel2).getChild(i);
                    if (!(wmiModel4 instanceof WmiMathOperatorModel)) continue;
                    String string = ((WmiMathOperatorModel)wmiModel4).getText();
                    if (string.equals(FOR_KEYWORD)) {
                        i = this.populateChild(dagArray, (WmiInlineMathModel)wmiModel2, i, 0);
                        continue;
                    }
                    if (string.equals(IN_KEYWORD)) {
                        wmiModel4 = ((WmiAbstractArrayCompositeModel)wmiModel2).getChild(++i);
                        Dag[] dagArray2 = new Dag[4];
                        dagArray2[0] = dagArray[0];
                        dagArray2[1] = DagUtil.createExpSeqDag(new Dag[0]);
                        if (wmiModel4 instanceof WmiMathModel) {
                            dagArray2[1] = ((WmiMathModel)wmiModel4).toDag();
                        }
                        dagArray2[2] = dagArray[4];
                        dagArray2[3] = DagUtil.createExpSeqDag(new Dag[0]);
                        dagArray = dagArray2;
                        n = 3;
                        n2 = 2;
                        continue;
                    }
                    if (string.equals(WHILE_KEYWORD)) {
                        i = this.populateChild(dagArray, (WmiInlineMathModel)wmiModel2, i, n2);
                        continue;
                    }
                    if (string.equals(FROM_KEYWORD)) {
                        i = this.populateChild(dagArray, (WmiInlineMathModel)wmiModel2, i, 1);
                        continue;
                    }
                    if (string.equals(BY_KEYWORD)) {
                        i = this.populateChild(dagArray, (WmiInlineMathModel)wmiModel2, i, 2);
                        continue;
                    }
                    if (!string.equals(TO_KEYWORD)) continue;
                    i = this.populateChild(dagArray, (WmiInlineMathModel)wmiModel2, i, 3);
                }
            }
            if ((wmiModel2 = this.retrieveForStatSeq(wmiInlineMathModel)) instanceof WmiMathModel) {
                dagArray[n] = ((WmiMathModel)wmiModel2).toDag();
            }
            dag = Dag.createDag(42, dagArray, null, false);
        }
        return dag;
    }

    private int populateChild(Dag[] dagArray, WmiInlineMathModel wmiInlineMathModel, int n, int n2) throws WmiNoReadAccessException {
        WmiModel wmiModel;
        if ((wmiModel = wmiInlineMathModel.getChild(++n)) instanceof WmiMathModel) {
            dagArray[n2] = ((WmiMathModel)wmiModel).toDag();
        }
        return n;
    }

    private WmiModel retrieveForStatSeq(WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException {
        WmiInlineMathModel wmiInlineMathModel2 = null;
        for (int i = wmiInlineMathModel.getChildCount(); i > -1 && wmiInlineMathModel2 == null; --i) {
            WmiModel wmiModel = wmiInlineMathModel.getChild(i);
            if (!(wmiModel instanceof WmiInlineMathModel)) continue;
            wmiInlineMathModel2 = (WmiInlineMathModel)wmiModel;
        }
        return wmiInlineMathModel2;
    }

    private WmiModel retrieveForLine(WmiInlineMathModel wmiInlineMathModel) throws WmiNoReadAccessException {
        WmiModel wmiModel = wmiInlineMathModel.getChild(0);
        if (WmiModelUtil.isEmptyIdentifierModel(wmiModel)) {
            wmiModel = wmiInlineMathModel.getChild(1);
        }
        return wmiModel;
    }

    private Dag[] createDefaultForDagChildren() {
        Dag[] dagArray = new Dag[]{DagUtil.createExpSeqDag(new Dag[0]), DagConstants.ONE, DagConstants.ONE, DagUtil.createExpSeqDag(new Dag[0]), DagConstants.NAME_TRUE, DagUtil.createExpSeqDag(new Dag[0])};
        return dagArray;
    }
}

