/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiFontLabelRecord;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFormatOperation;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiSubexpressionProxyModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class WmiMathContext {
    private static final String LABEL_PREFIX = "%";
    private static WmiMathFormatOperation[] labelFormatters = new WmiMathFormatOperation[]{new WmiMathFormatOperation.WmiIdentifierFormat(), new WmiMathFormatOperation.WmiKeywordIdentifierFormat(), new WmiMathFormatOperation.WmiNumericFormat(), new WmiMathFormatOperation.WmiOperatorFormat(), new WmiMathFormatOperation.WmiKeywordOperatorFormat(), new WmiMathFormatOperation.WmiBracketOpFormat(), new WmiMathFormatOperation.WmiStringFormat()};
    private static final String ASSUMPTION_TEXT = "With assumptions on ";
    public static final String DEFAULT_IMAGINARY_UNIT = "I";
    public static final int UNKNOWN = 0;
    public static final int OUTPUT = 1;
    public static final int INPUT_2D = 2;
    public static final int TEXT_2D = 3;
    private static HashMap styleMap = new HashMap();
    private static WmiFontLabelRecord defaultRecord = new WmiFontLabelRecord();
    private RuntimeException recoverableErrorPresent;
    private WmiFontAttributeSet style = null;
    private int procCounter = 0;
    private int typesettingCounter = 0;
    private boolean maple11OrLater = true;
    private boolean inOperatorProc;
    private boolean labellingAllowed = false;
    private HashSet assumedVariableSet = new HashSet();
    private Set subexpressionSet = new LinkedHashSet();
    private int labelCount = 0;
    private Map dagToLabelId = new LinkedHashMap();
    private Map idToModel = new LinkedHashMap();
    private boolean splitModel = false;
    private boolean enableMapleSyntaxMapping = true;
    private boolean enableOperatorPadding = true;
    private String formatMask;
    private boolean applyInteger = false;
    private boolean applyRational = false;
    private boolean engineeringNotation = false;
    private boolean inRational = false;
    private boolean applyNumericFormattingOnBuild = false;

    public WmiMathContext(WmiFontAttributeSet wmiFontAttributeSet) {
        this.style = wmiFontAttributeSet;
        this.labellingAllowed = WmiMathFactory.isSubexpressionLabellingOn();
    }

    public WmiMathModel reportSubexpressions(WmiMathDocumentModel wmiMathDocumentModel) {
        Iterator iterator = this.idToModel.keySet().iterator();
        WmiMathTableModel wmiMathTableModel = new WmiMathTableModel(wmiMathDocumentModel);
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            WmiModel[] wmiModelArray = new WmiMathModel[3];
            WmiMathModel wmiMathModel = (WmiMathModel)this.idToModel.get(n);
            try {
                wmiModelArray[0] = new WmiSubexpressionProxyModel(wmiMathDocumentModel, LABEL_PREFIX + n.toString(), wmiMathModel, this);
                wmiModelArray[1] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "=", this);
                wmiModelArray[2] = wmiMathModel;
                WmiMathTableModel.WmiMathTableDataModel wmiMathTableDataModel = new WmiMathTableModel.WmiMathTableDataModel(wmiMathDocumentModel, new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray));
                WmiMathTableModel.WmiMathTableRowModel wmiMathTableRowModel = new WmiMathTableModel.WmiMathTableRowModel(wmiMathDocumentModel, wmiMathTableDataModel);
                wmiMathTableModel.appendChild(wmiMathTableRowModel);
            }
            catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                WmiErrorLog.log(wmiInvalidModelInitializationException);
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
        }
        return wmiMathTableModel;
    }

    public boolean isSubexpressionLabellingActive() {
        return this.labellingAllowed;
    }

    public boolean needsSubexpressionLabelDetails() {
        return this.idToModel.size() > 0;
    }

    public void addDuplicate(Dag dag) {
        this.subexpressionSet.add(dag);
    }

    public boolean shouldSubExpressionLabel(WmiMathModel wmiMathModel, Dag dag) {
        boolean bl;
        boolean bl2 = bl = this.isSubexpressionLabellingActive() && this.subexpressionSet.contains(dag);
        if (bl) {
            try {
                int n = this.estimateModelWidth(wmiMathModel, 0);
                bl = n >= WmiMathFactory.getLabelWidth();
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
                bl = false;
            }
        }
        return bl;
    }

    private int estimateModelWidth(WmiMathModel wmiMathModel, int n) throws WmiNoReadAccessException {
        if (wmiMathModel instanceof WmiTextModel) {
            n += ((WmiTextModel)((Object)wmiMathModel)).getLength();
        } else if (wmiMathModel instanceof WmiCompositeModel) {
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
            int n2 = wmiCompositeModel.getChildCount();
            for (int i = 0; i < n2; ++i) {
                n = this.estimateModelWidth((WmiMathModel)wmiCompositeModel.getChild(i), n);
            }
        }
        return n;
    }

    public WmiMathModel createSubexpressionLabel(WmiMathModel wmiMathModel, Dag dag) {
        Integer n = null;
        if (this.dagToLabelId.containsKey(dag)) {
            n = (Integer)this.dagToLabelId.get(dag);
        }
        if (n == null) {
            n = new Integer(++this.labelCount);
            this.dagToLabelId.put(dag, n);
            this.idToModel.put(n, wmiMathModel);
        }
        return new WmiSubexpressionProxyModel(wmiMathModel.getDocument(), LABEL_PREFIX + n.toString(), wmiMathModel, this);
    }

    public void makeAssumption(String string) {
        this.assumedVariableSet.add(string);
    }

    public boolean needsAssumptionSummary() {
        return this.assumedVariableSet.size() > 0;
    }

    public WmiMathModel reportAssumptions(WmiMathDocumentModel wmiMathDocumentModel) {
        StringBuffer stringBuffer = new StringBuffer(ASSUMPTION_TEXT);
        Iterator iterator = this.assumedVariableSet.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, stringBuffer.toString(), this);
        this.assumedVariableSet.clear();
        return wmiMathTokenModel;
    }

    public WmiFontAttributeSet getStyle() {
        return this.style;
    }

    public boolean isInProc() {
        return this.procCounter > 0;
    }

    public void enableSyntaxMapping(boolean bl) {
        this.enableMapleSyntaxMapping = bl;
    }

    public void enableOperatorPadding(boolean bl) {
        this.enableOperatorPadding = bl;
    }

    public boolean isSyntaxMappingEnabled() {
        return this.enableMapleSyntaxMapping;
    }

    public boolean isOperatorPaddingEnabled() {
        return this.enableOperatorPadding;
    }

    public WmiMathAttributeSet createAttributes(int n) {
        WmiMathAttributeSet wmiMathAttributeSet;
        WmiFontLabelRecord wmiFontLabelRecord;
        WmiFontLabelRecord wmiFontLabelRecord2 = wmiFontLabelRecord = this.style != null ? (WmiFontLabelRecord)styleMap.get(this.style) : defaultRecord;
        if (wmiFontLabelRecord == null) {
            wmiFontLabelRecord = new WmiFontLabelRecord();
            styleMap.put(this.style, wmiFontLabelRecord);
        }
        if (n < 0 || n >= 7) {
            n = 0;
        }
        if ((wmiMathAttributeSet = wmiFontLabelRecord.getAttributesForType(n)) == null) {
            wmiMathAttributeSet = this.style != null ? new WmiMathAttributeSet(this.style) : new WmiMathAttributeSet();
            wmiMathAttributeSet.addAttribute("Typesetting:-msemantics", null);
            labelFormatters[n].format(wmiMathAttributeSet);
            WmiAbstractArrayAttributeSet wmiAbstractArrayAttributeSet = wmiMathAttributeSet.pack();
            if (wmiAbstractArrayAttributeSet instanceof WmiMathAttributeSet) {
                wmiMathAttributeSet = (WmiMathAttributeSet)wmiAbstractArrayAttributeSet;
            }
            wmiFontLabelRecord.setAttributesForType(n, wmiMathAttributeSet);
        }
        return wmiMathAttributeSet;
    }

    public String getImaginaryUnit() {
        return DEFAULT_IMAGINARY_UNIT;
    }

    public void incrementProcCounter() {
        ++this.procCounter;
    }

    public void decrementProcCounter() {
        if (this.procCounter > 0) {
            --this.procCounter;
        }
    }

    public int getProcCount() {
        return this.procCounter;
    }

    public void incrementTypesettingCounter() {
        ++this.typesettingCounter;
    }

    public void decrementTypesettingCounter() {
        if (this.typesettingCounter > 0) {
            --this.typesettingCounter;
        }
    }

    public int getTypesettingCount() {
        return this.typesettingCounter;
    }

    public void setOperatorProc(boolean bl) {
        this.inOperatorProc = bl;
    }

    public boolean isInOperatorProc() {
        return this.inOperatorProc;
    }

    public boolean useProcRules() {
        return this.isInProc() && (!this.isInOperatorProc() || this.procCounter != 1);
    }

    public int getRenderMode() {
        if (this.style == null) {
            return 0;
        }
        String string = this.style.getFontStyleName();
        if ("2D Output".equals(string)) {
            return 1;
        }
        if ("2D Input".equals(string)) {
            return 2;
        }
        return 0;
    }

    public boolean hasRecoverableErrorOccured() {
        return this.recoverableErrorPresent != null;
    }

    public void recordRecoverableError(RuntimeException runtimeException) {
        this.recoverableErrorPresent = runtimeException;
    }

    public RuntimeException getRecoverableError() {
        RuntimeException runtimeException = this.recoverableErrorPresent;
        this.recoverableErrorPresent = null;
        return runtimeException;
    }

    public void setSplitModel(boolean bl) {
        this.splitModel = bl;
    }

    public boolean isSplittingModel() {
        return this.splitModel;
    }

    public String getFormatMask() {
        return this.formatMask;
    }

    public void setFormatMask(String string) {
        this.formatMask = string;
    }

    public boolean isApplyInteger() {
        return this.applyInteger;
    }

    public void setApplyInteger(boolean bl) {
        this.applyInteger = bl;
    }

    public boolean isApplyRational() {
        return this.applyRational;
    }

    public void setApplyRational(boolean bl) {
        this.applyRational = bl;
    }

    public boolean isInRational() {
        return this.inRational;
    }

    public void setInRational(boolean bl) {
        this.inRational = bl;
    }

    public boolean isEngineeringNotation() {
        return this.engineeringNotation;
    }

    public void setEngineeringNotation(boolean bl) {
        this.engineeringNotation = bl;
    }

    public void setStyle(WmiFontAttributeSet wmiFontAttributeSet) {
        this.style = wmiFontAttributeSet;
    }

    public boolean isApplyNumericFormattingOnBuild() {
        return this.applyNumericFormattingOnBuild;
    }

    public void setApplyNumericFormattingOnBuild(boolean bl) {
        this.applyNumericFormattingOnBuild = bl;
    }

    public boolean isMaple11OrLater() {
        return this.maple11OrLater;
    }

    public void setMaple11OrLater(boolean bl) {
        this.maple11OrLater = bl;
    }
}

