/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiEnumeratedAttributeKey;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.WmiValidForTypeMK;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiDimensionUnit;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import java.util.HashMap;

public class WmiMathSpaceModel
extends WmiAbstractMathTokenModel
implements WmiMathModel,
WmiValidForTypeMK {
    private WmiMathSemantics semantics;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String DEPTH = "depth";
    public static final String LINEBREAK = "linebreak";
    public static final String LINEBREAK_AUTO = "auto";
    public static final String LINEBREAK_NEWLINE = "newline";
    public static final String LINEBREAK_INDENTING_NEWLINE = "indentingnewline";
    public static final String LINEBREAK_INCREASE_INDENT_NEWLINE = "increaseindentnewline";
    public static final String LINEBREAK_DECREASE_INDENT_NEWLINE = "decreaseindentnewline";
    public static final String LINEBREAK_FIRSTPROC_NEWLINE = "firstprocnewline";
    public static final String LINEBREAK_NO_BREAK = "nobreak";
    public static final String LINEBREAK_GOOD_BREAK = "goodbreak";
    public static final String LINEBREAK_BAD_BREAK = "badbreak";

    public WmiMathSpaceModel(WmiMathDocumentModel wmiMathDocumentModel) {
        super(wmiMathDocumentModel);
        try {
            this.setAttributes(this.createCompatibleAttributeSet());
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathSpaceModel(WmiMathDocumentModel wmiMathDocumentModel, String string) {
        super(wmiMathDocumentModel, string);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathSpaceModel(WmiMathDocumentModel wmiMathDocumentModel, String string, WmiAttributeSet wmiAttributeSet) {
        super(wmiMathDocumentModel, string);
        try {
            this.setAttributes(wmiAttributeSet);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiModelTag getTag() {
        return WmiModelTag.MATH_SPACE;
    }

    public Dag toDag() throws WmiNoReadAccessException {
        Dag dag = this.semantics != null ? this.semantics.toDag(this) : null;
        return dag;
    }

    public void setSemantics(WmiMathSemantics wmiMathSemantics) {
        this.semantics = wmiMathSemantics;
    }

    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    public void setAttributes(WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        if (wmiAttributeSet instanceof WmiMathSpaceAttributeSet) {
            super.setAttributes(wmiAttributeSet);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathSpaceAttributeSet();
    }

    public boolean forceSave(Object object, Object object2) {
        return false;
    }

    public boolean useScriptSize(WmiModel wmiModel) {
        return false;
    }

    public Dag getTypeMk() {
        return null;
    }

    public boolean suppliesOwnTypeMK() {
        return false;
    }

    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    public static class WmiMathSpaceAttributeSet
    extends WmiMathAttributeSet {
        public static final String[] ATTRIBUTES = new String[]{"height", "width", "depth", "linebreak"};
        private static final WmiDimensionUnit DEFAULT_HEIGHT = WmiDimensionUnit.createDimension("0ex", null);
        private static final WmiDimensionUnit DEFAULT_WIDTH = WmiDimensionUnit.createDimension("0em", null);
        private static final WmiDimensionUnit DEFAULT_DEPTH = WmiDimensionUnit.createDimension("0ex", null);
        public static final int DEFAULT_LINEBREAK = 0;
        public static final String[] LINEBREAK_OPTIONS = new String[]{"auto", "nobreak", "newline", "indentingnewline", "goodbreak", "badbreak", "increaseindentnewline", "decreaseindentnewline", "firstprocnewline"};
        public static final WmiAttributeKey[] SPACE_KEYS = new WmiAttributeKey[]{new HeightKey(), new WidthKey(), new DepthKey(), new LinebreakKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiFontAttributeSet.ATTRIBUTE_KEYS, SPACE_KEYS);
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();
        private WmiDimensionUnit height = DEFAULT_HEIGHT;
        private WmiDimensionUnit width = DEFAULT_WIDTH;
        private WmiDimensionUnit depth = DEFAULT_DEPTH;
        private int linebreak = 0;

        public WmiMathSpaceAttributeSet() {
        }

        public WmiMathSpaceAttributeSet(WmiMathSpaceAttributeSet wmiMathSpaceAttributeSet) {
            super(wmiMathSpaceAttributeSet);
            this.width = wmiMathSpaceAttributeSet.width;
            this.height = wmiMathSpaceAttributeSet.height;
            this.depth = wmiMathSpaceAttributeSet.depth;
            this.linebreak = wmiMathSpaceAttributeSet.linebreak;
        }

        public void addAttributes(WmiAttributeSet wmiAttributeSet) {
            super.addAttributes(wmiAttributeSet);
            if (wmiAttributeSet instanceof WmiMathSpaceAttributeSet) {
                WmiMathSpaceAttributeSet wmiMathSpaceAttributeSet = (WmiMathSpaceAttributeSet)wmiAttributeSet;
                this.width = wmiMathSpaceAttributeSet.width;
                this.height = wmiMathSpaceAttributeSet.height;
                this.depth = wmiMathSpaceAttributeSet.depth;
                this.linebreak = wmiMathSpaceAttributeSet.linebreak;
            }
        }

        public String getLinebreak() {
            return LINEBREAK_OPTIONS[this.linebreak];
        }

        public WmiDimensionUnit getWidth() {
            return this.width == null ? DEFAULT_WIDTH : this.width;
        }

        public WmiDimensionUnit getHeight() {
            return this.height == null ? DEFAULT_HEIGHT : this.height;
        }

        public WmiDimensionUnit getDepth() {
            return this.depth == null ? DEFAULT_DEPTH : this.depth;
        }

        public WmiAttributeSet copyAttributes() {
            return new WmiMathSpaceAttributeSet(this);
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (this == object) {
                bl = true;
            } else if (super.equals(object) && object instanceof WmiMathSpaceAttributeSet) {
                WmiMathSpaceAttributeSet wmiMathSpaceAttributeSet = (WmiMathSpaceAttributeSet)object;
                bl = wmiMathSpaceAttributeSet.linebreak == this.linebreak;
                bl &= this.height.equals(wmiMathSpaceAttributeSet.height);
                bl &= this.width.equals(wmiMathSpaceAttributeSet.width);
                bl &= this.depth.equals(wmiMathSpaceAttributeSet.depth);
            }
            return bl;
        }

        public int hashCode() {
            int n = super.hashCode();
            n ^= this.linebreak;
            n ^= this.height.hashCode();
            n ^= this.width.hashCode();
            return n ^= this.depth.hashCode();
        }

        protected HashMap getKeyMap() {
            return keyMap;
        }

        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS;
        }

        protected void setKeyMap(HashMap hashMap) {
            keyMap = hashMap;
        }

        public HashMap getCache() {
            return cache;
        }

        public static class LinebreakKey
        extends WmiEnumeratedAttributeKey {
            protected LinebreakKey() {
                super(WmiMathSpaceModel.LINEBREAK, LINEBREAK_OPTIONS, 0);
            }

            public int getIntValue(WmiAttributeSet wmiAttributeSet) {
                return ((WmiMathSpaceAttributeSet)wmiAttributeSet).linebreak;
            }

            public void setIntValue(WmiAttributeSet wmiAttributeSet, int n) {
                ((WmiMathSpaceAttributeSet)wmiAttributeSet).linebreak = n;
            }
        }

        public static class DepthKey
        extends DimensionKey {
            public DepthKey() {
                super(WmiMathSpaceModel.DEPTH, DEFAULT_DEPTH);
            }

            public WmiDimensionUnit getDimension(WmiMathSpaceAttributeSet wmiMathSpaceAttributeSet) {
                return wmiMathSpaceAttributeSet.depth;
            }

            public void setDimension(WmiMathSpaceAttributeSet wmiMathSpaceAttributeSet, WmiDimensionUnit wmiDimensionUnit) {
                wmiMathSpaceAttributeSet.depth = wmiDimensionUnit;
            }
        }

        public static class WidthKey
        extends DimensionKey {
            public WidthKey() {
                super(WmiMathSpaceModel.WIDTH, DEFAULT_WIDTH);
            }

            public WmiDimensionUnit getDimension(WmiMathSpaceAttributeSet wmiMathSpaceAttributeSet) {
                return wmiMathSpaceAttributeSet.width;
            }

            public void setDimension(WmiMathSpaceAttributeSet wmiMathSpaceAttributeSet, WmiDimensionUnit wmiDimensionUnit) {
                wmiMathSpaceAttributeSet.width = wmiDimensionUnit;
            }
        }

        public static class HeightKey
        extends DimensionKey {
            public HeightKey() {
                super(WmiMathSpaceModel.HEIGHT, DEFAULT_HEIGHT);
            }

            public WmiDimensionUnit getDimension(WmiMathSpaceAttributeSet wmiMathSpaceAttributeSet) {
                return wmiMathSpaceAttributeSet.height;
            }

            public void setDimension(WmiMathSpaceAttributeSet wmiMathSpaceAttributeSet, WmiDimensionUnit wmiDimensionUnit) {
                wmiMathSpaceAttributeSet.height = wmiDimensionUnit;
            }
        }

        public static abstract class DimensionKey
        extends WmiStringAttributeKey {
            private WmiDimensionUnit defaultDimension;

            public DimensionKey(String string, WmiDimensionUnit wmiDimensionUnit) {
                super(string, null);
                this.defaultDimension = wmiDimensionUnit;
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                Object object = this.getValue(wmiAttributeSet);
                return object != null ? object.toString() : null;
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                this.setValue(wmiAttributeSet, string);
            }

            public Object getValue(WmiAttributeSet wmiAttributeSet) {
                return this.getDimension((WmiMathSpaceAttributeSet)wmiAttributeSet);
            }

            public void setValue(WmiAttributeSet wmiAttributeSet, Object object) {
                WmiDimensionUnit wmiDimensionUnit = null;
                wmiDimensionUnit = object instanceof WmiDimensionUnit ? (WmiDimensionUnit)object : WmiDimensionUnit.createDimension(object.toString(), this.defaultDimension);
                this.setDimension((WmiMathSpaceAttributeSet)wmiAttributeSet, wmiDimensionUnit);
            }

            public abstract WmiDimensionUnit getDimension(WmiMathSpaceAttributeSet var1);

            public abstract void setDimension(WmiMathSpaceAttributeSet var1, WmiDimensionUnit var2);
        }
    }
}

