/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTextModel;
import java.util.ArrayList;
import java.util.HashMap;

public class WmiMathStringModel
extends WmiAbstractMathTokenModel
implements WmiMathModel,
WmiFontAttributeSource {
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    public static final String LEFT_QUOTE = "lquote";
    public static final String RIGHT_QUOTE = "rquote";
    public static final String DEFAULT_QUOTE = "\"";
    private WmiMathSemantics semantics = null;
    private String contentWithQuotes = null;

    public WmiMathStringModel(WmiMathDocumentModel wmiMathDocumentModel, String string, WmiMathContext wmiMathContext) {
        super(wmiMathDocumentModel, string, wmiMathContext);
        WmiMathStringAttributeSet wmiMathStringAttributeSet = new WmiMathStringAttributeSet();
        try {
            WmiMathAttributeSet wmiMathAttributeSet = wmiMathContext.createAttributes(6);
            wmiMathStringAttributeSet.addAttributes(wmiMathAttributeSet);
            this.setAttributes(wmiMathStringAttributeSet);
            this.syncQuotedContent();
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics != null ? this.semantics.toDag(this) : null;
    }

    public WmiModelTag getTag() {
        return WmiModelTag.MATH_STRING;
    }

    public void setAttributes(WmiAttributeSet wmiAttributeSet) throws WmiNoWriteAccessException {
        if (wmiAttributeSet instanceof WmiMathStringAttributeSet) {
            super.setAttributes(wmiAttributeSet);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    protected WmiAttributeSet createCompatibleAttributeSet() {
        WmiMathStringAttributeSet wmiMathStringAttributeSet = new WmiMathStringAttributeSet();
        return wmiMathStringAttributeSet;
    }

    protected boolean enableMapleSyntaxMapping() {
        return false;
    }

    protected boolean checkForQuotes() {
        return false;
    }

    public void update(String string) throws WmiNoUpdateAccessException {
        super.update(string);
    }

    protected WmiAbstractMathTokenModel.WmiTokenModelEdit createMathTextEdit() {
        return new WmiStringModelEdit(this);
    }

    protected void updateValuesFromPending() throws WmiNoUpdateAccessException {
        super.updateValuesFromPending();
        this.contentWithQuotes = ((WmiMathStringModel)this.pending).contentWithQuotes;
    }

    public void setSemantics(WmiMathSemantics wmiMathSemantics) {
        this.semantics = wmiMathSemantics;
    }

    private void syncQuotedContent() throws WmiNoReadAccessException {
        WmiAttributeSet wmiAttributeSet = this.getAttributesForRead();
        if (wmiAttributeSet instanceof WmiMathStringAttributeSet) {
            WmiMathStringAttributeSet wmiMathStringAttributeSet = (WmiMathStringAttributeSet)wmiAttributeSet;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(wmiMathStringAttributeSet.getLeftQuote());
            stringBuffer.append(super.getText());
            stringBuffer.append(wmiMathStringAttributeSet.getRightQuote());
            this.contentWithQuotes = stringBuffer.toString();
        }
    }

    public String getText() throws WmiNoReadAccessException {
        String string = this.contentWithQuotes;
        if (this.pending instanceof WmiMathStringModel) {
            string = ((WmiMathStringModel)this.pending).contentWithQuotes;
        }
        return string;
    }

    public void deleteText(int n, int n2) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int n3 = 0;
        try {
            int n4 = this.getLength();
            WmiAttributeSet wmiAttributeSet = this.getAttributes();
            WmiMathStringAttributeSet wmiMathStringAttributeSet = null;
            if (wmiAttributeSet instanceof WmiMathStringAttributeSet) {
                wmiMathStringAttributeSet = (WmiMathStringAttributeSet)wmiAttributeSet;
            }
            String string = wmiMathStringAttributeSet.getLeftQuote();
            String string2 = wmiMathStringAttributeSet.getRightQuote();
            if (n == 0 && string.length() > 0) {
                wmiMathStringAttributeSet.addAttribute(LEFT_QUOTE, "");
                this.setAttributes(wmiMathStringAttributeSet);
                ++n3;
            }
            if (n + n2 == n4 && string2.length() > 0) {
                wmiMathStringAttributeSet.addAttribute(RIGHT_QUOTE, "");
                this.setAttributes(wmiMathStringAttributeSet);
                ++n3;
            }
            this.replaceText(null, n, n2 - n3);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            this.replaceText(null, n, n2 - n3);
        }
    }

    public void replaceText(String string, int n, int n2) throws WmiModelIndexOutOfBoundsException, WmiNoWriteAccessException {
        WmiAttributeSet wmiAttributeSet;
        int n3 = 0;
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        boolean bl2 = false;
        try {
            WmiAttributeSet wmiAttributeSet2 = this.getAttributes();
            if (wmiAttributeSet2 instanceof WmiMathStringAttributeSet) {
                string2 = ((WmiMathStringAttributeSet)wmiAttributeSet2).getLeftQuote();
                string3 = ((WmiMathStringAttributeSet)wmiAttributeSet2).getRightQuote();
                bl = string2 != null && string2.length() > 0;
                bl2 = string3 != null && string3.length() > 0;
            }
            n3 = this.getLength();
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        int n4 = n;
        n4 -= n != 0 && bl ? 1 : 0;
        int n5 = n4 = (n4 -= n == n3 && bl2 ? 1 : 0) < 0 ? 0 : n4;
        if (n == 0 && string2.equals("") && string != null && string.equals(DEFAULT_QUOTE)) {
            try {
                wmiAttributeSet = this.getAttributes();
                wmiAttributeSet.addAttribute(LEFT_QUOTE, null);
                this.setAttributes(wmiAttributeSet);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        } else if (n == n3 && string3.equals("") && string != null && string.equals(DEFAULT_QUOTE)) {
            try {
                wmiAttributeSet = this.getAttributes();
                wmiAttributeSet.addAttribute(RIGHT_QUOTE, null);
                this.setAttributes(wmiAttributeSet);
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        } else {
            super.replaceText(string, n4, n2);
        }
        if (this.pending instanceof WmiMathStringModel) {
            try {
                ((WmiMathStringModel)this.pending).syncQuotedContent();
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
        }
    }

    public String getSubstring(int n, int n2) throws WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
        String string = null;
        String string2 = this.getText();
        if (string2 != null) {
            if (n < 0) {
                throw new WmiModelIndexOutOfBoundsException(this, n);
            }
            if (n + n2 > string2.length()) {
                throw new WmiModelIndexOutOfBoundsException(this, n + n2);
            }
            string = string2.substring(n, n + n2);
        }
        return string;
    }

    public int getLength() throws WmiNoReadAccessException {
        return this.getText().length();
    }

    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    public boolean useScriptSize(WmiModel wmiModel) throws WmiNoReadAccessException {
        return false;
    }

    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object object;
        String string = null;
        WmiAttributeSet wmiAttributeSet = this.getAttributesForRead();
        if (wmiAttributeSet != null && (object = wmiAttributeSet.getAttribute("font_style_name")) != null) {
            string = object.toString();
        }
        return string;
    }

    public void updateFontStyle(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet wmiFontAttributeSet = new WmiFontAttributeSet();
        wmiFontAttributeSet.setNamedFontStyle(string, this.getDocument());
        this.addAttributes(wmiFontAttributeSet);
    }

    protected WmiTextModel createSubModel(int n) throws WmiNoReadAccessException {
        String string = super.getText();
        return new WmiMathStringModel(this.getDocument(), string.substring(n), new WmiMathContext((WmiFontAttributeSet)this.getAttributes()));
    }

    public WmiModelPosition convertToIdentifier(int n) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathContext wmiMathContext = new WmiMathContext((WmiFontAttributeSet)this.getAttributesForRead());
        String string = this.getText();
        WmiIdentifierModel wmiIdentifierModel = new WmiIdentifierModel(this.getDocument(), string, string, wmiMathContext, false);
        WmiCompositeModel wmiCompositeModel = this.getParent();
        if (wmiCompositeModel != null) {
            int n2 = wmiCompositeModel.indexOf(this);
            try {
                wmiCompositeModel.replaceChild(wmiIdentifierModel, n2);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
        }
        return new WmiModelPosition(wmiIdentifierModel, n);
    }

    public WmiModelPosition convertToMathText(int n) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathContext wmiMathContext = new WmiMathContext((WmiFontAttributeSet)this.getAttributesForRead());
        String string = this.getText();
        WmiMathTextModel wmiMathTextModel = new WmiMathTextModel(this.getDocument(), string, wmiMathContext);
        WmiCompositeModel wmiCompositeModel = this.getParent();
        if (wmiCompositeModel != null) {
            int n2 = wmiCompositeModel.indexOf(this);
            try {
                wmiCompositeModel.replaceChild(wmiMathTextModel, n2);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
        }
        return new WmiModelPosition(wmiMathTextModel, n);
    }

    public WmiTextModel splitModel(int n, ArrayList arrayList) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel wmiModel;
        WmiTextModel wmiTextModel = null;
        WmiModelPosition wmiModelPosition = this.convertToMathText(n);
        if (wmiModelPosition != null && (wmiModel = wmiModelPosition.getModel()) instanceof WmiTextModel) {
            wmiTextModel = ((WmiTextModel)wmiModel).splitModel(n);
        }
        return wmiTextModel;
    }

    public static class WmiStringModelEdit
    extends WmiAbstractMathTokenModel.WmiTokenModelEdit {
        private String oldContentWithQuotes = null;
        private String newContentWithQuotes = null;

        protected WmiStringModelEdit(WmiAbstractMathTokenModel wmiAbstractMathTokenModel) {
            super(wmiAbstractMathTokenModel);
        }

        protected void setPreupdateProperties(WmiCompositeModel wmiCompositeModel, WmiAttributeSet wmiAttributeSet, WmiAbstractMathTokenModel.StringList stringList) {
            super.setPreupdateProperties(wmiCompositeModel, wmiAttributeSet, stringList);
            if (this.model instanceof WmiMathStringModel) {
                this.oldContentWithQuotes = ((WmiMathStringModel)this.model).contentWithQuotes;
            }
        }

        protected void setPostupdateProperties(WmiCompositeModel wmiCompositeModel, WmiAttributeSet wmiAttributeSet, WmiAbstractMathTokenModel.StringList stringList) {
            super.setPostupdateProperties(wmiCompositeModel, wmiAttributeSet, stringList);
            if (this.model instanceof WmiMathStringModel) {
                this.newContentWithQuotes = ((WmiMathStringModel)this.model).contentWithQuotes;
            }
        }

        public void undo() throws WmiNoUpdateAccessException {
            if (this.model instanceof WmiMathStringModel) {
                ((WmiMathStringModel)this.model).contentWithQuotes = this.oldContentWithQuotes;
            }
            super.undo();
        }

        public void redo() throws WmiNoUpdateAccessException {
            if (this.model instanceof WmiMathStringModel) {
                ((WmiMathStringModel)this.model).contentWithQuotes = this.newContentWithQuotes;
            }
            super.redo();
        }
    }

    public static class WmiStringBuilder
    implements WmiMathModelBuilder,
    WmiMathSemantics {
        public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) {
            String string = dag.getData();
            if (wmiMathContext.useProcRules()) {
                String string2;
                String string3;
                int n = string.indexOf(10);
                while (n >= 0) {
                    string3 = string.substring(0, n);
                    string2 = n < string.length() - 1 ? string.substring(n + 1) : "";
                    string = string3 + "\\n" + string2;
                    n = string.indexOf(10);
                }
                n = string.indexOf(34);
                while (n >= 0) {
                    string3 = string.substring(0, n);
                    string2 = n < string.length() - 1 ? string.substring(n + 1) : "";
                    string = string3 + "\\\"" + string2;
                    n = string.indexOf(34, n + 2);
                }
            }
            WmiMathStringModel wmiMathStringModel = new WmiMathStringModel(wmiMathDocumentModel, string, wmiMathContext);
            wmiMathStringModel.setSemantics(this);
            return wmiMathStringModel;
        }

        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            if (wmiMathModel != null && wmiMathModel instanceof WmiMathStringModel) {
                return DagUtil.createStringDag(((WmiMathStringModel)wmiMathModel).getContents());
            }
            return null;
        }
    }

    public static class WmiMathStringAttributeSet
    extends WmiMathAttributeSet {
        public static final String[] ATTRIBUTES = new String[]{"lquote", "rquote"};
        private String leftQuote = null;
        private String rightQuote = null;
        public static final WmiAttributeKey[] STRING_KEYS = new WmiAttributeKey[]{new LeftQuoteKey(), new RightQuoteKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS_STRING = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiMathAttributeSet.EXTENDED_KEYS, STRING_KEYS);
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();

        public WmiMathStringAttributeSet() {
        }

        public WmiMathStringAttributeSet(WmiMathStringAttributeSet wmiMathStringAttributeSet) {
            super(wmiMathStringAttributeSet);
            this.rightQuote = wmiMathStringAttributeSet.rightQuote;
            this.leftQuote = wmiMathStringAttributeSet.leftQuote;
        }

        public WmiAttributeSet copyAttributes() {
            return new WmiMathStringAttributeSet(this);
        }

        public void addAttributes(WmiAttributeSet wmiAttributeSet) {
            super.addAttributes(wmiAttributeSet);
            if (wmiAttributeSet instanceof WmiMathStringAttributeSet) {
                WmiMathStringAttributeSet wmiMathStringAttributeSet = (WmiMathStringAttributeSet)wmiAttributeSet;
                this.rightQuote = wmiMathStringAttributeSet.rightQuote;
                this.leftQuote = wmiMathStringAttributeSet.leftQuote;
            }
        }

        public String getLeftQuote() {
            return this.leftQuote != null ? this.leftQuote : WmiMathStringModel.DEFAULT_QUOTE;
        }

        public String getRightQuote() {
            return this.rightQuote != null ? this.rightQuote : WmiMathStringModel.DEFAULT_QUOTE;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (this == object) {
                bl = true;
            } else if (super.equals(object) && object instanceof WmiMathStringAttributeSet) {
                WmiMathStringAttributeSet wmiMathStringAttributeSet = (WmiMathStringAttributeSet)object;
                bl = true;
                if (this.leftQuote != null) {
                    bl = this.leftQuote.equals(wmiMathStringAttributeSet.leftQuote);
                } else {
                    boolean bl2 = bl = wmiMathStringAttributeSet.leftQuote == null;
                }
                bl = this.rightQuote != null ? (bl &= this.rightQuote.equals(wmiMathStringAttributeSet.rightQuote)) : (bl &= wmiMathStringAttributeSet.rightQuote == null);
            }
            return bl;
        }

        public int hashCode() {
            int n = super.hashCode();
            n = this.leftQuote != null ? (n ^= this.leftQuote.hashCode()) : (n ^= WmiMathStringModel.DEFAULT_QUOTE.hashCode());
            n = this.rightQuote != null ? (n ^= this.rightQuote.hashCode()) : (n ^= WmiMathStringModel.DEFAULT_QUOTE.hashCode());
            return n;
        }

        protected HashMap getKeyMap() {
            return keyMap;
        }

        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS_STRING;
        }

        protected void setKeyMap(HashMap hashMap) {
            keyMap = hashMap;
        }

        public HashMap getCache() {
            return cache;
        }

        public static class RightQuoteKey
        extends WmiStringAttributeKey {
            public RightQuoteKey() {
                super(WmiMathStringModel.RIGHT_QUOTE, null);
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return wmiAttributeSet instanceof WmiMathStringAttributeSet ? ((WmiMathStringAttributeSet)wmiAttributeSet).rightQuote : null;
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                if (wmiAttributeSet instanceof WmiMathStringAttributeSet) {
                    ((WmiMathStringAttributeSet)wmiAttributeSet).rightQuote = string;
                }
            }
        }

        public static class LeftQuoteKey
        extends WmiStringAttributeKey {
            public LeftQuoteKey() {
                super(WmiMathStringModel.LEFT_QUOTE, null);
            }

            public String getStringValue(WmiAttributeSet wmiAttributeSet) {
                return wmiAttributeSet instanceof WmiMathStringAttributeSet ? ((WmiMathStringAttributeSet)wmiAttributeSet).leftQuote : null;
            }

            public void setStringValue(WmiAttributeSet wmiAttributeSet, String string) {
                if (wmiAttributeSet instanceof WmiMathStringAttributeSet) {
                    ((WmiMathStringAttributeSet)wmiAttributeSet).leftQuote = string;
                }
            }
        }
    }
}

