/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;

public class WmiProductBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    public static final String EXPLICIT_MULTIPLICATION_OPERATOR = "&sdot;";
    public static final String PROC_MULTIPLICATION_OPERATOR = "*";
    public static final String IMPLICIT_MULTIPLICATION_OPERATOR = "&InvisibleTimes;";
    private static final String LINEBREAK_CONTEXT_NAME = "product";
    private static final WmiMathSemantics RATIONAL_SEMANTICS = new WmiRationalProductSemantics();

    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel[] wmiModelArray;
        Object object;
        Object object2;
        int n;
        int n2;
        Object object3 = null;
        WmiMathModel wmiMathModel = null;
        int n3 = dag.getLength();
        int n4 = 0;
        int n5 = 0;
        for (n2 = n = dag.getChild(0).getType() == 3 ? 2 : 0; n2 < n3; n2 += 2) {
            Dag dag2 = dag.getChild(n2 + 1);
            if (dag2.equals(DagConstants.MINUS_ONE)) {
                ++n5;
                continue;
            }
            ++n4;
        }
        boolean bl = false;
        if (n > 0 && n4 == 0 && n5 > 0) {
            bl = true;
            ++n4;
            ++n5;
        }
        int n6 = n4 > 0 ? n4 * 2 - 1 : 0;
        int n7 = n5 > 0 ? n5 * 2 - 1 : 0;
        WmiModel[] wmiModelArray2 = new WmiMathModel[n6];
        WmiModel[] wmiModelArray3 = new WmiMathModel[n7];
        int n8 = 3;
        int n9 = 3;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        if (bl) {
            object2 = dag.getChild(0);
            object = ((Dag)object2).getChild(0);
            wmiModelArray = ((Dag)object2).getChild(1);
            n12 = DagBuilder.getPrecedence((Dag)object);
            if (n12 > n8) {
                n8 = n12;
            }
            if ((n12 = DagBuilder.getPrecedence((Dag)wmiModelArray)) > n9) {
                n9 = n12;
            }
            this.addTerm((Dag)object, (WmiMathModel[])wmiModelArray2, wmiMathDocumentModel, wmiMathContext, 0, false);
            ++n10;
            this.addTerm((Dag)wmiModelArray, (WmiMathModel[])wmiModelArray3, wmiMathDocumentModel, wmiMathContext, 0, false);
            ++n11;
        }
        for (n2 = n; n2 < n3; n2 += 2) {
            object2 = dag.getChild(n2);
            object = dag.getChild(n2 + 1);
            n12 = DagBuilder.getPrecedence((Dag)object2);
            if (((Dag)object).equals(DagConstants.MINUS_ONE)) {
                if (n12 > n9) {
                    n9 = n12;
                }
                this.addTerm((Dag)object2, (WmiMathModel[])wmiModelArray3, wmiMathDocumentModel, wmiMathContext, n11, n5 > 1);
                n11 += n11 == 0 ? 1 : 2;
                continue;
            }
            if (n12 > n8) {
                n8 = n12;
            }
            this.addTerm((Dag)object2, (WmiMathModel[])wmiModelArray2, wmiMathDocumentModel, wmiMathContext, n10, n4 > 1);
            n10 += n10 == 0 ? 1 : 2;
        }
        if (n10 > 1) {
            n8 = 4;
        }
        if (n11 > 1) {
            n9 = 4;
        }
        if (n11 > 0) {
            object2 = null;
            try {
                wmiMathModel = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray3);
                wmiMathModel.setSemantics(this);
            }
            catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                WmiErrorLog.log(wmiInvalidModelInitializationException);
            }
            if (n10 > 0) {
                object2 = new WmiInlineMathModel(wmiMathDocumentModel);
                try {
                    object2 = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray2);
                }
                catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                    WmiErrorLog.log(wmiInvalidModelInitializationException);
                }
                object2.setSemantics(this);
            } else {
                object2 = WmiMathFactory.createMathNumericToken(wmiMathDocumentModel, "1", wmiMathContext);
            }
            if (wmiMathContext.useProcRules()) {
                if (n8 > 4) {
                    object2 = WmiMathFactory.addBrackets((WmiMathModel)object2, wmiMathContext);
                }
                if (n9 >= 4) {
                    wmiMathModel = WmiMathFactory.addBrackets(wmiMathModel, wmiMathContext);
                }
            }
            if (wmiMathContext.useProcRules()) {
                object3 = WmiNumericModel.WmiRationalBuilder.createInlineFraction(wmiMathDocumentModel, (WmiMathModel)object2, wmiMathModel, wmiMathContext);
                object3.setSemantics(RATIONAL_SEMANTICS);
            } else {
                object3 = new WmiFractionModel(wmiMathDocumentModel, (WmiModel)object2, wmiMathModel, wmiMathContext);
                object3.setSemantics(RATIONAL_SEMANTICS);
            }
        } else {
            try {
                object2 = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray2);
                object2.setSemantics(this);
                if (n8 > 4) {
                    object3 = WmiMathFactory.addBrackets((WmiMathModel)object2, wmiMathContext);
                    object3.setSemantics(this);
                } else {
                    object3 = object2;
                }
            }
            catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                WmiErrorLog.log(wmiInvalidModelInitializationException);
            }
        }
        if (n != 0 && !bl) {
            object2 = null;
            object = WmiMathFactory.createMath(wmiMathDocumentModel, dag.getChild(0), wmiMathContext);
            wmiModelArray = new WmiMathModel[]{object, wmiMathContext.useProcRules() ? WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, PROC_MULTIPLICATION_OPERATOR, wmiMathContext) : (object.getTag() == WmiModelTag.MATH_NUMERIC && object3.getTag() == WmiModelTag.MATH_NUMERIC ? WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, EXPLICIT_MULTIPLICATION_OPERATOR, wmiMathContext) : WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, IMPLICIT_MULTIPLICATION_OPERATOR, wmiMathContext)), object3};
            try {
                object2 = new WmiInlineMathModel(wmiMathDocumentModel, wmiModelArray);
            }
            catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
                WmiErrorLog.log(wmiInvalidModelInitializationException);
            }
            object3 = object2;
            object3.setSemantics(this);
        }
        if (wmiMathContext.shouldSubExpressionLabel((WmiMathModel)object3, dag)) {
            object3 = wmiMathContext.createSubexpressionLabel((WmiMathModel)object3, dag);
        }
        return object3;
    }

    private Dag getTestDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
        Dag dag = wmiMathModel.toDag();
        if (DagUtil.isProd(dag) && dag.getLength() == 2) {
            dag = dag.getChild(0);
        }
        return dag;
    }

    public void addTerm(Dag dag, WmiMathModel[] wmiMathModelArray, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext, int n, boolean bl) throws WmiNoWriteAccessException, WmiNoReadAccessException {
        if (n > 0) {
            WmiMathModel wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
            if (bl && WmiPrecedenceRules.areBracketsRequired(dag, 4, 0)) {
                wmiMathModel = WmiMathFactory.addBrackets(wmiMathModel, wmiMathContext);
            }
            wmiMathModelArray[n + 1] = wmiMathModel;
            wmiMathModelArray[n] = wmiMathContext.useProcRules() ? WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, PROC_MULTIPLICATION_OPERATOR, wmiMathContext) : (this.isNumeric(wmiMathModelArray[n + 1]) ? WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, EXPLICIT_MULTIPLICATION_OPERATOR, wmiMathContext) : WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, IMPLICIT_MULTIPLICATION_OPERATOR, wmiMathContext));
        } else {
            WmiMathModel wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
            if (bl) {
                int n2 = DagBuilder.getPrecedence(dag);
                if (WmiPrecedenceRules.areBracketsRequired(dag, 4, 0)) {
                    wmiMathModel = WmiMathFactory.addBrackets(wmiMathModel, wmiMathContext);
                }
            }
            wmiMathModelArray[n] = wmiMathModel;
        }
    }

    private boolean isNumeric(WmiMathModel wmiMathModel) {
        if (wmiMathModel.getTag() != WmiModelTag.MATH_NUMERIC) {
            return false;
        }
        WmiMathSemantics wmiMathSemantics = wmiMathModel.getSemantics();
        if (wmiMathSemantics == null) {
            return true;
        }
        return !(wmiMathSemantics instanceof WmiNumericModel.WmiComplexBuilder);
    }

    public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
        Dag dag = null;
        WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
        int n = wmiCompositeModel.getChildCount() - WmiModelUtil.getNumEmptyIdentifiers(wmiCompositeModel);
        if (n % 2 == 1) {
            int n2 = n + 1;
            Dag[] dagArray = new Dag[n2];
            int n3 = 0;
            for (int i = 0; i < n2; i += 2) {
                WmiMathModel wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(i);
                if (WmiModelUtil.isEmptyIdentifierModel(wmiMathModel2)) {
                    --i;
                    continue;
                }
                dagArray[n3] = wmiMathModel2 != null ? wmiMathModel2.toDag() : null;
                dagArray[n3 + 1] = DagConstants.ONE;
                n3 += 2;
            }
            WmiSemanticDagUtil.fillNullDags(dagArray);
            dag = Dag.createDag(14, dagArray, null, false);
        }
        return dag;
    }

    private static class WmiRationalProductSemantics
    implements WmiMathSemantics {
        private WmiRationalProductSemantics() {
        }

        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
            WmiMathModel wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(0);
            WmiMathModel wmiMathModel3 = (WmiMathModel)wmiCompositeModel.getChild(1);
            Dag[] dagArray = new Dag[]{wmiMathModel2.toDag(), DagConstants.ONE, wmiMathModel3.toDag(), DagConstants.MINUS_ONE};
            WmiSemanticDagUtil.fillNullDags(dagArray);
            return Dag.createDag(14, dagArray, null, false);
        }
    }
}

