/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiProcBuilder;

public class WmiTryStatementBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    public static final String TRY_KEYWORD = "try";
    public static final String END_TRY_KEYWORD = "end try";
    public static final String END_TRY_SHORT_KEYWORD = "end";
    public static final String CATCH_KEYWORD = "catch";
    public static final String FINALLY_KEYWORD = "finally";
    public static final String CATCH_DELIM_OP = ":";
    private static final int STATEMENT_INDEX = 0;
    private static final int CATCH_START_INDEX = 1;
    private static final int CHILD_CATCH_INDEX = 4;
    private static final WmiMathSemantics CATCH_LINE_SEMANTICS = new WmiCatchSemantics();

    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel wmiMathDocumentModel, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        int n = dag.getLength();
        int n2 = 5 + n / 2;
        boolean bl = (n & 1) == 0;
        WmiModel[] wmiModelArray = new WmiMathModel[n2 += bl ? 1 : 0];
        wmiModelArray[0] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, TRY_KEYWORD, wmiMathContext);
        wmiModelArray[1] = WmiProcBuilder.createLinebreakIndicator(wmiMathDocumentModel, WmiProcBuilder.PROC_INC_LINEBREAK_ATTR);
        wmiModelArray[2] = WmiProcBuilder.createStatementSequenceRow(dag.getChild(0), wmiMathDocumentModel, wmiMathContext);
        wmiModelArray[3] = WmiProcBuilder.createLinebreakIndicator(wmiMathDocumentModel, WmiProcBuilder.PROC_DEC_LINEBREAK_ATTR);
        int n3 = 4;
        int n4 = bl ? 2 : 1;
        for (int i = 1; i < n - n4; i += 2) {
            wmiModelArray[n3++] = this.createCatchRow(wmiMathDocumentModel, dag.getChild(i), dag.getChild(i + 1), wmiMathContext);
        }
        if (bl) {
            WmiInlineMathModel wmiInlineMathModel2 = new WmiInlineMathModel(wmiMathDocumentModel);
            WmiModel[] wmiModelArray2 = new WmiMathModel[]{WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, FINALLY_KEYWORD, wmiMathContext), WmiProcBuilder.createLinebreakIndicator(wmiMathDocumentModel, WmiProcBuilder.PROC_INC_LINEBREAK_ATTR), WmiProcBuilder.createStatementSequenceRow(dag.getChild(n - 1), wmiMathDocumentModel, wmiMathContext), WmiProcBuilder.createLinebreakIndicator(wmiMathDocumentModel, WmiProcBuilder.PROC_DEC_LINEBREAK_ATTR)};
            try {
                wmiInlineMathModel2.replaceChildren(wmiModelArray2, 0, 0);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
            wmiInlineMathModel2.setSemantics(CATCH_LINE_SEMANTICS);
            wmiModelArray[n3++] = wmiInlineMathModel2;
        }
        wmiModelArray[wmiModelArray.length - 1] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, WmiProcBuilder.getLongDelimProperty(wmiMathDocumentModel) ? END_TRY_KEYWORD : END_TRY_SHORT_KEYWORD, wmiMathContext);
        try {
            wmiInlineMathModel.replaceChildren(wmiModelArray, 0, 0);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        wmiInlineMathModel.setSemantics(this);
        return wmiInlineMathModel;
    }

    private WmiMathModel createCatchRow(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, Dag dag2, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        int n = 4;
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        boolean bl = DagUtil.isNull(dag);
        boolean bl2 = dag2.getLength() <= 0;
        int n2 = n;
        n2 += bl ? 0 : 2;
        WmiModel[] wmiModelArray = new WmiMathModel[n2 += bl2 ? 0 : 1];
        int n3 = 0;
        wmiModelArray[n3++] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, CATCH_KEYWORD, wmiMathContext);
        if (!bl) {
            wmiModelArray[n3] = new WmiMathSpaceModel(wmiMathDocumentModel);
            wmiModelArray[n3++].addAttribute("width", "0.5em");
            wmiModelArray[n3++] = WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
        }
        wmiModelArray[n3++] = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, CATCH_DELIM_OP, wmiMathContext);
        wmiModelArray[n3++] = WmiProcBuilder.createLinebreakIndicator(wmiMathDocumentModel, WmiProcBuilder.PROC_INC_LINEBREAK_ATTR);
        if (!bl2) {
            wmiModelArray[n3++] = WmiProcBuilder.createStatementSequenceRow(dag2, wmiMathDocumentModel, wmiMathContext);
        }
        wmiModelArray[n3++] = WmiProcBuilder.createLinebreakIndicator(wmiMathDocumentModel, WmiProcBuilder.PROC_DEC_LINEBREAK_ATTR);
        try {
            wmiInlineMathModel.replaceChildren(wmiModelArray, 0, 0);
        }
        catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
            WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
        }
        wmiInlineMathModel.setSemantics(CATCH_LINE_SEMANTICS);
        return wmiInlineMathModel;
    }

    public Dag toDag(WmiMathModel wmiMathModel) {
        return null;
    }

    public static class WmiCatchSemantics
    implements WmiMathSemantics {
        public Dag toDag(WmiMathModel wmiMathModel) {
            return null;
        }
    }
}

