/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import java.util.ArrayList;
import java.util.HashMap;

public class WmiRTableIDManager {
    private static HashMap rtableMap = new HashMap();
    private static HashMap idTranslationMap = new HashMap();
    private static HashMap idAliasMap = new HashMap();

    private static boolean containsRTableID(long l) {
        return rtableMap.containsKey(new Long(l));
    }

    private static long identifyRTableFunction(Dag dag) {
        long l = -1L;
        if (dag.getType() == 18) {
            Dag dag2;
            Object object;
            int n = dag.getLength();
            boolean bl = false;
            if (n > 0 && (object = dag.getChild(0).getData()) != null && ((String)object).equals("RTABLE")) {
                bl = true;
            }
            if (bl && ((Dag)(object = dag.getChild(1))).getLength() > 0 && (dag2 = ((Dag)object).getChild(0)).getType() == 2) {
                String string = dag2.getData();
                try {
                    l = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return l;
    }

    private static void release(long l) {
        Long l2 = new Long(l);
        rtableMap.remove(l2);
        idAliasMap.remove(l2);
    }

    private static void updateRTableID(Dag dag, long l) {
        Dag dag2 = dag.getChild(1);
        dag2.setChild(0, Dag.createDag(2, null, Long.toString(l), false));
    }

    protected static void getRTables(Dag dag, ArrayList arrayList) {
        if (DagUtil.isBranchDag(dag)) {
            int n = dag.getLength();
            for (int i = 0; i < n; ++i) {
                Dag dag2 = dag.getChild(i);
                long l = WmiRTableIDManager.identifyRTableFunction(dag2);
                if (l > 0L) {
                    long l2 = WmiRTableIDManager.getCorrectedRTableID(l);
                    if (l != l2) {
                        WmiRTableIDManager.updateRTableID(dag2, l2);
                        l = l2;
                    }
                    arrayList.add(new Long(l));
                }
                WmiRTableIDManager.getRTables(dag2, arrayList);
            }
        }
    }

    public static void addRTableID(long l, Dag dag) {
        Long l2 = new Long(l);
        if (idTranslationMap.containsKey(l2)) {
            Long l3 = (Long)idTranslationMap.get(l2);
            idAliasMap.put(l2, l3);
            l2 = l3;
            if (l2 != null) {
                WmiRTableIDManager.updateRTableID(dag, l2);
                rtableMap.put(l2, dag);
            }
            idTranslationMap.remove(l2);
        }
        rtableMap.put(l2, dag);
    }

    public static void addRTableTranslation(long l, long l2) {
        if (WmiRTableIDManager.containsRTableID(l)) {
            Long l3 = new Long(l);
            Long l4 = new Long(l2);
            Dag dag = (Dag)rtableMap.get(l3);
            if (dag != null) {
                WmiRTableIDManager.updateRTableID(dag, l2);
                rtableMap.remove(l3);
                idAliasMap.put(l3, l4);
                rtableMap.put(l4, dag);
            }
        } else {
            idTranslationMap.put(new Long(l), new Long(l2));
        }
    }

    public static long getCorrectedRTableID(long l) {
        long l2 = l;
        Long l3 = new Long(l);
        if (!rtableMap.containsKey(l3) && idAliasMap.containsKey(l3)) {
            l2 = (Long)idAliasMap.get(l3);
        }
        return l2;
    }

    public static void getRTables(WmiMathWrapperModel wmiMathWrapperModel, ArrayList arrayList) throws WmiNoReadAccessException {
        Dag dag;
        if (arrayList != null && wmiMathWrapperModel != null && (dag = wmiMathWrapperModel.getDag()) != null) {
            WmiRTableIDManager.getRTables(dag, arrayList);
        }
    }

    public static void releaseRTables(Dag dag) {
        if (DagUtil.isBranchDag(dag)) {
            int n = dag.getLength();
            for (int i = 0; i < n; ++i) {
                Dag dag2 = dag.getChild(i);
                if (dag2 == null) continue;
                long l = WmiRTableIDManager.identifyRTableFunction(dag2);
                if (l > 0L) {
                    WmiRTableIDManager.release(l);
                }
                WmiRTableIDManager.releaseRTables(dag2);
            }
        }
    }
}

