/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiAssignedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiOverModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiTableBuilder
extends WmiAbstractSpecialFunctionBuilder {
    private static final int ROW_INDEX = 0;
    private static final String VECTOR_TABLE = "VECTOR";
    private static final String FIELD_OPTION = "field";
    private static final String BASE_VECTOR = "e";
    private static final String OVER_BAR = "_";

    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel wmiMathDocumentModel, String string, Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel wmiMathModel = null;
        int n = dag.getLength();
        wmiMathModel = string.toUpperCase().equals(VECTOR_TABLE) ? this.buildVector(wmiMathDocumentModel, dag.getChild(0), wmiMathContext) : (n == 1 ? WmiTableBuilder.buildMatrix(wmiMathDocumentModel, dag.getChild(0), wmiMathContext) : this.buildBasisVector(wmiMathDocumentModel, dag, wmiMathContext));
        return wmiMathModel;
    }

    public boolean shouldBeUsed(Dag dag, WmiMathContext wmiMathContext) {
        boolean bl = super.shouldBeUsed(dag, wmiMathContext);
        Dag dag2 = dag.getChild(1);
        int n = dag2.getLength();
        bl = n == 1 ? dag2.getChild(0) != null && dag2.getChild(0).getType() == 30 : (n == 2 || n == 3 ? dag2.getChild(0) != null && dag2.getChild(0).getType() == 30 && dag2.getChild(1) != null && dag2.getChild(1).getType() == 30 : false);
        return bl;
    }

    private WmiMathModel buildVector(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext) {
        WmiMathModel wmiMathModel = null;
        int n = dag.getLength();
        WmiMathTableModel.WmiMathTableRowModel wmiMathTableRowModel = new WmiMathTableModel.WmiMathTableRowModel(wmiMathDocumentModel);
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            Dag dag2 = dag.getChild(i);
            WmiMathModel wmiMathModel2 = null;
            try {
                wmiMathModel2 = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
                bl = bl && DagUtil.isNumeric(dag2);
                WmiMathTableModel.WmiMathTableDataModel wmiMathTableDataModel = new WmiMathTableModel.WmiMathTableDataModel(wmiMathDocumentModel, wmiMathModel2);
                wmiMathTableRowModel.appendChild(wmiMathTableDataModel);
                continue;
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
                continue;
            }
            catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
                WmiErrorLog.log(wmiNoWriteAccessException);
            }
        }
        try {
            WmiMathTableModel wmiMathTableModel = new WmiMathTableModel(wmiMathDocumentModel);
            wmiMathTableModel.appendChild(wmiMathTableRowModel);
            wmiMathModel = WmiMathFactory.addBrackets(wmiMathTableModel, "[", "]", wmiMathContext);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        return wmiMathModel;
    }

    private WmiMathModel buildBasisVector(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext) throws WmiNoWriteAccessException {
        Object object;
        int n;
        int n2 = 0;
        Dag dag2 = null;
        boolean bl = true;
        String string = null;
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        boolean bl2 = false;
        Dag dag3 = dag.getChild(0);
        Dag dag4 = dag.getChild(1);
        Dag dag5 = null;
        if (dag.getLength() == 3 && dag.getChild(2).getData().equals(FIELD_OPTION)) {
            bl2 = true;
        }
        for (n = 0; n < dag3.getLength(); ++n) {
            Dag[] dagArray;
            boolean bl3;
            object = "+";
            dag5 = dag3.getChild(n);
            boolean bl4 = false;
            if (dag5.getType() == 30) {
                if ((dag5 = dag5.getChild(0)).getType() == 29) {
                    dag5 = dag5.getChild(0);
                }
                boolean bl5 = bl4 = dag5.getType() == 16 && dag5.getLength() <= 2 || dag5.getType() == 2 || dag5.getType() == 1;
                if (DagUtil.isOne(dag5) || DagUtil.isMinusOne(dag5)) {
                    if (DagUtil.isPosInt(dag5)) {
                        object = "+";
                    } else {
                        object = n > 0 ? "&minus;" : "&uminus0;";
                        dag5 = DagUtil.negate(dag5);
                    }
                } else if (!DagUtil.isZero(dag5) && bl4) {
                    bl3 = false;
                    if (dag5.getType() == 16) {
                        bl3 = DagUtil.isNegative(dag5.getChild(1));
                    } else if (dag5.getType() == 2 || dag5.getType() == 1) {
                        bl3 = DagUtil.isNegative(dag5);
                    }
                    if (bl3) {
                        if (dag5.getType() == 2 || dag5.getType() == 1) {
                            dag5 = DagUtil.negate(dag5);
                        } else {
                            dagArray = new Dag[]{dag5.getChild(0), DagUtil.negate(dag5.getChild(1))};
                            dag5 = Dag.createDag(16, dagArray, null, false);
                        }
                        object = n > 0 ? "&minus;" : "&uminus0;";
                    } else if (DagUtil.isNegative(dag5)) {
                        object = n > 0 ? "&minus;" : "&uminus0;";
                        dag5 = DagUtil.negate(dag5);
                    }
                }
            }
            if (n == 0) {
                dag2 = dag5;
                bl = bl4;
                string = object;
            }
            if (DagUtil.isZero(dag5)) continue;
            if (n2 > 0 || object != "+") {
                WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, (String)object, wmiMathContext);
                wmiInlineMathModel.appendChild(wmiMathTokenModel);
            }
            bl3 = !bl4;
            dagArray = this.buildTerm(wmiMathDocumentModel, dag5, dag4.getChild(n), wmiMathContext, bl2, bl3);
            wmiInlineMathModel.appendChild((WmiModel)dagArray);
            ++n2;
        }
        if (n2 == 0) {
            if (string != "+") {
                WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, string, wmiMathContext);
                wmiInlineMathModel.appendChild(wmiMathTokenModel);
            }
            n = !bl ? 1 : 0;
            object = this.buildTerm(wmiMathDocumentModel, dag5, dag4.getChild(0), wmiMathContext, bl2, n != 0);
            wmiInlineMathModel.appendChild((WmiModel)object);
        }
        return wmiInlineMathModel;
    }

    private WmiMathModel buildTerm(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, Dag dag2, WmiMathContext wmiMathContext, boolean bl, boolean bl2) {
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        Dag dag3 = DagUtil.createNameDag(BASE_VECTOR);
        Dag dag4 = DagUtil.createNameDag(dag2.getData());
        try {
            WmiMathModel wmiMathModel;
            if (dag != null && !DagUtil.isOne(dag)) {
                wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
                if (bl2) {
                    wmiMathModel = WmiMathFactory.addBrackets(wmiMathModel, wmiMathContext);
                }
                wmiInlineMathModel.appendChild(wmiMathModel);
            }
            wmiMathModel = this.buildCoordinate(wmiMathDocumentModel, dag3, dag4, wmiMathContext, bl);
            wmiInlineMathModel.appendChild(wmiMathModel);
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
        catch (WmiNoWriteAccessException wmiNoWriteAccessException) {
            WmiErrorLog.log(wmiNoWriteAccessException);
        }
        return wmiInlineMathModel;
    }

    private WmiMathModel buildCoordinate(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, Dag dag2, WmiMathContext wmiMathContext, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel wmiMathModel;
        WmiMathModel wmiMathModel2;
        WmiMathModel wmiMathModel3 = WmiMathFactory.createMath(wmiMathDocumentModel, dag, wmiMathContext);
        WmiMathModel wmiMathModel4 = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
        if (!bl) {
            wmiMathModel2 = wmiMathModel3;
        } else {
            wmiMathModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, OVER_BAR, wmiMathContext);
            wmiMathModel2 = new WmiOverModel(wmiMathDocumentModel, wmiMathModel3, wmiMathModel, wmiMathContext);
        }
        wmiMathModel = new WmiSubscriptModel(wmiMathDocumentModel, wmiMathModel2, wmiMathModel4, wmiMathContext);
        return wmiMathModel;
    }

    public static WmiMathModel buildMatrix(WmiMathDocumentModel wmiMathDocumentModel, Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel wmiMathModel = null;
        if (WmiTableBuilder.verifySquareListOfLists(dag)) {
            wmiMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
            WmiAbstractArrayCompositeModel wmiAbstractArrayCompositeModel = wmiMathModel;
            WmiMathTableModel wmiMathTableModel = new WmiMathTableModel(wmiMathDocumentModel);
            boolean bl = true;
            for (int i = 0; i < dag.getLength(); ++i) {
                Object object;
                WmiMathTableModel.WmiMathTableRowModel wmiMathTableRowModel = new WmiMathTableModel.WmiMathTableRowModel(wmiMathDocumentModel);
                Dag dag2 = dag.getChild(i);
                int n = dag2.getLength();
                if (n == 0) {
                    WmiMathModel wmiMathModel2 = WmiMathFactory.createMath(wmiMathDocumentModel, dag2, wmiMathContext);
                    bl = bl && DagUtil.isInt(dag2);
                    object = new WmiMathTableModel.WmiMathTableDataModel(wmiMathDocumentModel, wmiMathModel2);
                    wmiMathTableRowModel.appendChild((WmiModel)object);
                } else {
                    for (int j = 0; j < n; ++j) {
                        object = dag2.getChild(j);
                        WmiMathModel wmiMathModel3 = WmiMathFactory.createMath(wmiMathDocumentModel, (Dag)object, wmiMathContext);
                        bl = bl && DagUtil.isInt((Dag)object);
                        wmiMathModel3.setSemantics(new WmiAssignedSemantics((Dag)object));
                        WmiMathTableModel.WmiMathTableDataModel wmiMathTableDataModel = new WmiMathTableModel.WmiMathTableDataModel(wmiMathDocumentModel, wmiMathModel3);
                        wmiMathTableRowModel.appendChild(wmiMathTableDataModel);
                    }
                }
                wmiMathTableModel.appendChild(wmiMathTableRowModel);
            }
            wmiAbstractArrayCompositeModel.appendChild(wmiMathTableModel);
            if (bl) {
                wmiMathTableModel.addAttribute("columnalign", "right");
            }
            wmiMathModel = WmiMathFactory.addBrackets(wmiMathModel, "[", "]", wmiMathContext);
        }
        return wmiMathModel;
    }

    private static boolean verifySquareListOfLists(Dag dag) {
        boolean bl = true;
        int n = dag.getLength();
        int n2 = -1;
        for (int i = n - 1; i > -1 && bl; --i) {
            Dag dag2 = dag.getChild(i);
            bl = dag2.getType() == 30;
            n2 = n2 < 0 ? dag2.getLength() : n2;
            bl = n2 == dag2.getLength();
        }
        return bl;
    }
}

