/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math.specialfunction;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbstractSpecialFunctionBuilder;

public class WmiVectorDerivativesBuilder
extends WmiAbstractSpecialFunctionBuilder {
    public static final String CROSS_PRODUCT = "\u00d7";
    public static final String DOT_PRODUCT = "\u00b7";
    private static final WmiMathSemantics VECTOR_DERIVATIVE_SEMANTIC = new WmiVectorDerivativeSemantics();
    private String operator = "";
    private String NABLA = "\u2207";

    public WmiVectorDerivativesBuilder(String string) {
        this.operator = string;
    }

    public WmiMathModel createSpecialFunctionModel(WmiMathDocumentModel wmiMathDocumentModel, String string, Dag dag, WmiMathContext wmiMathContext) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
        wmiInlineMathModel.appendChild(WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, this.NABLA, wmiMathContext));
        wmiInlineMathModel.appendChild(WmiMathFactory.createMathIdentifierToken(wmiMathDocumentModel, this.operator, wmiMathContext));
        WmiMathModel wmiMathModel = WmiMathFactory.createMath(wmiMathDocumentModel, dag.getChild(0), wmiMathContext);
        if (WmiPrecedenceRules.areBracketsRequired(dag.getChild(0), 3, 0)) {
            wmiMathModel = WmiMathFactory.addBrackets(wmiMathModel, wmiMathContext);
        }
        wmiInlineMathModel.appendChild(wmiMathModel);
        wmiInlineMathModel.setSemantics(VECTOR_DERIVATIVE_SEMANTIC);
        return wmiInlineMathModel;
    }

    public static class WmiVectorDerivativeSemantics
    implements WmiMathSemantics {
        private static final int INDEX_OF_OPERATOR = 1;
        private static final int INDEX_OF_OPERAND = 2;
        private static final String SPACE = " ";

        public Dag toDag(WmiMathModel wmiMathModel) throws WmiNoReadAccessException {
            Dag dag = null;
            if (wmiMathModel != null && wmiMathModel.isComposite()) {
                WmiCompositeModel wmiCompositeModel = (WmiCompositeModel)((Object)wmiMathModel);
                WmiModel wmiModel = wmiCompositeModel.getChild(1);
                WmiMathModel wmiMathModel2 = (WmiMathModel)wmiCompositeModel.getChild(2);
                if (wmiModel instanceof WmiTextModel && wmiMathModel2 != null) {
                    Dag dag2 = wmiMathModel2.toDag();
                    String string = ((WmiTextModel)wmiModel).getText();
                    Dag dag3 = null;
                    if (WmiVectorDerivativesBuilder.CROSS_PRODUCT.equals(string)) {
                        dag3 = WmiSemanticDagUtil.CURL_FUNC_NAME;
                    } else if (WmiVectorDerivativesBuilder.DOT_PRODUCT.equals(string)) {
                        dag3 = WmiSemanticDagUtil.GRADIENT_FUNC_NAME;
                    } else if (SPACE.equals(string)) {
                        dag3 = WmiSemanticDagUtil.DIVERGENCE_FUNC_NAME;
                    }
                    dag = WmiSemanticDagUtil.createFunction(dag3, dag2);
                }
            }
            dag = WmiSemanticDagUtil.handleNullDag(dag, wmiMathModel);
            return dag;
        }
    }
}

