/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.platform;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;

public final class WmiComboBoxUIFactory {
    public static final int LIGHT_COLOR = 1;
    public static final int DARK_COLOR = 2;
    public static Paint LIGHT_BACKGROUND_PAINT = null;
    public static Paint LIGHT_SELECTED_BACKGROUND_PAINT = null;
    public static Paint DARK_BACKGROUND_PAINT = null;
    public static Paint DARK_SELECTED_BACKGROUND_PAINT = null;

    private static void createPaints() {
        LIGHT_SELECTED_BACKGROUND_PAINT = new GradientPaint(new Point(0, 0), Color.GRAY, new Point(0, 20), Color.LIGHT_GRAY);
        LIGHT_BACKGROUND_PAINT = new GradientPaint(new Point(0, 0), Color.LIGHT_GRAY.brighter(), new Point(0, 20), Color.LIGHT_GRAY);
        DARK_SELECTED_BACKGROUND_PAINT = new GradientPaint(new Point(0, 0), Color.GRAY, new Point(0, 20), Color.WHITE);
        DARK_BACKGROUND_PAINT = new GradientPaint(new Point(0, 0), Color.LIGHT_GRAY, new Point(0, 20), Color.GRAY);
    }

    public static ComboBoxUI createUI(int n) {
        if (LIGHT_BACKGROUND_PAINT == null) {
            WmiComboBoxUIFactory.createPaints();
        }
        return new OvalComboBoxUI(n);
    }

    private WmiComboBoxUIFactory() {
    }

    private static class TransparentArrowButton
    extends BasicArrowButton {
        public TransparentArrowButton() {
            super(5, null, Color.GRAY, Color.DARK_GRAY, null);
            this.setOpaque(false);
        }

        public void paint(Graphics graphics) {
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            boolean bl = this.getModel().isPressed();
            boolean bl2 = bl || this.isEnabled();
            int n3 = Math.min((n2 - 4) / 3, (n - 4) / 3);
            n3 = Math.max(n3, 2);
            this.paintTriangle(graphics, (n - n3) / 2, (n2 - n3) / 2, n3, this.direction, bl2);
        }
    }

    private static class TransparentCellRendererPane
    extends CellRendererPane {
        private TransparentCellRendererPane() {
        }

        public void paintComponent(Graphics graphics, Component component, Container container, int n, int n2, int n3, int n4, boolean bl) {
            OvalComboBoxUI ovalComboBoxUI;
            Color color = Color.BLACK;
            if (container instanceof JComboBox && (ovalComboBoxUI = (OvalComboBoxUI)((JComboBox)container).getUI()).color == 2) {
                color = Color.BLACK;
            }
            component.setForeground(color);
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(false);
            }
            super.paintComponent(graphics, component, container, n, n2, n3, n4, bl);
        }
    }

    protected static class ListItemRenderer
    extends BasicComboBoxRenderer
    implements ListCellRenderer {
        protected ListItemRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            BasicComboBoxRenderer basicComboBoxRenderer = (BasicComboBoxRenderer)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            basicComboBoxRenderer.setOpaque(bl);
            return basicComboBoxRenderer;
        }
    }

    private static class OvalComboBoxUI
    extends BasicComboBoxUI {
        private int color;

        public OvalComboBoxUI(int n) {
            this.color = n;
        }

        public void installUI(JComponent jComponent) {
            this.currentValuePane = new TransparentCellRendererPane();
            super.installUI(jComponent);
            jComponent.setOpaque(false);
            jComponent.setBorder(null);
            ((JComboBox)jComponent).setRenderer(new ListItemRenderer());
        }

        protected JButton createArrowButton() {
            return new TransparentArrowButton();
        }

        protected Insets getInsets() {
            Insets insets = super.getInsets();
            insets.left += 8;
            return insets;
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            Rectangle rectangle = jComponent.getBounds();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.isPopupVisible(this.comboBox)) {
                graphics2D.setPaint(this.color == 1 ? LIGHT_SELECTED_BACKGROUND_PAINT : DARK_SELECTED_BACKGROUND_PAINT);
            } else {
                graphics2D.setPaint(this.color == 1 ? LIGHT_BACKGROUND_PAINT : DARK_BACKGROUND_PAINT);
            }
            graphics2D.fillRoundRect(0, 0, rectangle.width - 1, rectangle.height - 1, rectangle.height, rectangle.height);
            super.paint(graphics2D, jComponent);
            graphics2D.setColor(this.color == 1 ? Color.GRAY : Color.DARK_GRAY);
            graphics2D.drawRoundRect(0, 0, rectangle.width - 1, rectangle.height - 1, rectangle.height, rectangle.height);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }

        public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
            super.paintCurrentValue(graphics, rectangle, bl);
        }

        public void paintCurrentValueBackground(Graphics graphics, Rectangle rectangle, boolean bl) {
        }

        protected Dimension getDisplaySize() {
            Dimension dimension = super.getDisplaySize();
            dimension.width = Math.min(dimension.width, 100);
            dimension.height = 20;
            return dimension;
        }

        public void setPopupVisible(JComboBox jComboBox, boolean bl) {
            super.setPopupVisible(jComboBox, bl);
            jComboBox.repaint();
        }
    }
}

