/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.platform;

import com.maplesoft.mathdoc.platform.WmiRolloverHighlightButtonUI;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ButtonUI;

public class WmiPaletteButtonUIFactory {
    public static final int DEFAULT_BUTTON_DIMENSION = 26;
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 50;
    private static final Dimension DEFAULT_BUTTON_SIZE = new Dimension(26, 26);

    public static ButtonUI createUI() {
        if (RuntimePlatform.isMac()) {
            return new MacPaletteButtonUI();
        }
        return new WindowsUnixPaletteButtonUI();
    }

    private static void setDefaultSizes(JComponent jComponent, Dimension dimension) {
        jComponent.setPreferredSize(dimension);
        jComponent.setMinimumSize(dimension);
    }

    private WmiPaletteButtonUIFactory() {
    }

    public static class MacPaletteButtonUI
    extends PaletteButtonUI {
        public void paint(Graphics graphics, JComponent jComponent) {
            super.paint(graphics, jComponent);
        }
    }

    public static class WindowsUnixPaletteButtonUI
    extends PaletteButtonUI {
        public void paint(Graphics graphics, JComponent jComponent) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paint(graphics, jComponent);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }

    public static class PaletteButtonUI
    extends WmiRolloverHighlightButtonUI {
        public void installUI(JComponent jComponent) {
            Icon icon;
            super.installUI(jComponent);
            final AbstractButton abstractButton = (AbstractButton)jComponent;
            abstractButton.setRolloverEnabled(true);
            abstractButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            if (RuntimePlatform.isWindows()) {
                abstractButton.addMouseListener(new MouseAdapter(){

                    public void mouseEntered(MouseEvent mouseEvent) {
                        if ((mouseEvent.getModifiers() & 0x10) != 0) {
                            ButtonModel buttonModel = abstractButton.getModel();
                            buttonModel.setRollover(false);
                        }
                    }
                });
            }
            if ((icon = abstractButton.getIcon()) != null) {
                int n = Math.max(50, icon.getIconWidth());
                int n2 = icon.getIconHeight();
                Dimension dimension = new Dimension(n, n2);
                WmiPaletteButtonUIFactory.setDefaultSizes(abstractButton, dimension);
            } else {
                WmiPaletteButtonUIFactory.setDefaultSizes(abstractButton, DEFAULT_BUTTON_SIZE);
            }
        }

        protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
            String string2 = abstractButton.getText();
            Font font = abstractButton.getFont();
            FontMetrics fontMetrics = abstractButton.getFontMetrics(font);
            int n = (abstractButton.getWidth() - fontMetrics.stringWidth(string2)) / 2;
            int n2 = abstractButton.getHeight() - fontMetrics.getMaxDescent() - 2;
            if (font != null && font.getName().equals("ESSTIXTen")) {
                --n2;
            }
            graphics.drawString(string, n, n2);
        }

        protected void paintContents(Graphics graphics, AbstractButton abstractButton) {
            Icon icon = abstractButton.getIcon();
            if (icon != null) {
                int n = (abstractButton.getWidth() - icon.getIconWidth()) / 2;
                int n2 = (abstractButton.getHeight() - icon.getIconHeight()) / 2;
                this.paintIcon(graphics, abstractButton, new Rectangle(n, n2, abstractButton.getWidth(), abstractButton.getHeight()));
            } else {
                Color color = null;
                color = abstractButton.isEnabled() ? abstractButton.getForeground() : Color.GRAY;
                graphics.setColor(color);
                this.paintText(graphics, abstractButton, null, abstractButton.getText());
            }
        }
    }
}

