/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.platform;

import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.platform.WmiRolloverHighlightButtonUI;
import com.maplesoft.util.RuntimePlatform;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class WmiToolBarButtonUIFactory {
    public static ButtonUI createUI() {
        if (RuntimePlatform.isMac()) {
            return new MacToolBarButtonUI();
        }
        return new WindowsUnixToolBarButtonUI();
    }

    private WmiToolBarButtonUIFactory() {
    }

    public static class MacToolBarButtonUI
    extends BasicButtonUI {
        public void installUI(JComponent jComponent) {
            super.installUI(jComponent);
            this.installPressedIcon(jComponent);
            jComponent.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            Font font = jComponent.getFont();
            jComponent.setFont(font.deriveFont(10.0f));
        }

        private void installPressedIcon(JComponent jComponent) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            Icon icon = abstractButton.getIcon();
            if (icon instanceof ImageIcon) {
                BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(((ImageIcon)icon).getImage(), 0, 0, null);
                graphics2D.setComposite(AlphaComposite.getInstance(10, 0.5f));
                graphics2D.setColor(Color.BLACK);
                graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                graphics2D.dispose();
                abstractButton.setPressedIcon(new ImageIcon(bufferedImage));
            }
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            String string;
            AbstractButton abstractButton = (AbstractButton)jComponent;
            Icon icon = null;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isSelected()) {
                graphics.setColor(Color.LIGHT_GRAY);
                graphics.fillRect(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
            }
            if (buttonModel.isPressed()) {
                icon = abstractButton.getPressedIcon();
            } else if (!abstractButton.isEnabled()) {
                icon = abstractButton.getDisabledIcon();
            }
            if (icon == null) {
                icon = abstractButton.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(abstractButton, graphics, 1, 1);
            }
            if ((string = abstractButton.getText()) != null) {
                Rectangle rectangle = WmiComponentUtil.centerTextInButton(abstractButton);
                graphics.setColor(abstractButton.getForeground());
                FontMetrics fontMetrics = graphics.getFontMetrics();
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, -1, rectangle.x + this.getTextShiftOffset(), rectangle.y + fontMetrics.getAscent() + this.getTextShiftOffset());
            }
        }
    }

    public static class WindowsUnixToolBarButtonUI
    extends WmiRolloverHighlightButtonUI {
    }
}

