/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.util;

import com.maplesoft.client.BlockingEvaluation;
import com.maplesoft.client.JavaCallbackListener;
import com.maplesoft.client.KernelAdapter;
import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelConnectionEvent;
import com.maplesoft.client.KernelConnectionListener;
import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelInterfacePropertiesChangeAdapter;
import com.maplesoft.client.KernelProxy;
import com.maplesoft.client.SetGetHandler;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.mathdoc.controller.WmiIndexedViewFactory;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiFormatException;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.WmiImageUtilities;
import com.maplesoft.mathdoc.io.html.WmiHTMLFormatter;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiMathMLParagraphModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.util.WmiRawFileWriter;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.util.Base64Encoder;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.Arrays;
import javax.media.jai.JAI;

public class WmiMathTools {
    private static final int MIN_BREAK_WIDTH = 96;
    private static WmiMathDocumentView docView;

    private WmiMathTools() {
    }

    public static boolean convertMathMLToGIF(String string, int n, String string2) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException, WmiInvalidModelInitializationException, IOException {
        return WmiMathTools.convertMathMLToGIF(string, n, string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean convertMathMLToGIF(String string, int n, String string2, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException, WmiInvalidModelInitializationException, IOException {
        boolean bl2 = true;
        WmiMathDocumentModel wmiMathDocumentModel = new WmiMathDocumentModel();
        Object var6_6 = null;
        if (bl) {
            WmiMathOperatorModel.disableStretchyOps = true;
        }
        if (!WmiModelLock.writeLock(wmiMathDocumentModel, true)) return false;
        try {
            WmiMathMLImportParser wmiMathMLImportParser = new WmiMathMLImportParser();
            wmiMathMLImportParser.parse(new StringReader(string), (WmiCompositeModel)wmiMathDocumentModel, 0);
            WmiMathMLParagraphModel wmiMathMLParagraphModel = (WmiMathMLParagraphModel)wmiMathDocumentModel.getChild(0);
            if (wmiMathMLParagraphModel == null) return bl2;
            WmiModel wmiModel = wmiMathMLParagraphModel.getChild(0);
            if (!(wmiModel instanceof WmiMathWrapperModel)) return bl2;
            WmiMathWrapperModel wmiMathWrapperModel = (WmiMathWrapperModel)wmiModel;
            docView = new WmiMathDocumentView(wmiMathDocumentModel, new WmiIndexedViewFactory());
            WmiRawFileWriter wmiRawFileWriter = new WmiRawFileWriter(string2);
            WmiMathToolsFormatter wmiMathToolsFormatter = new WmiMathToolsFormatter(docView, 0, bl);
            if (n < 96) {
                n = 96;
            }
            WmiMathToolsFormatter.setMaxWidth(n);
            wmiMathToolsFormatter.format(wmiRawFileWriter, wmiMathWrapperModel);
            wmiRawFileWriter.close();
            return bl2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl2 = false;
            return bl2;
        }
        finally {
            WmiModelLock.writeUnlock(wmiMathDocumentModel);
            docView.release();
            WmiCaret.cancelTimer();
        }
    }

    public static BufferedImage convertMathMLToImage(String string, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException, WmiInvalidModelInitializationException, IOException {
        return WmiMathTools.convertMathMLToImage(string, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage convertMathMLToImage(String string, int n, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException, WmiInvalidModelInitializationException, IOException {
        BufferedImage bufferedImage = null;
        WmiMathDocumentModel wmiMathDocumentModel = new WmiMathDocumentModel();
        if (bl) {
            WmiMathOperatorModel.disableStretchyOps = true;
        }
        if (WmiModelLock.writeLock(wmiMathDocumentModel, true)) {
            try {
                WmiModel wmiModel;
                WmiMathMLImportParser wmiMathMLImportParser = new WmiMathMLImportParser();
                wmiMathMLImportParser.parse(new StringReader(string), (WmiCompositeModel)wmiMathDocumentModel, 0);
                WmiMathMLParagraphModel wmiMathMLParagraphModel = (WmiMathMLParagraphModel)wmiMathDocumentModel.getChild(0);
                if (wmiMathMLParagraphModel != null && (wmiModel = wmiMathMLParagraphModel.getChild(0)) instanceof WmiMathWrapperModel) {
                    WmiMathWrapperModel wmiMathWrapperModel = (WmiMathWrapperModel)wmiModel;
                    docView = new WmiMathDocumentView(wmiMathDocumentModel, new WmiIndexedViewFactory());
                    WmiMathToolsFormatter wmiMathToolsFormatter = new WmiMathToolsFormatter(docView, 2, bl);
                    if (n < 96) {
                        n = 96;
                    }
                    WmiMathToolsFormatter.setMaxWidth(n);
                    wmiMathToolsFormatter.writeMathModel(wmiMathWrapperModel);
                    bufferedImage = wmiMathToolsFormatter.getImage();
                }
            }
            finally {
                WmiModelLock.writeUnlock(wmiMathDocumentModel);
            }
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertMathMLToTypeMK(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException, WmiInvalidModelInitializationException, IOException {
        String string2 = "";
        WmiMathDocumentModel wmiMathDocumentModel = new WmiMathDocumentModel();
        if (WmiModelLock.writeLock(wmiMathDocumentModel, true)) {
            try {
                WmiModel wmiModel;
                WmiMathMLImportParser wmiMathMLImportParser = new WmiMathMLImportParser();
                wmiMathMLImportParser.parse(new StringReader(string), (WmiCompositeModel)wmiMathDocumentModel, 0);
                WmiMathMLParagraphModel wmiMathMLParagraphModel = (WmiMathMLParagraphModel)wmiMathDocumentModel.getChild(0);
                if (wmiMathMLParagraphModel != null && (wmiModel = wmiMathMLParagraphModel.getChild(0)) instanceof WmiMathWrapperModel) {
                    WmiMathWrapperModel wmiMathWrapperModel = (WmiMathWrapperModel)wmiModel;
                    Dag dag = wmiMathWrapperModel.toDag();
                    string2 = DagBuilder.lPrint(dag);
                }
            }
            finally {
                WmiModelLock.writeUnlock(wmiMathDocumentModel);
            }
        }
        return string2;
    }

    public static boolean convertDotMToGIF(String string, int n, String string2) throws IOException, WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        return WmiMathTools.convertDotMToGIF(string, n, string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean convertDotMToGIF(String string, int n, String string2, boolean bl) throws IOException, WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        boolean bl2 = true;
        WmiMathDocumentModel wmiMathDocumentModel = new WmiMathDocumentModel();
        WmiMathWrapperModel wmiMathWrapperModel = new WmiMathWrapperModel(wmiMathDocumentModel);
        if (bl) {
            WmiMathOperatorModel.disableStretchyOps = true;
        }
        if (WmiModelLock.writeLock(wmiMathWrapperModel, true)) {
            try {
                wmiMathWrapperModel.createMathChildren(string);
                WmiModel[] wmiModelArray = new WmiModel[]{wmiMathWrapperModel};
                WmiParagraphModel wmiParagraphModel = new WmiParagraphModel(wmiMathDocumentModel, wmiModelArray);
                docView = new WmiMathDocumentView(wmiMathDocumentModel, new WmiIndexedViewFactory());
                WmiRawFileWriter wmiRawFileWriter = new WmiRawFileWriter(string2);
                WmiMathToolsFormatter wmiMathToolsFormatter = new WmiMathToolsFormatter(docView, 0, bl);
                if (n < 96) {
                    n = 96;
                }
                WmiMathToolsFormatter.setMaxWidth(n);
                wmiMathToolsFormatter.format(wmiRawFileWriter, wmiMathWrapperModel);
                wmiRawFileWriter.close();
            }
            catch (Exception exception) {
                bl2 = false;
            }
            finally {
                WmiModelLock.writeUnlock(wmiMathWrapperModel);
                docView.release();
                WmiCaret.cancelTimer();
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public static byte[] convertMathToByteArray(String string, int n) throws IOException, WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        return WmiMathTools.convertMathToByteArray(string, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertMathToByteArray(String string, int n, boolean bl) throws IOException, WmiNoReadAccessException, WmiNoWriteAccessException, WmiInvalidModelInitializationException {
        byte[] byArray = null;
        WmiMathDocumentModel wmiMathDocumentModel = new WmiMathDocumentModel();
        WmiMathWrapperModel wmiMathWrapperModel = new WmiMathWrapperModel(wmiMathDocumentModel);
        if (bl) {
            WmiMathOperatorModel.disableStretchyOps = true;
        }
        if (WmiModelLock.writeLock(wmiMathWrapperModel, true)) {
            try {
                wmiMathWrapperModel.createMathChildren(string);
                docView = new WmiMathDocumentView(wmiMathDocumentModel, new WmiIndexedViewFactory());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
                WmiMathToolsFormatter wmiMathToolsFormatter = new WmiMathToolsFormatter(docView, 1, bl);
                if (n < 96) {
                    n = 96;
                }
                WmiMathToolsFormatter.setMaxWidth(n);
                wmiMathToolsFormatter.format(outputStreamWriter, wmiMathWrapperModel);
                byArray = wmiMathToolsFormatter.getImageData();
            }
            catch (WmiFormatException wmiFormatException) {
                WmiErrorLog.log(wmiFormatException);
            }
            finally {
                WmiModelLock.writeUnlock(wmiMathWrapperModel);
                docView.release();
                WmiCaret.cancelTimer();
            }
        } else {
            return null;
        }
        return byArray;
    }

    public static int[] getImageDimensions(String string, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException, WmiInvalidModelInitializationException, IOException {
        return WmiMathTools.getImageDimensions(string, n, null, false);
    }

    public static int[] getImageDimensions(String string, WmiMathDocumentModel wmiMathDocumentModel, int n) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException, WmiInvalidModelInitializationException, IOException {
        return WmiMathTools.getImageDimensions(string, n, wmiMathDocumentModel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getImageDimensions(String string, int n, WmiMathDocumentModel wmiMathDocumentModel, boolean bl) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException, WmiInvalidModelInitializationException, IOException {
        int[] nArray = new int[3];
        WmiMathDocumentModel wmiMathDocumentModel2 = wmiMathDocumentModel == null ? new WmiMathDocumentModel() : wmiMathDocumentModel;
        WmiMathWrapperModel wmiMathWrapperModel = null;
        if (bl) {
            WmiMathOperatorModel.disableStretchyOps = true;
        }
        if (WmiModelLock.writeLock(wmiMathDocumentModel2, true)) {
            try {
                if (WmiMathTools.isMathML(string)) {
                    WmiModel wmiModel;
                    WmiMathMLImportParser wmiMathMLImportParser = new WmiMathMLImportParser();
                    wmiMathMLImportParser.parse(new StringReader(string), (WmiCompositeModel)wmiMathDocumentModel2, 0);
                    WmiMathMLParagraphModel wmiMathMLParagraphModel = (WmiMathMLParagraphModel)wmiMathDocumentModel2.getChild(0);
                    if (wmiMathMLParagraphModel != null && (wmiModel = wmiMathMLParagraphModel.getChild(0)) instanceof WmiMathWrapperModel) {
                        wmiMathWrapperModel = (WmiMathWrapperModel)wmiModel;
                        docView = new WmiMathDocumentView(wmiMathDocumentModel2, new WmiIndexedViewFactory());
                    }
                } else {
                    wmiMathWrapperModel = new WmiMathWrapperModel(wmiMathDocumentModel2);
                    wmiMathWrapperModel.createMathChildren(string);
                    WmiModel[] wmiModelArray = new WmiModel[]{wmiMathWrapperModel};
                    WmiParagraphModel wmiParagraphModel = new WmiParagraphModel(wmiMathDocumentModel2, wmiModelArray);
                    docView = new WmiMathDocumentView(wmiMathDocumentModel2, new WmiIndexedViewFactory());
                }
                nArray = WmiMathTools.getImageDimensions(wmiMathWrapperModel, n, bl);
            }
            finally {
                WmiModelLock.writeUnlock(wmiMathDocumentModel2);
            }
        }
        return nArray;
    }

    public static int[] getImageDimensions(WmiMathWrapperModel wmiMathWrapperModel, int n, boolean bl) throws WmiNoReadAccessException {
        int[] nArray = new int[3];
        if (docView != null && wmiMathWrapperModel != null) {
            WmiMathToolsFormatter wmiMathToolsFormatter = new WmiMathToolsFormatter(docView, 3, bl);
            if (n < 96) {
                n = 96;
            }
            WmiMathToolsFormatter.setMaxWidth(n);
            try {
                wmiMathToolsFormatter.writeMathModel(wmiMathWrapperModel);
                nArray[0] = wmiMathToolsFormatter.getBaseline();
                nArray[1] = wmiMathToolsFormatter.getWidth();
                nArray[2] = wmiMathToolsFormatter.getHeight();
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
                Arrays.fill(nArray, 0);
            }
            catch (IOException iOException) {
                WmiErrorLog.log(iOException);
                Arrays.fill(nArray, 0);
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertMathMLToDotM(String string) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiParseException, WmiModelIndexOutOfBoundsException {
        String string2 = "";
        WmiMathDocumentModel wmiMathDocumentModel = new WmiMathDocumentModel();
        if (WmiModelLock.writeLock(wmiMathDocumentModel, true)) {
            try {
                WmiModel wmiModel;
                WmiMathMLImportParser wmiMathMLImportParser = new WmiMathMLImportParser();
                wmiMathMLImportParser.parse(new StringReader(string), (WmiCompositeModel)wmiMathDocumentModel, 0);
                WmiMathMLParagraphModel wmiMathMLParagraphModel = (WmiMathMLParagraphModel)wmiMathDocumentModel.getChild(0);
                if (wmiMathMLParagraphModel != null && (wmiModel = wmiMathMLParagraphModel.getChild(0)) instanceof WmiMathWrapperModel) {
                    WmiInlineMathModel wmiInlineMathModel = new WmiInlineMathModel(wmiMathDocumentModel);
                    WmiMathWrapperModel wmiMathWrapperModel = (WmiMathWrapperModel)wmiModel;
                    for (int i = 0; i < wmiMathWrapperModel.getChildCount(); ++i) {
                        wmiInlineMathModel.appendChild(wmiMathWrapperModel.getChild(i));
                    }
                    wmiMathWrapperModel.removeChildren(0, wmiMathWrapperModel.getChildCount());
                    wmiMathWrapperModel.appendChild(wmiInlineMathModel);
                    Dag dag = wmiMathWrapperModel.toDag();
                    String string3 = DagBuilder.createDotm(dag);
                    StringBuffer stringBuffer = new StringBuffer();
                    Base64Encoder.encode(string3, stringBuffer);
                    string2 = stringBuffer.toString();
                }
            }
            finally {
                WmiModelLock.writeUnlock(wmiMathDocumentModel);
            }
        }
        return string2;
    }

    private static boolean isMathML(String string) {
        return string.trim().startsWith("<math") && string.trim().endsWith("</math>");
    }

    public static void main(String[] stringArray) {
        try {
            String string = "<math><apply><minus/><apply><times/><cn>2</cn><apply><minus/><ci>y</ci><cn>10</cn></apply></apply></apply></math>";
            int n = 750;
            try {
                boolean bl = WmiMathTools.convertMathMLToGIF(string, n, "C:\\test.gif");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static class WmiMathToolsTest
    extends KernelAdapter
    implements KernelConnectionListener {
        private static String[][] testData = new String[][]{{"int(x,x)", "50"}, {"Int(1/x^(2*m+1)/sqrt(x^2+a^2),x)=(2*m)!/(m!)^2*(sqrt(x^2+a^2)/a^2*Sum((-1)^(m-r+1)*r!*(r-1)!/2/(2*r)!/(4*a^2)^(m-r)/x^(2*r),r=1..m)+(-1)^(m+1)/2^(2*m)/a^(2*m+1)*log((sqrt(x^2+a^2)+a)/x))", "400"}, {"Int(1/x^(2*m+1)/sqrt(x^2+a^2),x)=(2*m)!/(m!)^2*(sqrt(x^2+a^2)/a^2*Sum((-1)^(m-r+1)*r!*(r-1)!/2/(2*r)!/(4*a^2)^(m-r)/x^(2*r),r=1..m)+(-1)^(m+1)/2^(2*m)/a^(2*m+1)*log((sqrt(x^2+a^2)+a)/x))", "400"}, {"sqrt(X)=sqrt(c)*abs(x+b/2/c)", "400"}, {"Int(1/(a+b*x+c*x^2)^n/sqrt((a+b*x+c*x^2)),x)=2*(2*c*x+b)*sqrt((a+b*x+c*x^2))/(2*n-1)/(4*a*c-b^2)/(a+b*x+c*x^2)^n+2*(4*c/(4*a*c-b^2))*(n-1)/(2*n-1)*Int(1/(a+b*x+c*x^2)^(n-1)/sqrt((a+b*x+c*x^2)),x)", "400"}, {"Int((a+b*x+c*x^2)^n*sqrt(a+b*x+c*x^2),x)=(2*n+2)!/((n+1)!)^2/(4*(4*c/(4*a*c-b^2)))^(n+1)*((4*c/(4*a*c-b^2))*(2*c*x+b)*sqrt(a+b*x+c*x^2)/c*Sum(r!*(r+1)!*(4*(4*c/(4*a*c-b^2))*(a+b*x+c*x^2))^r/(2*r+2)!,r=0..n) + Int(1/sqrt(a+b*x+c*x^2),x))", "400"}, {"Int(sqrt(x/(a^3-x^3)),x)=2/3*arcsin((x/a)^(3/2))", "400"}, {"Int(x^m*sin(a*x),x)=cos(a*x)*Sum((-1)^(r+1)*m!/(m-2*r)!*x^(m-2*r)/a^(2*r+1),r=0..floor(m/2))+sin(a*x)*Sum((-1)^r*m!/(m-2*r-1)!*x^(m-2*r-1)/a^(2*r+2),r=0..floor((m-1)/2))", "400"}, {"Int(x^m*cos(a*x),x)=sin(a*x)*Sum((-1)^r*m!/(m-2*r)!*x^(m-2*r)/a^(2*r+1),r=0..floor(m/2))+cos(a*x)*Sum((-1)^r*m!/(m-2*r-1)!*x^(m-2*r-1)/a^(2*r+2),r=0..floor((m-1)/2))", "400"}, {"Int(x^n*arccsc(a*x),x)=x^(n+1)/(n+1)*arccsc(a*x)+1/(n+1)*Int(x^n/sqrt(a^2*x^2-1),x)", "400"}, {"Int(1/x^2*log((x+a)/(x-a)),x)=1/x*log((x-a)/(x+a))-1/a*log((x^2-a^2)/x^2)+(2*a^(m+1))/(m+1)*Sum(1/(m-2*r+2)*(x/a)^(m-2*r+2),r=1..floor((m+1)/2))", "400"}, {"Int(1/x^2*log((x+a)/(x-a)),x)=1/x*log((x-a)/(x+a))-1/a*log((x^2-a^2)/x^2)+(2*a^(m+1))/(m+1)*Sum(1/(m-2*r+2)*(x/a)^(m-2*r+2),r=1..floor((m+1)/2))", "400"}, {"Int(log((a+b*x+c*x^2)),x)=(x+b/2/c)*log(a+b*x+c*x^2)-2*x+sqrt(b^2-4*a*c)/c*arctanh((2*c*x+b)/sqrt(b^2-4*a*c))", "400"}, {"Int(1/(a*exp(m*x)+b*exp(-m*x)),x)=1/m/sqrt(a*b)*arctan(exp(m*x)*sqrt(a/b))", "400"}, {"Int(exp(a*x)*(cos(x))^m*(sin(x))^n,x)=exp(a*x)*(cos(x))^(m-1)*(sin(x))^n*(a*cos(x)+(m+n)*sin(x))/((m+n)^2+a^2)-n*a/((m+n)^2+a^2)*Int(exp(a*x)*(cos(x))^(m-1)*(sin(x))^(n-1),x)+(m-1)*(m+n)/((m+n)^2+a^2)*Int(exp(a*x)*(cos(x))^(m-2)*(sin(x))^n,x)", "400"}, {"Int(x^(-p+1)*BesselJ(p,x),x)=-x^(-p+1)*BesselJ(p-1,x)", "400"}, {"Int(x^(m-1)/(1+x^n),x=0..infinity)=Pi/n/sin(m*Pi/n)", "400"}, {"Int(x^a/(m+x^b)^c,x=0..infinity)=m^((a+1-b*c)/b)/b*GAMMA((a+1)/b)*GAMMA(c-(a+1)/b)/GAMMA(c)", "400"}, {"Int((cos(a*x)-cos(b*x))/x,x=0..infinity)=log(abs(b/a))", "400"}, {"Int(1/(1+tan(x)^m),x=0..Pi/2)=Pi/4", "400"}, {"Int(exp(-a*x^2-b/x^2),x=0..infinity)=sqrt(Pi/a)/2*exp(-2*sqrt(a*b))", "400"}};
        private static final int MATHML_SOURCE = 0;
        private static final int DOTM_SOURCE = 1;
        private static final int GIF_TARGET = 0;
        private static final int BYTE_ARRAY_TARGET = 1;
        private static final int IMAGE_TARGET = 2;
        private static final int TYPEMK_TARGET = 3;
        private static final int DIMENSIONS_TARGET = 4;
        private static int outputFileCounter;
        private static String homeDir;
        private int inputFormat = 0;
        private int outputFormat = 0;
        private boolean disableStretchy = false;
        private SetGetHandler setGetHandler = new SetGetHandler(this);
        private KernelConnection kernelConnection = null;
        private int kernelID = -999;

        public KernelConnection getConnection() {
            return this.kernelConnection;
        }

        public int getKernelID() {
            return this.kernelID;
        }

        public void restart() {
            KernelProxy kernelProxy = KernelProxy.getInstance();
            kernelProxy.evaluate(this.getKernelID(), new KernelAdapter(), "restart;");
        }

        public void processConnection(KernelConnectionEvent kernelConnectionEvent) {
            if (kernelConnectionEvent.getKernelState() == 1) {
                KernelProxy kernelProxy = KernelProxy.getInstance();
                kernelProxy.evaluate(this.getKernelID(), this, "gc();");
            }
        }

        public void processDisconnection(KernelConnectionEvent kernelConnectionEvent) {
        }

        public void setConnection(KernelConnection kernelConnection) {
            this.kernelConnection = kernelConnection;
            this.kernelConnection.getInterfaceProperties().addChangeListener(new KernelInterfacePropertiesChangeAdapter());
        }

        public boolean processError(KernelEvent kernelEvent) {
            System.out.println(kernelEvent.getText());
            return true;
        }

        public boolean processJava(KernelEvent kernelEvent) {
            return JavaCallbackListener.processJava(kernelEvent);
        }

        public boolean processChar(KernelEvent kernelEvent) {
            System.out.println(kernelEvent.getDag().getChild(0).getData());
            return true;
        }

        public boolean processRealMath(KernelEvent kernelEvent) {
            return false;
        }

        public boolean processSet(KernelEvent kernelEvent) {
            this.setGetHandler.processSetHandler(kernelEvent);
            return true;
        }

        public boolean processGet(KernelEvent kernelEvent) {
            this.setGetHandler.processGetHandler(kernelEvent);
            return true;
        }

        public static void main(String[] stringArray) {
            WmiMathToolsTest wmiMathToolsTest = new WmiMathToolsTest();
            wmiMathToolsTest.runTests(testData, stringArray[0], stringArray[1], stringArray[2]);
        }

        public WmiMathToolsTest() {
            homeDir = System.getProperty("user.home") + System.getProperty("file.separator");
        }

        public void runTests(String[][] stringArray, String string, String string2, String string3) {
            String string4 = string.substring(string.indexOf("=") + 1);
            String string5 = string2.substring(string2.indexOf("=") + 1);
            String string6 = string3.substring(string3.indexOf("=") + 1);
            this.inputFormat = string4.toLowerCase().equals("mathml") ? 0 : 1;
            this.outputFormat = string5.toLowerCase().equals("gif") ? 0 : (string5.toLowerCase().equals("bytearray") ? 1 : (string5.toLowerCase().equals("image") ? 2 : (string5.toLowerCase().equals("typemk") ? 3 : 4)));
            this.disableStretchy = string6.toLowerCase().equals("true");
            KernelProxy kernelProxy = KernelProxy.getInstance();
            kernelProxy.createKernelConnection(this);
            outputFileCounter = 1;
            for (int i = 0; i < stringArray.length; ++i) {
                TestCommand testCommand = this.inputFormat == 0 ? new TestCommand("MathML:-ExportPresentation(" + stringArray[i][0] + ");", kernelProxy.getKernelIDs()[0], this) : new TestCommand(stringArray[i][0] + ";", kernelProxy.getKernelIDs()[0], this);
                testCommand.process();
                String string7 = testCommand.getLPrintResult();
                string7 = string7.substring(1, string7.length() - 1);
                this.processResult(string7);
            }
        }

        private void processResult(String string) {
            try {
                int n = Integer.parseInt(testData[outputFileCounter - 1][1]);
                if (this.outputFormat == 0) {
                    if (this.inputFormat == 0) {
                        WmiMathTools.convertMathMLToGIF(string, n, homeDir + "MathToolsResult_" + outputFileCounter + ".gif", this.disableStretchy);
                    } else {
                        WmiMathTools.convertDotMToGIF(string, n, homeDir + "MathToolsResult_" + outputFileCounter + ".gif", this.disableStretchy);
                    }
                } else if (this.outputFormat == 1) {
                    WmiMathTools.convertMathToByteArray(string, n, this.disableStretchy);
                } else if (this.outputFormat == 2) {
                    BufferedImage bufferedImage = WmiMathTools.convertMathMLToImage(string, n, this.disableStretchy);
                } else if (this.outputFormat == 3) {
                    System.out.println(WmiMathTools.convertMathMLToTypeMK(string));
                } else if (this.inputFormat == 0 && this.outputFormat == 4) {
                    int[] nArray = WmiMathTools.getImageDimensions(string, n, null, this.disableStretchy);
                    System.out.println(nArray[0] + ", " + nArray[1] + ", " + nArray[2]);
                } else {
                    int[] nArray = WmiMathTools.getImageDimensions(string, n, null, this.disableStretchy);
                    System.out.println(nArray[0] + ", " + nArray[1] + ", " + nArray[2]);
                }
                ++outputFileCounter;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        protected static class TestCommand
        extends BlockingEvaluation {
            String command = null;
            String lprintedResult = null;
            Dag dagResult = null;

            protected TestCommand(String string, int n, WmiMathToolsTest wmiMathToolsTest) {
                super(n, wmiMathToolsTest);
                this.command = string;
            }

            public String getCommand() {
                return this.command;
            }

            public void update() {
                this.dagResult = (Dag)this.getResult();
                if (this.dagResult != null) {
                    this.lprintedResult = DagBuilder.lPrint(this.dagResult);
                }
            }

            public String getLPrintResult() {
                return this.lprintedResult;
            }

            public Dag getDagResult() {
                return this.dagResult;
            }
        }
    }

    protected static class WmiMathToolsFormatter
    extends WmiHTMLFormatter {
        private static final int GIF_TARGET = 0;
        private static final int BYTE_ARRAY_TARGET = 1;
        private static final int IMAGE_TARGET = 2;
        private static final int DIMENSIONS_TARGET = 3;
        private static final int HORIZONTAL_PADDING = 3;
        private int target;
        private boolean disableStretchyOps;
        private byte[] imageData = null;
        private BufferedImage image = null;
        private int baseline = 0;
        private int height = 0;
        private int width = 0;

        public WmiMathToolsFormatter(WmiMathDocumentView wmiMathDocumentView, int n, boolean bl) {
            super(wmiMathDocumentView);
            this.target = n;
            this.disableStretchyOps = bl;
        }

        protected void postFormat() throws IOException {
        }

        protected void preFormat() throws IOException, WmiNoReadAccessException {
        }

        public byte[] getImageData() {
            return this.imageData;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public int getBaseline() {
            return this.baseline;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public static int getMaxWidth() {
            return maxWidth;
        }

        protected void formatLinebrokenMathView(WmiParagraphView wmiParagraphView, String string) throws WmiHTMLFormatter.WmiCancelException, WmiNoReadAccessException {
            WmiRenderPath wmiRenderPath = new WmiRenderPath(this.docView);
            wmiRenderPath.push(-wmiParagraphView.getHorizontalOffset(), -wmiParagraphView.getVerticalOffset());
            this.exportPositionedView(wmiParagraphView, wmiRenderPath, string);
            wmiRenderPath.pop();
        }

        protected void exportPositionedView(WmiPositionedView wmiPositionedView, WmiRenderPath wmiRenderPath, String string) throws WmiHTMLFormatter.WmiCancelException, WmiNoReadAccessException {
            this.image = this.drawViewToImage(wmiPositionedView, wmiRenderPath, WmiMathToolsFormatter.getMaxWidth());
            this.baseline = wmiPositionedView.getBaseline();
            this.height = wmiPositionedView.getHeight();
            this.width = wmiPositionedView.getWidth();
            if (this.target == 0) {
                this.createImageFile(this.image, string);
            } else if (this.target == 1) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)byteArrayOutputStream);
                    jPEGImageEncoder.encode(this.image);
                    this.imageData = byteArrayOutputStream.toByteArray();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }

        public BufferedImage drawViewToImage(WmiPositionedView wmiPositionedView, WmiRenderPath wmiRenderPath, int n) throws WmiNoReadAccessException {
            BufferedImage bufferedImage = null;
            int n2 = Math.min(wmiPositionedView.getWidth(), n);
            int n3 = wmiPositionedView.getHeight();
            if (wmiPositionedView.getWidth() > n) {
                n3 = (int)Math.round((double)n3 * ((double)wmiPositionedView.getWidth() * 1.0 / (double)n));
            }
            int n4 = (int)Math.round((double)n3 * 1.1);
            bufferedImage = WmiImageUtilities.createImageObject((int)(n2 + 6), (int)n4);
            wmiPositionedView.setWidth(n2);
            wmiPositionedView.setHeight(n4);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Rectangle rectangle = new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight());
            WmiMathDocumentView wmiMathDocumentView = wmiPositionedView.getDocumentView();
            Color color = wmiMathDocumentView != null ? wmiMathDocumentView.getColor(0) : Color.WHITE;
            graphics2D.setPaint(color);
            graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, rectangle.getWidth(), rectangle.getHeight()));
            wmiRenderPath.setScreenDraw(false);
            wmiRenderPath.drawStringsWithGlyphVectors(false);
            graphics2D.translate(3, (n4 - n3) / 2);
            wmiPositionedView.draw(graphics2D, wmiRenderPath, rectangle);
            return bufferedImage;
        }

        protected boolean createImageFile(BufferedImage bufferedImage, String string) throws WmiHTMLFormatter.WmiCancelException {
            File file = new File(this.getFilename());
            boolean bl = WmiImageUtilities.exportToGIF((BufferedImage)bufferedImage, (String)file.getAbsolutePath());
            if (!bl) {
                file = this.getNextImageFile(1);
                try {
                    BufferedImage bufferedImage2 = bufferedImage;
                    JAI.create((String)"filestore", (RenderedImage)bufferedImage2, (Object)file.getPath(), (Object)"JPEG");
                    bl = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return bl;
        }
    }
}

