/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPosition;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class WmiAbstractInlineWrapperView
extends WmiInlineView {
    protected WmiMathDocumentView doc = null;

    protected WmiAbstractInlineWrapperView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
        this.doc = wmiMathDocumentView;
    }

    protected void drawDecorator(Graphics graphics, WmiRenderPath wmiRenderPath) {
        graphics.setColor(this.getDecoratorColor());
        graphics.drawRect(this.x + wmiRenderPath.getHorizontalOffset(), this.y + wmiRenderPath.getVerticalOffset(), this.width, this.height);
    }

    public boolean isDecoratorVisible() {
        return true;
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        super.draw(graphics, wmiRenderPath, rectangle);
        if (this.isDecoratorVisible()) {
            Color color = graphics.getColor();
            this.drawDecorator(graphics, wmiRenderPath);
            graphics.setColor(color);
        }
    }

    public WmiViewPosition getFinalPosition() throws WmiNoReadAccessException {
        WmiViewPosition wmiViewPosition = null;
        WmiView wmiView = WmiViewUtil.findLastPhysicalDescendantOfTag(this, WmiModelTag.TEXT);
        if (wmiView instanceof WmiTextView) {
            int n = ((WmiTextView)wmiView).getEndOffset() - ((WmiTextView)wmiView).getStartOffset();
            wmiViewPosition = new WmiViewPosition((WmiPositionedView)wmiView, n);
        }
        return wmiViewPosition;
    }

    public boolean stepInto() {
        return false;
    }

    protected abstract Color getDecoratorColor();

    public abstract WmiAbstractInlineWrapperView createViewOfSameClass(WmiModel var1, WmiMathDocumentView var2);
}

