/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiDocumentScroller;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.view.WmiContainerView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class WmiBoundsMarker
implements WmiPositionMarker {
    protected WmiMathDocumentView docView;
    private WmiPositionedView positionedView = null;
    protected int left = 0;
    protected int top = 0;
    protected int height = 0;
    protected int width = 0;
    private boolean visible = false;

    protected WmiBoundsMarker(WmiMathDocumentView wmiMathDocumentView) {
        this.docView = wmiMathDocumentView;
    }

    public void drawBounds(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
    }

    public void updateView(WmiPositionedView wmiPositionedView) {
        this.positionedView = wmiPositionedView;
        this.height = this.positionedView.getHeight();
        this.width = this.positionedView.getWidth();
        Point point = WmiViewUtil.getAbsoluteOffset(this.positionedView);
        this.left = point.x;
        this.top = point.y;
        this.docView.notifyMarkerPositionChanged();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.left, this.top, this.width, this.height);
    }

    public WmiModelPosition getModelPosition() {
        WmiModelPosition wmiModelPosition = null;
        if (this.positionedView != null) {
            WmiModel wmiModel = this.positionedView.getModel();
            wmiModelPosition = new WmiModelPosition(wmiModel, this.getOffset());
        }
        return wmiModelPosition;
    }

    public WmiViewPath getViewPath() {
        WmiViewPath wmiViewPath = null;
        if (this.visible && this.positionedView != null) {
            wmiViewPath = new WmiViewPath(this.positionedView);
        }
        return wmiViewPath;
    }

    public void hide() {
        this.visible = false;
        if (this.positionedView instanceof WmiContainerView) {
            ((WmiContainerView)((Object)this.positionedView)).setFocus(false);
        }
        this.docView.setFocusedView(null);
        this.docView.repaint(new Rectangle(this.left, this.top, this.width + 1, this.height + 1));
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isReadOnly() throws WmiNoReadAccessException {
        WmiMathDocumentModel wmiMathDocumentModel;
        WmiModel wmiModel;
        boolean bl = false;
        if (this.positionedView != null && (wmiModel = this.positionedView.getModel()) != null && (wmiMathDocumentModel = wmiModel.getDocument()) != null) {
            bl = !wmiMathDocumentModel.isMutableModel(wmiModel);
        }
        return bl;
    }

    public void paint(Graphics graphics) {
        if (this.visible && this.positionedView != null && this.positionedView.getModel() != null) {
            Point point = WmiViewUtil.getAbsoluteOffset(this.positionedView);
            this.left = point.x;
            this.top = point.y;
            Color color = graphics.getColor();
            Color color2 = RuntimePlatform.isMac() ? Color.GRAY : this.docView.getColor(4);
            graphics.setColor(color2);
            this.drawBounds(graphics, this.left, this.top, this.width, this.height);
            graphics.setColor(color);
        }
    }

    public void scrollVisible() {
        WmiDocumentScroller.scrollVisible(this.docView, this.getBounds());
    }

    public void scrollToTop() {
        WmiDocumentScroller.scrollToTop(this.docView, this.getBounds());
    }

    public void show() {
        this.visible = true;
        if (this.positionedView != null) {
            this.docView.setFocusedView(this.positionedView);
        }
    }

    public WmiPositionedView getView() {
        return this.positionedView;
    }

    public int getOffset() {
        return 0;
    }

    public void resync() throws WmiNoReadAccessException {
        WmiView wmiView;
        WmiModel wmiModel;
        if (this.positionedView != null && (wmiModel = this.positionedView.getModel()) != null && (wmiView = WmiViewUtil.modelToView(this.positionedView.getDocumentView(), wmiModel, 0)) instanceof WmiPositionedView) {
            this.positionedView = (WmiPositionedView)wmiView;
        }
        this.show();
    }

    public void updateMarkerPosition(WmiModel wmiModel, int n) throws WmiNoReadAccessException {
    }
}

