/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelObserver;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.view.WmiAccessibleContext;
import com.maplesoft.mathdoc.view.WmiAggregateSelection;
import com.maplesoft.mathdoc.view.WmiArrayCompositeView;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiSwitchableCompositeView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiFencedView;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public class WmiGenericView
implements WmiPositionedView,
WmiModelObserver {
    private WmiMathDocumentView docView = null;
    private WmiModel model;
    private WmiCompositeView parent;
    protected int height = 0;
    protected int width = 0;
    protected int x = 0;
    protected int y = 0;
    protected int baseline = 0;
    private int validated = 0;
    protected WmiPositionedView[] neighbors = null;
    protected WmiPositionedView[] locations = null;
    private WmiModelObserver nextObserver = null;
    static /* synthetic */ Class class$com$maplesoft$mathdoc$view$WmiSwitchableCompositeView;

    public WmiGenericView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        this(wmiModel, wmiMathDocumentView, null);
    }

    public WmiGenericView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView, WmiCompositeView wmiCompositeView) {
        this.model = wmiModel;
        this.parent = wmiCompositeView;
        this.docView = wmiMathDocumentView;
        this.registerObserver();
    }

    public WmiModel getModel() {
        return this.model;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public WmiCompositeView getParentView() {
        return this.parent;
    }

    public void setParentView(WmiCompositeView wmiCompositeView) {
        this.parent = wmiCompositeView;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getBaseline() {
        return this.baseline;
    }

    public void setBaseline(int n) {
        this.baseline = n;
    }

    public void setHorizontalOffset(int n) {
        this.x = n;
    }

    public void setVerticalOffset(int n) {
        this.y = n;
    }

    public int getHorizontalOffset() {
        return this.x;
    }

    public int getVerticalOffset() {
        return this.y;
    }

    public boolean isLayoutValid() {
        return (this.validated & 1) != 0;
    }

    public boolean isContentValid() {
        return (this.validated & 2) != 0;
    }

    public void markValid(int n) {
        this.validated |= n;
    }

    public void markInvalid(int n) {
        this.validated &= ~n;
    }

    public void resetPaintFlags() {
        this.validated &= 0xFFFFFFF3;
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
    }

    public void invalidate(int n) {
        this.validated &= ~n;
        if ((n & 1) != 0 && this.parent != null && this.parent.isLayoutValid()) {
            this.parent.invalidate(1);
        }
    }

    public void layoutView() throws WmiNoReadAccessException {
        this.markValid(1);
        this.checkRepaint();
    }

    public void paintDirty() {
        if ((this.validated & 0xC) != 0) {
            this.getDocumentView();
            Point point = WmiViewUtil.getAbsoluteOffset(this);
            this.docView.repaint(point.x - 1, point.y - 1, this.width + 2, this.height + 2);
        }
        this.resetPaintFlags();
    }

    public boolean getForceRepaint() {
        return (this.validated & 4) != 0;
    }

    public boolean getCheckRepaint() {
        return (this.validated & 8) != 0;
    }

    public void forceRepaint() {
        this.validated |= 4;
    }

    public void checkRepaint() {
        this.validated |= 8;
    }

    public void updateView() throws WmiNoReadAccessException {
        this.invalidate(1);
        this.markValid(2);
    }

    public void release() {
        WmiViewFactory wmiViewFactory;
        WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
        if (wmiMathDocumentView != null && (wmiViewFactory = wmiMathDocumentView.getViewFactory()) != null) {
            wmiViewFactory.releaseView(this);
        }
        this.quickRelease();
    }

    public void quickRelease() {
        this.releaseObserver();
        this.model = null;
        this.parent = null;
        this.docView = null;
    }

    public String debugPrint(int n) throws WmiNoReadAccessException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getModel().getTag().toString();
        stringBuffer.append(this.createIndent(n));
        stringBuffer.append("<");
        stringBuffer.append(string);
        stringBuffer.append(" x = ");
        stringBuffer.append(this.x);
        stringBuffer.append(" y = ");
        stringBuffer.append(this.y);
        stringBuffer.append(" width = ");
        stringBuffer.append(this.width);
        stringBuffer.append(" height = ");
        stringBuffer.append(this.height);
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    public String getDebugName() {
        WmiModelTag wmiModelTag = null;
        wmiModelTag = this.getModel().getTag();
        String string = wmiModelTag != null ? wmiModelTag.toString() : this.getClass().toString();
        return string;
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    protected AccessibleContext createAccessibleContext() {
        return new WmiAccessibleContext();
    }

    public void setPositionMarker(int n) {
    }

    public WmiPositionedView getChildView(Point point) {
        return null;
    }

    public boolean getIntersectingChildViews(Shape shape, WmiAggregateSelection wmiAggregateSelection, int n) {
        return false;
    }

    public WmiPositionedView getViewForNavigation(int n, Point point) {
        return this.getNearestChildView(point);
    }

    public WmiPositionedView getNearestChildView(Point point) {
        return null;
    }

    public WmiMathDocumentView getDocumentView() {
        if (this.docView == null) {
            this.docView = WmiViewUtil.getDocumentView(this);
        }
        return this.docView;
    }

    public WmiView copyView() {
        WmiGenericView wmiGenericView = null;
        try {
            wmiGenericView = (WmiGenericView)this.clone();
            wmiGenericView.registerObserver();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            WmiErrorLog.log(cloneNotSupportedException);
        }
        return wmiGenericView;
    }

    public int getZoomFactor() {
        int n = 133;
        WmiCompositeView wmiCompositeView = this.getParentView();
        if (wmiCompositeView instanceof WmiPositionedView) {
            n = ((WmiPositionedView)((Object)wmiCompositeView)).getZoomFactor();
        }
        return n;
    }

    protected void verifyReadLock() throws WmiNoReadAccessException {
        if (this.model == null || !WmiModelLock.hasLock(this.model, 0) && !WmiModelLock.ownsWriteLock(this.model)) {
            throw new WmiNoReadAccessException(this.model);
        }
    }

    protected void verifyUpdateLock() throws WmiNoUpdateAccessException {
        if (this.model == null || !WmiModelLock.hasLock(this.model, 2)) {
            throw new WmiNoUpdateAccessException(this.model);
        }
    }

    protected boolean hasUpdateLock() {
        return this.model != null && WmiModelLock.hasLock(this.model, 2);
    }

    protected String createIndent(int n) {
        byte[] byArray = new byte[n];
        Arrays.fill(byArray, (byte)32);
        return new String(byArray);
    }

    public WmiPositionedView getNextView(int n) {
        WmiPositionedView wmiPositionedView = null;
        if (n >= 0) {
            if (this.neighbors != null) {
                wmiPositionedView = this.neighbors[n];
            }
        } else if (this.locations != null) {
            int n2 = n * -1 - 1;
            wmiPositionedView = this.locations[n2];
        }
        return wmiPositionedView;
    }

    public void setNextView(WmiPositionedView wmiPositionedView, int n) {
        WmiPositionedView wmiPositionedView2 = wmiPositionedView;
        if (wmiPositionedView2 != null && !wmiPositionedView2.isNavagableView()) {
            wmiPositionedView2 = null;
        }
        if (n >= 0) {
            if (this.neighbors == null) {
                this.neighbors = new WmiPositionedView[4];
            }
            this.neighbors[n] = wmiPositionedView2;
        } else {
            if (this.locations == null) {
                this.locations = new WmiPositionedView[4];
            }
            int n2 = n * -1 - 1;
            this.locations[n2] = wmiPositionedView2;
        }
    }

    public void addNavigationLinks() {
    }

    public boolean isNavagableView() {
        return true;
    }

    public WmiModelObserver getNextObserver() {
        return this.nextObserver;
    }

    public void setNextObserver(WmiModelObserver wmiModelObserver) {
        this.nextObserver = wmiModelObserver;
    }

    public void registerObserver() {
        if (this.model != null) {
            this.model.addObserver(this);
        }
    }

    public void releaseObserver() {
        if (this.model != null) {
            this.model.releaseObserver(this);
        }
    }

    public int doExplicitLinebreak(WmiParagraphView wmiParagraphView) throws WmiNoReadAccessException {
        return 0;
    }

    public int doImplicitLinebreak(WmiParagraphView wmiParagraphView, int n, int n2, int n3) throws WmiNoReadAccessException {
        int n4 = 0;
        WmiCompositeView wmiCompositeView = this.getParentView();
        int n5 = wmiCompositeView.indexOf(this);
        if (n5 >= 0) {
            n4 = 2;
            if (wmiParagraphView.isStartOfLine(this)) {
                wmiParagraphView.split(wmiCompositeView, n5 + 1, 0);
            } else {
                wmiParagraphView.split(wmiCompositeView, n5, 0);
            }
        }
        return n4;
    }

    public int doForcedLinebreak(WmiParagraphView wmiParagraphView, int n, int n2) throws WmiNoReadAccessException {
        return 0;
    }

    public boolean hasGoodBreakpoint(int n, int n2, int n3) throws WmiNoReadAccessException {
        return false;
    }

    public static WmiPositionedView addBrackets(WmiPositionedView wmiPositionedView) throws WmiNoReadAccessException {
        Object object;
        WmiGenericView wmiGenericView = null;
        WmiMathDocumentView wmiMathDocumentView = wmiPositionedView.getDocumentView();
        WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
        WmiModel wmiModel = wmiPositionedView.getModel();
        WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.MATH);
        WmiAttributeSet wmiAttributeSet = wmiCompositeModel != null ? wmiCompositeModel.getAttributesForRead() : null;
        String string = wmiAttributeSet != null ? (String)wmiAttributeSet.getAttribute("font_style_name") : null;
        WmiMathContext wmiMathContext = new WmiMathContext(wmiMathDocumentModel.getFontStyle(string));
        try {
            object = new WmiModel[]{};
            WmiMathFencedModel wmiMathFencedModel = new WmiMathFencedModel(wmiMathDocumentModel, (WmiModel[])object, wmiMathContext);
            wmiGenericView = new WmiFencedView(wmiMathFencedModel, wmiPositionedView.getDocumentView());
        }
        catch (WmiInvalidModelInitializationException wmiInvalidModelInitializationException) {
            WmiErrorLog.log(wmiInvalidModelInitializationException);
        }
        object = wmiPositionedView.getParentView();
        int n = object.indexOf(wmiPositionedView);
        if (wmiGenericView != null && n >= 0) {
            ((WmiArrayCompositeView)wmiGenericView).appendView(wmiPositionedView);
            object.replaceChild(wmiGenericView, n);
            wmiGenericView.setParentView((WmiCompositeView)object);
        }
        wmiGenericView.releaseObserver();
        ((WmiFencedView)wmiGenericView).layoutView();
        return wmiGenericView != null ? wmiGenericView : wmiPositionedView;
    }

    public static boolean areBracketsRequired(WmiModel wmiModel) throws WmiNoReadAccessException {
        boolean bl = false;
        if (wmiModel instanceof WmiCompositeModel && wmiModel.getTag() == WmiModelTag.MATH_ROW) {
            int n = ((WmiCompositeModel)wmiModel).getChildCount();
            if (n == 1) {
                bl = WmiGenericView.areBracketsRequired(((WmiCompositeModel)wmiModel).getChild(0));
            } else if (n > 1) {
                bl = true;
            }
        }
        return bl;
    }

    public void setCursor(Cursor cursor) {
        this.parent.setCursor(cursor);
    }

    public int getHeightConstraint() {
        int n = -1;
        if (this.parent instanceof WmiPositionedView) {
            n = ((WmiPositionedView)((Object)this.parent)).getHeightConstraint();
        }
        return n;
    }

    public int getWidthConstraint(boolean bl) {
        int n = -1;
        if (this.parent instanceof WmiPositionedView) {
            n = ((WmiPositionedView)((Object)this.parent)).getWidthConstraint(bl);
        }
        return n;
    }

    protected class WmiAccessibleGenericView
    extends AccessibleContext
    implements AccessibleComponent {
        protected Boolean viewIsPhysical = null;

        public WmiAccessibleGenericView() {
            this(null);
        }

        public WmiAccessibleGenericView(String string, String string2) {
            this(string);
            if (string2 != null) {
                this.setAccessibleDescription(string2);
            }
        }

        public WmiAccessibleGenericView(String string) {
            WmiModelTag wmiModelTag;
            WmiModel wmiModel;
            if (string == null && (wmiModel = WmiGenericView.this.getModel()) != null && (wmiModelTag = wmiModel.getTag()) != null) {
                string = wmiModelTag.getName();
            }
            this.setAccessibleName(string);
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public int getAccessibleIndexInParent() {
            int n = -1;
            Accessible accessible = this.getAccessibleParent();
            if (accessible != null) {
                AccessibleContext accessibleContext = accessible.getAccessibleContext();
                int n2 = accessibleContext.getAccessibleChildrenCount();
                for (int i = 0; i < n2 && n < 0; ++i) {
                    if (accessibleContext.getAccessibleChild(i).getAccessibleContext() != this) continue;
                    n = i;
                }
            }
            return n;
        }

        public Accessible getAccessibleParent() {
            return WmiGenericView.this.getParentView();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AccessibleStateSet getAccessibleStateSet() {
            Object object;
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            accessibleStateSet.add(AccessibleState.VISIBLE);
            accessibleStateSet.add(AccessibleState.FOCUSABLE);
            accessibleStateSet.add(AccessibleState.TRANSIENT);
            WmiModel wmiModel = WmiGenericView.this.getModel();
            if (WmiGenericView.this.docView != null && (object = WmiGenericView.this.docView.getCaret()) != null && WmiGenericView.this == ((WmiCaret)object).getView()) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            if (wmiModel != null) {
                object = wmiModel.getDocument();
                boolean bl = WmiModelLock.readLock((WmiModel)object, true);
                try {
                    if (((WmiMathDocumentModel)object).isMutableModel(wmiModel)) {
                        accessibleStateSet.add(AccessibleState.EDITABLE);
                    }
                }
                catch (WmiNoReadAccessException wmiNoReadAccessException) {
                    WmiErrorLog.log(wmiNoReadAccessException);
                }
                finally {
                    if (bl) {
                        WmiModelLock.readUnlock((WmiModel)object);
                    }
                }
            }
            return accessibleStateSet;
        }

        public Locale getLocale() throws IllegalComponentStateException {
            return Locale.getDefault();
        }

        public void addFocusListener(FocusListener focusListener) {
        }

        public boolean contains(Point point) {
            boolean bl = false;
            Rectangle rectangle = this.getBounds();
            if (point != null && rectangle != null) {
                bl = rectangle.contains(point);
            }
            return bl;
        }

        public Accessible getAccessibleAt(Point point) {
            WmiMathDocumentView wmiMathDocumentView = WmiGenericView.this.getDocumentView();
            WmiPositionedView wmiPositionedView = wmiMathDocumentView.getNearestChildView(point);
            return wmiPositionedView;
        }

        public Color getBackground() {
            return null;
        }

        public Rectangle getBounds() {
            return WmiGenericView.this.getBounds();
        }

        public Cursor getCursor() {
            return null;
        }

        public Font getFont() {
            return null;
        }

        public FontMetrics getFontMetrics(Font font) {
            return null;
        }

        public Color getForeground() {
            return null;
        }

        public Point getLocation() {
            return new Point(WmiGenericView.this.getHorizontalOffset(), WmiGenericView.this.getVerticalOffset());
        }

        public Point getLocationOnScreen() {
            WmiMathDocumentView wmiMathDocumentView = WmiGenericView.this.getDocumentView();
            Point point = wmiMathDocumentView.getLocationOnScreen();
            Point point2 = WmiViewUtil.getAbsoluteOffset(WmiGenericView.this);
            point.translate((int)point2.getX(), (int)point2.getY());
            return point;
        }

        public Dimension getSize() {
            return WmiGenericView.this.getSize();
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public boolean isShowing() {
            return true;
        }

        public boolean isVisible() {
            return true;
        }

        public void removeFocusListener(FocusListener focusListener) {
            System.err.println("Attempt to remove focus listener to view " + this.getAccessibleName());
        }

        public void requestFocus() {
            System.err.println("Attempt to request focus on view " + this.getAccessibleName());
        }

        public void setBackground(Color color) {
        }

        public void setBounds(Rectangle rectangle) {
        }

        public void setCursor(Cursor cursor) {
        }

        public void setEnabled(boolean bl) {
        }

        public void setFont(Font font) {
        }

        public void setForeground(Color color) {
        }

        public void setLocation(Point point) {
        }

        public void setSize(Dimension dimension) {
        }

        public void setVisible(boolean bl) {
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public void firePropertyChange(String string, Object object, Object object2) {
        }

        public boolean isPhysicalView() {
            if (this.viewIsPhysical == null) {
                WmiRowView wmiRowView;
                boolean bl = true;
                WmiSwitchableCompositeView wmiSwitchableCompositeView = (WmiSwitchableCompositeView)WmiViewUtil.findAncestorOfClass(WmiGenericView.this, class$com$maplesoft$mathdoc$view$WmiSwitchableCompositeView == null ? (class$com$maplesoft$mathdoc$view$WmiSwitchableCompositeView = WmiGenericView.class$("com.maplesoft.mathdoc.view.WmiSwitchableCompositeView")) : class$com$maplesoft$mathdoc$view$WmiSwitchableCompositeView);
                if (wmiSwitchableCompositeView != null && (wmiRowView = wmiSwitchableCompositeView.getRootPhysicalView()) != null) {
                    bl = WmiViewUtil.isViewAncestorOfView(wmiRowView, WmiGenericView.this);
                }
                this.viewIsPhysical = bl;
            }
            return this.viewIsPhysical;
        }
    }
}

