/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiClipboardManager;
import com.maplesoft.mathdoc.controller.WmiInputMethodRequestHandler;
import com.maplesoft.mathdoc.controller.WmiMathDocumentKeyListener;
import com.maplesoft.mathdoc.controller.WmiMathDocumentMouseListener;
import com.maplesoft.mathdoc.controller.WmiMathMLClipboardManager;
import com.maplesoft.mathdoc.controller.WmiMathMLKeyListener;
import com.maplesoft.mathdoc.controller.WmiViewFactory;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiMathMLDocumentModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Container;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.JViewport;

public class WmiMathMLDocumentView
extends WmiMathDocumentView {
    private boolean useBreakWidth = false;

    public WmiMathMLDocumentView(WmiMathDocumentModel wmiMathDocumentModel, WmiViewFactory wmiViewFactory) {
        super(wmiMathDocumentModel, wmiViewFactory);
        this.createListeners();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addKeyEventDispatcher(new MathMLKeyEventDispatcher());
    }

    public WmiMathMLDocumentView() {
        this(new WmiMathMLDocumentModel(), null);
    }

    protected void createListeners() {
        this.documentMouseListener = new WmiMathDocumentMouseListener(this);
        this.addMouseListener(this.documentMouseListener);
        this.addMouseMotionListener(this.documentMouseListener);
        this.addFocusListener(this);
        this.documentKeyListener = new WmiMathMLKeyListener(this);
        this.addKeyListener(this.documentKeyListener);
        if (RuntimePlatform.isWindows() || RuntimePlatform.isMac()) {
            this.inputHandler = new WmiInputMethodRequestHandler(this);
        }
        this.addInputMethodListener(this.inputHandler);
    }

    public Rectangle getVisibleRegion() {
        Rectangle rectangle = null;
        Container container = this.getParent();
        if (container instanceof JViewport) {
            rectangle = ((JViewport)container).getViewRect();
        } else if (container != null) {
            rectangle = container.getBounds();
        }
        return rectangle;
    }

    protected void calculatePendingBreakWidth() {
        Container container = this.getParent();
        if (this.useBreakWidth) {
            this.pendingBreakWidth = this.breakWidth;
        } else if (container instanceof JViewport) {
            Rectangle rectangle = ((JViewport)container).getViewRect();
            this.pendingBreakWidth = rectangle.width - 10;
        } else {
            this.pendingBreakWidth = container != null ? container.getWidth() : 0;
        }
        if (this.pendingBreakWidth <= 0) {
            this.pendingBreakWidth = 400;
        }
    }

    public void setBreakWidth(int n) {
        this.useBreakWidth = true;
        this.breakWidth = n;
    }

    public WmiClipboardManager getClipboardManager() {
        if (this.clipboardManager == null) {
            this.clipboardManager = new WmiMathMLClipboardManager(this);
        }
        return this.clipboardManager;
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            this.setSelection(null);
        }
        super.focusLost(focusEvent);
    }

    private class MathMLKeyEventDispatcher
    implements KeyEventDispatcher {
        private MathMLKeyEventDispatcher() {
        }

        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\t') {
                WmiMathDocumentKeyListener wmiMathDocumentKeyListener = WmiMathMLDocumentView.this.getKeyListener();
                if (keyEvent.getID() == 401) {
                    wmiMathDocumentKeyListener.keyPressed(keyEvent);
                } else if (keyEvent.getID() == 402) {
                    wmiMathDocumentKeyListener.keyReleased(keyEvent);
                } else if (keyEvent.getID() == 400) {
                    wmiMathDocumentKeyListener.keyTyped(keyEvent);
                }
                return true;
            }
            return false;
        }
    }
}

