/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.controller.WmiDocumentScroller;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSwitchableCompositeView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewPathInterval;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class WmiPathHighlighter {
    private static final int SELECTION_START_MODE = 0;
    private static final int SELECTION_END_MODE = 1;
    private Rectangle top;
    private Rectangle bottom;
    private Rectangle fill;
    private WmiMathDocumentView docView;
    private Rectangle dirtyRegion;

    public WmiPathHighlighter(WmiMathDocumentView wmiMathDocumentView, WmiViewPathInterval wmiViewPathInterval) {
        this(wmiMathDocumentView, wmiViewPathInterval, null);
    }

    public WmiPathHighlighter(WmiMathDocumentView wmiMathDocumentView, WmiViewPathInterval wmiViewPathInterval, WmiPathHighlighter wmiPathHighlighter) {
        this.docView = wmiMathDocumentView;
        WmiViewPath wmiViewPath = wmiViewPathInterval.getSelectionStartPath();
        WmiViewPath wmiViewPath2 = wmiViewPathInterval.getSelectionEndPath();
        int[] nArray = new int[1];
        WmiCompositeView wmiCompositeView = this.findSelectionParent(wmiViewPath, wmiViewPath2, nArray);
        int n = nArray[0];
        WmiInlineView wmiInlineView = this.findInline(wmiCompositeView, wmiViewPath, n, 0);
        WmiInlineView wmiInlineView2 = this.findInline(wmiCompositeView, wmiViewPath2, n, 1);
        if (wmiInlineView != null && wmiInlineView2 != null) {
            int n2 = this.findHorizontalOffset(wmiCompositeView, wmiViewPath, n, 0);
            int n3 = this.findHorizontalOffset(wmiCompositeView, wmiViewPath2, n, 1);
            Point point = WmiViewUtil.getAbsoluteOffset(wmiInlineView);
            Point point2 = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)((Object)wmiCompositeView));
            int n4 = point2.x;
            int n5 = ((WmiPositionedView)((Object)wmiCompositeView)).getWidth();
            int n6 = wmiInlineView2 == wmiInlineView ? n3 - n2 : n5 - (n2 - n4);
            int n7 = wmiInlineView2 == wmiInlineView ? 0 : n3 - n4;
            this.top = new Rectangle(n2, point.y, n6, wmiInlineView.getHeight());
            if (wmiInlineView2 != wmiInlineView) {
                point = WmiViewUtil.getAbsoluteOffset(wmiInlineView2);
                this.bottom = new Rectangle(n4, point.y, n7, wmiInlineView2.getHeight());
                if (this.bottom.y > this.top.y + this.top.height) {
                    this.fill = new Rectangle(n4, this.top.y + this.top.height, n5, this.bottom.y - (this.top.y + this.top.height));
                }
            }
        }
        this.computeDirtyRegions(wmiPathHighlighter);
    }

    public void paint(Graphics graphics) {
        Color color = graphics.getColor();
        Color color2 = this.getHighlightColor();
        graphics.setColor(color2);
        if (this.top != null) {
            graphics.fillRect(this.top.x, this.top.y, this.top.width, this.top.height);
        }
        if (this.fill != null) {
            graphics.fillRect(this.fill.x, this.fill.y, this.fill.width, this.fill.height);
        }
        if (this.bottom != null) {
            graphics.fillRect(this.bottom.x, this.bottom.y, this.bottom.width, this.bottom.height);
        }
        graphics.setColor(color);
    }

    public void repaintDirtyRegions() {
        if (this.dirtyRegion != null) {
            this.docView.repaint(this.dirtyRegion);
        } else {
            this.docView.repaint();
        }
    }

    public void scrollVisible() {
        Rectangle rectangle = this.computeBounds();
        WmiDocumentScroller.scrollVisible(this.docView, rectangle);
    }

    public int getLeftBoundary(int n) {
        int n2 = -1;
        if (this.top != null && n >= this.top.y) {
            if (n < this.top.y + this.top.height) {
                n2 = this.top.x;
            } else if (this.fill != null && n < this.fill.y + this.fill.height) {
                n2 = this.fill.x;
            } else if (this.bottom != null && n < this.bottom.y + this.bottom.height) {
                n2 = this.bottom.x;
            }
        }
        return n2;
    }

    public int getRightBoundary(int n) {
        int n2 = -1;
        if (this.top != null && n >= this.top.y) {
            if (n < this.top.y + this.top.height) {
                n2 = this.top.x + this.top.width;
            } else if (this.fill != null && n < this.fill.y + this.fill.height) {
                n2 = this.fill.x + this.fill.width;
            } else if (this.bottom != null && n < this.bottom.y + this.bottom.height) {
                n2 = this.bottom.x + this.bottom.width;
            }
        }
        return n2;
    }

    protected Color getHighlightColor() {
        return this.docView.getColor(4);
    }

    private WmiCompositeView findSelectionParent(WmiViewPath wmiViewPath, WmiViewPath wmiViewPath2, int[] nArray) {
        int n;
        int n2;
        WmiView wmiView = null;
        int n3 = wmiViewPath != null ? wmiViewPath.depth() : 0;
        int n4 = wmiViewPath2 != null ? wmiViewPath2.depth() : 0;
        int n5 = n3 < n4 ? n3 : n4;
        wmiView = this.docView;
        for (n2 = 0; n2 < n5 && (n = wmiViewPath.peek(n2)) == wmiViewPath2.peek(n2); ++n2) {
            WmiView wmiView2;
            if (wmiView instanceof WmiSwitchableCompositeView && (wmiView2 = ((WmiSwitchableCompositeView)wmiView).getRootPhysicalView()) != null) {
                wmiView = wmiView2;
            }
            if (!((wmiView2 = wmiView.getChild(n)) instanceof WmiCompositeView)) break;
            wmiView = wmiView2;
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = n2;
        }
        return wmiView;
    }

    private WmiInlineView findInline(WmiCompositeView wmiCompositeView, WmiViewPath wmiViewPath, int n, int n2) {
        WmiInlineView wmiInlineView = null;
        int n3 = n;
        if (wmiViewPath != null) {
            int n4 = wmiViewPath.depth();
            while (true) {
                WmiView wmiView;
                if (wmiCompositeView instanceof WmiSwitchableCompositeView && (wmiView = ((WmiSwitchableCompositeView)wmiCompositeView).getRootPhysicalView()) != null) {
                    wmiCompositeView = wmiView;
                }
                WmiView wmiView2 = n3 < n4 ? wmiCompositeView.getChild(wmiViewPath.peek(n3)) : (wmiView = n2 == 0 ? wmiCompositeView.getChild(0) : wmiCompositeView.getChild(wmiCompositeView.getChildCount() - 1));
                if (wmiView instanceof WmiInlineView) {
                    wmiInlineView = (WmiInlineView)wmiView;
                    break;
                }
                if (!(wmiView instanceof WmiCompositeView)) break;
                wmiCompositeView = wmiView;
                ++n3;
            }
            if (wmiInlineView == null) {
                wmiInlineView = this.findParentInline(wmiCompositeView);
            }
        }
        return wmiInlineView;
    }

    private WmiInlineView findParentInline(WmiCompositeView wmiCompositeView) {
        WmiInlineView wmiInlineView = null;
        while (wmiCompositeView != null) {
            if (wmiCompositeView instanceof WmiInlineView) {
                wmiInlineView = (WmiInlineView)wmiCompositeView;
                break;
            }
            wmiCompositeView = wmiCompositeView.getParentView();
        }
        return wmiInlineView;
    }

    private int findHorizontalOffset(WmiCompositeView wmiCompositeView, WmiViewPath wmiViewPath, int n, int n2) {
        Cloneable cloneable;
        int n3 = 0;
        WmiView wmiView = null;
        int n4 = wmiViewPath.depth();
        int n5 = n;
        while (true) {
            if (wmiCompositeView instanceof WmiSwitchableCompositeView && (cloneable = ((WmiSwitchableCompositeView)wmiCompositeView).getRootPhysicalView()) != null) {
                wmiCompositeView = cloneable;
            }
            if (n5 >= n4) {
                wmiView = null;
                cloneable = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)((Object)wmiCompositeView));
                n3 = n2 == 0 ? ((Point)cloneable).x : ((Point)cloneable).x + ((WmiPositionedView)((Object)wmiCompositeView)).getWidth();
                break;
            }
            wmiView = wmiCompositeView.getChild(wmiViewPath.peek(n5));
            if (!(wmiView instanceof WmiCompositeView)) break;
            wmiCompositeView = (WmiCompositeView)wmiView;
            ++n5;
        }
        if (wmiView instanceof WmiPositionedView) {
            cloneable = WmiViewUtil.getAbsoluteOffset((WmiPositionedView)wmiView);
            n3 = ((Point)cloneable).x;
        }
        if (wmiView instanceof WmiTextView) {
            if (++n5 < n4) {
                n3 += ((WmiTextView)wmiView).getHorizontalOffset(wmiViewPath.peek(n5));
            } else if (n2 == 1) {
                n3 += ((WmiPositionedView)wmiView).getWidth();
            }
        } else if (wmiView != null && n2 == 1) {
            n3 += ((WmiPositionedView)wmiView).getWidth();
        }
        return n3;
    }

    private void computeDirtyRegions(WmiPathHighlighter wmiPathHighlighter) {
        this.dirtyRegion = this.computeBounds();
        if (this.dirtyRegion == null && wmiPathHighlighter != null) {
            this.dirtyRegion = wmiPathHighlighter.computeBounds();
        } else if (wmiPathHighlighter != null) {
            Rectangle rectangle = wmiPathHighlighter.computeBounds();
            if (rectangle == null) {
                return;
            }
            if (rectangle.x != this.dirtyRegion.x || rectangle.width != this.dirtyRegion.width) {
                this.dirtyRegion = SwingUtilities.computeUnion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.dirtyRegion);
            } else if (rectangle.y == this.dirtyRegion.y && rectangle.height == this.dirtyRegion.height) {
                this.dirtyRegion = this.top.x != wmiPathHighlighter.top.x || this.top.width != wmiPathHighlighter.top.width ? SwingUtilities.computeUnion(this.top.x, this.top.y, this.top.width, this.top.height, wmiPathHighlighter.top) : (this.bottom != null && wmiPathHighlighter.bottom != null ? SwingUtilities.computeUnion(this.bottom.x, this.bottom.y, this.bottom.width, this.bottom.height, wmiPathHighlighter.bottom) : null);
            } else if (this.dirtyRegion.y != rectangle.y) {
                if (this.dirtyRegion.y + this.dirtyRegion.height == rectangle.y + rectangle.height) {
                    int n = this.dirtyRegion.y;
                    int n2 = rectangle.y;
                    int n3 = Math.min(n, n2);
                    int n4 = Math.max(n += this.top.height, n2 += wmiPathHighlighter.top.height);
                    int n5 = Math.min(this.dirtyRegion.x, rectangle.x);
                    int n6 = Math.max(this.dirtyRegion.x + this.dirtyRegion.width, rectangle.x + rectangle.width);
                    this.dirtyRegion = new Rectangle(n5, n3, n6 - n5 + 1, n4 - n3 + 1);
                } else {
                    this.dirtyRegion = SwingUtilities.computeUnion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.dirtyRegion);
                }
            } else {
                int n = this.dirtyRegion.y + this.dirtyRegion.height;
                int n7 = rectangle.y + rectangle.height;
                int n8 = Math.max(n, n7);
                if (this.bottom != null) {
                    n -= this.bottom.height;
                }
                if (wmiPathHighlighter.bottom != null) {
                    n7 -= wmiPathHighlighter.bottom.height;
                }
                int n9 = Math.min(n, n7);
                int n10 = Math.min(this.dirtyRegion.x, rectangle.x);
                int n11 = Math.max(this.dirtyRegion.x + this.dirtyRegion.width, rectangle.x + rectangle.width);
                this.dirtyRegion = new Rectangle(n10, n9, n11 - n10 + 1, n8 - n9 + 1);
            }
        }
    }

    private Rectangle computeBounds() {
        Rectangle rectangle;
        Rectangle rectangle2 = rectangle = this.top != null ? new Rectangle(this.top.x, this.top.y, this.top.width, this.top.height) : null;
        if (rectangle != null) {
            if (this.fill != null) {
                rectangle = SwingUtilities.computeUnion(this.fill.x, this.fill.y, this.fill.width, this.fill.height, rectangle);
            }
            if (this.bottom != null) {
                rectangle = SwingUtilities.computeUnion(this.bottom.x, this.bottom.y, this.bottom.width, this.bottom.height, rectangle);
            }
        }
        return rectangle;
    }

    public Point getPointAtEnd() {
        Point point = null;
        if (this.bottom != null) {
            Rectangle rectangle = this.bottom.getBounds();
            point = new Point(rectangle.x + rectangle.width, rectangle.height);
        } else if (this.top != null) {
            Rectangle rectangle = this.top.getBounds();
            point = new Point(rectangle.x + rectangle.width, rectangle.height);
        }
        return point;
    }
}

