/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.view.WmiArrayCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class WmiRowView
extends WmiArrayCompositeView
implements WmiPositionedView {
    private String debugName = null;

    public WmiRowView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        this(wmiModel, wmiMathDocumentView, (String)null);
    }

    public WmiRowView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView, String string) {
        super(wmiModel, wmiMathDocumentView);
        this.debugName = string;
    }

    public String getDebugName() {
        return this.debugName != null ? this.debugName : super.getDebugName();
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            this.validateChildren();
            this.checkRepaint();
            int n = this.height;
            int n2 = this.width;
            this.width = 0;
            this.height = this.getTopMargin();
            boolean bl = false;
            for (int i = 0; i < this.length; ++i) {
                WmiPositionedView wmiPositionedView = (WmiPositionedView)this.children[i];
                if (wmiPositionedView == null) continue;
                int n3 = wmiPositionedView.getVerticalOffset();
                int n4 = wmiPositionedView.getHorizontalOffset();
                wmiPositionedView.setVerticalOffset(this.height);
                wmiPositionedView.setHorizontalOffset(this.getLeftIndent());
                int n5 = wmiPositionedView.getWidth() + this.getLeftIndent() + this.getRightIndent();
                if (n5 > this.width) {
                    this.width = n5;
                }
                if (bl || n4 != wmiPositionedView.getHorizontalOffset()) {
                    wmiPositionedView.forceRepaint();
                } else if (this.height != n3) {
                    wmiPositionedView.forceRepaint();
                    bl = true;
                }
                this.height += wmiPositionedView.getHeight();
            }
            if (this.length > 0) {
                WmiPositionedView wmiPositionedView = (WmiPositionedView)this.children[0];
                this.baseline = wmiPositionedView.getVerticalOffset() + wmiPositionedView.getBaseline();
            }
            this.addNavigationLinks();
            super.layoutView();
            if (this.height != n || this.width != n2) {
                this.forceRepaint();
            }
        }
    }

    public void paintDirty() {
        WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
        if (wmiMathDocumentView != null) {
            if (this.getForceRepaint()) {
                Point point = WmiViewUtil.getAbsoluteOffset(this);
                wmiMathDocumentView.repaint(point.x - 1, point.y - 1, this.width + 2, this.height + 2);
            } else if (this.getCheckRepaint()) {
                Point point = WmiViewUtil.getAbsoluteOffset(this);
                for (int i = 0; i < this.length; ++i) {
                    WmiPositionedView wmiPositionedView = (WmiPositionedView)this.children[i];
                    if (wmiPositionedView.getForceRepaint()) {
                        wmiMathDocumentView.repaint(point.x - 1, point.y + wmiPositionedView.getVerticalOffset() - 1, this.width + 2, wmiPositionedView.getHeight() + 2);
                        wmiPositionedView.resetPaintFlags();
                        continue;
                    }
                    wmiPositionedView.paintDirty();
                }
            }
        }
        this.resetPaintFlags();
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        int n = rectangle != null ? rectangle.y : Integer.MIN_VALUE;
        int n2 = rectangle != null ? n + rectangle.height : Integer.MAX_VALUE;
        int n3 = wmiRenderPath.getVerticalOffset() + this.y;
        Rectangle rectangle2 = graphics.getClipBounds();
        if (rectangle2 != null) {
            if (n < rectangle2.y) {
                n = rectangle2.y;
            }
            if (n2 > rectangle2.y + rectangle2.height) {
                n2 = rectangle2.y + rectangle2.height;
            }
        }
        int n4 = n3 + this.height;
        if (n3 < n2 && n4 > n) {
            wmiRenderPath.push(this.x, this.y);
            for (int i = 0; i < this.length; ++i) {
                WmiPositionedView wmiPositionedView = (WmiPositionedView)this.children[i];
                if (wmiPositionedView != null) {
                    int n5 = n3 + wmiPositionedView.getVerticalOffset();
                    int n6 = n5 + wmiPositionedView.getHeight();
                    if (n5 < n2 && n6 > n) {
                        wmiPositionedView.draw(graphics, wmiRenderPath, rectangle);
                    }
                }
                wmiRenderPath.next();
            }
            wmiRenderPath.pop();
        }
    }

    public int getLeftIndent() {
        return 0;
    }

    public int getRightIndent() {
        return 0;
    }

    public int getTopMargin() {
        return 0;
    }

    public void addNavigationLinks() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            WmiPositionedView wmiPositionedView;
            WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.getChild(i);
            if (i < n - 1) {
                wmiPositionedView = (WmiPositionedView)this.getChild(i + 1);
                wmiPositionedView2.setNextView(wmiPositionedView, 1);
                wmiPositionedView2.setNextView(wmiPositionedView, 3);
            }
            if (i > 0) {
                wmiPositionedView = (WmiPositionedView)this.getChild(i - 1);
                wmiPositionedView2.setNextView(wmiPositionedView, 0);
                wmiPositionedView2.setNextView(wmiPositionedView, 2);
            }
            if (n <= 0) continue;
            wmiPositionedView2 = (WmiPositionedView)this.getChild(0);
            wmiPositionedView2.setNextView(null, 0);
            wmiPositionedView2.setNextView(null, 2);
            wmiPositionedView2 = (WmiPositionedView)this.getChild(n - 1);
            wmiPositionedView2.setNextView(null, 1);
            wmiPositionedView2.setNextView(null, 3);
        }
    }

    public WmiPositionedView getNearestChildView(Point point) {
        return this.getNearestChildView(point, 1);
    }

    public int getWidthConstraint(boolean bl) {
        int n = super.getWidthConstraint(bl);
        if (n >= 0) {
            n -= this.getLeftIndent();
            if ((n -= this.getRightIndent()) < 0) {
                n = 0;
            }
        }
        return n;
    }
}

