/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiAggregateSelection;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewPathInterval;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.util.Iterator;
import java.util.Set;

public class WmiSelectionBuilder {
    private WmiMathDocumentView docView;

    public WmiSelectionBuilder(WmiMathDocumentView wmiMathDocumentView) {
        this.setDocument(wmiMathDocumentView);
    }

    public void setDocument(WmiMathDocumentView wmiMathDocumentView) {
        this.docView = wmiMathDocumentView;
    }

    public WmiMathDocumentView getDocumentView() {
        return this.docView;
    }

    public void updateSelection(WmiView wmiView, int n) throws WmiNoReadAccessException {
        WmiMathDocumentView wmiMathDocumentView = wmiView.getDocumentView();
        if (wmiMathDocumentView != null) {
            WmiViewPath wmiViewPath = new WmiViewPath(wmiView);
            if (wmiView instanceof WmiTraversableView) {
                wmiViewPath.push(n);
            } else if (n != 0 && wmiView instanceof WmiCompositeView) {
                wmiViewPath.push(-1);
            }
            WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
            if (wmiSelection == null) {
                WmiViewPath wmiViewPath2;
                WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
                if (wmiPositionMarker != null && (wmiViewPath2 = wmiPositionMarker.getViewPath()) != null) {
                    wmiSelection = this.createSelection(wmiViewPath2, wmiViewPath);
                    wmiMathDocumentView.setSelection(wmiSelection);
                }
            } else {
                wmiSelection.updateSelection(wmiViewPath);
            }
            if (wmiSelection != null) {
                wmiSelection.repaintDirtyRegions();
            }
        }
    }

    public WmiSelection createAggregateSelection(Set set) {
        WmiAggregateSelection wmiAggregateSelection = new WmiAggregateSelection(this.docView);
        this.populateAggregateSelection(set, wmiAggregateSelection);
        return wmiAggregateSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateAggregateSelection(Set set, WmiAggregateSelection wmiAggregateSelection) {
        if (set != null) {
            try {
                WmiModelLock.readLock(this.docView.getModel(), true);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    WmiModel wmiModel = (WmiModel)iterator.next();
                    WmiView wmiView = WmiViewUtil.modelToView(this.docView, wmiModel, 0);
                    wmiAggregateSelection.add(wmiView);
                }
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                WmiErrorLog.log(wmiNoReadAccessException);
            }
            finally {
                WmiModelLock.readUnlock(this.docView.getModel());
            }
        }
    }

    public WmiSelection createSelection(WmiViewPath wmiViewPath, WmiViewPath wmiViewPath2) {
        WmiViewPathInterval wmiViewPathInterval = new WmiViewPathInterval(this.docView, wmiViewPath, wmiViewPath2);
        this.docView.setSelection(wmiViewPathInterval);
        wmiViewPathInterval.repaintDirtyRegions();
        return wmiViewPathInterval;
    }

    public WmiSelection createSelection(WmiModel wmiModel, int n, WmiModel wmiModel2, int n2) throws WmiNoReadAccessException {
        WmiViewPathInterval wmiViewPathInterval = new WmiViewPathInterval(this.docView);
        wmiViewPathInterval.updateSelection(wmiModel, n, wmiModel2, n2);
        this.docView.setSelection(wmiViewPathInterval);
        wmiViewPathInterval.repaintDirtyRegions();
        return wmiViewPathInterval;
    }

    public WmiSelection selectModel(WmiModel wmiModel) throws WmiNoReadAccessException {
        return this.createSelection(wmiModel, 0, wmiModel, -1);
    }
}

