/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTableModel;
import com.maplesoft.mathdoc.view.WmiArrayCompositeView;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiResizableContainerView;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTableCellView;
import com.maplesoft.mathdoc.view.WmiTableColumnView;
import com.maplesoft.mathdoc.view.WmiTableRowView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Arrays;

public class WmiTableView
extends WmiArrayCompositeView {
    private static final int TABLE_TOP_MARGIN = 4;
    private static final int TABLE_BOTTOM_MARGIN = 4;
    public static final Stroke BORDER_STROKE = new BasicStroke(1.0f);
    public static final Color VISIBLE_BORDER_COLOR = Color.BLACK;
    public static final Color FOCUS_BORDER_COLOR = Color.LIGHT_GRAY;
    public static final int LEFT_SIDE = 1;
    public static final int TOP_SIDE = 2;
    public static final int RIGHT_SIDE = 4;
    public static final int BOTTOM_SIDE = 8;
    public static final int DYNAMIC_BORDER = 16;
    public static final int ALL_SIDES = 15;
    protected static WmiTableView focusedTable = null;
    private int[] columnWidth = null;
    private int[] rowHeight = null;
    private WmiTableCellView[] rowBuilder = null;
    private ArrayList multiRowCells = null;
    private int columns = 0;
    private int rows = 0;
    private int borders = 15;
    private boolean showGroups = true;
    private boolean showInput = true;
    private boolean showLabels = true;
    private boolean useRandomRowOrder = false;
    private ArrayList rowOrderList;
    private int pagebreak = 0;
    private int leftIndent = 0;
    private boolean mutable = true;

    public WmiTableView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        wmiRenderPath.push(this.x, this.y);
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            WmiModelTag wmiModelTag;
            WmiView wmiView = this.getChild(i);
            WmiModel wmiModel = wmiView != null ? wmiView.getModel() : null;
            WmiModelTag wmiModelTag2 = wmiModelTag = wmiModel != null ? wmiModel.getTag() : null;
            if (wmiModelTag == WmiModelTag.TABLE_ROW) {
                ((WmiTableRowView)wmiView).draw(graphics, wmiRenderPath, rectangle);
            }
            wmiRenderPath.next();
        }
        wmiRenderPath.pop();
        this.drawStub(graphics, wmiRenderPath, rectangle);
    }

    public void drawStub(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Color color = graphics.getColor();
        graphics2D.setStroke(BORDER_STROKE);
        int n = wmiRenderPath.getHorizontalOffset();
        int n2 = wmiRenderPath.getVerticalOffset();
        int n3 = n + this.x + this.leftIndent;
        int n4 = n2 + this.y + this.getTopMargin();
        int n5 = n3 + this.width - this.leftIndent;
        int n6 = n4 + this.height - this.getTopMargin() - this.getBottomMargin();
        boolean bl = this.hasFocus();
        WmiSelection wmiSelection = wmiRenderPath.getSelection();
        WmiHighlightPainter wmiHighlightPainter = wmiSelection != null ? wmiSelection.getSelectionHighlighter() : null;
        Color color2 = wmiHighlightPainter != null ? this.getDocumentView().getColor(3) : null;
        WmiTableView.drawBorder(graphics, this.borders, 2, bl, n3, n4, n5, n4, wmiHighlightPainter, color2);
        WmiTableView.drawBorder(graphics, this.borders, 8, bl, n5, n6, n3, n6, wmiHighlightPainter, color2);
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    public static void drawBorder(Graphics graphics, int n, int n2, boolean bl, int n3, int n4, int n5, int n6, WmiHighlightPainter wmiHighlightPainter, Color color) {
        Color color2 = null;
        if ((n & n2) != 0) {
            color2 = VISIBLE_BORDER_COLOR;
        } else if (bl) {
            color2 = FOCUS_BORDER_COLOR;
        }
        if (color2 != null) {
            if (wmiHighlightPainter != null && color != null) {
                if (n4 == n6) {
                    int n7 = wmiHighlightPainter.getLeftBoundary(n4);
                    int n8 = wmiHighlightPainter.getRightBoundary(n4);
                    if (n8 > n3 && n7 < n5) {
                        if (n3 < n7 && n5 > n7) {
                            WmiTableView.drawLine(graphics, n3, n4, n7, n6, color2);
                        }
                        if (n5 > n8 && n8 > n3) {
                            WmiTableView.drawLine(graphics, n8, n4, n5, n6, color2);
                        }
                        if (n7 < n3) {
                            n7 = n3;
                        }
                        if (n8 > n5) {
                            n8 = n5;
                        }
                        WmiTableView.drawLine(graphics, n7, n4, n8, n6, color);
                    } else {
                        WmiTableView.drawLine(graphics, n3, n4, n5, n6, color2);
                    }
                } else if (n3 == n5) {
                    int n9 = wmiHighlightPainter.getTopBoundary(n3);
                    int n10 = wmiHighlightPainter.getBottomBoundary(n3);
                    if (n10 > n4 && n9 < n6) {
                        if (n4 < n9 && n6 > n9) {
                            WmiTableView.drawLine(graphics, n3, n4, n5, n9, color2);
                        }
                        if (n6 > n10 && n10 > n4) {
                            WmiTableView.drawLine(graphics, n3, n10, n5, n6, color2);
                        }
                        if (n9 < n4) {
                            n9 = n4;
                        }
                        if (n10 > n6) {
                            n10 = n6;
                        }
                        WmiTableView.drawLine(graphics, n3, n9, n5, n10, color);
                    } else {
                        WmiTableView.drawLine(graphics, n3, n4, n5, n6, color2);
                    }
                }
            } else {
                WmiTableView.drawLine(graphics, n3, n4, n5, n6, color2);
            }
        }
    }

    public static void drawLine(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        graphics.setColor(color);
        graphics.drawLine(n, n2, n3, n4);
    }

    public int getBorderStyleIndex() {
        return this.borders;
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            WmiAttributeSet wmiAttributeSet = this.getModel().getAttributesForRead();
            if (wmiAttributeSet != null) {
                this.showGroups = this.parseBooleanAttribute(wmiAttributeSet, "showgroup");
                this.showInput = this.parseBooleanAttribute(wmiAttributeSet, "showinput");
                this.showLabels = this.parseBooleanAttribute(wmiAttributeSet, "showlabel");
                this.useRandomRowOrder = this.parseBooleanAttribute(wmiAttributeSet, "randomized");
                if (this.useRandomRowOrder) {
                    this.rowOrderList = (ArrayList)(wmiAttributeSet != null ? wmiAttributeSet.getAttribute("randomizedroworder") : null);
                }
            }
            this.extractBorderStyle();
            this.extractPagebreakOption();
            boolean bl = this.computeColumnWidths();
            this.adjustAlignment();
            this.layoutRows(bl);
            this.alignRows();
            this.addNavigationLinks();
            super.layoutView();
        }
        this.mutable = !this.isEntirelyResizable();
    }

    private void extractPagebreakOption() throws WmiNoReadAccessException {
        Object object;
        WmiAttributeSet wmiAttributeSet = this.getModel().getAttributesForRead();
        Object object2 = object = wmiAttributeSet != null ? wmiAttributeSet.getAttribute("pagebreak") : null;
        if (object != null) {
            String string = object.toString();
            this.pagebreak = string.equals("row") ? 1 : (string.equals("cell") ? 2 : 0);
        }
    }

    private void extractBorderStyle() throws WmiNoReadAccessException {
        Object object;
        WmiAttributeSet wmiAttributeSet = this.getModel().getAttributesForRead();
        Object object2 = object = wmiAttributeSet != null ? wmiAttributeSet.getAttribute("exterior") : null;
        if (object != null) {
            String string = object.toString();
            if (string.equals("all")) {
                this.borders = 15;
            } else if (string.equals("none")) {
                this.borders = 0;
            } else if (string.equals("left")) {
                this.borders = 1;
            } else if (string.equals("top")) {
                this.borders = 2;
            } else if (string.equals("right")) {
                this.borders = 4;
            } else if (string.equals("bottom")) {
                this.borders = 8;
            } else if (string.equals("horizontal")) {
                this.borders = 10;
            } else if (string.equals("vertical")) {
                this.borders = 5;
            }
        }
    }

    private boolean parseBooleanAttribute(WmiAttributeSet wmiAttributeSet, String string) {
        Object object;
        boolean bl = true;
        Object object2 = object = wmiAttributeSet != null ? wmiAttributeSet.getAttribute(string) : null;
        if (object instanceof Boolean) {
            bl = object.equals(Boolean.TRUE);
        } else if (object != null) {
            bl = object.toString().equals("true");
        }
        return bl;
    }

    private boolean computeColumnWidths() throws WmiNoReadAccessException {
        int n;
        boolean bl = false;
        int n2 = this.getChildCount();
        int n3 = ((WmiTableModel)this.getModel()).getAdjustedWidth(this.getZoomFactor(), this.getLinebreakWidth());
        int n4 = 0;
        this.columns = 0;
        for (n = 0; n < n2; ++n) {
            WmiModelTag wmiModelTag;
            WmiView wmiView = this.getChild(n);
            WmiModel wmiModel = wmiView != null ? wmiView.getModel() : null;
            WmiModelTag wmiModelTag2 = wmiModelTag = wmiModel != null ? wmiModel.getTag() : null;
            if (wmiModelTag != WmiModelTag.TABLE_COLUMN) continue;
            n4 += ((WmiTableColumnView)wmiView).getProportionalWidth();
            ++this.columns;
        }
        if (this.columnWidth == null || this.columns != this.columnWidth.length) {
            this.columnWidth = new int[this.columns];
            bl = true;
        }
        n = 0;
        double d = 0.0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            WmiModelTag wmiModelTag;
            WmiView wmiView = this.getChild(i);
            WmiModel wmiModel = wmiView != null ? wmiView.getModel() : null;
            WmiModelTag wmiModelTag3 = wmiModelTag = wmiModel != null ? wmiModel.getTag() : null;
            if (wmiModelTag != WmiModelTag.TABLE_COLUMN) continue;
            double d2 = (double)(n3 * ((WmiTableColumnView)wmiView).getProportionalWidth()) / ((double)n4 * 1.0);
            if (d2 < 11.0) {
                d2 = 11.0;
            }
            int n6 = (int)Math.round((d += d2) - (double)n5);
            n5 += n6;
            ((WmiTableColumnView)wmiView).setWidth(n6);
            ((WmiTableColumnView)wmiView).layoutView();
            if (n6 != this.columnWidth[n]) {
                bl = true;
                this.columnWidth[n] = n6;
            }
            ++n;
        }
        this.width = n3;
        return bl;
    }

    private void adjustAlignment() throws WmiNoReadAccessException {
        WmiModel wmiModel = this.getModel();
        WmiAttributeSet wmiAttributeSet = wmiModel.getAttributesForRead();
        Object object = wmiAttributeSet.getAttribute("alignment");
        if (object != null) {
            if (object.equals("center")) {
                int n = this.getLinebreakWidth();
                if (n > this.width) {
                    this.leftIndent = (n - this.width) / 2;
                    this.width += this.leftIndent;
                } else {
                    this.leftIndent = 0;
                }
            } else if (object.equals("right")) {
                int n = this.getLinebreakWidth();
                if (n > this.width) {
                    this.leftIndent = n - this.width;
                    this.width = n;
                } else {
                    this.leftIndent = 0;
                }
            } else {
                this.leftIndent = 0;
            }
        }
    }

    private void alignRows() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            WmiView wmiView = this.getChild(i);
            if (!(wmiView instanceof WmiTableRowView)) continue;
            ((WmiTableRowView)wmiView).setHorizontalOffset(this.leftIndent);
        }
    }

    private void layoutRows(boolean bl) throws WmiNoReadAccessException {
        if (this.rowBuilder == null || this.rowBuilder.length <= this.getColumnCount()) {
            this.rowBuilder = new WmiTableCellView[this.getColumnCount() + 1];
        } else {
            Arrays.fill(this.rowBuilder, null);
        }
        if (this.multiRowCells != null) {
            this.multiRowCells.clear();
        }
        int n = this.getChildCount();
        this.rows = 0;
        for (int i = 0; i < n; ++i) {
            WmiModelTag wmiModelTag;
            WmiView wmiView = this.getChild(i);
            WmiModel wmiModel = wmiView != null ? wmiView.getModel() : null;
            WmiModelTag wmiModelTag2 = wmiModelTag = wmiModel != null ? wmiModel.getTag() : null;
            if (wmiModelTag != WmiModelTag.TABLE_ROW) continue;
            WmiTableRowView wmiTableRowView = (WmiTableRowView)wmiView;
            if (!this.useRandomRowOrder) {
                wmiTableRowView.setRow(this.rows++);
            } else {
                wmiTableRowView.setRow(this.rowOrderList.indexOf(new Integer(this.rows++)));
            }
            if (bl) {
                this.getDocumentView().invalidateAll(wmiTableRowView);
            }
            wmiTableRowView.layoutView();
        }
        this.computeVerticalLayout();
        if (this.multiRowCells != null && this.multiRowCells.size() > 0 && this.adjustLayoutForRowSpan()) {
            this.computeVerticalLayout();
        }
    }

    private void computeVerticalLayout() {
        Object object;
        Object object2;
        int n;
        this.height = this.getTopMargin();
        int n2 = this.getChildCount();
        if (this.rowHeight == null || this.rows != this.rowHeight.length) {
            this.rowHeight = new int[this.rows];
        }
        int n3 = this.getChildCount() - this.getRowCount();
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            WmiView wmiView = this.getChild(n);
            object2 = wmiView != null ? wmiView.getModel() : null;
            Object object3 = object = object2 != null ? object2.getTag() : null;
            if (object != WmiModelTag.TABLE_ROW) continue;
            if (this.useRandomRowOrder) {
                wmiView = this.getChild(n3 + (Integer)this.rowOrderList.get(n4));
            }
            int n5 = ((WmiTableRowView)wmiView).getHeight();
            this.rowHeight[n4++] = n5;
            this.height += n5;
        }
        int n6 = this.getTopMargin();
        n4 = 0;
        for (n = 0; n < n2; ++n) {
            WmiModelTag wmiModelTag;
            object2 = this.getChild(n);
            object = object2 != null ? object2.getModel() : null;
            WmiModelTag wmiModelTag2 = wmiModelTag = object != null ? object.getTag() : null;
            if (wmiModelTag != WmiModelTag.TABLE_ROW) continue;
            if (this.useRandomRowOrder) {
                object2 = this.getChild(n3 + (Integer)this.rowOrderList.get(n4));
            }
            ((WmiTableRowView)object2).setVerticalOffset(n6);
            n6 += this.rowHeight[n4++];
        }
        this.height += this.getBottomMargin();
    }

    public int getColumnWidth(int n) {
        int n2 = 0;
        if (this.columnWidth != null && this.columnWidth.length > n && n >= 0) {
            n2 = this.columnWidth[n];
        }
        return n2;
    }

    public int getRowHeight(int n) {
        int n2 = 0;
        if (this.rowHeight != null && this.rowHeight.length > n && n >= 0) {
            n2 = this.rowHeight[n];
        }
        return n2;
    }

    public WmiTableCellView getActiveCell(int n) {
        return this.rowBuilder != null && n < this.columns ? this.rowBuilder[n] : null;
    }

    public void setActiveCell(int n, WmiTableCellView wmiTableCellView) {
        int n2;
        if (this.rowBuilder != null && n < this.columns) {
            this.rowBuilder[n] = wmiTableCellView;
        }
        int n3 = n2 = wmiTableCellView == null ? 1 : wmiTableCellView.getRowSpan();
        if (n2 > 1) {
            if (this.multiRowCells == null) {
                this.multiRowCells = new ArrayList();
            }
            this.multiRowCells.add(wmiTableCellView);
        }
    }

    public int getColumnCount() {
        return this.columns;
    }

    public int getRowCount() {
        return this.rows;
    }

    public WmiTableColumnView getColumn(int n) {
        WmiTableColumnView wmiTableColumnView = null;
        int n2 = this.getChildCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            WmiModelTag wmiModelTag;
            WmiView wmiView = this.getChild(i);
            WmiModel wmiModel = wmiView != null ? wmiView.getModel() : null;
            WmiModelTag wmiModelTag2 = wmiModelTag = wmiModel != null ? wmiModel.getTag() : null;
            if (wmiModelTag != WmiModelTag.TABLE_COLUMN) continue;
            if (n3 == n) {
                wmiTableColumnView = (WmiTableColumnView)wmiView;
                break;
            }
            ++n3;
        }
        return wmiTableColumnView;
    }

    public WmiTableCellView findCell(int n, int n2) {
        WmiView wmiView;
        int n3;
        WmiView wmiView2 = null;
        int n4 = this.getChildCount();
        WmiArrayCompositeView wmiArrayCompositeView = null;
        for (n3 = 0; n3 < n4; ++n3) {
            wmiView = this.getChild(n3);
            if (!(wmiView instanceof WmiTableRowView) || ((WmiTableRowView)wmiView).getRow() != n) continue;
            wmiArrayCompositeView = (WmiTableRowView)wmiView;
            break;
        }
        if (wmiArrayCompositeView != null) {
            n4 = wmiArrayCompositeView.getChildCount();
            for (n3 = 0; n3 < n4; ++n3) {
                wmiView = (WmiTableCellView)wmiArrayCompositeView.getChild(n3);
                if (((WmiTableCellView)wmiView).getColumnIndex() != n2) continue;
                wmiView2 = wmiView;
                break;
            }
        }
        return wmiView2;
    }

    public void getExtremeBounds(int[] nArray) {
        int n;
        if (nArray == null || nArray.length < 4) {
            throw new IllegalArgumentException("WmiTableView.getExtremeBounds argument must have length at least 4");
        }
        nArray[0] = 0;
        nArray[1] = 0;
        int n2 = this.getChildCount();
        WmiArrayCompositeView wmiArrayCompositeView = null;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            WmiView wmiView = this.getChild(n);
            if (!(wmiView instanceof WmiTableRowView) || ((WmiTableRowView)wmiView).getRow() < n3) continue;
            wmiArrayCompositeView = (WmiTableRowView)wmiView;
            n3 = ((WmiTableRowView)wmiView).getRow();
        }
        n = 0;
        if (wmiArrayCompositeView != null) {
            n2 = wmiArrayCompositeView.getChildCount();
            for (int i = 0; i < n2; ++i) {
                WmiTableCellView wmiTableCellView = (WmiTableCellView)wmiArrayCompositeView.getChild(i);
                if (wmiTableCellView.getColumnIndex() < n) continue;
                n = wmiTableCellView.getColumnIndex();
            }
        }
        nArray[2] = n3;
        nArray[3] = n;
    }

    public WmiTableCellView findLastCell() {
        int n;
        WmiTableCellView wmiTableCellView = null;
        int n2 = this.getChildCount();
        WmiArrayCompositeView wmiArrayCompositeView = null;
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            WmiView wmiView = this.getChild(n);
            if (!(wmiView instanceof WmiTableRowView) || ((WmiTableRowView)wmiView).getRow() <= n3) continue;
            wmiArrayCompositeView = (WmiTableRowView)wmiView;
            n3 = ((WmiTableRowView)wmiView).getRow();
        }
        if (wmiArrayCompositeView != null) {
            n2 = wmiArrayCompositeView.getChildCount();
            n = -1;
            for (int i = 0; i < n2; ++i) {
                WmiTableCellView wmiTableCellView2 = (WmiTableCellView)wmiArrayCompositeView.getChild(i);
                if (wmiTableCellView2.getColumnIndex() <= n) continue;
                wmiTableCellView = wmiTableCellView2;
                n = wmiTableCellView2.getColumnIndex();
            }
        }
        return wmiTableCellView;
    }

    private boolean adjustLayoutForRowSpan() {
        int n;
        int n2;
        int n3;
        boolean bl = false;
        for (n3 = 0; n3 < this.multiRowCells.size(); ++n3) {
            WmiTableCellView wmiTableCellView = (WmiTableCellView)this.multiRowCells.get(n3);
            int n4 = 0;
            int n5 = wmiTableCellView.getRowSpan();
            int n6 = wmiTableCellView.getRowIndex();
            for (n2 = 0; n2 < n5; ++n2) {
                n4 += this.rowHeight[n6 + n2];
            }
            n2 = wmiTableCellView.getHeight();
            if (n4 >= n2) continue;
            for (n = 0; n < n5; ++n) {
                this.rowHeight[n6 + n] = Math.round((float)this.rowHeight[n6 + n] * (float)n2 / (float)n4);
                bl = true;
            }
        }
        int n7 = this.getChildCount();
        int n8 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            WmiModelTag wmiModelTag;
            WmiView wmiView = this.getChild(n3);
            WmiModel wmiModel = wmiView != null ? wmiView.getModel() : null;
            WmiModelTag wmiModelTag2 = wmiModelTag = wmiModel != null ? wmiModel.getTag() : null;
            if (wmiModelTag != WmiModelTag.TABLE_ROW) continue;
            ((WmiTableRowView)wmiView).setHeight(this.rowHeight[n8++]);
        }
        for (n3 = 0; n3 < this.multiRowCells.size(); ++n3) {
            WmiTableCellView wmiTableCellView = (WmiTableCellView)this.multiRowCells.get(n3);
            int n9 = 0;
            int n10 = wmiTableCellView.getRowSpan();
            n2 = wmiTableCellView.getRowIndex();
            for (n = 0; n < n10; ++n) {
                n9 += this.rowHeight[n2 + n];
            }
            wmiTableCellView.setHeight(n9);
        }
        return bl;
    }

    public int getTopMargin() {
        return 4;
    }

    public int getBottomMargin() {
        return 4;
    }

    public int getLeftMargin() {
        return this.leftIndent;
    }

    public int getLinebreakWidth() {
        int n = 400;
        WmiCompositeView wmiCompositeView = null;
        WmiTableCellView wmiTableCellView = (WmiTableCellView)WmiViewUtil.findAncestorOfTag(this, WmiModelTag.TABLE_CELL);
        if (wmiTableCellView != null) {
            n = wmiTableCellView.getBreakWidth();
        } else {
            n = this.getDocumentView().getBreakWidth();
            for (wmiCompositeView = this.getParentView(); wmiCompositeView != null; wmiCompositeView = wmiCompositeView.getParentView()) {
                if (!(wmiCompositeView instanceof WmiRowView)) continue;
                n -= ((WmiRowView)wmiCompositeView).getLeftIndent();
                n -= ((WmiRowView)wmiCompositeView).getRightIndent();
            }
        }
        return n;
    }

    public boolean hasFocus() {
        return focusedTable == this;
    }

    public boolean isInputVisible() {
        return this.showInput;
    }

    public boolean isGroupBracketVisible() {
        return this.showGroups;
    }

    public boolean isGroupLabelVisible() {
        return this.showLabels;
    }

    public boolean allowRowBreak() {
        return this.pagebreak != 0;
    }

    public boolean allowCellBreak() {
        return this.pagebreak == 2;
    }

    public void addNavigationLinks() {
        Object object;
        WmiView wmiView;
        int n;
        WmiPositionedView[] wmiPositionedViewArray = new WmiPositionedView[this.rows];
        int n2 = this.getChildCount();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            WmiModelTag wmiModelTag;
            wmiView = this.getChild(n);
            object = wmiView != null ? wmiView.getModel() : null;
            WmiModelTag wmiModelTag2 = wmiModelTag = object != null ? object.getTag() : null;
            if (wmiModelTag != WmiModelTag.TABLE_ROW) continue;
            wmiPositionedViewArray[n3++] = (WmiTableRowView)wmiView;
        }
        for (n = 0; n < this.rows; ++n) {
            wmiView = wmiPositionedViewArray[n];
            if (n < this.rows - 1) {
                object = wmiPositionedViewArray[n + 1];
                wmiView.setNextView((WmiPositionedView)object, 1);
                wmiView.setNextView((WmiPositionedView)object, 3);
            }
            if (n <= 0) continue;
            object = wmiPositionedViewArray[n - 1];
            wmiView.setNextView((WmiPositionedView)object, 0);
            wmiView.setNextView((WmiPositionedView)object, 2);
        }
    }

    public WmiPositionedView getNearestChildView(Point point) {
        WmiPositionedView wmiPositionedView = null;
        WmiPositionedView wmiPositionedView2 = null;
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this.length; ++i) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            WmiView wmiView = this.getChild(i);
            if (!(wmiView instanceof WmiTableRowView)) continue;
            WmiTableRowView wmiTableRowView = (WmiTableRowView)wmiView;
            point.x -= wmiTableRowView.getHorizontalOffset();
            point.y -= wmiTableRowView.getVerticalOffset();
            int n5 = wmiTableRowView.getChildCount();
            for (int j = 0; j < n5; ++j) {
                WmiPositionedView wmiPositionedView3 = (WmiPositionedView)((WmiCompositeView)wmiView).getChild(j);
                Rectangle rectangle = wmiPositionedView3.getBounds();
                if (rectangle != null && rectangle.contains(point)) {
                    wmiPositionedView = wmiPositionedView3;
                    break;
                }
                if (rectangle.x > point.x) {
                    n3 = rectangle.x - point.x;
                } else if (rectangle.x + rectangle.width < point.x) {
                    n3 = point.x - rectangle.x - rectangle.width;
                }
                if (rectangle.y > point.y) {
                    n2 = rectangle.y - point.y;
                } else if (rectangle.y + rectangle.height < point.y) {
                    n2 = point.y - rectangle.y - rectangle.height;
                }
                n4 = n3 * n3 + n2 * n2;
                if (n4 >= n) continue;
                n = n4;
                wmiPositionedView2 = wmiPositionedView3;
            }
            point.x += wmiTableRowView.getHorizontalOffset();
            point.y += wmiTableRowView.getVerticalOffset();
            if (wmiPositionedView != null) break;
        }
        if (wmiPositionedView == null) {
            wmiPositionedView = wmiPositionedView2;
        }
        return wmiPositionedView;
    }

    public void extendRangeForSpanningCells(WmiRowColumnRange wmiRowColumnRange) {
        boolean bl = false;
        while (!bl) {
            bl = true;
            for (int i = 0; i <= this.getRowCount(); ++i) {
                for (int j = 0; j <= this.getColumnCount(); ++j) {
                    WmiTableCellView wmiTableCellView = this.findCell(i, j);
                    if (wmiTableCellView == null) continue;
                    int n = wmiTableCellView.getRowIndex();
                    int n2 = wmiTableCellView.getColumnIndex();
                    int n3 = wmiTableCellView.getRowSpan();
                    int n4 = wmiTableCellView.getColumnSpan();
                    if (n4 <= 1 && n3 <= 1 || n + n3 - 1 < wmiRowColumnRange.startRow || n > wmiRowColumnRange.endRow || n2 + n4 - 1 < wmiRowColumnRange.startColumn || n2 > wmiRowColumnRange.endColumn) continue;
                    if (wmiRowColumnRange.startRow > n) {
                        wmiRowColumnRange.startRow = n;
                        bl = false;
                    }
                    if (wmiRowColumnRange.endRow < n + n3 - 1) {
                        wmiRowColumnRange.endRow = n + n3 - 1;
                        bl = false;
                    }
                    if (wmiRowColumnRange.startColumn > n2) {
                        wmiRowColumnRange.startColumn = n2;
                        bl = false;
                    }
                    if (wmiRowColumnRange.endColumn >= n2 + n4 - 1) continue;
                    wmiRowColumnRange.endColumn = n2 + n4 - 1;
                    bl = false;
                }
            }
        }
    }

    public boolean isMutable() {
        return this.mutable;
    }

    private boolean isEntirelyResizable() throws WmiNoReadAccessException {
        int n = this.getChildCount();
        boolean bl = true;
        block0: for (int i = 0; i < n; ++i) {
            WmiView wmiView = this.getChild(i);
            if (wmiView.getModel().getTag() != WmiModelTag.TABLE_ROW) continue;
            WmiTableRowView wmiTableRowView = (WmiTableRowView)wmiView;
            for (int j = 0; j < wmiTableRowView.getChildCount(); ++j) {
                WmiView wmiView2 = wmiTableRowView.getChild(j);
                if (wmiView2.getModel().getTag() != WmiModelTag.TABLE_CELL) continue;
                WmiCompositeView wmiCompositeView = (WmiCompositeView)wmiView2;
                if (wmiCompositeView.getChildCount() > 1) {
                    bl = false;
                    continue block0;
                }
                if (wmiCompositeView.getChildCount() != 1 || wmiCompositeView.getChild(0) instanceof WmiResizableContainerView) continue;
                bl = false;
                continue block0;
            }
        }
        return bl;
    }

    public class WmiRowColumnRange {
        public int startRow;
        public int startColumn;
        public int endRow;
        public int endColumn;

        public WmiRowColumnRange(int n, int n2, int n3, int n4) {
            this.startRow = n;
            this.startColumn = n2;
            this.endRow = n3;
            this.endColumn = n4;
        }
    }
}

