/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiTextView;
import java.awt.Font;

public class WmiTextFragmentView
extends WmiTextView {
    protected int startOffset;
    protected int endOffset;

    public WmiTextFragmentView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView, int n, int n2) throws WmiNoReadAccessException {
        super(wmiModel, wmiMathDocumentView);
        this.startOffset = n;
        this.endOffset = n2;
        this.markInvalid(2);
        this.layoutView();
    }

    public WmiTextFragmentView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView, int n) throws WmiNoReadAccessException {
        super(wmiModel, wmiMathDocumentView);
        this.startOffset = n;
        this.endOffset = this.getLength();
        this.markInvalid(2);
        this.layoutView();
    }

    public WmiTextFragmentView(WmiTextView wmiTextView, WmiMathDocumentView wmiMathDocumentView) throws WmiNoReadAccessException {
        super(wmiTextView.getModel(), wmiMathDocumentView);
        this.startOffset = wmiTextView.getStartOffset();
        this.endOffset = wmiTextView.getEndOffset();
        this.layout = wmiTextView.layout;
        this.attributes = wmiTextView.attributes;
    }

    public static WmiTextView[] splitTextView(WmiTextView wmiTextView, int n, int n2) throws WmiNoReadAccessException {
        WmiTextLayout wmiTextLayout;
        WmiMathDocumentView wmiMathDocumentView = wmiTextView.getDocumentView();
        WmiTextFragmentView wmiTextFragmentView = new WmiTextFragmentView(wmiTextView, wmiMathDocumentView);
        WmiTextFragmentView wmiTextFragmentView2 = wmiTextFragmentView.splitFragmentView(n, n2);
        WmiTextLayout wmiTextLayout2 = wmiTextLayout = wmiTextFragmentView2 != null ? wmiTextFragmentView2.getLayout() : null;
        if (wmiTextLayout != null && wmiTextLayout.getWidth() == 0) {
            wmiTextFragmentView2.layout = null;
        }
        WmiTextView[] wmiTextViewArray = new WmiTextView[]{wmiTextFragmentView, wmiTextFragmentView2};
        wmiTextFragmentView.markInvalid(1);
        wmiTextFragmentView2.markInvalid(1);
        return wmiTextViewArray;
    }

    private WmiTextFragmentView splitFragmentView(int n, int n2) throws WmiNoReadAccessException {
        WmiTextFragmentView wmiTextFragmentView = new WmiTextFragmentView(this, this.getDocumentView());
        wmiTextFragmentView.layout = this.layout != null ? this.layout.splitLayout(n, n2) : null;
        this.endOffset = this.startOffset + n;
        wmiTextFragmentView.startOffset = this.endOffset + n2;
        if (wmiTextFragmentView.endOffset < wmiTextFragmentView.startOffset) {
            wmiTextFragmentView.startOffset = wmiTextFragmentView.endOffset;
        }
        wmiTextFragmentView.markInvalid(1);
        this.markInvalid(1);
        return wmiTextFragmentView;
    }

    public String getText() throws WmiNoReadAccessException {
        String string = null;
        WmiModel wmiModel = this.getModel();
        if (wmiModel instanceof WmiTextModel) {
            try {
                string = ((WmiTextModel)wmiModel).getSubstring(this.startOffset, this.endOffset - this.startOffset);
            }
            catch (WmiModelIndexOutOfBoundsException wmiModelIndexOutOfBoundsException) {
                WmiErrorLog.log(wmiModelIndexOutOfBoundsException);
            }
        }
        return string;
    }

    public void insertString(String string, int n) {
        super.insertString(string, n += this.startOffset);
    }

    public void delete(int n, int n2) {
        super.delete(n += this.startOffset, n2);
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            Object object;
            WmiModel wmiModel = this.getModel();
            boolean bl = this.getDocumentView().isPrintView();
            this.attributes = (WmiFontAttributeSet)wmiModel.getAttributesForRead();
            int n = this.getCorrectedZoomFactor();
            Font font = WmiFontResolver.getFont(this.attributes, n, bl);
            boolean bl2 = this.attributes.isSuperscript();
            boolean bl3 = this.attributes.isSubscript();
            if (this.layout == null && !this.isContentValid()) {
                object = this.getText();
                if (object != null && ((String)object).length() > 0) {
                    boolean bl4 = WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.MATH) != null;
                    this.layout = WmiTextLayout.createTextLayout((String)object, font, this.getDocumentView(), bl4);
                }
                this.markValid(2);
            }
            if (this.layout != null) {
                this.width = this.layout.getWidth();
                this.baseline = this.layout.getBaseline();
                this.height = this.layout.getHeight();
            } else {
                this.width = this.getEmptyTextWidth();
                object = WmiFontResolver.getFontMetrics(font);
                this.baseline = ((WmiFontMetrics)object).getFontProperty(0, bl) + ((WmiFontMetrics)object).getFontProperty(3, bl);
                this.height = this.baseline + ((WmiFontMetrics)object).getFontProperty(4, bl);
            }
            this.baselineAdjust = 0;
            if (bl2) {
                this.baselineAdjust -= Math.round((float)this.height * 0.5f);
                this.height -= this.baselineAdjust;
                this.baseline -= this.baselineAdjust;
            } else if (bl3) {
                this.baselineAdjust += Math.round((float)this.height * 0.35f);
                this.height += this.baselineAdjust;
            }
            this.markValid(1);
        }
    }
}

