/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiViewUtil;

public class WmiViewPosition {
    public static final int VIEW_START = 0;
    public static final int VIEW_END = -1;
    private WmiPositionedView view;
    private int offset;

    public WmiViewPosition(WmiPositionedView wmiPositionedView, int n) {
        this.view = wmiPositionedView;
        this.offset = n;
    }

    public WmiPositionedView getView() {
        return this.view;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean snapToPosition() {
        return this.snapToPosition(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean snapToPosition(boolean bl) {
        boolean bl2 = false;
        WmiMathDocumentView wmiMathDocumentView = this.view.getDocumentView();
        WmiModel wmiModel = wmiMathDocumentView.getModel();
        boolean bl3 = !WmiModelLock.ownsWriteLock(wmiModel);
        try {
            int n;
            if (bl3) {
                WmiModelLock.readLock(wmiModel, true);
            }
            while (this.view instanceof WmiCompositeView && !WmiViewUtil.isTraversableView(this.view) && (n = ((WmiCompositeView)((Object)this.view)).getChildCount()) > 0) {
                if (this.offset == -1) {
                    this.view = (WmiPositionedView)((WmiCompositeView)((Object)this.view)).getChild(n - 1);
                    continue;
                }
                this.view = (WmiPositionedView)((WmiCompositeView)((Object)this.view)).getChild(0);
            }
            if (bl) {
                if (this.view instanceof WmiPositionedView) {
                    this.view.setPositionMarker(this.offset);
                } else if (wmiMathDocumentView != null) {
                    wmiMathDocumentView.setPositionMarker(null);
                }
            }
            if (wmiMathDocumentView != null) {
                WmiSelection wmiSelection;
                if (bl && (wmiSelection = wmiMathDocumentView.getSelection()) != null) {
                    wmiMathDocumentView.setSelection(null);
                    wmiSelection.repaintDirtyRegions();
                }
                wmiMathDocumentView.saveLastHorizontalPosition();
                bl2 = true;
            }
        }
        finally {
            if (bl3) {
                WmiModelLock.readUnlock(wmiModel);
            }
        }
        return bl2;
    }
}

