/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.io.WmiImageUtilities;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelObserver;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMapleTASwitchableCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiPositionInView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiRowView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiSwitchableCompositeView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewPosition;
import com.maplesoft.mathdoc.view.math.WmiFencedView;
import com.maplesoft.mathdoc.view.math.WmiMathViewUtil;
import com.maplesoft.util.SearchAlgorithms;
import com.maplesoft.util.WmiSearchException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class WmiViewUtil {
    private static ViewUtilLogicalChildOperation logicalChildOp = new ViewUtilLogicalChildOperation();
    private static ViewUtilPhysicalChildOperation physicalChildOp = new ViewUtilPhysicalChildOperation();
    private static ViewUtilParentOperation parentOp = new ViewUtilParentOperation();
    private static ViewUtilClassMatch docViewClassMatch = new ViewUtilClassMatch(WmiMathDocumentView.class);

    public static WmiView findAncestorOfTag(WmiView wmiView, WmiModelTag wmiModelTag) {
        return WmiViewUtil.parentSearch(wmiView, new ViewUtilTagMatch(wmiView, wmiModelTag));
    }

    public static WmiView findAncestorOfTags(WmiView wmiView, WmiModelTag[] wmiModelTagArray) {
        return WmiViewUtil.parentSearch(wmiView, new ViewUtilTagsMatch(wmiView, wmiModelTagArray));
    }

    public static WmiView findAncestorOfClass(WmiView wmiView, Class clazz) {
        ViewUtilClassMatch viewUtilClassMatch = new ViewUtilClassMatch(wmiView, clazz);
        return WmiViewUtil.parentSearch(wmiView, viewUtilClassMatch);
    }

    public static boolean isViewAncestorOfView(WmiView wmiView, WmiView wmiView2) {
        if (wmiView == wmiView2) {
            return false;
        }
        ViewUtilEqualityMatch viewUtilEqualityMatch = new ViewUtilEqualityMatch(wmiView);
        return WmiViewUtil.parentSearch(wmiView2, viewUtilEqualityMatch) != null;
    }

    public static WmiView findFirstDescendantOfTag(WmiView wmiView, WmiModelTag wmiModelTag) {
        WmiView wmiView2 = null;
        try {
            wmiView2 = WmiViewUtil.depthFirstSearch(wmiView, new ViewUtilTagMatch(wmiView, wmiModelTag), 1, false);
        }
        catch (WmiSearchException wmiSearchException) {
            WmiErrorLog.log(wmiSearchException);
        }
        return wmiView2;
    }

    public static WmiView findFirstDescendantOfTags(WmiView wmiView, WmiModelTag[] wmiModelTagArray) {
        WmiView wmiView2 = null;
        try {
            wmiView2 = WmiViewUtil.depthFirstSearch(wmiView, new ViewUtilTagsMatch(wmiView, wmiModelTagArray), 1, false);
        }
        catch (WmiSearchException wmiSearchException) {
            WmiErrorLog.log(wmiSearchException);
        }
        return wmiView2;
    }

    public static WmiView findFirstPhysicalDescendantOfTag(WmiView wmiView, WmiModelTag wmiModelTag) {
        WmiView wmiView2 = null;
        try {
            wmiView2 = WmiViewUtil.depthFirstSearch(wmiView, new ViewUtilTagMatch(wmiView, wmiModelTag), 1, true);
        }
        catch (WmiSearchException wmiSearchException) {
            WmiErrorLog.log(wmiSearchException);
        }
        return wmiView2;
    }

    public static WmiView findLastDescendantOfTag(WmiView wmiView, WmiModelTag wmiModelTag) {
        WmiView wmiView2 = null;
        try {
            wmiView2 = WmiViewUtil.depthFirstSearch(wmiView, new ViewUtilTagMatch(wmiView, wmiModelTag), -1, false);
        }
        catch (WmiSearchException wmiSearchException) {
            WmiErrorLog.log(wmiSearchException);
        }
        return wmiView2;
    }

    public static WmiView findLastPhysicalDescendantOfTag(WmiView wmiView, WmiModelTag wmiModelTag) {
        WmiView wmiView2 = null;
        try {
            wmiView2 = WmiViewUtil.depthFirstSearch(wmiView, new ViewUtilTagMatch(wmiView, wmiModelTag), -1, true);
        }
        catch (WmiSearchException wmiSearchException) {
            WmiErrorLog.log(wmiSearchException);
        }
        return wmiView2;
    }

    public static WmiView findLastDescendantOfClass(WmiView wmiView, Class clazz) {
        WmiView wmiView2 = null;
        try {
            wmiView2 = WmiViewUtil.depthFirstSearch(wmiView, new ViewUtilClassMatch(wmiView, clazz), -1, false);
        }
        catch (WmiSearchException wmiSearchException) {
            WmiErrorLog.log(wmiSearchException);
        }
        return wmiView2;
    }

    public static WmiView findFirstDescendantOfClass(WmiView wmiView, Class clazz) {
        WmiView wmiView2 = null;
        try {
            wmiView2 = WmiViewUtil.depthFirstSearch(wmiView, new ViewUtilClassMatch(wmiView, clazz), 1, false);
        }
        catch (WmiSearchException wmiSearchException) {
            WmiErrorLog.log(wmiSearchException);
        }
        return wmiView2;
    }

    public static WmiMathDocumentView getDocumentView(WmiView wmiView) {
        WmiMathDocumentView wmiMathDocumentView = null;
        try {
            if (wmiView instanceof WmiMathDocumentView) {
                return (WmiMathDocumentView)wmiView;
            }
            wmiMathDocumentView = (WmiMathDocumentView)SearchAlgorithms.parentSearch(wmiView, parentOp, docViewClassMatch);
        }
        catch (WmiSearchException wmiSearchException) {
            WmiErrorLog.log(wmiSearchException);
        }
        return wmiMathDocumentView;
    }

    public static WmiMathDocumentView getDocumentView(Object object) {
        return object instanceof WmiView ? WmiViewUtil.getDocumentView((WmiView)object) : null;
    }

    public static Point getAbsoluteOffset(WmiPositionedView wmiPositionedView) {
        return WmiViewUtil.getOffsetFrom(wmiPositionedView, null);
    }

    public static Point getRelativeOffset(WmiPositionedView wmiPositionedView, WmiPositionedView wmiPositionedView2) {
        Point point;
        if (wmiPositionedView == wmiPositionedView2) {
            point = new Point(0, 0);
        } else if (WmiViewUtil.isViewAncestorOfView(wmiPositionedView2, wmiPositionedView)) {
            point = WmiViewUtil.getOffsetFrom(wmiPositionedView, wmiPositionedView2);
        } else if (WmiViewUtil.isViewAncestorOfView(wmiPositionedView, wmiPositionedView2)) {
            point = WmiViewUtil.getOffsetFrom(wmiPositionedView2, wmiPositionedView);
            point.setLocation(-point.getX(), -point.getY());
        } else {
            point = WmiViewUtil.getOffsetFrom(wmiPositionedView, null);
            Point point2 = WmiViewUtil.getOffsetFrom(wmiPositionedView2, null);
            point.translate(-((int)point2.getX()), -((int)point2.getY()));
        }
        return point;
    }

    private static Point getOffsetFrom(WmiPositionedView wmiPositionedView, WmiPositionedView wmiPositionedView2) {
        int n = 0;
        int n2 = 0;
        for (WmiView wmiView = wmiPositionedView; wmiView instanceof WmiPositionedView && !(wmiView instanceof WmiMathDocumentView) && wmiView != wmiPositionedView2; wmiView = wmiView.getParentView()) {
            n += wmiView.getHorizontalOffset();
            n2 += wmiView.getVerticalOffset();
        }
        return new Point(n, n2);
    }

    public static WmiScrollableContainerView findEnclosingContainer(WmiView wmiView) {
        WmiScrollableContainerView wmiScrollableContainerView = null;
        if (wmiView instanceof WmiScrollableContainerView) {
            wmiScrollableContainerView = (WmiScrollableContainerView)wmiView;
        } else if (wmiView != null) {
            wmiScrollableContainerView = (WmiScrollableContainerView)WmiViewUtil.findAncestorOfClass(wmiView, WmiScrollableContainerView.class);
        }
        return wmiScrollableContainerView;
    }

    public static boolean isInSubcontainer(WmiView wmiView) {
        WmiScrollableContainerView wmiScrollableContainerView;
        boolean bl = false;
        if (wmiView != null && (wmiScrollableContainerView = WmiViewUtil.findEnclosingContainer(wmiView)) != null) {
            bl = !wmiScrollableContainerView.isDocumentView();
        }
        return bl;
    }

    public static Point offsetForContainer(WmiScrollableContainerView wmiScrollableContainerView) {
        int n = 0;
        int n2 = 0;
        if (wmiScrollableContainerView != null && !wmiScrollableContainerView.isDocumentView()) {
            Rectangle rectangle;
            Point point = WmiViewUtil.getAbsoluteOffset(wmiScrollableContainerView);
            if (point != null) {
                n += point.x;
                n2 += point.y;
            }
            if ((rectangle = wmiScrollableContainerView.getVisibleRect()) != null) {
                n -= rectangle.x;
                n2 -= rectangle.y;
            }
        }
        return new Point(n, n2);
    }

    public static Point containerRelativeOffset(WmiPositionedView wmiPositionedView, WmiScrollableContainerView wmiScrollableContainerView) {
        Point point = new Point(0, 0);
        if (wmiPositionedView != null) {
            if (wmiScrollableContainerView == null && (wmiScrollableContainerView = WmiViewUtil.findEnclosingContainer(wmiPositionedView)) == null) {
                wmiScrollableContainerView = wmiPositionedView.getDocumentView();
            }
            if (wmiScrollableContainerView != null) {
                point = WmiViewUtil.getRelativeOffset(wmiPositionedView, wmiScrollableContainerView);
            }
        }
        return point;
    }

    public static Point containerRelativeOffset(WmiPositionedView wmiPositionedView) {
        return WmiViewUtil.containerRelativeOffset(wmiPositionedView, null);
    }

    public static JScrollPane getDocumentScrollPane(WmiView wmiView) {
        WmiMathDocumentView wmiMathDocumentView = wmiView.getDocumentView();
        JScrollPane jScrollPane = null;
        if (wmiMathDocumentView != null) {
            jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, wmiMathDocumentView);
        }
        return jScrollPane;
    }

    public static WmiViewPath mapBeginningOfCompositeView(WmiCompositeView wmiCompositeView) {
        WmiViewPath wmiViewPath = new WmiViewPath(wmiCompositeView);
        WmiCompositeView wmiCompositeView2 = wmiCompositeView;
        while (wmiCompositeView2 != null && wmiCompositeView2.getChildCount() > 0) {
            WmiRowView wmiRowView;
            wmiViewPath.push(0);
            WmiView wmiView = wmiCompositeView2.getChild(0);
            if (wmiView instanceof WmiSwitchableCompositeView && (wmiRowView = ((WmiSwitchableCompositeView)wmiView).getRootPhysicalView()) != null) {
                wmiView = wmiRowView;
            }
            if (wmiView instanceof WmiCompositeView) {
                wmiCompositeView2 = (WmiCompositeView)wmiView;
                continue;
            }
            wmiCompositeView2 = null;
            if (!(wmiView instanceof WmiTextView)) continue;
            wmiViewPath.push(0);
        }
        return wmiViewPath;
    }

    public static WmiViewPath mapEndOfCompositeView(WmiCompositeView wmiCompositeView, boolean bl) throws WmiNoReadAccessException {
        WmiViewPath wmiViewPath = null;
        if (wmiCompositeView != null) {
            wmiViewPath = new WmiViewPath(wmiCompositeView);
            WmiCompositeView wmiCompositeView2 = wmiCompositeView;
            while (wmiCompositeView2 != null && wmiCompositeView2.getChildCount() > 0) {
                WmiRowView wmiRowView;
                int n = wmiCompositeView2.getChildCount() - 1;
                if (wmiCompositeView2 instanceof WmiFencedView) {
                    n = 1;
                }
                wmiViewPath.push(n);
                WmiView wmiView = wmiCompositeView2.getChild(n);
                if (!bl && wmiView instanceof WmiSwitchableCompositeView && (wmiRowView = ((WmiSwitchableCompositeView)wmiView).getRootPhysicalView()) != null) {
                    wmiView = wmiRowView;
                }
                if (wmiView instanceof WmiCompositeView) {
                    wmiCompositeView2 = (WmiCompositeView)wmiView;
                    continue;
                }
                wmiCompositeView2 = null;
                if (!(wmiView instanceof WmiTextView)) continue;
                wmiViewPath.push(((WmiTextView)wmiView).getLength());
            }
        }
        return wmiViewPath;
    }

    public static WmiViewPath mapEndOfCompositeView(WmiCompositeView wmiCompositeView) throws WmiNoReadAccessException {
        return WmiViewUtil.mapEndOfCompositeView(wmiCompositeView, false);
    }

    public static WmiView modelToView(WmiMathDocumentView wmiMathDocumentView, WmiModel wmiModel, int n) throws WmiNoReadAccessException {
        if (wmiMathDocumentView == null || wmiModel == null) {
            return null;
        }
        WmiView wmiView = null;
        if (wmiModel instanceof WmiTextModel) {
            for (WmiModelObserver wmiModelObserver = wmiModel.getObserver(); wmiModelObserver != null; wmiModelObserver = wmiModelObserver.getNextObserver()) {
                WmiTextView wmiTextView;
                if (!(wmiModelObserver instanceof WmiTextView) || (wmiTextView = (WmiTextView)wmiModelObserver).getDocumentView() != wmiMathDocumentView || wmiTextView.getStartOffset() > n || wmiTextView.getEndOffset() < n) continue;
                wmiView = wmiTextView;
                break;
            }
        }
        if (wmiView == null) {
            wmiView = WmiViewUtil.modelToPhysicalView(wmiMathDocumentView, wmiModel);
        }
        return wmiView;
    }

    public static void findChildViews(WmiCompositeView wmiCompositeView, int n, ArrayList arrayList) {
        WmiRowView wmiRowView;
        if (wmiCompositeView instanceof WmiSwitchableCompositeView && (wmiRowView = ((WmiSwitchableCompositeView)wmiCompositeView).getRootPhysicalView()) != null) {
            wmiCompositeView = wmiRowView;
        }
        for (int i = 0; i < wmiCompositeView.getChildCount(); ++i) {
            WmiPositionedView wmiPositionedView;
            Rectangle rectangle;
            WmiView wmiView = wmiCompositeView.getChild(i);
            if (!(wmiView instanceof WmiPositionedView) || (rectangle = (wmiPositionedView = (WmiPositionedView)wmiView).getBounds()) == null) continue;
            Point point = WmiViewUtil.getAbsoluteOffset(wmiPositionedView);
            int n2 = point.y;
            if (n2 > n || rectangle.height + n2 < n) continue;
            if (wmiView instanceof WmiCompositeView) {
                WmiViewUtil.findChildViews((WmiCompositeView)wmiView, n, arrayList);
                continue;
            }
            arrayList.add(wmiView);
        }
    }

    public static WmiView findNextDescendantOfTag(WmiView wmiView, WmiView wmiView2, WmiModelTag wmiModelTag) {
        int n;
        WmiView wmiView3 = null;
        WmiCompositeView wmiCompositeView = wmiView2.getParentView();
        int n2 = n = wmiCompositeView != null ? wmiCompositeView.indexOf(wmiView2) : -1;
        if (n >= 0 && n < wmiCompositeView.getChildCount() - 1) {
            WmiView wmiView4 = wmiCompositeView.getChild(n + 1);
            WmiModel wmiModel = wmiView4.getModel();
            WmiModelTag wmiModelTag2 = wmiModel.getTag();
            WmiView wmiView5 = wmiView3 = wmiModelTag2 == wmiModelTag ? wmiView4 : WmiViewUtil.findFirstDescendantOfTag(wmiView4, wmiModelTag);
            if (wmiView3 == null) {
                wmiView3 = WmiViewUtil.findNextDescendantOfTag(wmiView, wmiView4, wmiModelTag);
            }
        } else if (wmiCompositeView != null && wmiCompositeView != wmiView) {
            wmiView3 = WmiViewUtil.findNextDescendantOfTag(wmiView, wmiCompositeView, wmiModelTag);
        }
        return wmiView3;
    }

    public static WmiView findNextDescendantOfTags(WmiView wmiView, WmiView wmiView2, WmiModelTag[] wmiModelTagArray) {
        int n;
        WmiView wmiView3 = null;
        WmiCompositeView wmiCompositeView = wmiView2.getParentView();
        int n2 = n = wmiCompositeView != null ? wmiCompositeView.indexOf(wmiView2) : -1;
        if (n >= 0 && n < wmiCompositeView.getChildCount() - 1) {
            WmiView wmiView4 = wmiCompositeView.getChild(n + 1);
            WmiModel wmiModel = wmiView4.getModel();
            WmiModelTag wmiModelTag = wmiModel.getTag();
            boolean bl = false;
            for (int i = 0; i < wmiModelTagArray.length && !bl; ++i) {
                bl = wmiModelTag == wmiModelTagArray[i];
            }
            WmiView wmiView5 = wmiView3 = bl ? wmiView4 : WmiViewUtil.findFirstDescendantOfTags(wmiView4, wmiModelTagArray);
            if (wmiView3 == null) {
                wmiView3 = WmiViewUtil.findNextDescendantOfTags(wmiView, wmiView4, wmiModelTagArray);
            }
        } else if (wmiCompositeView != null && wmiCompositeView != wmiView) {
            wmiView3 = WmiViewUtil.findNextDescendantOfTags(wmiView, wmiCompositeView, wmiModelTagArray);
        }
        return wmiView3;
    }

    public static WmiView findNextDescendantOfClass(WmiView wmiView, WmiView wmiView2, Class clazz) {
        int n;
        WmiView wmiView3 = null;
        WmiCompositeView wmiCompositeView = wmiView2.getParentView();
        int n2 = n = wmiCompositeView != null ? wmiCompositeView.indexOf(wmiView2) : -1;
        if (n >= 0 && n < wmiCompositeView.getChildCount() - 1) {
            WmiView wmiView4 = wmiCompositeView.getChild(n + 1);
            WmiView wmiView5 = wmiView3 = clazz.isInstance(wmiView4) ? wmiView4 : WmiViewUtil.findFirstDescendantOfClass(wmiView4, clazz);
            if (wmiView3 == null) {
                wmiView3 = WmiViewUtil.findNextDescendantOfClass(wmiView, wmiView4, clazz);
            }
        } else if (wmiCompositeView != null && wmiCompositeView != wmiView) {
            wmiView3 = WmiViewUtil.findNextDescendantOfClass(wmiView, wmiCompositeView, clazz);
        }
        return wmiView3;
    }

    public static WmiView findPreviousDescendantOfClass(WmiView wmiView, WmiView wmiView2, Class clazz) {
        int n;
        WmiView wmiView3 = null;
        WmiCompositeView wmiCompositeView = wmiView2.getParentView();
        int n2 = n = wmiCompositeView != null ? wmiCompositeView.indexOf(wmiView2) : -1;
        if (n > 0 && n < wmiCompositeView.getChildCount()) {
            WmiView wmiView4 = wmiCompositeView.getChild(n - 1);
            WmiView wmiView5 = wmiView3 = clazz.isInstance(wmiView4) ? wmiView4 : WmiViewUtil.findLastDescendantOfClass(wmiView4, clazz);
            if (wmiView3 == null) {
                wmiView3 = WmiViewUtil.findPreviousDescendantOfClass(wmiView, wmiView4, clazz);
            }
        } else if (wmiCompositeView != null && wmiCompositeView != wmiView) {
            wmiView3 = WmiViewUtil.findPreviousDescendantOfClass(wmiView, wmiCompositeView, clazz);
        }
        return wmiView3;
    }

    public static WmiView findNextPhysicalDescendantOfTag(WmiView wmiView, WmiView wmiView2, WmiModelTag wmiModelTag) {
        int n;
        WmiView wmiView3 = null;
        WmiCompositeView wmiCompositeView = wmiView2.getParentView();
        int n2 = n = wmiCompositeView != null ? wmiCompositeView.indexOf(wmiView2) : -1;
        if (n >= 0 && n < wmiCompositeView.getChildCount() - 1) {
            WmiView wmiView4 = wmiCompositeView.getChild(n + 1);
            WmiModel wmiModel = wmiView4.getModel();
            WmiModelTag wmiModelTag2 = wmiModel.getTag();
            WmiView wmiView5 = wmiView3 = wmiModelTag2 == wmiModelTag ? wmiView4 : WmiViewUtil.findFirstPhysicalDescendantOfTag(wmiView4, wmiModelTag);
            if (wmiView3 == null) {
                wmiView3 = WmiViewUtil.findNextPhysicalDescendantOfTag(wmiView, wmiView4, wmiModelTag);
            }
        } else if (wmiCompositeView != null && wmiCompositeView != wmiView) {
            wmiView3 = WmiViewUtil.findNextPhysicalDescendantOfTag(wmiView, wmiCompositeView, wmiModelTag);
        }
        return wmiView3;
    }

    public static WmiView findPreviousDescendantOfTag(WmiView wmiView, WmiView wmiView2, WmiModelTag wmiModelTag) {
        int n;
        WmiView wmiView3 = null;
        WmiCompositeView wmiCompositeView = wmiView2.getParentView();
        int n2 = n = wmiCompositeView != null ? wmiCompositeView.indexOf(wmiView2) : -1;
        if (n >= 1 && n < wmiCompositeView.getChildCount()) {
            WmiView wmiView4 = wmiCompositeView.getChild(n - 1);
            WmiModel wmiModel = wmiView4.getModel();
            WmiModelTag wmiModelTag2 = wmiModel.getTag();
            WmiView wmiView5 = wmiView3 = wmiModelTag2 == wmiModelTag ? wmiView4 : WmiViewUtil.findLastDescendantOfTag(wmiView4, wmiModelTag);
            if (wmiView3 == null) {
                wmiView3 = WmiViewUtil.findPreviousDescendantOfTag(wmiView, wmiView4, wmiModelTag);
            }
        } else if (wmiCompositeView != null && wmiCompositeView != wmiView) {
            wmiView3 = WmiViewUtil.findPreviousDescendantOfTag(wmiView, wmiCompositeView, wmiModelTag);
        }
        return wmiView3;
    }

    public static WmiView findPreviousPhysicalDescendantOfTag(WmiView wmiView, WmiView wmiView2, WmiModelTag wmiModelTag) {
        int n;
        WmiView wmiView3 = null;
        WmiCompositeView wmiCompositeView = wmiView2.getParentView();
        int n2 = n = wmiCompositeView != null ? wmiCompositeView.indexOf(wmiView2) : -1;
        if (n >= 1 && n < wmiCompositeView.getChildCount()) {
            WmiView wmiView4 = wmiCompositeView.getChild(n - 1);
            WmiModel wmiModel = wmiView4.getModel();
            WmiModelTag wmiModelTag2 = wmiModel.getTag();
            WmiView wmiView5 = wmiView3 = wmiModelTag2 == wmiModelTag ? wmiView4 : WmiViewUtil.findLastPhysicalDescendantOfTag(wmiView4, wmiModelTag);
            if (wmiView3 == null) {
                wmiView3 = WmiViewUtil.findPreviousPhysicalDescendantOfTag(wmiView, wmiView4, wmiModelTag);
            }
        } else if (wmiCompositeView != null && wmiCompositeView != wmiView) {
            wmiView3 = WmiViewUtil.findPreviousPhysicalDescendantOfTag(wmiView, wmiCompositeView, wmiModelTag);
        }
        return wmiView3;
    }

    public static WmiView findNextSibling(WmiView wmiView) throws WmiNoReadAccessException {
        WmiCompositeView wmiCompositeView = wmiView.getParentView();
        WmiView wmiView2 = null;
        if (wmiCompositeView != null) {
            int n;
            int n2 = wmiCompositeView.indexOf(wmiView);
            for (n = n2 + 1; n < wmiCompositeView.getChildCount() && WmiModelUtil.isEmptyIdentifierModel(wmiCompositeView.getChild(n).getModel()); ++n) {
            }
            if (n < wmiCompositeView.getChildCount()) {
                wmiView2 = wmiCompositeView.getChild(n);
            }
        }
        return wmiView2;
    }

    public static WmiView findPreviousSibling(WmiView wmiView) throws WmiNoReadAccessException {
        WmiCompositeView wmiCompositeView = wmiView.getParentView();
        WmiView wmiView2 = null;
        if (wmiCompositeView != null) {
            int n;
            int n2 = wmiCompositeView.indexOf(wmiView);
            for (n = n2 - 1; n >= 0 && WmiModelUtil.isEmptyIdentifierModel(wmiCompositeView.getChild(n).getModel()); --n) {
            }
            if (n >= 0) {
                wmiView2 = wmiCompositeView.getChild(n);
            }
        }
        return wmiView2;
    }

    public static WmiViewPosition findNearestView(WmiPositionedView wmiPositionedView, Point point) {
        WmiViewPosition wmiViewPosition = null;
        WmiPositionedView wmiPositionedView2 = wmiPositionedView;
        point = new Point(point.x, point.y);
        while (wmiPositionedView2 != null) {
            WmiPositionedView wmiPositionedView3;
            WmiPositionedView wmiPositionedView4;
            int n = 0;
            if (wmiPositionedView2 != wmiPositionedView && WmiViewUtil.isTraversableView(wmiPositionedView2)) {
                wmiPositionedView4 = (WmiTraversableView)wmiPositionedView2;
                if (wmiPositionedView2.getHorizontalOffset() + point.x <= 0 && (wmiPositionedView4.getTraversalType() & 2) != 0) {
                    if (wmiPositionedView2.getParentView() != wmiPositionedView) {
                        wmiPositionedView2 = (WmiPositionedView)((Object)wmiPositionedView2.getParentView());
                    }
                    n = 0;
                    wmiViewPosition = new WmiViewPosition(wmiPositionedView2, n);
                    break;
                }
                if (point.x >= wmiPositionedView2.getWidth()) {
                    wmiPositionedView3 = (WmiPositionedView)((Object)wmiPositionedView2.getParentView());
                    if (point.x + wmiPositionedView2.getHorizontalOffset() >= wmiPositionedView3.getWidth() && (wmiPositionedView4.getTraversalType() & 4) != 0) {
                        wmiPositionedView2 = wmiPositionedView3;
                        n = -1;
                        wmiViewPosition = new WmiViewPosition(wmiPositionedView2, n);
                        break;
                    }
                }
            }
            if ((wmiPositionedView4 = wmiPositionedView2.getNearestChildView(point)) != null && !wmiPositionedView4.isNavagableView()) {
                wmiPositionedView4 = wmiPositionedView2.getViewForNavigation(-4, point);
            }
            if (wmiPositionedView4 != null) {
                for (wmiPositionedView3 = wmiPositionedView4; wmiPositionedView3 != wmiPositionedView2 && wmiPositionedView3 != null; wmiPositionedView3 = (WmiPositionedView)((Object)wmiPositionedView3.getParentView())) {
                    point.x -= wmiPositionedView3.getHorizontalOffset();
                    point.y -= wmiPositionedView3.getVerticalOffset();
                }
                wmiPositionedView2 = wmiPositionedView4;
                continue;
            }
            if (wmiPositionedView2 instanceof WmiTextView) {
                n = ((WmiTextView)wmiPositionedView2).getOffset(point);
            }
            wmiViewPosition = new WmiViewPosition(wmiPositionedView2, n);
            break;
        }
        return wmiViewPosition;
    }

    public static WmiModel findModelAtSource(WmiView wmiView, WmiModelTag wmiModelTag) throws WmiNoReadAccessException {
        WmiModel wmiModel = null;
        if (wmiView != null) {
            WmiModel wmiModel2 = wmiView.getModel();
            if (wmiModel2.getTag() == wmiModelTag) {
                wmiModel = wmiModel2;
            } else {
                WmiPositionedView wmiPositionedView;
                WmiMathDocumentView wmiMathDocumentView;
                WmiPositionMarker wmiPositionMarker;
                if (wmiView instanceof WmiMathDocumentView && (wmiPositionMarker = (wmiMathDocumentView = (WmiMathDocumentView)wmiView).getPositionMarker()) != null && (wmiPositionedView = wmiPositionMarker.getView()) != null) {
                    wmiModel2 = wmiPositionedView.getModel();
                }
                if (wmiModel2 != null && wmiModel2.getTag() != wmiModelTag) {
                    wmiModel2 = WmiModelUtil.findAncestorOfTag(wmiModel2, wmiModelTag);
                }
                if (wmiModel2 != null && wmiModel2.getTag() == wmiModelTag) {
                    wmiModel = wmiModel2;
                }
            }
        }
        return wmiModel;
    }

    public static WmiView findViewAtSource(WmiView wmiView, WmiModelTag wmiModelTag) {
        WmiView wmiView2 = null;
        if (wmiView != null && wmiView.getModel().getTag() == wmiModelTag) {
            wmiView2 = wmiView;
        } else {
            WmiView wmiView3 = wmiView;
            if (wmiView instanceof WmiMathDocumentView) {
                WmiMathDocumentView wmiMathDocumentView = (WmiMathDocumentView)wmiView;
                WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
                if (wmiPositionMarker != null) {
                    wmiView3 = wmiPositionMarker.getView();
                } else {
                    WmiViewPath wmiViewPath;
                    WmiViewPath wmiViewPath2;
                    WmiViewPath wmiViewPath3;
                    WmiSelection wmiSelection = wmiMathDocumentView.getSelection();
                    if (wmiSelection != null && !wmiSelection.isCompoundSelection() && (wmiViewPath3 = WmiViewPath.commonParent(wmiViewPath2 = wmiSelection.getSelectionStartPath(), wmiViewPath = wmiSelection.getSelectionEndPath())) != null) {
                        wmiView3 = wmiViewPath3.extractView(wmiMathDocumentView);
                    }
                }
            }
            if (wmiView3 != null && wmiView3.getModel() != null && wmiView3.getModel().getTag() != wmiModelTag) {
                wmiView3 = WmiViewUtil.findAncestorOfTag(wmiView3, wmiModelTag);
            }
            if (wmiView3 != null && wmiView3.getModel() != null && wmiView3.getModel().getTag() == wmiModelTag) {
                wmiView2 = wmiView3;
            }
        }
        return wmiView2;
    }

    public static WmiView modelToPhysicalView(WmiMathDocumentView wmiMathDocumentView, WmiModel wmiModel) throws WmiNoReadAccessException {
        Object object;
        Object object2 = null;
        if (wmiModel == wmiModel.getDocument()) {
            object2 = wmiMathDocumentView;
        } else {
            Object object3 = object = wmiModel != null ? wmiModel.getObserver() : null;
            while (object != null) {
                if (object instanceof WmiView) {
                    WmiCompositeView wmiCompositeView;
                    boolean bl = true;
                    WmiView wmiView = (WmiView)object;
                    WmiCompositeView wmiCompositeView2 = wmiView.getParentView();
                    while (wmiCompositeView2 != wmiMathDocumentView) {
                        if (wmiCompositeView2 instanceof WmiSwitchableCompositeView) {
                            wmiCompositeView = ((WmiSwitchableCompositeView)wmiCompositeView2).getRootPhysicalView();
                            if (wmiCompositeView != null && wmiCompositeView != wmiView) {
                                bl = false;
                                break;
                            }
                        } else if (wmiCompositeView2 == null) {
                            bl = false;
                            break;
                        }
                        wmiView = wmiCompositeView2;
                        wmiCompositeView2 = wmiView.getParentView();
                    }
                    if (bl && (wmiCompositeView = ((WmiView)object).getParentView()) != null && wmiCompositeView.getModel() == wmiModel) {
                        bl = false;
                    }
                    if (bl) {
                        object2 = (WmiView)object;
                        break;
                    }
                }
                object = object.getNextObserver();
            }
        }
        object = WmiViewUtil.findView(wmiMathDocumentView, wmiModel, false);
        if (object != object2 && object != null) {
            object2 = object;
        }
        return object2;
    }

    public static WmiModelPosition findVisibleMarkerPosition(WmiMathDocumentView wmiMathDocumentView) throws WmiNoReadAccessException {
        Object object;
        Object object2;
        WmiModelPosition wmiModelPosition = null;
        WmiPositionedView wmiPositionedView = null;
        WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
        if (wmiPositionMarker != null) {
            wmiModelPosition = wmiPositionMarker.getModelPosition();
            WmiPositionedView wmiPositionedView2 = wmiPositionMarker.getView();
            if (wmiPositionedView2 instanceof WmiPositionedView && !(object2 = wmiPositionedView2.getModel()).isVisible()) {
                wmiPositionedView = wmiPositionedView2;
                for (object = wmiPositionedView2.getParentView(); object != null && !object.getModel().isVisible(); object = object.getParentView()) {
                    if (!(object instanceof WmiPositionedView)) continue;
                    wmiPositionedView = (WmiPositionedView)object;
                }
            }
        }
        if (wmiPositionedView != null) {
            int n = -1;
            object2 = wmiPositionedView.getNextView(2);
            if (object2 != null) {
                if (object2 instanceof WmiTextView) {
                    n = ((WmiTextView)object2).getLength();
                }
                wmiModelPosition = new WmiModelPosition(object2.getModel(), n);
            } else {
                if (wmiModelPosition == null) {
                    object2 = wmiPositionedView.getNextView(3);
                }
                if (object2 == null) {
                    object2 = wmiPositionedView.getNextView(0);
                }
                if (object2 == null) {
                    object2 = wmiPositionedView.getNextView(1);
                }
                if (object2 != null) {
                    object = object2.getModel();
                    if (object instanceof WmiCompositeModel) {
                        WmiModelPath wmiModelPath = WmiModelUtil.mapBeginningOfCompositeModel((WmiCompositeModel)object);
                        wmiModelPosition = wmiModelPath.getModelPosition(object.getDocument());
                    } else {
                        wmiModelPosition = new WmiModelPosition((WmiModel)object, n);
                    }
                }
            }
        }
        return wmiModelPosition;
    }

    public static BufferedImage drawViewToImage(WmiPositionedView wmiPositionedView, WmiRenderPath wmiRenderPath, int n) throws WmiNoReadAccessException {
        BufferedImage bufferedImage = null;
        int n2 = wmiPositionedView.getModel().kerningPoints();
        if (wmiPositionedView instanceof WmiInlineView) {
            n2 = Math.max(n2, WmiMathViewUtil.getMathKerningSize((WmiInlineView)wmiPositionedView));
        }
        AffineTransform affineTransform = null;
        if (n <= 0 || wmiPositionedView.getWidth() + 2 * n2 < n) {
            bufferedImage = WmiImageUtilities.createImageObject((int)(wmiPositionedView.getWidth() + 2 * n2), (int)wmiPositionedView.getHeight());
        } else if (wmiPositionedView instanceof WmiInlineView) {
            n2 = WmiMathViewUtil.getMathKerningSize((WmiInlineView)wmiPositionedView);
            bufferedImage = WmiImageUtilities.createImageObject((int)n, (int)wmiPositionedView.getHeight());
            wmiPositionedView.setWidth(n - 2 * n2);
        } else {
            int n3 = n;
            int n4 = (int)Math.round((double)wmiPositionedView.getHeight() / ((double)wmiPositionedView.getWidth() * 1.0) * (double)n);
            bufferedImage = WmiImageUtilities.createImageObject((int)n3, (int)n4);
            affineTransform = new AffineTransform();
            affineTransform.setToScale((float)n3 / (float)wmiPositionedView.getWidth(), (float)n4 / (float)wmiPositionedView.getHeight());
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Rectangle rectangle = new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight());
        WmiMathDocumentView wmiMathDocumentView = wmiPositionedView.getDocumentView();
        Color color = wmiMathDocumentView != null ? wmiMathDocumentView.getColor(0) : Color.WHITE;
        graphics2D.setPaint(color);
        graphics2D.setClip(rectangle);
        graphics2D.fill(rectangle);
        wmiRenderPath.setScreenDraw(false);
        wmiRenderPath.drawStringsWithGlyphVectors(false);
        graphics2D.translate(n2, 0);
        if (affineTransform != null) {
            graphics2D.transform(affineTransform);
        }
        wmiPositionedView.draw(graphics2D, wmiRenderPath, rectangle);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static WmiView findFirstLeafView(WmiCompositeModel wmiCompositeModel, WmiMathDocumentView wmiMathDocumentView) throws WmiNoReadAccessException {
        WmiView wmiView = null;
        WmiModel wmiModel = WmiModelUtil.findFirstDescendantLeaf(wmiCompositeModel);
        while (wmiModel != null && wmiView == null) {
            if (wmiModel.isVisible()) {
                wmiView = WmiViewUtil.modelToPhysicalView(wmiMathDocumentView, wmiModel);
            }
            wmiModel = WmiModelUtil.findNextDescendantLeaf(wmiCompositeModel, wmiModel);
        }
        return wmiView;
    }

    public static WmiView findLastLeafView(WmiCompositeModel wmiCompositeModel, WmiMathDocumentView wmiMathDocumentView) throws WmiNoReadAccessException {
        WmiView wmiView = null;
        WmiModel wmiModel = WmiModelUtil.findLastDescendantLeaf(wmiCompositeModel);
        while (wmiModel != null && wmiView == null) {
            if (wmiModel.isVisible()) {
                wmiView = WmiViewUtil.modelToPhysicalView(wmiMathDocumentView, wmiModel);
            }
            wmiModel = WmiModelUtil.findPreviousDescendantLeaf(wmiCompositeModel, wmiModel);
        }
        return wmiView;
    }

    private static Vector childModelToView(WmiCompositeView wmiCompositeView, WmiModel wmiModel, boolean bl) {
        Vector<WmiView> vector = new Vector<WmiView>();
        LinkedList<WmiView> linkedList = new LinkedList<WmiView>();
        linkedList.addLast(wmiCompositeView);
        if (wmiCompositeView.getModel() == wmiModel) {
            vector.add(wmiCompositeView);
        } else {
            while (!linkedList.isEmpty()) {
                WmiRowView wmiRowView;
                WmiCompositeView wmiCompositeView2 = null;
                wmiCompositeView2 = (WmiCompositeView)linkedList.removeFirst();
                if ((!bl && wmiCompositeView2 instanceof WmiSwitchableCompositeView || wmiCompositeView2 instanceof WmiMapleTASwitchableCompositeView) && (wmiRowView = ((WmiSwitchableCompositeView)wmiCompositeView2).getRootPhysicalView()) != null) {
                    wmiCompositeView2 = wmiRowView;
                }
                int n = wmiCompositeView2.getChildCount();
                for (int i = 0; i < n; ++i) {
                    WmiView wmiView = wmiCompositeView2.getChild(i);
                    if (wmiView == null) continue;
                    if (wmiView.getModel() == wmiModel) {
                        vector.add(wmiView);
                    }
                    if (!(wmiView instanceof WmiCompositeView) || !vector.isEmpty()) continue;
                    linkedList.addLast(wmiView);
                }
            }
        }
        return vector;
    }

    private static WmiView depthFirstSearch(WmiView wmiView, SearchAlgorithms.MatchCondition matchCondition, int n, boolean bl) throws WmiSearchException {
        return (WmiView)SearchAlgorithms.depthFirstSearch(wmiView, bl ? physicalChildOp : logicalChildOp, matchCondition, n);
    }

    public static WmiView findView(WmiMathDocumentView wmiMathDocumentView, WmiModel wmiModel, boolean bl) throws WmiNoReadAccessException {
        Vector vector;
        if (wmiMathDocumentView.getModel() == wmiModel) {
            return wmiMathDocumentView;
        }
        WmiView wmiView = null;
        Stack<WmiModel> stack = new Stack<WmiModel>();
        stack.push(wmiModel);
        for (WmiCompositeModel wmiCompositeModel = wmiModel.getParent(); wmiCompositeModel != null; wmiCompositeModel = wmiCompositeModel.getParent()) {
            stack.push(wmiCompositeModel);
        }
        WmiModel wmiModel2 = (WmiModel)stack.pop();
        Vector<WmiView> vector2 = new Vector<WmiView>();
        vector2.add(wmiMathDocumentView);
        block1: while (!stack.isEmpty()) {
            WmiView wmiView2;
            wmiModel2 = (WmiModel)stack.pop();
            vector = null;
            int n = 0;
            while ((vector == null || vector.size() == 0) && n < vector2.size()) {
                wmiView2 = (WmiCompositeView)vector2.get(n++);
                vector = WmiViewUtil.childModelToView((WmiCompositeView)wmiView2, wmiModel2, bl);
            }
            if (vector != null && !vector.isEmpty()) {
                vector2.removeAllElements();
            }
            while (vector != null && !vector.isEmpty()) {
                wmiView2 = (WmiView)vector.remove(vector.size() - 1);
                if (wmiView2 != null && wmiView2.getModel() == wmiModel) {
                    wmiView = wmiView2;
                    continue block1;
                }
                if (!bl && wmiView2 instanceof WmiSwitchableCompositeView || wmiView2 instanceof WmiMapleTASwitchableCompositeView) {
                    WmiRowView wmiRowView = ((WmiSwitchableCompositeView)wmiView2).getRootPhysicalView();
                    vector2.add(wmiRowView != null ? wmiRowView : (WmiCompositeView)wmiView2);
                    continue;
                }
                if (!(wmiView2 instanceof WmiCompositeView)) continue;
                vector2.add(wmiView2);
            }
        }
        if (wmiView == null && (vector = WmiViewUtil.childModelToView(wmiMathDocumentView, wmiModel, bl)) != null && !vector.isEmpty()) {
            wmiView = (WmiView)vector.get(0);
        }
        return wmiView;
    }

    private static WmiView parentSearch(WmiView wmiView, SearchAlgorithms.MatchCondition matchCondition) {
        WmiView wmiView2 = null;
        while (wmiView != null) {
            if (matchCondition.matchesCondition(wmiView)) {
                wmiView2 = wmiView;
                break;
            }
            wmiView = wmiView.getParentView();
        }
        return wmiView2;
    }

    public static WmiPositionInView getPositionInView(MouseEvent mouseEvent) {
        return WmiViewUtil.getPositionInView(mouseEvent, null);
    }

    public static WmiPositionInView getPositionInView(MouseEvent mouseEvent, WmiView wmiView) {
        Object object = mouseEvent.getSource();
        Point point = mouseEvent.getPoint();
        while (!(object instanceof WmiPositionedView)) {
            if (object instanceof Component) {
                Component component = (Component)object;
                point.translate((int)component.getLocation().getX(), (int)component.getLocation().getY());
                object = component.getParent();
                continue;
            }
            if (wmiView instanceof WmiPositionedView) {
                return new WmiPositionInView((WmiPositionedView)wmiView, mouseEvent.getPoint());
            }
            throw new NullPointerException();
        }
        return new WmiPositionInView((WmiPositionedView)object, point);
    }

    public static WmiFontMetrics getFontMetrics(WmiGenericView wmiGenericView) throws WmiNoReadAccessException {
        WmiModel wmiModel = wmiGenericView.getModel();
        WmiAttributeSet wmiAttributeSet = wmiModel.getAttributesForRead();
        boolean bl = wmiGenericView.getDocumentView().isPrintView();
        WmiFontAttributeSet wmiFontAttributeSet = wmiAttributeSet instanceof WmiFontAttributeSet ? (WmiFontAttributeSet)wmiAttributeSet : WmiFontAttributeSet.DEFAULT_FONT_ATTRIBUTES;
        Font font = WmiFontResolver.getFont(wmiFontAttributeSet, wmiGenericView.getZoomFactor(), bl);
        return WmiFontResolver.getFontMetrics(font);
    }

    public static AffineTransform createCOBMatrix(WmiPositionedView wmiPositionedView, WmiPositionedView wmiPositionedView2) {
        AffineTransform affineTransform = new AffineTransform();
        while (wmiPositionedView2 != wmiPositionedView) {
            int n = wmiPositionedView2.getHorizontalOffset();
            int n2 = wmiPositionedView2.getVerticalOffset();
            affineTransform.preConcatenate(AffineTransform.getTranslateInstance(n, n2));
            wmiPositionedView2 = (WmiPositionedView)((Object)wmiPositionedView2.getParentView());
        }
        return affineTransform;
    }

    public static boolean isTraversableView(WmiView wmiView) {
        boolean bl = false;
        if (wmiView instanceof WmiTraversableView) {
            bl = ((WmiTraversableView)wmiView).getTraversalType() != 0;
        }
        return bl;
    }

    private WmiViewUtil() {
    }

    private static class ViewUtilEqualityMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiView toMatch = null;

        private ViewUtilEqualityMatch(WmiView wmiView) {
            this.toMatch = wmiView;
        }

        public boolean matchesCondition(Object object) {
            return object == this.toMatch;
        }
    }

    private static class ViewUtilClassMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiView view = null;
        private Class toMatch = null;

        private ViewUtilClassMatch(Class clazz) {
            this(null, clazz);
        }

        private ViewUtilClassMatch(WmiView wmiView, Class clazz) {
            this.view = wmiView;
            this.toMatch = clazz;
        }

        public boolean matchesCondition(Object object) {
            return (this.view == null || this.view != object) && this.toMatch.isInstance(object);
        }
    }

    private static class ViewUtilTagsMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiView origin = null;
        private WmiModelTag[] tags = null;

        private ViewUtilTagsMatch(WmiView wmiView, WmiModelTag[] wmiModelTagArray) {
            this.origin = wmiView;
            this.tags = wmiModelTagArray;
        }

        public boolean matchesCondition(Object object) {
            WmiModel wmiModel;
            boolean bl = false;
            if (object != this.origin && (wmiModel = ((WmiView)object).getModel()) != null) {
                for (int i = 0; i < this.tags.length; ++i) {
                    if (this.tags[i] != wmiModel.getTag()) continue;
                    bl = true;
                    break;
                }
            }
            return bl;
        }
    }

    private static class ViewUtilTagMatch
    implements SearchAlgorithms.MatchCondition {
        private WmiView origin = null;
        private WmiModelTag tag = null;

        private ViewUtilTagMatch(WmiView wmiView, WmiModelTag wmiModelTag) {
            this.origin = wmiView;
            this.tag = wmiModelTag;
        }

        public boolean matchesCondition(Object object) {
            if (object == this.origin) {
                return false;
            }
            WmiModel wmiModel = ((WmiView)object).getModel();
            return wmiModel != null ? wmiModel.getTag() == this.tag : false;
        }
    }

    private static class ViewUtilParentOperation
    implements SearchAlgorithms.ParentOperation {
        private ViewUtilParentOperation() {
        }

        public Object getParent(Object object) {
            WmiView wmiView = (WmiView)object;
            return wmiView.getParentView();
        }
    }

    private static class ViewUtilPhysicalChildOperation
    implements SearchAlgorithms.ChildOperation {
        private ViewUtilPhysicalChildOperation() {
        }

        public Object getChild(Object object, int n) {
            WmiRowView wmiRowView;
            WmiCompositeView wmiCompositeView = (WmiCompositeView)object;
            if (object instanceof WmiSwitchableCompositeView && (wmiRowView = ((WmiSwitchableCompositeView)object).getRootPhysicalView()) != null) {
                wmiCompositeView = wmiRowView;
            }
            return wmiCompositeView.getChild(n);
        }

        public int getChildCount(Object object) {
            WmiRowView wmiRowView;
            WmiCompositeView wmiCompositeView = (WmiCompositeView)object;
            if (object instanceof WmiSwitchableCompositeView && (wmiRowView = ((WmiSwitchableCompositeView)object).getRootPhysicalView()) != null) {
                wmiCompositeView = wmiRowView;
            }
            return wmiCompositeView.getChildCount();
        }

        public boolean hasChildren(Object object) {
            return object instanceof WmiCompositeView;
        }
    }

    private static class ViewUtilLogicalChildOperation
    implements SearchAlgorithms.ChildOperation {
        private ViewUtilLogicalChildOperation() {
        }

        public Object getChild(Object object, int n) {
            WmiCompositeView wmiCompositeView = (WmiCompositeView)object;
            return wmiCompositeView.getChild(n);
        }

        public int getChildCount(Object object) {
            WmiCompositeView wmiCompositeView = (WmiCompositeView)object;
            return wmiCompositeView.getChildCount();
        }

        public boolean hasChildren(Object object) {
            return object instanceof WmiCompositeView;
        }
    }
}

