/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiFontMetrics;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.view.WmiArrayCompositeView;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiGenericView;
import com.maplesoft.mathdoc.view.WmiHighlightPainter;
import com.maplesoft.mathdoc.view.WmiInlineView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionMarker;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiTraversableView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewPath;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.WmiViewlessPositionMarker;
import com.maplesoft.mathdoc.view.math.WmiMathCaret;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.WmiMathPhantomView;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;

public class WmiFractionView
extends WmiArrayCompositeView
implements WmiTraversableView {
    private static final int ALIGN_CENTER = 0;
    private static final int ALIGN_LEFT = 1;
    private static final int ALIGN_RIGHT = 2;
    private static final Stroke DEFAULT_PRINT_STROKE = new BasicStroke(0.5f);
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Stroke ZOOM_STROKE = new BasicStroke(2.0f);
    private static final Stroke MARKER_STROKE = new BasicStroke(2.0f);
    private static final Stroke ZOOM_MARKER_STROKE = new BasicStroke(3.0f);
    private static final WmiAlignCalculation[] ALIGNMENT_CALCULATORS = new WmiAlignCalculation[]{new WmiCenterAlignment(), new WmiLeftAlignment(), new WmiRightAlignment()};
    public static final int FRACTION_VIEW_SIZE = 2;
    public static final int NUMERATOR_INDEX = 0;
    public static final int DENOMINATOR_INDEX = 1;
    private static final int BEVELLED_PADDING_TERM = 2;
    private static final int FRACTION_VERTICAL_PADDING_TERM = 1;
    private static final int FRACTION_HORIZONTAL_PADDING_TERM = 2;
    private static final float BASELINE_SCALE_FACTOR = 0.35f;
    private static final int THRESHOLD_ZOOM_FACTOR = 250;
    private static final int EMPTY_FRACTION_BAR_WIDTH = 5;
    private static final float LEADING_RATIONAL_CONVERT_THRESHOLD = 0.5f;
    private Color foreground = null;
    private int linethickness = 1;
    private Stroke lineStroke = null;
    private int baselineShift = 0;
    private boolean inLeadRationalLinebreak = false;
    WmiFractionBarView bar = null;

    public WmiFractionView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
        this.inLeadRationalLinebreak = false;
    }

    private WmiFractionView(WmiModel wmiModel, WmiView wmiView, WmiView wmiView2, WmiView wmiView3, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
        this.children = new WmiView[2];
        this.children[0] = wmiView;
        this.children[1] = wmiView3;
        this.bar = (WmiFractionBarView)wmiView2;
        this.inLeadRationalLinebreak = true;
        this.length = 2;
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            this.validateChildren();
            this.layoutStackOrInline();
            super.layoutView();
        }
    }

    private void layoutStackOrInline() {
        try {
            int n;
            Object object;
            Object object2;
            WmiAttributeSet wmiAttributeSet;
            WmiModel wmiModel = this.getModel();
            if (this.bar == null) {
                this.bar = new WmiFractionBarView(wmiModel, this.getDocumentView());
            }
            WmiFontAttributeSet wmiFontAttributeSet = (wmiAttributeSet = wmiModel.getAttributesForRead()) instanceof WmiFontAttributeSet ? (WmiFontAttributeSet)wmiAttributeSet : WmiFontAttributeSet.DEFAULT_FONT_ATTRIBUTES;
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            int n4 = this.getCorrectedZoomFactor();
            if (wmiAttributeSet instanceof WmiFractionModel.WmiFractionAttributeSet) {
                WmiFractionModel.WmiFractionAttributeSet wmiFractionAttributeSet = (WmiFractionModel.WmiFractionAttributeSet)wmiAttributeSet;
                object2 = (String)wmiFractionAttributeSet.getAttribute("numalign");
                object = (String)wmiFractionAttributeSet.getAttribute("denomalign");
                n2 = this.mapAlignment((String)object2);
                n3 = this.mapAlignment((String)object);
                this.linethickness = wmiFractionAttributeSet.getLineThickness();
                bl = wmiFractionAttributeSet.isBevelled();
                if (this.linethickness != 1) {
                    n = this.linethickness;
                    if (n4 > 250) {
                        ++n;
                    }
                    this.lineStroke = new BasicStroke(n);
                } else {
                    this.lineStroke = null;
                }
            }
            boolean bl2 = this.getDocumentView().isPrintView();
            object2 = WmiFontResolver.getFont(wmiFontAttributeSet, n4, bl2);
            object = WmiFontResolver.getFontMetrics((Font)object2);
            n = ((WmiFontMetrics)object).getFontProperty(5, bl2);
            int n5 = ((WmiFontMetrics)object).getFontProperty(2, bl2);
            this.baselineShift = Math.round(0.35f * (float)n);
            WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(0);
            wmiPositionedView.layoutView();
            WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.getChild(1);
            wmiPositionedView2.layoutView();
            if (bl) {
                this.configureViewsForBevelled(wmiPositionedView, this.bar, wmiPositionedView2);
            } else {
                this.configureViewsForFraction(wmiPositionedView, this.bar, wmiPositionedView2, n2, n3, n, n5);
            }
            this.foreground = new Color(wmiFontAttributeSet.getForeground());
            this.addNavigationLinks();
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    private void configureViewsForBevelled(WmiPositionedView wmiPositionedView, WmiPositionedView wmiPositionedView2, WmiPositionedView wmiPositionedView3) {
        this.height = wmiPositionedView.getHeight();
        if (this.height < wmiPositionedView3.getHeight()) {
            this.height = wmiPositionedView3.getHeight();
        }
        wmiPositionedView2.setHeight(this.height);
        int n = this.height / 2;
        wmiPositionedView2.setWidth(n);
        wmiPositionedView.setHorizontalOffset(0);
        int n2 = wmiPositionedView.getWidth();
        wmiPositionedView2.setHorizontalOffset(n2 + 2);
        wmiPositionedView3.setHorizontalOffset(n2 + n + 4);
        this.width = n + n2 + wmiPositionedView3.getWidth() + 4;
        this.baseline = wmiPositionedView.getBaseline();
        if (wmiPositionedView3.getBaseline() > this.baseline) {
            this.baseline = wmiPositionedView3.getBaseline();
        }
        wmiPositionedView.setVerticalOffset(this.baseline - wmiPositionedView.getBaseline());
        wmiPositionedView3.setVerticalOffset(this.baseline - wmiPositionedView3.getBaseline());
        int n3 = wmiPositionedView.getBaseline() > wmiPositionedView3.getBaseline() ? wmiPositionedView.getBaseline() : wmiPositionedView3.getBaseline();
        wmiPositionedView2.setBaseline(n3);
        wmiPositionedView2.setVerticalOffset(this.baseline - wmiPositionedView2.getBaseline());
        ((WmiFractionBarView)wmiPositionedView2).setBevelled(true);
    }

    private void configureViewsForFraction(WmiPositionedView wmiPositionedView, WmiPositionedView wmiPositionedView2, WmiPositionedView wmiPositionedView3, int n, int n2, int n3, int n4) {
        int n5 = wmiPositionedView.getWidth();
        int n6 = wmiPositionedView3.getWidth();
        int n7 = wmiPositionedView.getHeight();
        int n8 = wmiPositionedView3.getHeight();
        if (n7 < n3) {
            n7 = n3;
        }
        this.width = n5 > n6 ? n5 : n6;
        if (this.linethickness > 0) {
            this.width += n4 / 3;
            if (this.fractionPadding(wmiPositionedView) || this.fractionPadding(wmiPositionedView3)) {
                this.width += n4;
            }
        }
        int n9 = ALIGNMENT_CALCULATORS[n].calculateHOffset(this.width, n5);
        wmiPositionedView.setHorizontalOffset(n9);
        int n10 = ALIGNMENT_CALCULATORS[n2].calculateHOffset(this.width, n6);
        wmiPositionedView3.setHorizontalOffset(n10);
        this.baseline = n7 + this.baselineShift;
        if (wmiPositionedView instanceof WmiMathPhantomView || wmiPositionedView3 instanceof WmiMathPhantomView) {
            this.baseline = wmiPositionedView.getBaseline();
        }
        wmiPositionedView2.setHorizontalOffset(0);
        wmiPositionedView2.setVerticalOffset(n7 + 1);
        wmiPositionedView2.setWidth(this.width);
        wmiPositionedView2.setHeight(this.linethickness);
        int n11 = n7 + this.linethickness + 2 - 1;
        wmiPositionedView3.setVerticalOffset(n11);
        ((WmiFractionBarView)wmiPositionedView2).setBevelled(false);
        this.height = n11 + n8;
    }

    private boolean fractionPadding(WmiPositionedView wmiPositionedView) {
        boolean bl = false;
        if (wmiPositionedView instanceof WmiFractionView) {
            bl = true;
        }
        return bl;
    }

    private int mapAlignment(String string) {
        int n = 0;
        if (string.equals("left")) {
            n = 1;
        } else if (string.equals("right")) {
            n = 2;
        }
        return n;
    }

    public void addNavigationLinks() {
        WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(0);
        WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.getChild(1);
        if (this.bar.isBevelled()) {
            wmiPositionedView.setNextView(wmiPositionedView2, 3);
            wmiPositionedView.setNextView(null, 1);
            wmiPositionedView2.setNextView(wmiPositionedView, 2);
            wmiPositionedView2.setNextView(null, 0);
            this.setNextView(null, -2);
            this.setNextView(null, -1);
            this.setNextView(wmiPositionedView, -4);
            this.setNextView(wmiPositionedView2, -3);
        } else {
            wmiPositionedView.setNextView(wmiPositionedView2, 1);
            wmiPositionedView.setNextView(null, 3);
            wmiPositionedView.setNextView(null, 2);
            wmiPositionedView2.setNextView(wmiPositionedView, 0);
            wmiPositionedView2.setNextView(null, 2);
            wmiPositionedView2.setNextView(null, 3);
            this.setNextView(wmiPositionedView, -2);
            this.setNextView(wmiPositionedView2, -1);
            this.setNextView(wmiPositionedView, -4);
            this.setNextView(wmiPositionedView2, -3);
        }
    }

    public WmiPositionedView getViewForNavigation(int n, Point point) {
        WmiPositionedView wmiPositionedView = this.getNextView(n);
        if (wmiPositionedView == null) {
            wmiPositionedView = this.getNearestChildView(point);
        }
        return wmiPositionedView;
    }

    protected int getCorrectedZoomFactor() throws WmiNoReadAccessException {
        int n = this.getZoomFactor();
        boolean bl = false;
        WmiModel wmiModel = this.getModel();
        WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
        while (wmiCompositeModel instanceof WmiMathModel) {
            bl = ((WmiMathModel)((Object)wmiCompositeModel)).useScriptSize(wmiModel);
            if (bl) {
                n = Math.round((float)n * 0.8f);
                break;
            }
            wmiModel = wmiCompositeModel;
            wmiCompositeModel = wmiModel.getParent();
        }
        return n;
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        super.draw(graphics, wmiRenderPath, rectangle);
        wmiRenderPath.push(this.getHorizontalOffset(), this.getVerticalOffset());
        if (this.bar != null) {
            this.bar.draw(graphics, wmiRenderPath, rectangle);
        }
        wmiRenderPath.pop();
    }

    public WmiFractionBarView getBar() {
        return this.bar;
    }

    public void setPositionMarker(int n) {
        WmiMathCaret.setBoundaryCaret(this, n);
    }

    public WmiPositionedView getNearestChildView(Point point) {
        return this.getNearestChildView(point, 1);
    }

    public int getTraversalType() {
        return 6;
    }

    public int getOffset(Point point) {
        return 0;
    }

    public int getTraversableCount() {
        return 2;
    }

    public boolean isRepeatable() {
        return false;
    }

    public int doImplicitLinebreak(WmiParagraphView wmiParagraphView, int n, int n2, int n3) throws WmiNoReadAccessException {
        int n4 = 0;
        if (this.bar.isBevelled()) {
            WmiInlineView wmiInlineView = this.convertToInline();
            WmiCompositeView wmiCompositeView = this.getParentView();
            int n5 = wmiCompositeView.indexOf(this);
            if (n5 >= 0) {
                wmiCompositeView.replaceChild(wmiInlineView, n5);
                wmiInlineView.setParentView(wmiCompositeView);
                n4 = wmiInlineView.doImplicitLinebreak(wmiParagraphView, n, n2, n3);
            }
        } else if (n3 != 0 || this.getWidth() > n2) {
            WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(0);
            WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.getChild(1);
            boolean bl = false;
            if ((float)wmiPositionedView2.getWidth() < 0.5f * (float)n2 && wmiPositionedView instanceof WmiCompositeView) {
                bl = true;
            }
            if (bl) {
                WmiInlineView wmiInlineView;
                if (WmiFractionView.areBracketsRequired(wmiPositionedView.getModel())) {
                    wmiPositionedView = WmiFractionView.addBrackets(wmiPositionedView);
                }
                if ((wmiInlineView = this.convertToLeadingRationalInline()) != null) {
                    n4 = 1;
                }
            } else {
                if (WmiFractionView.areBracketsRequired(wmiPositionedView.getModel())) {
                    wmiPositionedView = WmiFractionView.addBrackets(wmiPositionedView);
                }
                if (WmiFractionView.areBracketsRequired(wmiPositionedView2.getModel())) {
                    wmiPositionedView2 = WmiFractionView.addBrackets(wmiPositionedView2);
                }
                this.configureViewsForBevelled(wmiPositionedView, this.bar, wmiPositionedView2);
                n4 = 1;
            }
        }
        return n4;
    }

    private WmiInlineView convertToInline() throws WmiNoReadAccessException {
        WmiModel wmiModel = this.getModel();
        WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
        WmiInlineView wmiInlineView = new WmiInlineView(wmiModel, wmiMathDocumentView);
        wmiInlineView.releaseObserver();
        WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(0);
        WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.getChild(1);
        wmiInlineView.appendView(this.createPaddedView(wmiPositionedView));
        wmiInlineView.appendView(this.bar);
        wmiInlineView.appendView(this.createPaddedView(wmiPositionedView2));
        wmiInlineView.layoutView();
        return wmiInlineView;
    }

    private WmiInlineView convertToLeadingRationalInline() throws WmiNoReadAccessException {
        WmiModel wmiModel = this.getModel();
        WmiAttributeSet wmiAttributeSet = wmiModel.getAttributesForRead();
        WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
        WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
        WmiInlineView wmiInlineView = new WmiInlineView(wmiModel, wmiMathDocumentView);
        wmiInlineView.releaseObserver();
        WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(0);
        WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.getChild(1);
        WmiCompositeModel wmiCompositeModel = WmiModelUtil.findAncestorOfTag(wmiModel, WmiModelTag.MATH);
        WmiAttributeSet wmiAttributeSet2 = wmiCompositeModel != null ? wmiCompositeModel.getAttributesForRead() : null;
        String string = wmiAttributeSet2 != null ? (String)wmiAttributeSet2.getAttribute("font_style_name") : null;
        WmiMathContext wmiMathContext = new WmiMathContext(wmiMathDocumentModel.getFontStyle(string));
        WmiNumericModel wmiNumericModel = new WmiNumericModel(wmiMathDocumentModel, "1", "1", wmiMathContext);
        WmiMathTextView wmiMathTextView = new WmiMathTextView(wmiNumericModel, wmiMathDocumentView);
        wmiMathTextView.setParentView(this);
        wmiMathTextView.layoutView();
        boolean bl = this.getDocumentView().isPrintView();
        int n = this.getCorrectedZoomFactor();
        Font font = WmiFontResolver.getFont((WmiFontAttributeSet)wmiAttributeSet, n, bl);
        WmiFontMetrics wmiFontMetrics = WmiFontResolver.getFontMetrics(font);
        int n2 = wmiFontMetrics.getFontProperty(5, bl);
        int n3 = wmiFontMetrics.getFontProperty(2, bl);
        this.replaceChild(wmiMathTextView, 0);
        this.markInvalid(1);
        this.configureViewsForFraction(wmiMathTextView, this.bar, wmiPositionedView2, 0, 0, n2, n3);
        WmiCompositeView wmiCompositeView = this.getParentView();
        int n4 = wmiCompositeView.indexOf(this);
        if (n4 >= 0) {
            wmiInlineView.appendView(this);
            wmiInlineView.appendView(wmiPositionedView);
            this.setParentView(wmiInlineView);
            wmiPositionedView.setParentView(wmiInlineView);
            wmiCompositeView.replaceChild(wmiInlineView, n4);
            wmiInlineView.setParentView(wmiCompositeView);
        }
        wmiInlineView.layoutView();
        wmiCompositeView = wmiInlineView.getParentView();
        while (!(wmiCompositeView instanceof WmiParagraphView)) {
            wmiCompositeView.markInvalid(1);
            wmiCompositeView = wmiCompositeView.getParentView();
        }
        return wmiInlineView;
    }

    private WmiInlineView createPaddedView(WmiPositionedView wmiPositionedView) throws WmiNoReadAccessException {
        WmiInlineView wmiInlineView = new WmiInlineView(wmiPositionedView.getModel(), wmiPositionedView.getDocumentView());
        wmiInlineView.releaseObserver();
        wmiInlineView.appendView(wmiPositionedView);
        wmiInlineView.setBaselineAdjustment(this.getBaseline() - wmiPositionedView.getVerticalOffset() - wmiPositionedView.getBaseline());
        wmiInlineView.layoutView();
        return wmiInlineView;
    }

    protected static class FractionBarMarker
    extends WmiViewlessPositionMarker {
        private WmiFractionBarView view;
        private boolean visible = false;

        protected FractionBarMarker(WmiFractionBarView wmiFractionBarView) {
            this.view = wmiFractionBarView;
        }

        public Rectangle getBounds() {
            Rectangle rectangle = null;
            if (this.view != null) {
                Point point = WmiViewUtil.getAbsoluteOffset(this.view);
                rectangle = new Rectangle(point.x, point.y, this.view.getWidth(), this.view.getHeight());
            }
            return rectangle;
        }

        public WmiModelPosition getModelPosition() {
            WmiModelPosition wmiModelPosition = null;
            if (this.view != null) {
                WmiModel wmiModel = this.view.getModel();
                wmiModelPosition = new WmiModelPosition(wmiModel, this.getOffset());
            }
            return wmiModelPosition;
        }

        public WmiViewPath getViewPath() throws WmiNoReadAccessException {
            return this.view != null ? new WmiViewPath(this.view) : null;
        }

        public void hide() {
            this.visible = false;
            this.repaint();
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void paint(Graphics graphics) {
        }

        public void resync() throws WmiNoReadAccessException {
            this.show();
        }

        public void show() {
            WmiMathDocumentView wmiMathDocumentView;
            this.visible = true;
            if (this.view != null && (wmiMathDocumentView = this.view.getDocumentView()) != null) {
                wmiMathDocumentView.setFocusedView(this.view);
            }
            this.repaint();
        }

        public void updateMarkerPosition(WmiModel wmiModel, int n) throws WmiNoReadAccessException {
        }

        public WmiPositionedView getView() {
            return this.view;
        }

        public int getOffset() {
            return 0;
        }

        public boolean isReadOnly() throws WmiNoReadAccessException {
            return true;
        }

        protected void repaint() {
            if (this.view != null) {
                WmiMathDocumentView wmiMathDocumentView = this.view.getDocumentView();
                Rectangle rectangle = this.getBounds();
                wmiMathDocumentView.repaint(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
            }
        }
    }

    public static class LeadingRationalView
    extends WmiInlineView {
        public LeadingRationalView(WmiModel wmiModel, WmiView wmiView, WmiView wmiView2, WmiView wmiView3, WmiMathDocumentView wmiMathDocumentView) {
            super(wmiModel, wmiMathDocumentView);
            try {
                WmiFractionModel wmiFractionModel = (WmiFractionModel)wmiModel;
                WmiFractionModel wmiFractionModel2 = WmiFractionModel.createDenominatorModel(wmiFractionModel);
                WmiMathTextView wmiMathTextView = new WmiMathTextView(wmiFractionModel2.getChild(0), wmiMathDocumentView);
                WmiFractionView wmiFractionView = new WmiFractionView(wmiFractionModel2, wmiMathTextView, wmiView2.copyView(), wmiView3.copyView(), wmiMathDocumentView);
                this.appendView(wmiFractionView);
                this.appendView(this.constructInvisibleTimes(wmiView));
                this.appendView(wmiView.copyView());
            }
            catch (WmiNoReadAccessException wmiNoReadAccessException) {
                // empty catch block
            }
        }

        public int getLeadWidth() {
            WmiView wmiView = (WmiCompositeView)this.getChild(0);
            wmiView = wmiView.getChild(2);
            return ((WmiPositionedView)wmiView).getWidth();
        }

        private WmiView constructInvisibleTimes(WmiView wmiView) throws WmiNoReadAccessException {
            WmiMathOperatorView wmiMathOperatorView = null;
            WmiModel wmiModel = wmiView.getModel();
            WmiFontAttributeSet wmiFontAttributeSet = (WmiFontAttributeSet)wmiModel.getAttributes();
            WmiMathContext wmiMathContext = new WmiMathContext(wmiFontAttributeSet);
            WmiMathOperatorModel wmiMathOperatorModel = new WmiMathOperatorModel(wmiModel.getDocument(), "&InvisibleTimes;", "&InvisibleTimes;", wmiMathContext, wmiModel.getParent());
            wmiMathOperatorView = new WmiMathOperatorView(wmiMathOperatorModel, wmiView.getDocumentView());
            return wmiMathOperatorView;
        }

        public void layoutView() throws WmiNoReadAccessException {
            super.layoutView();
            this.height = 0;
            WmiPositionedView wmiPositionedView = (WmiPositionedView)this.getChild(0);
            WmiPositionedView wmiPositionedView2 = (WmiPositionedView)this.getChild(1);
            WmiPositionedView wmiPositionedView3 = (WmiPositionedView)this.getChild(2);
            int n = wmiPositionedView.getWidth();
            wmiPositionedView.setVerticalOffset(0);
            wmiPositionedView.setHorizontalOffset(0);
            int n2 = wmiPositionedView2.getWidth();
            wmiPositionedView2.setHorizontalOffset(n);
            wmiPositionedView3.setHorizontalOffset(n + n2);
            this.width = n;
            this.width += n2;
            this.width += wmiPositionedView3.getWidth();
        }
    }

    public class WmiFractionBarView
    extends WmiGenericView
    implements WmiPositionedView {
        private boolean bevelled;

        public WmiFractionBarView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
            super(wmiModel, wmiMathDocumentView);
            this.bevelled = false;
        }

        public Dimension getSize() {
            return new Dimension(this.width, WmiFractionView.this.linethickness);
        }

        public void setBevelled(boolean bl) {
            this.bevelled = bl;
        }

        public boolean isBevelled() {
            return this.bevelled;
        }

        public void addTraversableLinks() {
        }

        public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
            Graphics2D graphics2D = graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
            Color color = graphics.getColor();
            Color color2 = WmiFractionView.this.foreground;
            WmiSelection wmiSelection = wmiRenderPath.getSelection();
            WmiHighlightPainter wmiHighlightPainter = wmiSelection != null ? wmiSelection.getSelectionHighlighter() : null;
            Rectangle[] rectangleArray = null;
            graphics.setColor(color2);
            int n = this.getHorizontalOffset() + wmiRenderPath.getHorizontalOffset() + 2;
            int n2 = this.getVerticalOffset() + wmiRenderPath.getVerticalOffset();
            if (wmiHighlightPainter != null) {
                rectangleArray = wmiHighlightPainter.intersect(n + wmiRenderPath.getHorizontalShift(), n2 + wmiRenderPath.getVerticalShift(), this.width, this.height);
            }
            WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
            if (WmiFractionView.this.linethickness > 0) {
                int n3;
                int n4;
                Stroke stroke = null;
                if (graphics2D != null) {
                    stroke = graphics2D.getStroke();
                    WmiPositionMarker wmiPositionMarker = wmiMathDocumentView.getPositionMarker();
                    n4 = this.getZoomFactor();
                    if (wmiPositionMarker != null && wmiPositionMarker.getView() == this && wmiMathDocumentView.getSelection() == null) {
                        graphics2D.setStroke(n4 > 250 ? ZOOM_MARKER_STROKE : MARKER_STROKE);
                    } else if (WmiFractionView.this.lineStroke != null) {
                        graphics2D.setStroke(WmiFractionView.this.lineStroke);
                    } else {
                        graphics2D.setStroke(n4 > 250 ? ZOOM_STROKE : (this.getDocumentView().isPrintView() ? DEFAULT_PRINT_STROKE : DEFAULT_STROKE));
                    }
                }
                if ((n3 = this.getWidth() - 4) == 0) {
                    n3 = (int)((float)(5 * wmiMathDocumentView.getZoomFactor()) / 100.0f);
                }
                if (this.bevelled) {
                    graphics.drawLine(n, n2 + this.getHeight(), n + n3, n2);
                } else {
                    graphics.drawLine(n, n2, n + n3, n2);
                }
                if (rectangleArray != null) {
                    graphics.setColor(this.getDocumentView().getColor(3));
                    for (n4 = 0; n4 < rectangleArray.length; ++n4) {
                        Rectangle rectangle2 = graphics.getClipBounds();
                        graphics.clipRect(rectangleArray[n4].x - wmiRenderPath.getHorizontalShift(), rectangleArray[n4].y - wmiRenderPath.getVerticalShift(), rectangleArray[n4].width, rectangleArray[n4].height);
                        if (this.bevelled) {
                            graphics.drawLine(n, n2 + this.getHeight(), n + n3, n2);
                        } else {
                            graphics.drawLine(n, n2, n + n3, n2);
                        }
                        graphics.setClip(rectangle2);
                    }
                }
                if (graphics2D != null) {
                    graphics2D.setStroke(stroke);
                }
            }
            graphics.setColor(color);
        }

        public void setPositionMarker(int n) {
            WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
            if (wmiMathDocumentView != null) {
                FractionBarMarker fractionBarMarker = new FractionBarMarker(this);
                wmiMathDocumentView.setPositionMarker(fractionBarMarker);
                wmiMathDocumentView.notifyMarkerPositionChanged();
                fractionBarMarker.show();
            } else {
                WmiErrorLog.log(new Exception("unable to find document view"));
            }
        }

        public boolean isNavagableView() {
            return false;
        }

        public int doImplicitLinebreak(WmiParagraphView wmiParagraphView, int n, int n2, int n3) throws WmiNoReadAccessException {
            int n4 = 0;
            if (n + this.getWidth() < n2) {
                WmiCompositeView wmiCompositeView = this.getParentView();
                int n5 = wmiCompositeView.indexOf(this);
                if (n5 >= 0) {
                    wmiParagraphView.split(wmiCompositeView, n5 + 1, 0);
                    n4 = 2;
                }
            } else if (n3 > 0) {
                n4 = super.doImplicitLinebreak(wmiParagraphView, n, n2, n3);
            }
            return n4;
        }
    }

    private static class WmiRightAlignment
    implements WmiAlignCalculation {
        private WmiRightAlignment() {
        }

        public int calculateHOffset(int n, int n2) {
            return n - n2;
        }
    }

    private static class WmiLeftAlignment
    implements WmiAlignCalculation {
        private WmiLeftAlignment() {
        }

        public int calculateHOffset(int n, int n2) {
            return 0;
        }
    }

    private static class WmiCenterAlignment
    implements WmiAlignCalculation {
        private WmiCenterAlignment() {
        }

        public int calculateHOffset(int n, int n2) {
            return (n - n2) / 2;
        }
    }

    private static interface WmiAlignCalculation {
        public int calculateHOffset(int var1, int var2);
    }
}

