/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathGlyphModel;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.math.WmiMathTextView;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class WmiMathGlyphView
extends WmiMathTextView {
    public static int DEFAULT_FONT_SIZE = 12;
    private static int FONT_MISSING_COLOR = 0xFF0000;
    private String fontName;
    private int index;
    private GlyphVector v;
    private WmiMathGlyphModel.WmiMathGlyphAttributeSet attrs;
    private WmiTextLayout layout = null;

    public WmiMathGlyphView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        Color color = graphics.getColor();
        if (this.v != null) {
            Color color2 = new Color(this.attrs.getForeground());
            graphics.setColor(color2);
            ((Graphics2D)graphics).drawGlyphVector(this.v, wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset(), wmiRenderPath.getVerticalOffset() + this.getVerticalOffset() + this.baseline);
        } else {
            super.draw(graphics, wmiRenderPath, rectangle);
        }
        graphics.setColor(color);
    }

    public void layoutView() throws WmiNoReadAccessException {
        super.layoutView();
        try {
            this.attrs = (WmiMathGlyphModel.WmiMathGlyphAttributeSet)this.getModel().getAttributesForRead();
            this.fontName = this.attrs.getFontFamily();
            this.index = this.attrs.getIndex();
            Font font = new Font(this.fontName, 0, this.getDocumentView().getZoomFactor() * DEFAULT_FONT_SIZE / 100);
            int n = font.getNumGlyphs();
            if (!this.fontName.equals("") && this.index >= 0 && this.index < n) {
                FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, false);
                int[] nArray = new int[]{this.index};
                this.v = font.createGlyphVector(fontRenderContext, nArray);
                GlyphMetrics glyphMetrics = this.v.getGlyphMetrics(0);
                Rectangle2D rectangle2D = glyphMetrics.getBounds2D();
                this.width = (int)Math.round(rectangle2D.getWidth()) + 2;
                this.width += (int)Math.floor(rectangle2D.getMinX() + rectangle2D.getWidth() + rectangle2D.getMinX() - (double)glyphMetrics.getAdvance());
                this.height = (int)Math.round(rectangle2D.getHeight());
            } else {
                String string = this.attrs.getAlt();
                boolean bl = WmiModelUtil.findAncestorOfTag(this.getModel(), WmiModelTag.MATH) != null;
                this.layout = WmiTextLayout.createTextLayout(string, font, this.getDocumentView(), bl);
                WmiFontAttributeSet wmiFontAttributeSet = (WmiFontAttributeSet)this.attrs.copyAttributes();
                wmiFontAttributeSet.setForeground(FONT_MISSING_COLOR);
                this.setLayout(this.layout, wmiFontAttributeSet, 0);
                this.width = this.layout.getWidth();
                this.baseline = this.layout.getBaseline();
                this.height = this.layout.getHeight();
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    public void applyKerningAdjustment(boolean bl, boolean bl2) {
        if (this.v != null) {
            GlyphMetrics glyphMetrics = this.v.getGlyphMetrics(0);
            this.width = (int)((float)this.width + glyphMetrics.getAdvanceX());
        }
    }
}

