/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiNonSplitableInlineView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiRenderPath;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathTableCellView;
import com.maplesoft.mathdoc.view.math.WmiMathTableLabeledRowView;
import com.maplesoft.mathdoc.view.math.WmiMathTableView;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;

public class WmiMathTableRowView
extends WmiNonSplitableInlineView {
    private Integer rowAlignment = WmiMathTableView.ALIGN_STYLE_UNSET;
    private ArrayList columnAlignments = new ArrayList();
    private ArrayList alignGroupAlignments = new ArrayList();
    private int maxHeight = 0;
    private int cellMaxBaseline = 0;
    private boolean isLabelRow = false;
    static /* synthetic */ Class class$com$maplesoft$mathdoc$view$WmiTextView;

    public WmiMathTableRowView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView) {
        super(wmiModel, wmiMathDocumentView);
    }

    public boolean isLabelRow() {
        return this.isLabelRow;
    }

    public void setLabelRow(boolean bl) {
        this.isLabelRow = bl;
    }

    private WmiMathTableView getTableView() {
        WmiCompositeView wmiCompositeView = this.getParentView();
        return wmiCompositeView instanceof WmiMathTableView ? (WmiMathTableView)wmiCompositeView : null;
    }

    protected void initializeView(WmiCompositeModel wmiCompositeModel) throws WmiNoReadAccessException {
        super.initializeView(wmiCompositeModel);
        WmiMathTableModel wmiMathTableModel = (WmiMathTableModel)wmiCompositeModel.getParent();
        WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet = (WmiMathTableModel.WmiMathTableAttributeSet)wmiMathTableModel.getAttributesForRead();
        if (wmiCompositeModel.getTag() == WmiModelTag.MATH_TABLE_ROW && wmiMathTableAttributeSet.getSide().startsWith("left")) {
            WmiView[] wmiViewArray = new WmiView[this.getChildCount() + 1];
            System.arraycopy(this.children, 0, wmiViewArray, 1, this.getChildCount());
            WmiMathDocumentModel wmiMathDocumentModel = wmiCompositeModel.getDocument();
            WmiTextModel wmiTextModel = new WmiTextModel(wmiMathDocumentModel);
            WmiMathTableModel.WmiMathTableDataModel wmiMathTableDataModel = new WmiMathTableModel.WmiMathTableDataModel(wmiMathDocumentModel, wmiTextModel);
            WmiMathTableCellView wmiMathTableCellView = new WmiMathTableCellView(wmiMathTableDataModel, this.getDocumentView());
            wmiMathTableCellView.updateView();
            wmiMathTableCellView.setParentView(this);
            wmiViewArray[0] = wmiMathTableCellView;
            ++this.length;
            this.children = wmiViewArray;
        }
    }

    public void layoutView() throws WmiNoReadAccessException {
        if (!this.isLayoutValid()) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            WmiMathTableView wmiMathTableView = this.getTableView();
            int n7 = this.getChildCount();
            this.maxHeight = 0;
            boolean bl = wmiMathTableView.isMatrix() && wmiMathTableView.cellLinebroken;
            this.width = 0;
            if (bl) {
                for (int i = 0; i < n7; ++i) {
                    WmiMathTableCellView wmiMathTableCellView = (WmiMathTableCellView)this.getChild(i);
                    this.width += wmiMathTableCellView.getWidth() + wmiMathTableView.getColumnSpacing(i);
                    this.maxHeight = this.maxHeight > wmiMathTableCellView.getHeight() ? this.maxHeight : wmiMathTableCellView.getHeight();
                }
                this.height = this.maxHeight;
            }
            WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet wmiMathTableRowAttributeSet = (WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet)this.getModel().getAttributesForRead();
            this.getRowAlignment(wmiMathTableRowAttributeSet);
            this.getColumnAlignment(wmiMathTableRowAttributeSet);
            this.cellMaxBaseline = 0;
            for (n6 = 0; n6 < n7; ++n6) {
                int n8;
                WmiMathTableCellView wmiMathTableCellView = (WmiMathTableCellView)this.getChild(n6);
                if (((WmiMathTableModel)wmiMathTableView.getModel()).containsAlignmentElement()) {
                    wmiMathTableCellView.invalidate(1);
                    wmiMathTableCellView.layoutView(false, true);
                }
                if (wmiMathTableCellView.getChildCount() > 0 && (n8 = ((WmiPositionedView)wmiMathTableCellView.getChild(0)).getBaseline()) > this.cellMaxBaseline) {
                    this.cellMaxBaseline = n8;
                }
                this.maxHeight = this.maxHeight > wmiMathTableCellView.getHeight() ? this.maxHeight : wmiMathTableCellView.getHeight();
            }
            n6 = 0;
            for (n5 = 0; n5 < n7; ++n5) {
                Integer n9;
                WmiMathTableCellView wmiMathTableCellView = (WmiMathTableCellView)this.getChild(n5);
                n4 = wmiMathTableCellView.getColumnSpan();
                n3 = wmiMathTableCellView.getRowIndex();
                n2 = wmiMathTableCellView.getColumnIndex();
                n = wmiMathTableCellView.getWidth();
                int n10 = 0;
                int n11 = Integer.MAX_VALUE;
                if (wmiMathTableView != null) {
                    int n12;
                    for (n12 = 0; n12 < n2; ++n12) {
                        n10 += wmiMathTableView.getMaximumColumnWidth(n12) + wmiMathTableView.getColumnSpacing(n12);
                    }
                    if (this instanceof WmiMathTableLabeledRowView && n2 == this.getChildCount() - 1) {
                        n10 = 0;
                        for (n12 = 0; n12 < wmiMathTableView.getMaxNumberOfColumns(); ++n12) {
                            n10 += wmiMathTableView.getMaximumColumnWidth(n12) + wmiMathTableView.getColumnSpacing(n12);
                        }
                    }
                    n11 = wmiMathTableView.getMaximumColumnWidth(n2);
                    for (n12 = n2 + 1; n12 < n2 + n4; ++n12) {
                        n11 += wmiMathTableView.getMaximumColumnWidth(n12) + wmiMathTableView.getColumnSpacing(n12);
                    }
                    if (n10 + n11 > n6) {
                        n6 = n10 + n11;
                    }
                } else {
                    n6 = Integer.MAX_VALUE;
                }
                if ((n9 = wmiMathTableCellView.getHorizontalAlignment()).equals(WmiMathTableView.ALIGN_STYLE_UNSET)) {
                    n9 = this.getColumnAlignment(n5);
                }
                if (n9.equals(WmiMathTableView.ALIGN_STYLE_UNSET) && wmiMathTableView != null) {
                    n9 = wmiMathTableView.getColumnAlignment(n2);
                }
                if (n9.equals(WmiMathTableView.ALIGN_STYLE_UNSET)) {
                    n9 = WmiMathTableView.ALIGN_STYLE_CENTER;
                }
                int n13 = n10;
                if (n9.equals(WmiMathTableView.ALIGN_STYLE_CENTER)) {
                    if (n < n11) {
                        n13 += (n11 - n) / 2;
                    }
                } else if (n9.equals(WmiMathTableView.ALIGN_STYLE_RIGHT) && n < n11) {
                    n13 += n11 - n;
                }
                wmiMathTableCellView.setHorizontalOffset(n13);
            }
            for (n5 = 0; n5 < n7; ++n5) {
                Integer n14;
                WmiMathTableCellView wmiMathTableCellView = (WmiMathTableCellView)this.getChild(n5);
                n4 = wmiMathTableCellView.getRowIndex();
                n3 = wmiMathTableCellView.getRowSpan();
                n2 = 0;
                n = Integer.MAX_VALUE;
                if (wmiMathTableView != null) {
                    n = wmiMathTableView.getMaximumRowHeight(n4);
                    if (n > this.maxHeight) {
                        this.maxHeight = n;
                    }
                    if (n3 > 1) {
                        for (int i = n4 + 1; i < n4 + n3; ++i) {
                            n += wmiMathTableView.getMaximumRowHeight(i) + wmiMathTableView.getRowSpacing(i);
                        }
                    }
                } else {
                    this.maxHeight = Integer.MAX_VALUE;
                }
                if ((n14 = wmiMathTableCellView.getVerticalAlignment()).equals(WmiMathTableView.ALIGN_STYLE_UNSET)) {
                    n14 = this.rowAlignment;
                }
                if (n14.equals(WmiMathTableView.ALIGN_STYLE_UNSET) && wmiMathTableView != null) {
                    n14 = wmiMathTableView.getRowAlignment(n4);
                }
                if (n14.equals(WmiMathTableView.ALIGN_STYLE_UNSET)) {
                    n14 = WmiMathTableView.ALIGN_STYLE_CENTER;
                }
                if (n14.equals(WmiMathTableView.ALIGN_STYLE_TOP)) {
                    WmiTextView wmiTextView = (WmiTextView)WmiViewUtil.findFirstDescendantOfClass(wmiMathTableCellView, class$com$maplesoft$mathdoc$view$WmiTextView == null ? WmiMathTableRowView.class$("com.maplesoft.mathdoc.view.WmiTextView") : class$com$maplesoft$mathdoc$view$WmiTextView);
                    if (wmiTextView != null) {
                        n2 = wmiTextView.computeSpaceAbove() * -1;
                        if (n4 == 0) {
                            n2 += wmiMathTableView.getFrameSpacing(1);
                        }
                    }
                } else if (n14.equals(WmiMathTableView.ALIGN_STYLE_BOTTOM)) {
                    n2 = this.maxHeight - wmiMathTableCellView.getHeight();
                } else if (n14.equals(WmiMathTableView.ALIGN_STYLE_CENTER)) {
                    n2 = (this.maxHeight - wmiMathTableCellView.getHeight()) / 2;
                } else if (n14.equals(WmiMathTableView.ALIGN_STYLE_AXIS)) {
                    n2 = (this.maxHeight - wmiMathTableCellView.getHeight()) / 2;
                }
                wmiMathTableCellView.setVerticalOffset(n2);
            }
            this.addNavigationLinks();
            if (!bl) {
                this.height = this.maxHeight;
                this.width = n6;
            }
            this.markValid(1);
            this.checkRepaint();
        }
    }

    public void adjustVerticalLayout() throws WmiNoReadAccessException {
    }

    public void draw(Graphics graphics, WmiRenderPath wmiRenderPath, Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        WmiMathTableView wmiMathTableView = this.getTableView();
        int n4 = wmiMathTableView.indexOf(this);
        if (wmiMathTableView != null && !wmiMathTableView.cellLinebroken && this.isLabelRow()) {
            return;
        }
        boolean bl = false;
        int n5 = this.getChildCount();
        if (wmiMathTableView != null && wmiMathTableView.containsLabeledRow()) {
            if (wmiMathTableView.getSide() == WmiMathTableView.RIGHT_SIDE || wmiMathTableView.getSide() == WmiMathTableView.RIGHT_OVERLAP_SIDE) {
                n5 = this instanceof WmiMathTableLabeledRowView ? (n5 -= 2) : --n5;
            } else {
                bl = true;
            }
        }
        if (wmiMathTableView != null) {
            for (int i = 0; i < n5; ++i) {
                int n6;
                int n7;
                int n8;
                Integer n9 = wmiMathTableView.getColumnLineStyle(i);
                if (n9 == WmiMathTableView.LINE_STYLE_NONE || (n8 = wmiMathTableView.getColumnIndex(n4, i)) == wmiMathTableView.getMaxNumberOfColumns() - 1) continue;
                WmiMathTableCellView wmiMathTableCellView = (WmiMathTableCellView)this.getChild(i);
                n3 = wmiMathTableCellView.getColumnSpan();
                if (n3 > 1) {
                    n7 = n8;
                    int n10 = n8 + n3 < wmiMathTableView.getMaxNumberOfColumns() ? n8 + n3 : wmiMathTableView.getMaxNumberOfColumns();
                    for (n6 = n7; n6 < n10; ++n6) {
                        if (n6 > 0) {
                            n += wmiMathTableView.getColumnSpacing(i) / 2;
                        }
                        n2 += wmiMathTableView.getMaximumColumnWidth(n6);
                        if (n6 >= wmiMathTableView.getMaxNumberOfColumns()) continue;
                        n += wmiMathTableView.getColumnSpacing(i + 1) / 2;
                    }
                } else {
                    n2 = 0;
                    n = 0;
                    for (n7 = 0; n7 <= n8; ++n7) {
                        n2 += wmiMathTableView.getMaximumColumnWidth(n7);
                        n += wmiMathTableView.getColumnSpacing(n7);
                    }
                    n -= wmiMathTableView.getColumnSpacing(n8) / 2;
                }
                n7 = wmiRenderPath.getHorizontalOffset() + this.getHorizontalOffset() + n + n2;
                Stroke stroke = graphics2D.getStroke();
                if (n9 == WmiMathTableView.LINE_STYLE_DASHED) {
                    float[] fArray = new float[]{1.5f};
                    graphics2D.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, fArray, 1.0f));
                }
                n6 = 0;
                int n11 = 0;
                int n12 = 0;
                if (wmiMathTableView.indexOf(this) == 0) {
                    n6 = wmiRenderPath.getVerticalOffset() + wmiMathTableView.getFrameSpacing(1);
                    if (wmiMathTableView.getChildCount() > 1) {
                        n12 = wmiMathTableView.getRowSpacing(wmiMathTableView.indexOf(this)) / 2;
                        n11 = wmiMathTableView.getFrameSpacing(1);
                    } else {
                        n11 = wmiMathTableView.getFrameSpacing(1) * 2;
                    }
                } else if (wmiMathTableView.indexOf(this) == wmiMathTableView.getChildCount() - 1) {
                    n12 = wmiMathTableView.getRowSpacing(wmiMathTableView.indexOf(this) - 1) / 2;
                    n6 = wmiRenderPath.getVerticalOffset() + this.getVerticalOffset() - n12;
                    n11 = wmiMathTableView.getFrameSpacing(1) * -1;
                } else {
                    n12 = wmiMathTableView.getRowSpacing(wmiMathTableView.indexOf(this));
                    if (wmiMathTableView.containsLabeledRow() && !wmiMathTableView.drawOverlappedLabel() && !this.isLabelRow() && wmiMathTableView.indexOf(this) == 1) {
                        n6 = wmiRenderPath.getVerticalOffset();
                        n11 = wmiMathTableView.getFrameSpacing(1) * 2;
                    } else {
                        n6 = wmiRenderPath.getVerticalOffset() + this.getVerticalOffset() - (n12 / 2 + 1);
                        n11 = 0;
                    }
                }
                int n13 = 0;
                int n14 = wmiMathTableCellView.getRowSpan();
                if (n14 > 1) {
                    for (int j = 0; j < n14; ++j) {
                        n13 += wmiMathTableView.getMaximumRowHeight(n4 + j);
                        if (n4 + j >= wmiMathTableView.getNumberOfRows() - 1) continue;
                        n13 += wmiMathTableView.getRowSpacing(n4 + j);
                    }
                } else {
                    n13 = this.getHeight();
                }
                if (!(i + n3 >= wmiMathTableView.getMaxNumberOfColumns() || wmiMathTableView.getCellWidth(n4, n8) == 0 || i == 0 && bl || this.isLabelRow)) {
                    graphics2D.drawLine(n7, n6, n7, n6 + n13 + n12 + n11);
                }
                graphics2D.setStroke(stroke);
            }
        }
        super.draw(graphics, wmiRenderPath, rectangle);
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int n) {
        this.maxHeight = n;
    }

    public int getMaxBaseline() {
        return this.cellMaxBaseline;
    }

    private void getRowAlignment(WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet wmiMathTableRowAttributeSet) {
        String string;
        String string2 = string = wmiMathTableRowAttributeSet.getRowAlign() != null ? wmiMathTableRowAttributeSet.getRowAlign() : "";
        this.rowAlignment = string.equals("top") ? WmiMathTableView.ALIGN_STYLE_TOP : (string.equals("bottom") ? WmiMathTableView.ALIGN_STYLE_BOTTOM : (string.equals("center") || string.equals("baseline") ? WmiMathTableView.ALIGN_STYLE_CENTER : (string.equals("axis") ? WmiMathTableView.ALIGN_STYLE_AXIS : WmiMathTableView.ALIGN_STYLE_UNSET)));
    }

    private void getColumnAlignment(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) {
        String string = wmiMathTableAttributeSet.getColumnAlign() != null ? wmiMathTableAttributeSet.getColumnAlign() : "";
        String[] stringArray = string.split(" ");
        Integer n = WmiMathTableView.ALIGN_STYLE_UNSET;
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (i < stringArray.length) {
                if (stringArray[i].equals("left")) {
                    this.columnAlignments.add(i, WmiMathTableView.ALIGN_STYLE_LEFT);
                } else if (stringArray[i].equals("right")) {
                    this.columnAlignments.add(i, WmiMathTableView.ALIGN_STYLE_RIGHT);
                } else if (stringArray[i].equals("center")) {
                    this.columnAlignments.add(i, WmiMathTableView.ALIGN_STYLE_CENTER);
                } else {
                    this.columnAlignments.add(i, WmiMathTableView.ALIGN_STYLE_UNSET);
                }
                n = (Integer)this.columnAlignments.get(i);
                continue;
            }
            this.columnAlignments.add(n);
        }
    }

    public void getAlignGroupAlignments(WmiMathTableModel.WmiMathTableAttributeSet wmiMathTableAttributeSet) {
        String string = wmiMathTableAttributeSet.getGroupAlign() != null ? wmiMathTableAttributeSet.getGroupAlign() : "";
        String[] stringArray = string.split("[\\{\\}]");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().equals("")) continue;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            String[] stringArray2 = stringArray[i].split(" ");
            for (int j = 0; j < stringArray2.length; ++j) {
                if (stringArray2[j].equals("left")) {
                    arrayList.add(WmiMathTableView.ALIGN_STYLE_LEFT);
                    continue;
                }
                if (stringArray2[j].equals("right")) {
                    arrayList.add(WmiMathTableView.ALIGN_STYLE_RIGHT);
                    continue;
                }
                if (stringArray2[j].equals("center")) {
                    arrayList.add(WmiMathTableView.ALIGN_STYLE_CENTER);
                    continue;
                }
                arrayList.add(WmiMathTableView.ALIGN_STYLE_DECIMALPOINT);
            }
            this.alignGroupAlignments.add(arrayList);
        }
    }

    public ArrayList getAlignGroupAlignments(int n) {
        return n < this.alignGroupAlignments.size() ? this.alignGroupAlignments.get(n) : null;
    }

    public Integer getColumnAlignment(int n) {
        return (Integer)this.columnAlignments.get(n);
    }

    public void addNavigationLinks() {
        WmiMathTableCellView wmiMathTableCellView;
        int n = this.getChildCount();
        if (n > 0) {
            WmiMathTableCellView wmiMathTableCellView2 = (WmiMathTableCellView)this.getChild(0);
            wmiMathTableCellView2.setNextView(null, 2);
            wmiMathTableCellView = (WmiMathTableCellView)this.getChild(n - 1);
            wmiMathTableCellView.setNextView(null, 3);
        }
        for (int i = 0; i < n - 1; ++i) {
            wmiMathTableCellView = (WmiMathTableCellView)this.getChild(i);
            WmiMathTableCellView wmiMathTableCellView3 = (WmiMathTableCellView)this.getChild(i + 1);
            wmiMathTableCellView.setNextView(wmiMathTableCellView3, 3);
            wmiMathTableCellView3.setNextView(wmiMathTableCellView, 2);
        }
    }
}

