/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.font.WmiTextLayout;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.view.WmiCaret;
import com.maplesoft.mathdoc.view.WmiCompositeView;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiParagraphView;
import com.maplesoft.mathdoc.view.WmiPositionedView;
import com.maplesoft.mathdoc.view.WmiScrollableContainerView;
import com.maplesoft.mathdoc.view.WmiTextFragmentView;
import com.maplesoft.mathdoc.view.WmiTextView;
import com.maplesoft.mathdoc.view.WmiView;
import com.maplesoft.mathdoc.view.WmiViewUtil;
import com.maplesoft.mathdoc.view.math.WmiMathCaret;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import java.awt.Point;

public class WmiMathTextFragmentView
extends WmiTextFragmentView {
    public WmiMathTextFragmentView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView, int n, int n2) throws WmiNoReadAccessException {
        super(wmiModel, wmiMathDocumentView, n, n2);
    }

    public WmiMathTextFragmentView(WmiModel wmiModel, WmiMathDocumentView wmiMathDocumentView, int n) throws WmiNoReadAccessException {
        super(wmiModel, wmiMathDocumentView, n);
    }

    public WmiMathTextFragmentView(WmiTextView wmiTextView, WmiMathDocumentView wmiMathDocumentView) throws WmiNoReadAccessException {
        super(wmiTextView, wmiMathDocumentView);
    }

    public void setPositionMarker(int n) {
        try {
            WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
            if (wmiMathDocumentView != null) {
                int[] nArray;
                WmiCaret wmiCaret = wmiMathDocumentView.getCaret();
                boolean bl = false;
                if (!(wmiCaret instanceof WmiMathCaret)) {
                    wmiCaret = new WmiMathCaret(wmiMathDocumentView);
                    bl = true;
                }
                WmiScrollableContainerView wmiScrollableContainerView = WmiViewUtil.findEnclosingContainer(this);
                int[] nArray2 = super.getCaretBounds(wmiScrollableContainerView, n);
                if (wmiCaret instanceof WmiMathCaret) {
                    ((WmiMathCaret)wmiCaret).setUprightPosition(nArray2[0], nArray2[2]);
                }
                int n2 = (nArray = this.getCaretBounds(wmiScrollableContainerView, n))[2] > nArray2[2] ? nArray[2] : nArray2[2];
                nArray[2] = n2;
                wmiCaret.updateCaretBounds(wmiScrollableContainerView, nArray[0], nArray[1], nArray[2], nArray[3]);
                wmiCaret.updateView(this, n);
                if (bl) {
                    wmiMathDocumentView.setPositionMarker(wmiCaret);
                }
                wmiCaret.show();
            } else {
                WmiErrorLog.log(new Exception("unable to find document view"));
            }
        }
        catch (WmiNoReadAccessException wmiNoReadAccessException) {
            WmiErrorLog.log(wmiNoReadAccessException);
        }
    }

    public int getCorrectedZoomFactor() throws WmiNoReadAccessException {
        int n = this.getZoomFactor();
        boolean bl = false;
        WmiModel wmiModel = this.getModel();
        WmiCompositeModel wmiCompositeModel = wmiModel.getParent();
        while (wmiCompositeModel instanceof WmiMathModel) {
            bl = ((WmiMathModel)((Object)wmiCompositeModel)).useScriptSize(wmiModel);
            if (bl) {
                n = Math.round((float)n * 0.8f);
                break;
            }
            wmiModel = wmiCompositeModel;
            wmiCompositeModel = wmiModel.getParent();
        }
        return n;
    }

    public int doForcedLinebreak(WmiParagraphView wmiParagraphView, int n, int n2) throws WmiNoReadAccessException {
        boolean bl = false;
        WmiMathDocumentView wmiMathDocumentView = this.getDocumentView();
        WmiMathDocumentModel wmiMathDocumentModel = (WmiMathDocumentModel)wmiMathDocumentView.getModel();
        WmiMathTokenModel wmiMathTokenModel = WmiMathFactory.createMathOperatorToken(wmiMathDocumentModel, "\\", this.getContext());
        WmiMathOperatorView wmiMathOperatorView = new WmiMathOperatorView(wmiMathTokenModel, wmiMathDocumentView);
        wmiMathOperatorView.layoutView();
        int n3 = n2 - n - wmiMathOperatorView.getWidth();
        Point point = new Point(n3, 0);
        int n4 = this.getOffset(point);
        if (n4 > 0) {
            int n5;
            bl = true;
            WmiTextView[] wmiTextViewArray = WmiMathTextFragmentView.splitMathTextView(this, n4, 0);
            WmiCompositeView wmiCompositeView = this.getParentView();
            int n6 = n5 = wmiCompositeView != null ? wmiCompositeView.indexOf(this) : -1;
            if (n5 >= 0) {
                wmiCompositeView.replaceChild(wmiTextViewArray[0], n5);
                wmiTextViewArray[0].setParentView(wmiCompositeView);
                wmiCompositeView.insertView(wmiMathOperatorView, n5 + 1);
                wmiCompositeView.insertView(wmiTextViewArray[1], n5 + 2);
                wmiCompositeView.markInvalid(1);
                ((WmiPositionedView)((Object)wmiCompositeView)).layoutView();
                wmiParagraphView.split(wmiCompositeView, n5 + 2, 0);
                bl = true;
                this.release();
            }
        }
        return bl ? 2 : 0;
    }

    private WmiMathContext getContext() throws WmiNoReadAccessException {
        WmiAttributeSet wmiAttributeSet;
        WmiMathContext wmiMathContext = null;
        WmiView wmiView = WmiViewUtil.findAncestorOfTag(this, WmiModelTag.MATH);
        if (wmiView != null && wmiView.getModel() instanceof WmiMathWrapperModel && (wmiAttributeSet = wmiView.getModel().getAttributesForRead()) instanceof WmiFontAttributeSet) {
            wmiMathContext = new WmiMathContext((WmiFontAttributeSet)wmiAttributeSet);
        }
        if (wmiMathContext == null) {
            wmiMathContext = new WmiMathContext(null);
        }
        return wmiMathContext;
    }

    public static WmiTextView[] splitMathTextView(WmiTextView wmiTextView, int n, int n2) throws WmiNoReadAccessException {
        WmiTextLayout wmiTextLayout;
        WmiMathDocumentView wmiMathDocumentView = wmiTextView.getDocumentView();
        WmiMathTextFragmentView wmiMathTextFragmentView = new WmiMathTextFragmentView(wmiTextView, wmiMathDocumentView);
        WmiMathTextFragmentView wmiMathTextFragmentView2 = wmiMathTextFragmentView.splitFragmentView(n, n2);
        WmiTextLayout wmiTextLayout2 = wmiTextLayout = wmiMathTextFragmentView2 != null ? wmiMathTextFragmentView2.getLayout() : null;
        if (wmiTextLayout != null && wmiTextLayout.getWidth() == 0) {
            wmiMathTextFragmentView2.layout = null;
        }
        WmiTextView[] wmiTextViewArray = new WmiTextView[]{wmiMathTextFragmentView, wmiMathTextFragmentView2};
        wmiMathTextFragmentView.markInvalid(1);
        wmiMathTextFragmentView2.markInvalid(1);
        return wmiTextViewArray;
    }

    private WmiMathTextFragmentView splitFragmentView(int n, int n2) throws WmiNoReadAccessException {
        WmiMathTextFragmentView wmiMathTextFragmentView = new WmiMathTextFragmentView(this, this.getDocumentView());
        wmiMathTextFragmentView.layout = this.layout != null ? this.layout.splitLayout(n, n2) : null;
        this.endOffset = this.startOffset + n - 1;
        wmiMathTextFragmentView.startOffset = this.endOffset + n2 + 1;
        wmiMathTextFragmentView.markInvalid(1);
        this.markInvalid(1);
        return wmiMathTextFragmentView;
    }
}

