/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.view.math.renderers;

import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import com.maplesoft.mathdoc.view.math.renderers.WmiGlyphRenderer;
import java.awt.Font;

public abstract class WmiSquareBracketRenderer
extends WmiGlyphRenderer {
    private static final float[][] LEFT_SQUARE_OUTLINE = new float[][]{{0.20000002f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}, {0.20000002f, 0.0f}, {0.20000002f, 0.03608248f}, {0.061855674f, 0.03608248f}, {0.061855674f, 0.96391755f}, {0.20000002f, 0.96391755f}, new float[0]};
    private static final int[] LEFT_SQUARE_MORPH_RULES = new int[]{3, 3, 1, 1, 1, 1, 3, 3, 0};
    private static final float[][] DOUBLE_LEFT_OUTLINE = new float[][]{{0.35876292f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}, {0.35876292f, 0.0f}, {0.35876292f, 0.03608248f}, {0.22061855f, 0.03608248f}, {0.22061855f, 0.96391755f}, {0.35876292f, 0.96391755f}, new float[0], {0.1670103f, 0.96391755f}, {0.1670103f, 0.03608248f}, {0.053608246f, 0.03608248f}, {0.053608246f, 0.96391755f}, new float[0]};
    private static final int[] DOUBLE_LEFT_MORPH_RULES = new int[]{3, 3, 1, 1, 1, 1, 3, 3, 0, 3, 1, 1, 3, 0};
    private static final float[][] LEFT_FLOOR_OUTLINE = new float[][]{{0.20000002f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}, {0.061855674f, 0.0f}, {0.061855674f, 0.96391755f}, {0.20000002f, 0.96391755f}, new float[0]};
    private static final int[] LEFT_FLOOR_MORPH_RULES = new int[]{3, 3, 1, 1, 3, 3, 0};
    private static final float[][] LEFT_CEILING_OUTLINE = new float[][]{{0.20000002f, 0.03608248f}, {0.061855674f, 0.03608248f}, {0.061855674f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}, {0.20000002f, 0.0f}, new float[0]};
    private static final int[] LEFT_CEILING_MORPH_RULES = new int[]{1, 1, 3, 3, 1, 1, 0};
    private static final float[][] SINGLE_VERTICAL_BAR_OUTLINE = new float[][]{{0.053608254f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}, {0.053608254f, 0.0f}, new float[0]};
    private static final int[] SINGLE_VERTICAL_BAR_MORPH_RULES = new int[]{3, 3, 1, 1, 0};
    private static final float[][] DOUBLE_VERTICAL_BAR_OUTLINE = new float[][]{{0.2613169f, 0.9979423f}, {0.20781894f, 0.9979423f}, {0.20781894f, 0.0f}, {0.2613169f, 0.0f}, new float[0], {0.05349794f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}, {0.05349794f, 0.0f}, new float[0]};
    private static final int[] DOUBLE_VERTICAL_BAR_MORPH_RULES = new int[]{3, 3, 1, 1, 0, 3, 3, 1, 1, 0};
    private static final float[][] TRIPLE_VERTICAL_BAR_OUTLINE = new float[][]{{0.46804124f, 1.0f}, {0.41443303f, 1.0f}, {0.41443303f, 0.0f}, {0.46804124f, 0.0f}, new float[0], {0.26082474f, 1.0f}, {0.20721652f, 1.0f}, {0.20721652f, 0.0f}, {0.26082474f, 0.0f}, new float[0], {0.053608246f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}, {0.053608246f, 0.0f}, new float[0]};
    private static final int[] TRIPLE_VERTICAL_BAR_MORPH_RULES = new int[]{3, 3, 1, 1, 0, 3, 3, 1, 1, 0, 3, 3, 1, 1, 0};
    private static final float DOUBLE_BRACKET_SHIFT_FACTOR = 0.2f;

    protected boolean isRightBracket() {
        return false;
    }

    protected boolean isBracket() {
        return true;
    }

    protected void morphGlyph(float[][] fArray, Font font, int n) {
        this.stretchScale(fArray, font.getSize2D(), n, this.getStretchRules());
        if (this.isRightBracket()) {
            this.rotate180(fArray);
        }
    }

    public boolean forcePreKernAdjustment(WmiMathOperatorView wmiMathOperatorView) {
        return this.isRightBracket();
    }

    public boolean forcePostKernAdjustment(WmiMathOperatorView wmiMathOperatorView) {
        return !this.isRightBracket();
    }

    public static class WmiTripleVerticalBarRenderer
    extends WmiSquareBracketRenderer {
        protected float[][] getGlyphOutline() {
            return TRIPLE_VERTICAL_BAR_OUTLINE;
        }

        protected int[] getStretchRules() {
            return TRIPLE_VERTICAL_BAR_MORPH_RULES;
        }

        public boolean forcePreKernAdjustment(WmiMathOperatorView wmiMathOperatorView) {
            return true;
        }

        public boolean forcePostKernAdjustment(WmiMathOperatorView wmiMathOperatorView) {
            return true;
        }
    }

    public static class WmiDoubleVerticalBarRenderer
    extends WmiSquareBracketRenderer {
        protected float[][] getGlyphOutline() {
            return DOUBLE_VERTICAL_BAR_OUTLINE;
        }

        protected int[] getStretchRules() {
            return DOUBLE_VERTICAL_BAR_MORPH_RULES;
        }

        public boolean forcePreKernAdjustment(WmiMathOperatorView wmiMathOperatorView) {
            return true;
        }

        public boolean forcePostKernAdjustment(WmiMathOperatorView wmiMathOperatorView) {
            return true;
        }
    }

    public static class WmiSingleVerticalBarRenderer
    extends WmiSquareBracketRenderer {
        protected float[][] getGlyphOutline() {
            return SINGLE_VERTICAL_BAR_OUTLINE;
        }

        protected int[] getStretchRules() {
            return SINGLE_VERTICAL_BAR_MORPH_RULES;
        }

        public boolean forcePreKernAdjustment(WmiMathOperatorView wmiMathOperatorView) {
            return true;
        }

        public boolean forcePostKernAdjustment(WmiMathOperatorView wmiMathOperatorView) {
            return true;
        }
    }

    public static class WmiRightFloorRenderer
    extends WmiSquareBracketRenderer {
        protected float[][] getGlyphOutline() {
            return LEFT_CEILING_OUTLINE;
        }

        protected int[] getStretchRules() {
            return LEFT_CEILING_MORPH_RULES;
        }

        protected boolean isRightBracket() {
            return true;
        }
    }

    public static class WmiLeftFloorRenderer
    extends WmiSquareBracketRenderer {
        protected float[][] getGlyphOutline() {
            return LEFT_FLOOR_OUTLINE;
        }

        protected int[] getStretchRules() {
            return LEFT_FLOOR_MORPH_RULES;
        }
    }

    public static class WmiRightCeilingRenderer
    extends WmiSquareBracketRenderer {
        protected float[][] getGlyphOutline() {
            return LEFT_FLOOR_OUTLINE;
        }

        protected int[] getStretchRules() {
            return LEFT_FLOOR_MORPH_RULES;
        }

        protected boolean isRightBracket() {
            return true;
        }
    }

    public static class WmiLeftCeilingRenderer
    extends WmiSquareBracketRenderer {
        protected float[][] getGlyphOutline() {
            return LEFT_CEILING_OUTLINE;
        }

        protected int[] getStretchRules() {
            return LEFT_CEILING_MORPH_RULES;
        }
    }

    public static class WmiDoubleRightBracketRenderer
    extends WmiSquareBracketRenderer {
        protected float[][] getGlyphOutline() {
            return DOUBLE_LEFT_OUTLINE;
        }

        protected int[] getStretchRules() {
            return DOUBLE_LEFT_MORPH_RULES;
        }

        protected boolean isRightBracket() {
            return true;
        }

        protected float getBracketShiftFactor() {
            return 0.2f;
        }
    }

    public static class WmiDoubleLeftBracketRenderer
    extends WmiSquareBracketRenderer {
        protected float[][] getGlyphOutline() {
            return DOUBLE_LEFT_OUTLINE;
        }

        protected int[] getStretchRules() {
            return DOUBLE_LEFT_MORPH_RULES;
        }

        protected float getBracketShiftFactor() {
            return 0.2f;
        }
    }

    public static class WmiRightSquareBracketRenderer
    extends WmiSquareBracketRenderer {
        protected float[][] getGlyphOutline() {
            return LEFT_SQUARE_OUTLINE;
        }

        protected int[] getStretchRules() {
            return LEFT_SQUARE_MORPH_RULES;
        }

        protected boolean isRightBracket() {
            return true;
        }
    }

    public static class WmiLeftSquareBracketRenderer
    extends WmiSquareBracketRenderer {
        protected float[][] getGlyphOutline() {
            return LEFT_SQUARE_OUTLINE;
        }

        protected int[] getStretchRules() {
            return LEFT_SQUARE_MORPH_RULES;
        }
    }
}

