/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.encoder.AbstractStringEncoder;
import com.maplesoft.util.encoder.Cp1250Encoder;
import com.maplesoft.util.encoder.Cp1251Encoder;
import com.maplesoft.util.encoder.Cp1252Encoder;
import com.maplesoft.util.encoder.Cp1253Encoder;
import com.maplesoft.util.encoder.Cp1254Encoder;
import com.maplesoft.util.encoder.Cp1256Encoder;
import com.maplesoft.util.encoder.Cp1257Encoder;
import com.maplesoft.util.encoder.Cp1258Encoder;
import com.maplesoft.util.encoder.Cp874Encoder;
import com.maplesoft.util.encoder.Cp936Encoder;
import com.maplesoft.util.encoder.Cp949Encoder;
import com.maplesoft.util.encoder.Cp950Encoder;
import com.maplesoft.util.encoder.KernelEncoder;
import com.maplesoft.util.encoder.MacCenteuroEncoder;
import com.maplesoft.util.encoder.MacChinsimpEncoder;
import com.maplesoft.util.encoder.MacChintradEncoder;
import com.maplesoft.util.encoder.MacCroatianEncoder;
import com.maplesoft.util.encoder.MacCyrillicEncoder;
import com.maplesoft.util.encoder.MacGreekEncoder;
import com.maplesoft.util.encoder.MacIcelandEncoder;
import com.maplesoft.util.encoder.MacJapaneseEncoder;
import com.maplesoft.util.encoder.MacKoreanEncoder;
import com.maplesoft.util.encoder.MacRomanEncoder;
import com.maplesoft.util.encoder.MacRomanianEncoder;
import com.maplesoft.util.encoder.MacThaiEncoder;
import com.maplesoft.util.encoder.MacTurkishEncoder;
import com.maplesoft.util.encoder.ShiftJISEncoder;
import com.maplesoft.util.encoder.UTF8Encoder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;

public class RuntimeLocale {
    public static final Locale GREEK = new Locale("el");
    public static final Locale HUNGARIAN = new Locale("hu");
    private static final String[] CP1250 = new String[]{"hrv", "ces", "hun", "pol", "ron", "slk", "slv"};
    private static final String[] CP1251 = new String[]{"bul", "rus"};
    private static final String[] CP1252 = new String[]{"cat", "dan", "nld", "eng", "fin", "fra", "deu", "ita", "nor", "por", "spa", "swe"};
    private static final String[] CP1257 = new String[]{"est", "lav", "lit"};
    private static final String CP1253 = "ell";
    private static final String CP1254 = "tur";
    private static final String CP1256 = "ara";
    private static final String CP1258 = "vie";
    private static final String CP874 = "tha";
    private static final String CHINESE = "zho";
    private static final String SHIFT_JIS = "jpn";
    private static final String CP949 = "kor";
    private static final String[] MACCENTEURO = new String[]{"ces", "est", "hun", "lav", "lit", "pol", "slk", "slv", "wen"};
    private static final String[] MACTURKISH = new String[]{"kur", "tur"};
    private static final String[] MACCYRILLIC = new String[]{"bel", "bul", "mkd", "mol", "rus", "srp", "ukr"};
    private static final String[] MACROMAN = new String[]{"sqi", "dan", "nld", "eng", "fin", "fra", "deu", "ita", "nor", "por", "spa", "swe"};
    private static final String MACCHINESE = "zho";
    private static final String MACCROATIAN = "hrv";
    private static final String MACGREEK = "ell";
    private static final String MACICELAND = "isl";
    private static final String MACJAPANESE = "jpn";
    private static final String MACKOREAN = "kor";
    private static final String MACROMANIAN = "ron";
    private static final String MACTHAI = "tha";
    private static boolean isGreek = false;
    private static boolean isJapanese = false;
    private static boolean isKorean = false;
    private static boolean isSimplifiedChinese = false;
    private static KernelEncoder kernelEncoder = null;
    private static AbstractStringEncoder exportEncoder = null;
    private static Locale encodingLocale = null;
    private static Locale displayLocale = null;
    private static Set supportedLocalizations = new HashSet();

    private static void setFlags(Locale locale) {
        isGreek = RuntimeLocale.areLocalesEqual(locale, GREEK);
        isJapanese = !isGreek && RuntimeLocale.areLocalesEqual(locale, Locale.JAPANESE);
        isKorean = !isJapanese && RuntimeLocale.areLocalesEqual(locale, Locale.KOREAN);
        isSimplifiedChinese = !isKorean && RuntimeLocale.areLocalesEqual(locale, Locale.SIMPLIFIED_CHINESE);
    }

    public static void setDisplayLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("Display locale cannot be null");
        }
        if (!RuntimeLocale.isSupported(locale = RuntimeLocale.normalize(locale)) && !RuntimeLocale.isSupported(locale = RuntimeLocale.normalize(Locale.getDefault()))) {
            locale = Locale.ENGLISH;
        }
        displayLocale = locale;
        RuntimeLocale.setFlags(locale);
    }

    public static void setDisplayLocale(String string) {
        RuntimeLocale.setDisplayLocale(RuntimeLocale.decodeLocale(string));
    }

    public static Locale getDisplayLocale() {
        if (displayLocale == null) {
            displayLocale = encodingLocale != null && RuntimeLocale.isSupported(encodingLocale) ? encodingLocale : (RuntimeLocale.isSupported(Locale.getDefault()) ? RuntimeLocale.normalize(Locale.getDefault()) : Locale.ENGLISH);
        }
        return displayLocale;
    }

    public static String getDisplayEnvVariableName() {
        Locale locale = RuntimeLocale.getDisplayLocale();
        String string = "C";
        if (locale != null) {
            if (RuntimeLocale.areLocalesEqual(locale, Locale.JAPANESE)) {
                if (RuntimePlatform.isWindows()) {
                    string = "Japanese_Japan.932";
                } else if (RuntimePlatform.isMac() || RuntimePlatform.isUnix()) {
                    string = "ja_JP";
                }
            } else if (RuntimeLocale.areLocalesEqual(locale, Locale.SIMPLIFIED_CHINESE)) {
                if (RuntimePlatform.isWindows()) {
                    string = "Chinese_People's Republic of China.936";
                } else if (RuntimePlatform.isMac() || RuntimePlatform.isUnix()) {
                    string = "zh_CN";
                }
            } else if (RuntimeLocale.areLocalesEqual(locale, Locale.ENGLISH)) {
                if (RuntimePlatform.isWindows()) {
                    string = "English_United States.1252";
                } else if (RuntimePlatform.isMac() || RuntimePlatform.isUnix()) {
                    string = "C";
                }
            }
        }
        return string;
    }

    public static void setEncodingLocale(Locale locale) {
        encodingLocale = RuntimeLocale.normalize(locale);
    }

    public static void setEncodingLocale(String string) {
        RuntimeLocale.setEncodingLocale(RuntimeLocale.decodeLocale(string));
    }

    public static Locale decodeLocale(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String[] stringArray = string.split("_");
        string2 = stringArray[0];
        if (stringArray.length > 1) {
            string3 = stringArray[1];
        }
        if (stringArray.length > 2) {
            string4 = stringArray[2];
        }
        return new Locale(string2, string3, string4);
    }

    public static Locale getEncodingLocale() {
        return encodingLocale != null ? encodingLocale : Locale.getDefault();
    }

    public static void addSupportedLocalization(Locale locale) {
        supportedLocalizations.add(RuntimeLocale.normalize(locale));
    }

    public static boolean isSupported(Locale locale) {
        return supportedLocalizations.contains(RuntimeLocale.normalize(locale));
    }

    public static Locale normalize(Locale locale) {
        if (locale.getLanguage().equals("zh")) {
            if (locale.getVariant().length() > 0) {
                locale = new Locale("zh", locale.getCountry());
            }
        } else if (locale.getCountry().length() > 0 || locale.getVariant().length() > 0) {
            locale = new Locale(locale.getLanguage());
        }
        return locale;
    }

    public static boolean areLocalesEqual(Locale locale, Locale locale2) {
        return RuntimeLocale.normalize(locale).equals(RuntimeLocale.normalize(locale2));
    }

    public static boolean isSimplifiedChinese() {
        return isSimplifiedChinese;
    }

    public static boolean isJapanese() {
        return isJapanese;
    }

    public static boolean isKorean() {
        return isKorean;
    }

    public static boolean isGreek() {
        return isGreek;
    }

    public static Iterator getSupportedLocaleIterator() {
        return supportedLocalizations.iterator();
    }

    public static KernelEncoder getKernelEncoder() {
        if (kernelEncoder == null) {
            kernelEncoder = RuntimePlatform.isWindows() ? new KernelEncoder(RuntimeLocale.getExportEncoder()) : new KernelEncoder(new UTF8Encoder());
        }
        return kernelEncoder;
    }

    public static void setKernelEncoder(AbstractStringEncoder abstractStringEncoder) {
        kernelEncoder = new KernelEncoder(abstractStringEncoder);
    }

    public static void setExportEncoder(AbstractStringEncoder abstractStringEncoder) {
        if (abstractStringEncoder == null) {
            abstractStringEncoder = RuntimeLocale.selectDefaultExportEncoder();
        }
        exportEncoder = abstractStringEncoder;
    }

    public static AbstractStringEncoder getExportEncoder() {
        if (null == exportEncoder) {
            RuntimeLocale.setExportEncoder(RuntimeLocale.selectDefaultExportEncoder());
        }
        return exportEncoder;
    }

    private static AbstractStringEncoder selectDefaultExportEncoder() {
        String string = null;
        Locale locale = RuntimeLocale.getEncodingLocale();
        try {
            string = locale.getISO3Language();
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        AbstractStringEncoder abstractStringEncoder = null;
        if (string != null) {
            if (RuntimePlatform.isWindows()) {
                if (Arrays.binarySearch(CP1252, string) >= 0) {
                    abstractStringEncoder = new Cp1252Encoder();
                } else if (Arrays.binarySearch(CP1251, string) >= 0) {
                    abstractStringEncoder = new Cp1251Encoder();
                } else if (Arrays.binarySearch(CP1250, string) >= 0) {
                    abstractStringEncoder = new Cp1250Encoder();
                } else if (Arrays.binarySearch(CP1257, string) >= 0) {
                    abstractStringEncoder = new Cp1257Encoder();
                } else if (string.equals("jpn")) {
                    abstractStringEncoder = new ShiftJISEncoder();
                } else if (string.equals("zho")) {
                    String string2 = "";
                    try {
                        string2 = locale.getISO3Country();
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    abstractStringEncoder = string2.equals("CHN") ? new Cp936Encoder() : new Cp950Encoder();
                } else {
                    abstractStringEncoder = string.equals("kor") ? new Cp949Encoder() : (string.equals("ell") ? new Cp1253Encoder() : (string.equals(CP1254) ? new Cp1254Encoder() : (string.equals(CP1256) ? new Cp1256Encoder() : (string.equals(CP1258) ? new Cp1258Encoder() : (string.equals("tha") ? new Cp874Encoder() : new Cp1252Encoder())))));
                }
            } else if (RuntimePlatform.isMac()) {
                String string3;
                abstractStringEncoder = Arrays.binarySearch(MACROMAN, string) >= 0 ? new MacRomanEncoder() : (Arrays.binarySearch(MACCYRILLIC, string) >= 0 ? new MacCyrillicEncoder() : (Arrays.binarySearch(MACCENTEURO, string) >= 0 ? new MacCenteuroEncoder() : (Arrays.binarySearch(MACTURKISH, string) >= 0 ? new MacTurkishEncoder() : (string.equals("jpn") ? new MacJapaneseEncoder() : (string.equals("kor") ? new MacKoreanEncoder() : (string.equals("zho") ? ((string3 = Locale.getDefault().getISO3Country()).equals("CHN") ? new MacChinsimpEncoder() : new MacChintradEncoder()) : (string.equals(MACCROATIAN) ? new MacCroatianEncoder() : (string.equals("ell") ? new MacGreekEncoder() : (string.equals(MACICELAND) ? new MacIcelandEncoder() : (string.equals(MACROMANIAN) ? new MacRomanianEncoder() : (string.equals("tha") ? new MacThaiEncoder() : new MacRomanEncoder())))))))))));
            }
        }
        if (abstractStringEncoder == null) {
            abstractStringEncoder = new UTF8Encoder();
        }
        return abstractStringEncoder;
    }

    private RuntimeLocale() {
    }

    static {
        Locale locale = Locale.getDefault();
        if (RuntimePlatform.isMac() || RuntimePlatform.isWindows()) {
            RuntimeLocale.setFlags(locale);
        }
        RuntimeLocale.addSupportedLocalization(Locale.ENGLISH);
        RuntimeLocale.addSupportedLocalization(Locale.JAPANESE);
    }
}

