/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.FontTools;
import com.maplesoft.util.RuntimeLocale;
import com.maplesoft.util.RuntimePlatform;
import com.maplesoft.util.StringToolsJapanese;
import com.maplesoft.util.encoder.AbstractStringEncoder;
import com.maplesoft.util.encoder.Cp949Encoder;
import com.maplesoft.util.encoder.UTF8Encoder;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringTools {
    private static Cp949Encoder cp949Encoder = null;
    private static boolean[] delimiterTable = null;
    public static final int TOO_LONG_TO_PASTE = 5000;
    public static final int MAX_LINE_LENGTH = 80;
    private static final float BUFFER_EXPANSION_FACTOR = 1.025f;
    public static final char[] HIRAGANA = new char[]{'\u3040', '\u309f'};
    public static final char[] KATAKANA = new char[]{'\u30a0', '\u30ff'};
    public static final char[] KATAKANA_EXT = new char[]{'\u31f0', '\u31ff'};
    public static final char[] HANGUL1 = new char[]{'\u3130', '\u318f'};
    public static final char[] HANGUL2 = new char[]{'\uac00', '\ud7af'};
    public static final char[] CJK1 = new char[]{'\u3000', '\u303f'};
    public static final char[] CJK2 = new char[]{'\u3200', '\u4dbf'};
    public static final char[] CJK3 = new char[]{'\u4e00', '\u9faf'};
    public static final char[] CJK4 = new char[]{'\ufe30', '\ufe4f'};
    public static final char[] CJK5 = new char[]{'\uff00', '\uffef'};
    public static final int[] CJK6 = new int[]{131072, 173791};
    public static final int[] CJK7 = new int[]{194560, 195103};
    public static final char DOUBLE_RIGHT_ANGLE_BRACKET = '\u300b';
    public static final char DOUBLE_LEFT_ANGLE_BRACKET = '\u300a';
    private static final int LATIN_UNICODE_LIMIT = 639;
    private static final int DELIMITER_TABLE_SIZE = 639;
    private static final int LATIN_1_DELIMITER_LOW = 128;
    private static final int LATIN_1_DELIMITER_HIGH = 191;
    private static final char LATIN_1_EXPLICIT_TIMES = '\u00d7';
    private static final char LATIN_1_INLINE_DIVIDE = '\u00f7';
    private static final int LATIN_EXT_B_DELIMITER_LOW = 448;
    private static final int LATIN_EXT_B_DELIMITER_HIGH = 451;
    private static final char[] DELIMITERS = new char[]{'.', ',', '?', '!', '\"', '\'', '(', ')', ';', ':', '{', '}', '[', ']', '<', '>', '@', '#', '$', '%', '^', '&', '*', '+', '~', '`', '\\', '/', '|', '\u00d7', '\u00f7'};
    public static String MS_MINCHO_ENGLISH = StringToolsJapanese.MINCHO_FONT_NAME;
    public static String MS_MINCHO_JAPANESE = StringToolsJapanese.MINCHO_ALTERNATE_NAME;
    public static String MS_PMINCHO_ENGLISH = StringToolsJapanese.PMINCHO_FONT_NAME;
    public static String MS_PMINCHO_JAPANESE = StringToolsJapanese.PMINCHO_ALTERNATE_NAME;
    public static String MS_GOTHIC_ENGLISH = StringToolsJapanese.GOTHIC_FONT_NAME;
    public static String MS_GOTHIC_JAPANESE = StringToolsJapanese.GOTHIC_ALTERNATE_NAME;
    public static String MS_PGOTHIC_ENGLISH = StringToolsJapanese.PGOTHIC_FONT_NAME;
    public static String MS_PGOTHIC_JAPANESE = StringToolsJapanese.PGOTHIC_ALTERNATE_NAME;
    public static final String JAPANESE_UI_FONT_NAME = FontTools.JAPANESE_UI_FONT_NAME;
    public static final String JAPANESE_CONTENT_FONT_NAME = FontTools.JAPANESE_CONTENT_FONT_NAME;

    private static Cp949Encoder getCP949Encoder() {
        if (cp949Encoder == null) {
            cp949Encoder = new Cp949Encoder();
        }
        return cp949Encoder;
    }

    public static String convertLongInput(String string) {
        String string2 = string;
        if (string2 != null && string2.length() > 5000) {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer(1 + (int)((float)string2.length() * 1.025f));
            boolean bl = false;
            boolean bl2 = true;
            while (n < string2.length()) {
                int n2;
                int n3;
                int n4 = n3 = bl2 ? string2.indexOf(10, n) : -1;
                if (n3 == -1) {
                    bl2 = false;
                }
                int n5 = n2 = n3 > 0 ? n3 : n + 80;
                if (n2 >= string2.length() - 1) {
                    n2 = string2.length() - 1;
                    bl = true;
                }
                if (n3 == -1 && string2.length() - n > 80 || n3 - n > 80) {
                    stringBuffer.append(string2.substring(n, n2));
                    if (!bl) {
                        stringBuffer.append("\\\n");
                    }
                    n = n2;
                    continue;
                }
                if (stringBuffer == null) continue;
                stringBuffer.append(string2.substring(n, n2 + 1));
                n = n2 + 1;
            }
            if (stringBuffer != null) {
                string2 = stringBuffer.toString();
            }
        }
        return string2;
    }

    public static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf(string2, n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + string2.length();
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String escapeWindowsBackslashes(String string) {
        if (RuntimePlatform.isWindows() && string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '\\') {
                    stringBuffer.append("\\\\");
                    continue;
                }
                stringBuffer.append(string.charAt(i));
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static ResourceBundle getResourceBundle(String string) throws MissingResourceException {
        ResourceBundle resourceBundle = null;
        if (string != null) {
            resourceBundle = ResourceBundle.getBundle(string, RuntimeLocale.isJapanese() ? Locale.JAPAN : Locale.getDefault());
        }
        return resourceBundle;
    }

    public static String mapComponentName(String string, ResourceBundle resourceBundle, int[] nArray) {
        String string2 = string;
        if (string2 != null) {
            int n;
            if (resourceBundle != null) {
                String string3 = null;
                try {
                    string3 = resourceBundle.getString(string2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (string3 != null) {
                    string2 = string3;
                }
            }
            if ((n = string2.indexOf(126)) >= 0) {
                string2 = StringTools.removeTilde(string2);
            }
            if (nArray != null) {
                nArray[0] = RuntimePlatform.isMac() ? -1 : n;
            }
        }
        return string2;
    }

    public static String mapString(String string, ResourceBundle resourceBundle) {
        return StringTools.mapString(string, resourceBundle, true);
    }

    public static String mapString(String string, ResourceBundle resourceBundle, boolean bl) {
        String string2;
        String string3 = string2 = bl ? string : null;
        if (string != null && resourceBundle != null) {
            try {
                String string4 = resourceBundle.getString(string);
                if (string4 != null) {
                    string2 = string4;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return string2;
    }

    public static String mapString(String string, String string2, ResourceBundle resourceBundle) {
        String string3 = StringTools.mapString(string, resourceBundle);
        return string3.replaceAll("%1", string2);
    }

    public static String mapString(String string, String[] stringArray, ResourceBundle resourceBundle) {
        String string2 = StringTools.mapString(string, resourceBundle);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = "%" + (i + 1);
            string2 = string2.replaceAll(string3, stringArray[i]);
        }
        return string2;
    }

    public static String[] mapStringArray(String[] stringArray, ResourceBundle resourceBundle) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = StringTools.mapString(stringArray[i], resourceBundle);
        }
        return stringArray2;
    }

    public static String removeTilde(String string) {
        String string2 = string;
        int n = string.indexOf(126);
        if (n >= 0) {
            if (RuntimePlatform.isMac() && n > 0 && string.charAt(n - 1) == '(' && string.charAt(n + 2) == ')') {
                string = string.replaceAll("\\(~.\\)", "");
            }
            string2 = string.replaceAll("~", "");
        }
        return string2;
    }

    public static boolean isWordDelimiter(char c) {
        if (delimiterTable == null) {
            int n;
            delimiterTable = new boolean[639];
            for (n = 0; n <= 32; ++n) {
                StringTools.delimiterTable[n] = true;
            }
            for (n = 33; n < 639; ++n) {
                StringTools.delimiterTable[n] = false;
            }
            for (n = 0; n < DELIMITERS.length; ++n) {
                StringTools.delimiterTable[StringTools.DELIMITERS[n]] = true;
            }
            for (n = 128; n <= 191; ++n) {
                StringTools.delimiterTable[n] = true;
            }
            for (n = 448; n <= 451; ++n) {
                StringTools.delimiterTable[n] = true;
            }
        }
        return c < '\u027f' ? delimiterTable[c] : false;
    }

    public static String UTF8Encode(String string, boolean bl) {
        UTF8Encoder uTF8Encoder = new UTF8Encoder();
        String string2 = uTF8Encoder.fromUnicode(string);
        if (bl) {
            string2 = AbstractStringEncoder.xmlEncode(string2);
        }
        return string2;
    }

    public static String UTF8Decode(String string) {
        return StringTools.UTF8Decode(string, true);
    }

    public static String UTF8Decode(String string, boolean bl) {
        UTF8Encoder uTF8Encoder = new UTF8Encoder();
        String string2 = bl ? AbstractStringEncoder.xmlDecode(string) : string;
        string2 = uTF8Encoder.toUnicode(string2);
        return string2;
    }

    public static boolean isJapaneseHiraganaOrKatakana(char c) {
        return StringTools.inArrayRange(HIRAGANA, c) || StringTools.inArrayRange(KATAKANA, c) || StringTools.inArrayRange(KATAKANA_EXT, c);
    }

    public static boolean isKoreanHangul(char c) {
        return StringTools.inArrayRange(HANGUL1, c) || StringTools.inArrayRange(HANGUL2, c);
    }

    public static boolean isSharedCJKIdeograph(char c) {
        boolean bl = false;
        if (c >= CJK1[0] && (StringTools.inArrayRange(CJK1, c) && c != '\u300a' && c != '\u300b' || StringTools.inArrayRange(CJK2, c) || StringTools.inArrayRange(CJK3, c) || StringTools.inArrayRange(CJK4, c) || StringTools.inArrayRange(CJK5, c))) {
            bl = true;
        }
        return bl;
    }

    public static boolean isCJKCharacter(char c) {
        return StringTools.isJapaneseHiraganaOrKatakana(c) || StringTools.isKoreanHangul(c) || StringTools.isSharedCJKIdeograph(c);
    }

    private static boolean inArrayRange(char[] cArray, char c) {
        return cArray[0] <= c && c <= cArray[1];
    }

    public static String cp949Encode(String string, boolean bl) {
        String string2 = StringTools.getCP949Encoder().fromUnicode(string);
        return bl ? AbstractStringEncoder.xmlEncode(string2) : string2;
    }

    public static String cp949Decode(String string, boolean bl) {
        String string2 = bl ? AbstractStringEncoder.xmlDecode(string) : string;
        return StringTools.getCP949Encoder().toUnicode(string2);
    }

    public static boolean isJapaneseText(String string) {
        return StringToolsJapanese.isJapaneseText(string);
    }

    public static boolean isJapaneseFont(String string) {
        return StringToolsJapanese.isJapaneseFont(string, true);
    }

    public static boolean isJapaneseFont(String string, boolean bl) {
        return StringToolsJapanese.isJapaneseFont(string, bl);
    }

    public static String shiftJISEncode(String string, boolean bl) {
        return StringToolsJapanese.shiftJISEncode(string, bl);
    }

    public static String shiftJISDecode(String string) {
        return StringToolsJapanese.shiftJISDecode(string);
    }
}

