/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util;

import com.maplesoft.util.WmiStringParseTools;

public class WmiStringParseTools {
    private static final char[] infinity;
    private static final char[] notANumber;
    private static final char[] zero;
    private static final long signMask = Long.MIN_VALUE;
    private static final long expMask = 0x7FF0000000000000L;
    private static final long fractMask = 0xFFFFFFFFFFFFFL;
    private static final int expShift = 52;
    private static final int expBias = 1023;
    private static final long fractHOB = 0x10000000000000L;
    private static final int maxDecimalDigits = 15;
    private static final int maxDecimalExponent = 308;
    private static final int minDecimalExponent = -324;
    private static final int bigDecimalExponent = 324;
    private static final long highbyte = -72057594037927936L;
    private static final long lowbytes = 0xFFFFFFFFFFFFFFL;
    private static final int singleMaxDecimalDigits = 7;
    private static final int singleMaxDecimalExponent = 38;
    private static final int singleMinDecimalExponent = -45;
    private static final int intDecimalDigits = 9;
    private static final char[] digitsBuffer;
    private static final double[] small10pow;
    private static final float[] singleSmall10pow;
    private static final double[] big10pow;
    private static final double[] tiny10pow;
    private static final int maxSmallTen;
    private static final int singleMaxSmallTen;
    private static final int[] small5pow;
    private static final long[] long5pow;
    private static FDBigInt[] b5p;
    static final /* synthetic */ boolean $assertionsDisabled;

    private WmiStringParseTools() {
    }

    public static int parseInt(String string, int n, int n2) throws NumberFormatException {
        int n3 = 0;
        boolean bl = false;
        int n4 = n;
        int n5 = n2;
        if (n5 > 0) {
            int n6;
            int n7;
            if (string.charAt(n4) == '-') {
                bl = true;
                n7 = Integer.MIN_VALUE;
                ++n4;
            } else {
                n7 = -2147483647;
            }
            int n8 = n7 / 10;
            if (n4 < n5) {
                if ((n6 = Character.digit(string.charAt(n4++), 10)) < 0) {
                    throw new NumberFormatException(string);
                }
                n3 = -n6;
            }
            while (n4 < n5) {
                if ((n6 = Character.digit(string.charAt(n4++), 10)) < 0) {
                    throw new NumberFormatException(string);
                }
                if (n3 < n8) {
                    throw new NumberFormatException(string);
                }
                if ((n3 *= 10) < n7 + n6) {
                    throw new NumberFormatException(string);
                }
                n3 -= n6;
            }
        } else {
            throw new NumberFormatException(string);
        }
        if (bl) {
            if (n4 > 1) {
                return n3;
            }
            throw new NumberFormatException(string);
        }
        return -n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static float parseFloat(String string, int n, int n2) throws NumberFormatException {
        boolean bl = false;
        boolean bl2 = false;
        try {
            while (Character.isWhitespace(string.charAt(n)) && n < n2) {
                ++n;
            }
            while (Character.isWhitespace(string.charAt(n2)) && n < n2) {
                --n2;
            }
            int n3 = n2 - n;
            if (n3 == 0) {
                throw new NumberFormatException("empty String");
            }
            int n4 = n;
            char c = string.charAt(n4);
            switch (c) {
                case '-': {
                    bl = true;
                }
                case '+': {
                    ++n4;
                    bl2 = true;
                    break;
                }
            }
            c = string.charAt(n4);
            if (c == 'N' || c == 'I') {
                int n5;
                boolean bl3 = false;
                char[] cArray = null;
                if (c == 'N') {
                    cArray = notANumber;
                    bl3 = true;
                } else {
                    cArray = infinity;
                }
                for (n5 = 0; n4 < n3 && n5 < cArray.length; ++n4, ++n5) {
                    if (string.charAt(n4) != cArray[n5]) throw new NumberFormatException(string);
                }
                if (n5 != cArray.length) throw new NumberFormatException(string);
                if (n4 != n3) throw new NumberFormatException(string);
                if (bl3) {
                    return Float.NaN;
                }
                if (!bl) return Float.POSITIVE_INFINITY;
                return Float.NEGATIVE_INFINITY;
            }
            char[] cArray = digitsBuffer;
            synchronized (digitsBuffer) {
                char[] cArray2 = n3 <= digitsBuffer.length ? digitsBuffer : new char[n3];
                int n6 = 0;
                boolean bl4 = false;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                block23: while (n4 < n3) {
                    c = string.charAt(n4);
                    switch (c) {
                        case '0': {
                            if (n6 > 0) {
                                ++n9;
                                break;
                            }
                            ++n8;
                            break;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            while (n9 > 0) {
                                cArray2[n6++] = 48;
                                --n9;
                            }
                            cArray2[n6++] = c;
                            break;
                        }
                        case '.': {
                            if (bl4) {
                                throw new NumberFormatException("multiple points");
                            }
                            n7 = n4;
                            if (bl2) {
                                --n7;
                            }
                            bl4 = true;
                            break;
                        }
                        default: {
                            break block23;
                        }
                    }
                    ++n4;
                }
                if (n6 == 0) {
                    cArray2 = zero;
                    n6 = 1;
                    if (n8 == 0) {
                        // ** MonitorExit[var9_10] (shouldn't be in output)
                        throw new NumberFormatException(string);
                    }
                }
                int n10 = bl4 ? n7 - n8 : n6 + n9;
                if (n4 < n3 && (c = string.charAt(n4)) == 'e' || c == 'E') {
                    int n11 = 1;
                    int n12 = 0;
                    int n13 = 0xCCCCCCC;
                    boolean bl5 = false;
                    switch (string.charAt(++n4)) {
                        case '-': {
                            n11 = -1;
                        }
                        case '+': {
                            ++n4;
                            break;
                        }
                    }
                    int n14 = n4;
                    block25: while (n4 < n3) {
                        if (n12 >= n13) {
                            bl5 = true;
                        }
                        c = string.charAt(n4++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                n12 = n12 * 10 + (c - 48);
                                continue block25;
                            }
                        }
                        --n4;
                        break;
                    }
                    int n15 = 324 + n6 + n9;
                    n10 = bl5 || n12 > n15 ? n11 * n15 : (n10 += n11 * n12);
                    if (n4 == n14) {
                        // ** MonitorExit[var9_10] (shouldn't be in output)
                        throw new NumberFormatException(string);
                    }
                }
                if (n4 >= n3) return WmiStringParseTools.floatValue(bl, n10, cArray2, n6, false);
                if (n4 != n3 - 1) throw new NumberFormatException(string);
                if (string.charAt(n4) == 'f') return WmiStringParseTools.floatValue(bl, n10, cArray2, n6, false);
                if (string.charAt(n4) == 'F') return WmiStringParseTools.floatValue(bl, n10, cArray2, n6, false);
                if (string.charAt(n4) == 'd') return WmiStringParseTools.floatValue(bl, n10, cArray2, n6, false);
                if (string.charAt(n4) == 'D') return WmiStringParseTools.floatValue(bl, n10, cArray2, n6, false);
                // ** MonitorExit[var9_10] (shouldn't be in output)
                throw new NumberFormatException(string);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        throw new NumberFormatException(string);
    }

    private static float floatValue(boolean bl, int n, char[] cArray, int n2, boolean bl2) {
        int n3;
        int n4 = Math.min(n2, 8);
        if (cArray == infinity || cArray == notANumber) {
            if (cArray == notANumber) {
                return Float.NaN;
            }
            return bl ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        int n5 = cArray[0] - 48;
        for (n3 = 1; n3 < n4; ++n3) {
            n5 = n5 * 10 + cArray[n3] - 48;
        }
        float f = n5;
        n3 = n - n4;
        if (n2 <= 7) {
            if (n3 == 0 || f == 0.0f) {
                return bl ? -f : f;
            }
            if (n3 >= 0) {
                if (n3 <= singleMaxSmallTen) {
                    return bl ? -f : (f *= singleSmall10pow[n3]);
                }
                int n6 = 7 - n4;
                if (n3 <= singleMaxSmallTen + n6) {
                    f *= singleSmall10pow[n6];
                    return bl ? -f : (f *= singleSmall10pow[n3 - n6]);
                }
            } else if (n3 >= -singleMaxSmallTen) {
                return bl ? -f : (f /= singleSmall10pow[-n3]);
            }
        } else if (n >= n2 && n2 + n <= 15) {
            long l = n5;
            for (int i = n4; i < n2; ++i) {
                l = l * 10L + (long)(cArray[i] - 48);
            }
            double d = l;
            n3 = n - n2;
            f = (float)(d *= small10pow[n3]);
            return bl ? -f : f;
        }
        if (n > 39) {
            return bl ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        if (n < -46) {
            return bl ? -0.0f : 0.0f;
        }
        double d = WmiStringParseTools.doubleValue(bl, n, cArray, n2, bl2, true);
        return WmiStringParseTools.stickyRound(d);
    }

    private static float stickyRound(double d) {
        long l = Double.doubleToLongBits(d);
        long l2 = l & 0x7FF0000000000000L;
        if (l2 == 0L || l2 == 0x7FF0000000000000L) {
            return (float)d;
        }
        return (float)Double.longBitsToDouble(l);
    }

    private static double doubleValue(boolean bl, int n, char[] cArray, int n2, boolean bl2, boolean bl3) {
        boolean bl4;
        double d;
        int n3;
        int n4;
        int n5 = Math.min(n2, 16);
        if (cArray == infinity || cArray == notANumber) {
            if (cArray == notANumber) {
                return Double.NaN;
            }
            return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        int n6 = 0;
        int n7 = cArray[0] - 48;
        int n8 = Math.min(n5, 9);
        for (n4 = 1; n4 < n8; ++n4) {
            n7 = n7 * 10 + cArray[n4] - 48;
        }
        long l = n7;
        for (n4 = n8; n4 < n5; ++n4) {
            l = l * 10L + (long)(cArray[n4] - 48);
        }
        double d2 = l;
        n4 = n - n5;
        if (n2 <= 15) {
            if (n4 == 0 || d2 == 0.0) {
                return bl ? -d2 : d2;
            }
            if (n4 >= 0) {
                if (n4 <= maxSmallTen) {
                    double d3 = d2 * small10pow[n4];
                    if (bl3) {
                        double d4 = d3 / small10pow[n4];
                        n6 = d4 == d2 ? 0 : (d4 < d2 ? 1 : -1);
                    }
                    return bl ? -d3 : d3;
                }
                n3 = 15 - n5;
                if (n4 <= maxSmallTen + n3) {
                    double d5 = (d2 *= small10pow[n3]) * small10pow[n4 - n3];
                    if (bl3) {
                        double d6 = d5 / small10pow[n4 - n3];
                        n6 = d6 == d2 ? 0 : (d6 < d2 ? 1 : -1);
                    }
                    return bl ? -d5 : d5;
                }
            } else if (n4 >= -maxSmallTen) {
                double d7 = d2 / small10pow[-n4];
                double d8 = d7 * small10pow[-n4];
                if (bl3) {
                    n6 = d8 == d2 ? 0 : (d8 < d2 ? 1 : -1);
                }
                return bl ? -d7 : d7;
            }
        }
        if (n4 > 0) {
            if (n > 309) {
                return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if ((n4 & 0xF) != 0) {
                d2 *= small10pow[n4 & 0xF];
            }
            if ((n4 >>= 4) != 0) {
                n3 = 0;
                while (n4 > 1) {
                    if ((n4 & 1) != 0) {
                        d2 *= big10pow[n3];
                    }
                    ++n3;
                    n4 >>= 1;
                }
                d = d2 * big10pow[n3];
                if (Double.isInfinite(d)) {
                    d = d2 / 2.0;
                    if (Double.isInfinite(d *= big10pow[n3])) {
                        return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                    d = Double.MAX_VALUE;
                }
                d2 = d;
            }
        } else if (n4 < 0) {
            n4 = -n4;
            if (n < -325) {
                return bl ? -0.0 : 0.0;
            }
            if ((n4 & 0xF) != 0) {
                d2 /= small10pow[n4 & 0xF];
            }
            if ((n4 >>= 4) != 0) {
                n3 = 0;
                while (n4 > 1) {
                    if ((n4 & 1) != 0) {
                        d2 *= tiny10pow[n3];
                    }
                    ++n3;
                    n4 >>= 1;
                }
                d = d2 * tiny10pow[n3];
                if (d == 0.0) {
                    d = d2 * 2.0;
                    if ((d *= tiny10pow[n3]) == 0.0) {
                        return bl ? -0.0 : 0.0;
                    }
                    d = Double.MIN_VALUE;
                }
                d2 = d;
            }
        }
        FDBigInt fDBigInt = new FDBigInt(l, cArray, n5, n2);
        n4 = n - n2;
        int n9 = 0;
        int n10 = 0;
        do {
            FDBigInt fDBigInt2;
            FDBigInt fDBigInt3;
            int n11;
            int n12;
            int n13;
            int n14;
            long l2 = Double.doubleToLongBits(d2) & Long.MAX_VALUE;
            int n15 = (int)(l2 >>> 52);
            l2 &= 0xFFFFFFFFFFFFFL;
            if (n15 > 0) {
                l2 |= 0x10000000000000L;
            } else {
                if (!$assertionsDisabled && l2 == 0L) {
                    throw new AssertionError(l2);
                }
                ++n15;
                while ((l2 & 0x10000000000000L) == 0L) {
                    l2 <<= 1;
                    --n15;
                }
            }
            int n16 = WmiStringParseTools.countBits(l2);
            int n17 = 53 - n16;
            n9 = (n15 -= 1023) + 1 - n16;
            n10 = n16;
            FDBigInt fDBigInt4 = new FDBigInt(l2 >>>= n17);
            if (n4 >= 0) {
                n14 = 0;
                n13 = 0;
                n11 = n12 = n4;
            } else {
                n13 = n14 = -n4;
                n12 = 0;
                n11 = 0;
            }
            if (n9 >= 0) {
                n13 += n9;
            } else {
                n11 -= n9;
            }
            int n18 = n13;
            int n19 = n9 + n10 <= -1022 ? n9 + 1023 + 52 : 54 - n10;
            int n20 = Math.min(n13 += n19, Math.min(n11 += n19, n18));
            n18 -= n20;
            fDBigInt4 = WmiStringParseTools.multPow52(fDBigInt4, n14, n13 -= n20);
            FDBigInt fDBigInt5 = WmiStringParseTools.multPow52(new FDBigInt(fDBigInt), n12, n11 -= n20);
            int n21 = fDBigInt4.cmp(fDBigInt5);
            if (n21 > 0) {
                bl4 = true;
                fDBigInt3 = fDBigInt4.sub(fDBigInt5);
                if (n10 == 1 && n9 > -1023 && --n18 < 0) {
                    n18 = 0;
                    fDBigInt3.lshiftMe(1);
                }
            } else {
                if (n21 >= 0) break;
                bl4 = false;
                fDBigInt3 = fDBigInt5.sub(fDBigInt4);
            }
            if ((n21 = fDBigInt3.cmp(fDBigInt2 = WmiStringParseTools.constructPow52(n14, n18))) < 0) {
                n6 = bl4 ? -1 : 1;
                break;
            }
            if (n21 != 0) continue;
            d2 += 0.5 * WmiStringParseTools.ulp(d2, bl4);
            n6 = bl4 ? -1 : 1;
            break;
        } while ((d2 += WmiStringParseTools.ulp(d2, bl4)) != 0.0 && d2 != Double.POSITIVE_INFINITY);
        return bl ? -d2 : d2;
    }

    private static int countBits(long l) {
        if (l == 0L) {
            return 0;
        }
        while ((l & 0xFF00000000000000L) == 0L) {
            l <<= 8;
        }
        while (l > 0L) {
            l <<= 1;
        }
        int n = 0;
        while ((l & 0xFFFFFFFFFFFFFFL) != 0L) {
            l <<= 8;
            n += 8;
        }
        while (l != 0L) {
            l <<= 1;
            ++n;
        }
        return n;
    }

    private static FDBigInt multPow52(FDBigInt fDBigInt, int n, int n2) {
        if (n != 0) {
            fDBigInt = n < small5pow.length ? fDBigInt.mult(small5pow[n]) : fDBigInt.mult(WmiStringParseTools.big5pow(n));
        }
        if (n2 != 0) {
            fDBigInt.lshiftMe(n2);
        }
        return fDBigInt;
    }

    private static synchronized FDBigInt big5pow(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError(n);
        }
        if (b5p == null) {
            b5p = new FDBigInt[n + 1];
        } else if (b5p.length <= n) {
            FDBigInt[] fDBigIntArray = new FDBigInt[n + 1];
            System.arraycopy(b5p, 0, fDBigIntArray, 0, b5p.length);
            b5p = fDBigIntArray;
        }
        if (b5p[n] != null) {
            return b5p[n];
        }
        if (n < small5pow.length) {
            WmiStringParseTools.b5p[n] = new FDBigInt(small5pow[n]);
            return WmiStringParseTools.b5p[n];
        }
        if (n < long5pow.length) {
            WmiStringParseTools.b5p[n] = new FDBigInt(long5pow[n]);
            return WmiStringParseTools.b5p[n];
        }
        int n2 = n >> 1;
        int n3 = n - n2;
        FDBigInt fDBigInt = b5p[n2];
        if (fDBigInt == null) {
            fDBigInt = WmiStringParseTools.big5pow(n2);
        }
        if (n3 < small5pow.length) {
            WmiStringParseTools.b5p[n] = fDBigInt.mult(small5pow[n3]);
            return WmiStringParseTools.b5p[n];
        }
        FDBigInt fDBigInt2 = b5p[n3];
        if (fDBigInt2 == null) {
            fDBigInt2 = WmiStringParseTools.big5pow(n3);
        }
        WmiStringParseTools.b5p[n] = fDBigInt.mult(fDBigInt2);
        return WmiStringParseTools.b5p[n];
    }

    private static FDBigInt constructPow52(int n, int n2) {
        FDBigInt fDBigInt = new FDBigInt(WmiStringParseTools.big5pow(n));
        if (n2 != 0) {
            fDBigInt.lshiftMe(n2);
        }
        return fDBigInt;
    }

    private static double ulp(double d, boolean bl) {
        long l = Double.doubleToLongBits(d) & Long.MAX_VALUE;
        int n = (int)(l >>> 52);
        if (bl && n >= 52 && (l & 0xFFFFFFFFFFFFFL) == 0L) {
            --n;
        }
        double d2 = n > 52 ? Double.longBitsToDouble((long)(n - 52) << 52) : (n == 0 ? Double.MIN_VALUE : Double.longBitsToDouble(1L << n - 1));
        if (bl) {
            d2 = -d2;
        }
        return d2;
    }

    static {
        $assertionsDisabled = !WmiStringParseTools.class.desiredAssertionStatus();
        infinity = new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
        notANumber = new char[]{'N', 'a', 'N'};
        zero = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
        digitsBuffer = new char[20];
        small10pow = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
        singleSmall10pow = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
        big10pow = new double[]{1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
        tiny10pow = new double[]{1.0E-16, 1.0E-32, 1.0E-64, 1.0E-128, 1.0E-256};
        maxSmallTen = small10pow.length - 1;
        singleMaxSmallTen = singleSmall10pow.length - 1;
        small5pow = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
        long5pow = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L};
    }
}

