/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util.encoder;

import com.maplesoft.util.WmiMathEntityNameMapper;
import com.maplesoft.util.encoder.AbstractStringEncoder;
import com.maplesoft.util.encoder.UnicodeEscapeEncoder;

public class KernelEncoder
extends AbstractStringEncoder {
    private static final boolean DEBUG_ENCODER = false;
    private static final String[] XML_PREFIXES = new String[]{"<?xml", "<application_communications", "\"<application_communications"};
    private AbstractStringEncoder encoder = null;

    public KernelEncoder(AbstractStringEncoder abstractStringEncoder) {
        super(null);
        this.encoder = abstractStringEncoder;
    }

    protected void initialize() {
    }

    public String toUnicode(String string) {
        return this.toUnicode(string, true);
    }

    public String fromUnicode(String string) {
        return this.fromUnicode(string, true);
    }

    public String toUnicode(String string, boolean bl) {
        String string2 = string;
        String string3 = this.process(string, true, true);
        if (bl && !this.isXML(string3) && !string2.equals(string3)) {
            string3 = string3.replaceAll("`", "");
        }
        return string3;
    }

    public String fromUnicode(String string, boolean bl) {
        return this.process(string, false, bl);
    }

    private void encodeAndAppendString(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        for (int i = 0; i < stringBuffer.length(); ++i) {
            this.encodeAndAppendCharacter(stringBuffer.charAt(i), stringBuffer2);
        }
    }

    private void encodeAndAppendCharacter(char c, StringBuffer stringBuffer) {
        if (c > '\u007f') {
            boolean bl = false;
            if (WmiMathEntityNameMapper.isMathEntity(c)) {
                bl = this.appendEntityNameIfExists(c, stringBuffer);
            }
            if (!bl) {
                if (this.canEncodeCharacter(c)) {
                    stringBuffer.append(this.encoder.fromUnicode(Character.toString(c)));
                    bl = true;
                } else {
                    stringBuffer.append("&#");
                    stringBuffer.append((int)c);
                    stringBuffer.append(";");
                }
            }
        } else {
            stringBuffer.append(c);
        }
    }

    private boolean appendEntityNameIfExists(char c, StringBuffer stringBuffer) {
        boolean bl = false;
        String string = WmiMathEntityNameMapper.getEntityName(c);
        if (string != null) {
            stringBuffer.append("&");
            stringBuffer.append(string);
            stringBuffer.append(";");
            bl = true;
        }
        return bl;
    }

    public boolean canEncodeCharacter(char c) {
        return this.encoder.canEncodeCharacter(c);
    }

    public int canEncodeUpTo(String string) {
        return this.encoder.canEncodeUpTo(string);
    }

    private boolean isXML(String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            for (int i = 0; i < XML_PREFIXES.length; ++i) {
                if (!string.startsWith(XML_PREFIXES[i])) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private String process(String string, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && string.length() > 0) {
            if (bl) {
                if (this.encoder != null) {
                    string = this.encoder.toUnicode(string);
                }
                string = UnicodeEscapeEncoder.convertEscapeSequenceToUnicode(string, false);
            }
            boolean bl3 = this.isPartOfIdentifier(string.charAt(0));
            boolean bl4 = this.isXML(string);
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            int n = 0;
            StringBuffer stringBuffer2 = new StringBuffer();
            while (n < string.length()) {
                stringBuffer2.setLength(0);
                boolean bl9 = false;
                while (n < string.length()) {
                    char c = string.charAt(n);
                    if (bl3 != this.isPartOfIdentifier(c)) {
                        bl3 = !bl3;
                        break;
                    }
                    if (bl8) {
                        bl8 = false;
                    } else if (!bl4) {
                        if (c == '\\') {
                            bl8 = true;
                        } else if (c == '\"' && !bl6 && !bl7) {
                            bl5 = !bl5;
                        } else if (c == '`' && !bl5 && !bl7) {
                            bl6 = !bl6;
                        } else if (c == '\'' && !bl5 && !bl6) {
                            bl7 = !bl7;
                        }
                    }
                    stringBuffer2.append(c);
                    if (bl2 && c > '\u007f') {
                        bl9 = !bl4 && !bl5 && !bl6 && !bl7;
                    }
                    ++n;
                }
                if (bl9) {
                    stringBuffer.append('`');
                }
                if (bl || this.encoder == null) {
                    stringBuffer.append(stringBuffer2);
                } else {
                    this.encodeAndAppendString(stringBuffer2, stringBuffer);
                }
                if (!bl9) continue;
                stringBuffer.append('`');
            }
        }
        return stringBuffer.toString();
    }

    private static void printAsInt(String string) {
        for (int i = 0; i < string.length(); ++i) {
            System.out.print(string.charAt(i));
            System.out.print('(');
            System.out.print((int)string.charAt(i));
            System.out.print(") ");
        }
        System.out.println();
    }

    private boolean isPartOfIdentifier(char c) {
        boolean bl = true;
        if (c < '\u007f') {
            bl = Character.isLetterOrDigit(c) || c == '_';
        }
        return bl;
    }

    public int getType() {
        return 0;
    }

    protected String[] getPageRefs() {
        return null;
    }
}

