/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util.encoder;

import com.maplesoft.util.encoder.AbstractStringEncoder;

public class UTF8Encoder
extends AbstractStringEncoder {
    public UTF8Encoder() {
        super("UTF-8");
    }

    protected void initialize() {
    }

    public int[] fromUnicode(int[] nArray) {
        String string = this.intArrayToString(nArray);
        string = this.fromUnicode(string);
        return this.stringToIntArray(string);
    }

    public int[] toUnicode(int[] nArray) {
        String string = this.intArrayToString(nArray);
        string = this.toUnicode(string);
        return this.stringToIntArray(string);
    }

    private int[] stringToIntArray(String string) {
        int[] nArray = new int[string.length()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = string.charAt(i);
        }
        return nArray;
    }

    private String intArrayToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append((char)nArray[i]);
        }
        return stringBuffer.toString();
    }

    public String fromUnicode(String string) {
        return UTF8Encoder.convertUnicodeToUtf8(string);
    }

    public String toUnicode(String string) {
        return UTF8Encoder.convertUtf8ToUnicode(string);
    }

    public boolean canEncodeCharacter(char c) {
        return true;
    }

    public int canEncodeUpTo(String string) {
        return -1;
    }

    public int getType() {
        return 0;
    }

    protected String[] getPageRefs() {
        return null;
    }

    public static String convertUtf8ToUnicode(String string) {
        String string2 = null;
        if (string != null) {
            try {
                byte[] byArray = string.getBytes("ISO8859-1");
                string2 = new String(byArray, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    public static String convertUnicodeToUtf8(String string) {
        byte[] byArray = null;
        String string2 = null;
        if (string != null) {
            try {
                byArray = string.getBytes("UTF-8");
                string2 = new String(byArray, "ISO8859-1");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }
}

