/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.util.encoder;

import com.maplesoft.util.encoder.AbstractStringEncoder;

public class UnicodeEscapeEncoder
extends AbstractStringEncoder {
    private static final String ESCAPE_SEQUENCE_START = "&#";
    private static final String ESCAPE_SEQUENCE_END = ";";
    private static final int ESCAPE_SEQUENCE_MAXLEN = 10;

    public UnicodeEscapeEncoder() {
        super(null);
    }

    public static String convertEscapeSequenceToUnicode(String string) {
        return UnicodeEscapeEncoder.convertEscapeSequenceToUnicode(string, true);
    }

    public static String convertEscapeSequenceToUnicode(String string, boolean bl) {
        if (string != null && string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            boolean bl2 = false;
            int n2 = string.indexOf(ESCAPE_SEQUENCE_START);
            int n3 = string.indexOf(ESCAPE_SEQUENCE_END, n2);
            while (n2 >= 0 && n3 >= 0) {
                if (n3 - n2 < 10) {
                    String string2 = string.substring(n2 + ESCAPE_SEQUENCE_START.length(), n3);
                    try {
                        int n4 = Integer.parseInt(string2);
                        stringBuffer.append(string.substring(n, n2));
                        stringBuffer.append((char)n4);
                        bl2 = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringBuffer.append(string.substring(n, n3 + 1));
                    }
                } else {
                    stringBuffer.append(string.substring(n, n3 + 1));
                }
                n = n3 + 1;
                n2 = string.indexOf(ESCAPE_SEQUENCE_START, n3);
                n3 = string.indexOf(ESCAPE_SEQUENCE_END, n2);
            }
            stringBuffer.append(string.substring(n));
            string = stringBuffer.toString();
            if (bl2 && bl) {
                string = string.replaceAll("`", "");
            }
        }
        return string;
    }

    public static String convertUnicodeToEscapeSequence(String string) {
        return UnicodeEscapeEncoder.convertUnicodeToEscapeSequence(string, true);
    }

    public static String convertUnicodeToEscapeSequence(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && string.length() > 0) {
            boolean bl2 = UnicodeEscapeEncoder.isPartOfIdentifier(string.charAt(0));
            boolean bl3 = false;
            boolean bl4 = false;
            int n = 0;
            while (n < string.length()) {
                StringBuffer stringBuffer2 = new StringBuffer();
                boolean bl5 = false;
                while (n < string.length()) {
                    char c = string.charAt(n);
                    if (bl2 != UnicodeEscapeEncoder.isPartOfIdentifier(c)) {
                        bl2 = !bl2;
                        break;
                    }
                    if (bl4) {
                        bl4 = false;
                    } else if (c == '\\') {
                        bl4 = true;
                    } else if (c == '\"') {
                        boolean bl6 = bl3 = !bl3;
                    }
                    if (c <= '\u007f') {
                        stringBuffer2.append(c);
                    } else {
                        stringBuffer2.append(ESCAPE_SEQUENCE_START);
                        stringBuffer2.append((int)c);
                        stringBuffer2.append(ESCAPE_SEQUENCE_END);
                        bl5 = !bl3;
                    }
                    ++n;
                }
                if (bl && bl5 && (stringBuffer.length() < 1 || stringBuffer.charAt(stringBuffer.length() - 1) != '`')) {
                    stringBuffer.append('`');
                }
                stringBuffer.append(stringBuffer2);
                if (!bl || !bl5 || n < string.length() && string.charAt(n) == '`') continue;
                stringBuffer.append('`');
            }
        }
        return stringBuffer.toString();
    }

    private static boolean isPartOfIdentifier(char c) {
        boolean bl = true;
        if (c < '\u007f') {
            bl = Character.isLetterOrDigit(c) || c == '_';
        }
        return bl;
    }

    public String toUnicode(String string) {
        if (string.indexOf(ESCAPE_SEQUENCE_START) > 0 && string.indexOf(ESCAPE_SEQUENCE_END) > 0) {
            string = string.replaceAll("`", "");
        }
        return string;
    }

    public String fromUnicode(String string) {
        return UnicodeEscapeEncoder.convertUnicodeToEscapeSequence(string);
    }

    public int getType() {
        return 0;
    }

    protected String[] getPageRefs() {
        return null;
    }
}

