/*
 * Decompiled with CFR 0.152.
 */
package applets.clickableImage;

import applets.clickableImage.ClickableImageCreator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Scrollbar;
import java.lang.reflect.Constructor;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CICImageCanvas
extends Panel {
    private static final long serialVersionUID = 1L;
    private Color CORRECT_REGION_BORDER = new Color(0, 192, 0);
    private Color CORRECT_REGION_SHADE = new Color(0, 0, 0);
    private Color INCORRECT_REGION_BORDER = new Color(0, 0, 0);
    private Color INCORRECT_REGION_SHADE = new Color(0, 0, 0);
    private boolean supportsAlpha = false;
    private Image image;
    private Image passImage;
    private int image_width;
    private int image_height;
    private int image_x;
    private int image_y;
    private Scrollbar hbar;
    private Scrollbar vbar;
    public Point dragPoint;
    private boolean selecting;
    private boolean imageLoaded;
    private static boolean scrollbarIsBuggy = false;
    private static boolean scrollbarTested = false;
    private Vector<Vector<Point>> regions;
    private int correct;
    private int active;
    private ClickableImageCreator myApplet;

    CICImageCanvas(Vector<Vector<Point>> regions, int correct, ClickableImageCreator myApplet) {
        this.setBackground(Color.gray);
        this.setLayout(new BorderLayout());
        this.regions = regions;
        this.correct = correct - 1;
        this.myApplet = myApplet;
        this.selecting = false;
        this.imageLoaded = false;
        try {
            Constructor cstr = Color.class.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            this.CORRECT_REGION_SHADE = (Color)cstr.newInstance(new Integer(0), new Integer(255), new Integer(0), new Integer(32));
            this.INCORRECT_REGION_SHADE = (Color)cstr.newInstance(new Integer(0), new Integer(0), new Integer(0), new Integer(32));
            this.supportsAlpha = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void addRegion() {
        if (this.regions.lastElement().size() > 0) {
            this.regions.addElement(new Vector());
            this.active = this.regions.size() - 1;
            this.dragPoint = null;
            this.repaint();
        }
    }

    private int closestLineIn(int x, int y, Vector v) {
        double dist = Double.POSITIVE_INFINITY;
        int closest = -1;
        int i = 0;
        while (i < v.size() - 1) {
            double d2;
            Point p1 = (Point)v.elementAt(i);
            Point p2 = (Point)v.elementAt(i + 1);
            double a = p2.x - p1.x;
            double b = p2.y - p1.y;
            double llen = this.distance(p1.x, p1.y, p2.x, p2.y);
            double pdist = Math.abs(a * (double)(y - p1.y) - b * (double)(x - p1.x)) / llen;
            double d1 = this.distance(x, y, p1.x, p1.y);
            double trydist = Math.max(d1, d2 = this.distance(x, y, p2.x, p2.y)) > llen ? Math.min(d1, d2) : pdist;
            if (trydist < dist) {
                dist = trydist;
                closest = i;
            }
            ++i;
        }
        return closest;
    }

    void deleteActiveRegion() {
        if (this.active == this.correct) {
            this.correct = -1;
        } else if (this.correct > this.active) {
            --this.correct;
        }
        this.regions.removeElementAt(this.active);
        this.active = 0;
        if (this.regions.size() == 0) {
            this.regions.addElement(new Vector());
        }
        this.repaint();
    }

    private double distance(float x1, float y1, float x2, float y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    private void drawActiveRegion(Graphics g) {
        Vector<Point> v = this.regions.elementAt(this.active);
        if (v == null || v.size() == 0) {
            return;
        }
        g.setPaintMode();
        g.setColor(this.active == this.correct ? this.CORRECT_REGION_BORDER : this.INCORRECT_REGION_BORDER);
        Polygon p = CICImageCanvas.regionToPolygon(v, -this.image_x, -this.image_y);
        int i = 0;
        while (i < p.npoints - 1) {
            this.drawThickLine(g, p.xpoints[i], p.ypoints[i], p.xpoints[i + 1], p.ypoints[i + 1]);
            ++i;
        }
        this.drawThickLine(g, p.xpoints[i], p.ypoints[i], p.xpoints[0], p.ypoints[0]);
        g.setColor(this.active == this.correct ? this.CORRECT_REGION_SHADE : this.INCORRECT_REGION_SHADE);
        if (!this.supportsAlpha) {
            g.setXORMode(new Color(128, 128, 128));
        }
        g.fillPolygon(p);
        g.setPaintMode();
        g.setColor(Color.red);
        i = 0;
        while (i < p.npoints) {
            g.fill3DRect(p.xpoints[i] - 1, p.ypoints[i] - 1, 4, 4, true);
            ++i;
        }
        if (this.dragPoint != null) {
            g.setColor(Color.yellow);
            g.fill3DRect(this.dragPoint.x - this.image_x - 1, this.dragPoint.y - this.image_y - 1, 4, 4, true);
        }
    }

    private void drawPassImage() {
        if (!this.imageLoaded) {
            return;
        }
        if (this.passImage == null) {
            this.passImage = this.createImage(this.image_width, this.image_height);
        }
        if (this.passImage == null) {
            return;
        }
        Graphics g = this.passImage.getGraphics();
        g.drawImage(this.image, 0, 0, this);
        int i = 0;
        while (i < this.regions.size()) {
            if (i != this.active) {
                this.drawPassiveRegion(g, i);
            }
            ++i;
        }
    }

    private void drawPassiveRegion(Graphics g, int index) {
        Vector<Point> v = this.regions.elementAt(index);
        if (v == null || v.size() == 0) {
            return;
        }
        Polygon p = CICImageCanvas.regionToPolygon(v, 0, 0);
        g.setColor(index == this.correct ? this.CORRECT_REGION_SHADE : this.INCORRECT_REGION_SHADE);
        if (!this.supportsAlpha) {
            g.setXORMode(new Color(127, 127, 127));
        }
        g.fillPolygon(p);
        g.setPaintMode();
        g.setColor(index == this.correct ? this.CORRECT_REGION_BORDER : this.INCORRECT_REGION_BORDER);
        int i = 0;
        while (i < p.npoints - 1) {
            g.drawLine(p.xpoints[i], p.ypoints[i], p.xpoints[i + 1], p.ypoints[i + 1]);
            ++i;
        }
        g.drawLine(p.xpoints[i], p.ypoints[i], p.xpoints[0], p.ypoints[0]);
    }

    private void drawThickLine(Graphics g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
        g.drawLine(x1 + 1, y1, x2 + 1, y2);
        g.drawLine(x1, y1 + 1, x2, y2 + 1);
    }

    private Point findClosePointIn(int x, int y, Vector v) {
        int i = 0;
        while (i < v.size() - 1) {
            Point p1 = (Point)v.elementAt(i);
            int trydist2 = (p1.x - x) * (p1.x - x) + (p1.y - y) * (p1.y - y);
            if (trydist2 < 9) {
                return p1;
            }
            ++i;
        }
        return null;
    }

    private int findRegion(int x, int y) {
        int i = 0;
        while (i < this.regions.size()) {
            Vector<Point> v = this.regions.elementAt(i);
            if (v.size() > 3 && CICImageCanvas.regionToPolygon(v, 0, 0).inside(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int getCorrect() {
        return this.correct;
    }

    Vector getRegions() {
        return this.regions;
    }

    private void gotImage() {
        int view_height;
        this.imageLoaded = true;
        this.image = this.myApplet.image;
        this.image_width = this.image.getWidth(this);
        this.image_height = this.image.getHeight(this);
        int width = this.size().width;
        int height = this.size().height;
        this.vbar = new Scrollbar(1);
        this.hbar = new Scrollbar(0);
        int view_width = this.image_height > height ? width - this.vbar.preferredSize().width : width;
        int n = view_height = this.image_width > width ? height - this.hbar.preferredSize().height : height;
        if (this.image_height > view_height) {
            if (CICImageCanvas.hasBuggyScrollbarAPI()) {
                this.vbar.setValues(0, view_height, 0, this.image_height);
                System.out.println("special: " + view_height + "  " + this.image_height);
            } else {
                this.vbar.setValues(0, view_height, 0, this.image_height - view_height);
                System.out.println("not special: " + view_height + "  " + (this.image_height - view_height));
            }
            this.add("East", this.vbar);
            this.image_y = 0;
        } else {
            this.image_y = (this.image_height - height) / 2;
        }
        if (this.image_width > view_width) {
            if (CICImageCanvas.hasBuggyScrollbarAPI()) {
                this.hbar.setValues(0, view_width, 0, this.image_width);
            } else {
                this.hbar.setValues(0, view_width, 0, this.image_width - view_width);
            }
            this.add("South", this.hbar);
            this.image_x = 0;
        } else {
            this.image_x = (this.image_width - width) / 2;
        }
        this.validate();
    }

    @Override
    public boolean handleEvent(Event e) {
        if (e.target == this.hbar) {
            int ix = this.image_x;
            this.image_x = this.hbar.getValue();
            if (ix != this.image_x) {
                this.update(this.getGraphics());
            }
            return true;
        }
        if (e.target == this.vbar) {
            int iy = this.image_y;
            this.image_y = this.vbar.getValue();
            if (iy != this.image_y) {
                this.update(this.getGraphics());
            }
            return true;
        }
        return super.handleEvent(e);
    }

    private static boolean hasBuggyScrollbarAPI() {
        if (!scrollbarTested) {
            Scrollbar testBar = new Scrollbar();
            testBar.setValues(0, 10, 0, 20);
            try {
                testBar.setValue(20);
                if (testBar.getValue() < 20) {
                    scrollbarIsBuggy = true;
                }
            }
            catch (Exception e) {
                scrollbarIsBuggy = true;
            }
            scrollbarTested = true;
        }
        return scrollbarIsBuggy;
    }

    @Override
    public boolean mouseDown(Event e, int x, int y) {
        if (this.selecting) {
            return true;
        }
        int ax = x + this.image_x;
        int ay = y + this.image_y;
        Vector<Point> v = this.regions.elementAt(this.active);
        if (ax < 0 || ay < 0 || ax >= this.image_width || ay >= this.image_height) {
            return false;
        }
        Point cp = this.findClosePointIn(ax, ay, v);
        if (cp != null) {
            this.dragPoint = cp;
            this.dragPoint.move(ax, ay);
        } else {
            int r = this.findRegion(ax, ay);
            if (r >= 0 && r != this.active) {
                this.selecting = true;
            } else if (v.size() == 0) {
                this.dragPoint = new Point(ax, ay);
                v.addElement(this.dragPoint);
                v.addElement(this.dragPoint);
            } else {
                this.dragPoint = new Point(ax, ay);
                int cl = this.closestLineIn(ax, ay, v);
                v.insertElementAt(this.dragPoint, this.closestLineIn(ax, ay, v) + 1);
            }
        }
        this.repaint();
        return true;
    }

    @Override
    public boolean mouseDrag(Event e, int x, int y) {
        if (this.selecting) {
            return true;
        }
        if (this.dragPoint == null) {
            return false;
        }
        int ax = x + this.image_x;
        int ay = y + this.image_y;
        int n = ax < 0 ? 0 : (ax = ax >= this.image_width ? this.image_width - 1 : ax);
        ay = ay < 0 ? 0 : (ay >= this.image_height ? this.image_height - 1 : ay);
        this.dragPoint.move(ax, ay);
        this.repaint();
        return true;
    }

    @Override
    public boolean mouseMove(Event e, int x, int y) {
        Point oldp = this.dragPoint;
        Vector<Point> v = this.regions.elementAt(this.active);
        this.dragPoint = this.findClosePointIn(x + this.image_x, y + this.image_y, v);
        if (this.dragPoint != oldp) {
            Graphics g = this.getGraphics();
            g.clipRect(-this.image_x, -this.image_y, this.image_width, this.image_height);
            g.setPaintMode();
            if (oldp != null) {
                g.setColor(Color.red);
                g.fill3DRect(oldp.x - this.image_x - 1, oldp.y - this.image_y - 1, 4, 4, true);
            }
            if (this.dragPoint != null) {
                g.setColor(Color.yellow);
                g.fill3DRect(this.dragPoint.x - this.image_x - 1, this.dragPoint.y - this.image_y - 1, 4, 4, true);
            }
        }
        return true;
    }

    @Override
    public boolean mouseUp(Event e, int x, int y) {
        if (this.selecting) {
            this.active = this.findRegion(x + this.image_x, y + this.image_y);
            this.selecting = false;
            this.repaint();
        }
        return true;
    }

    @Override
    public void paint(Graphics g) {
        if (!this.imageLoaded) {
            g.clearRect(0, 0, this.size().width, this.size().height);
            if (this.myApplet.gotImage) {
                this.gotImage();
            } else {
                g.drawString(this.myApplet.loadingStatus, 4, 34);
            }
        }
        if (this.imageLoaded) {
            this.drawPassImage();
            g.clipRect(-this.image_x, -this.image_y, this.image_width, this.image_height);
            if (this.passImage != null) {
                g.drawImage(this.passImage, -this.image_x, -this.image_y, this);
            }
            this.drawActiveRegion(g);
        }
    }

    private static Polygon regionToPolygon(Vector v, int xTrans, int yTrans) {
        int npoints = v.size() - 1;
        int[] xpoints = new int[npoints];
        int[] ypoints = new int[npoints];
        int i = 0;
        while (i < npoints) {
            Point p1 = (Point)v.elementAt(i);
            xpoints[i] = p1.x + xTrans;
            ypoints[i] = p1.y + yTrans;
            ++i;
        }
        return new Polygon(xpoints, ypoints, npoints);
    }

    void selectActiveRegion() {
        this.correct = this.active;
        this.passImage = null;
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }
}

