/*
 * Decompiled with CFR 0.152.
 */
package applets.clickableImage;

import applets.MessageUtilities;
import applets.clickableImage.CICImageCanvas;
import applets.util.URLEncoder;
import applets.util.WarningDialog;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClickableImageCreator
extends Applet
implements Runnable,
ActionListener {
    static final String TEST_KEY = "clickable.image.response";
    Image image;
    private JButton undoButton;
    private JButton showAll;
    private JButton newButton;
    private JButton deleteButton;
    private JButton selectButton;
    private Panel topBar;
    private CICImageCanvas imageArea;
    String loadingStatus;
    boolean gotImage = false;
    private Frame holderFrame;
    Locale mtaLocale = new Locale("en", "US");

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.newButton) {
            this.imageArea.addRegion();
        } else if (event.getSource() == this.deleteButton) {
            this.imageArea.deleteActiveRegion();
        } else if (event.getSource() == this.selectButton) {
            this.imageArea.selectActiveRegion();
        }
    }

    private URL completeURL(String tail) throws MalformedURLException {
        try {
            return new URL(URLEncoder.encode(tail));
        }
        catch (MalformedURLException e) {
            String urlBase = this.getCodeBase().toString();
            int c = urlBase.indexOf(63);
            if (c >= 0) {
                urlBase = urlBase.substring(0, c);
            }
            if ((c = urlBase.lastIndexOf(47)) >= 0) {
                urlBase = urlBase.substring(0, c + 1);
            }
            return new URL(URLEncoder.encode(String.valueOf(urlBase) + tail));
        }
    }

    @Override
    public void destroy() {
        this.holderFrame.dispose();
        this.holderFrame = null;
    }

    private void dialog(Exception e) {
        this.loadingStatus = MessageUtilities.getMessage(this.mtaLocale, "ClickableImageCreator.LoadingStatus.ErrorLoadingImage");
        this.showStatus(this.loadingStatus);
        System.out.println("Exception: " + e.toString());
        e.printStackTrace();
        this.popup(String.valueOf(MessageUtilities.getMessage(this.mtaLocale, "ClickableImageCreator.Popup.ErrorLoadingImage.Part1")) + "\n\n" + "   " + this.getParameter("imageURL") + "\n\n" + MessageUtilities.getMessage(this.mtaLocale, "ClickableImageCreator.Popup.ErrorLoadingImage.Part2"));
    }

    public void doneButtonAction() {
        block7: {
            Vector regions = this.imageArea.getRegions();
            int correct = this.imageArea.getCorrect() + 1;
            if (correct < 1 || correct > regions.size()) {
                this.popup(MessageUtilities.getMessage(this.mtaLocale, "ClickableImageCreator.Popup.MustDesignateCorrectRegion"));
                return;
            }
            try {
                String urlStr = "dbEdit.AddClickableImage?actionID=accept";
                urlStr = String.valueOf(urlStr) + "&clickable.image.response=" + this.getParameter(TEST_KEY) + "&answer=" + correct + "&imageURL=" + this.getParameter("imageURL") + "&width=" + this.image.getWidth(this) + "&height=" + this.image.getHeight(this);
                int n = 1;
                int i = 0;
                while (i < regions.size()) {
                    Vector v = (Vector)regions.elementAt(i);
                    if (v.size() > 3) {
                        urlStr = String.valueOf(urlStr) + "&region." + n + "=";
                        int j = 0;
                        while (j < v.size() - 1) {
                            Point p1 = (Point)v.elementAt(j);
                            urlStr = String.valueOf(urlStr) + p1.x + "," + p1.y + ",";
                            ++j;
                        }
                        ++n;
                    }
                    ++i;
                }
                urlStr = String.valueOf(urlStr) + "&numberOfRegions=" + (n - 1);
                urlStr = String.valueOf(urlStr) + "&forceReload=" + System.currentTimeMillis();
                if (n > 2) {
                    this.getAppletContext().showDocument(this.completeURL(urlStr), "_self");
                    break block7;
                }
                this.popup(MessageUtilities.getMessage(this.mtaLocale, "ClickableImageCreator.Popup.NeedAtLeastTwoRegions"));
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.loadingStatus = MessageUtilities.getMessage(this.mtaLocale, "ClickableImageCreator.LoadingStatus.QuestionUpdateFailed");
                this.showStatus(this.loadingStatus);
            }
        }
    }

    private int getAnswerFromParameters() {
        try {
            return Integer.parseInt(this.getParameter("answer"));
        }
        catch (Exception e) {
            return -1;
        }
    }

    private Vector<Vector<Point>> getRegionsFromParameters() {
        String region;
        Vector<Vector<Point>> regions = new Vector<Vector<Point>>();
        int i = 1;
        while ((region = this.getParameter("region." + i)) != null) {
            StringTokenizer stz = new StringTokenizer(region, ",\n\t ");
            int numPoints = stz.countTokens() / 2;
            Vector<Point> v = new Vector<Point>();
            int j = 0;
            while (j < numPoints) {
                v.addElement(new Point(Integer.parseInt(stz.nextToken()), Integer.parseInt(stz.nextToken())));
                ++j;
            }
            v.addElement((Point)v.elementAt(0));
            regions.addElement(v);
            ++i;
        }
        if (regions.size() == 0) {
            regions.addElement(new Vector());
        }
        return regions;
    }

    @Override
    public void init() {
        String[] locale;
        try {
            locale = this.getParameter("mtalocale").split("_");
        }
        catch (Exception e) {
            locale = "en_US".split("_");
        }
        if (locale.length == 1) {
            this.mtaLocale = new Locale(locale[0]);
        } else if (locale.length == 2) {
            this.mtaLocale = new Locale(locale[0], locale[1]);
        } else if (locale.length == 3) {
            this.mtaLocale = new Locale(locale[0], locale[1], locale[2]);
        }
        this.holderFrame = new Frame();
        this.loadingStatus = MessageUtilities.getMessage(this.mtaLocale, "ClickableImageCreator.LoadingStatus.LoadingImage");
        this.showStatus(this.loadingStatus);
        Thread loader = new Thread(this);
        loader.start();
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setFont(new Font("Helvetica", 0, 12));
        this.setLayout(new BorderLayout());
        this.topBar = new Panel();
        this.topBar.setBackground(Color.white);
        this.newButton = new JButton(MessageUtilities.getMessage(this.mtaLocale, "ClickableImageCreator.Button.NewRegion.Label"));
        this.topBar.add(this.newButton);
        this.selectButton = new JButton(MessageUtilities.getMessage(this.mtaLocale, "ClickableImageCreator.Button.SetCorrect.Label"));
        this.topBar.add(this.selectButton);
        this.deleteButton = new JButton(MessageUtilities.getMessage(this.mtaLocale, "ClickableImageCreator.Button.Delete.Label"));
        this.topBar.add(this.deleteButton);
        this.newButton.addActionListener(this);
        this.selectButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.add("North", this.topBar);
        this.imageArea = new CICImageCanvas(this.getRegionsFromParameters(), this.getAnswerFromParameters(), this);
        this.add("Center", this.imageArea);
    }

    @Override
    public boolean keyDown(Event event, int key) {
        switch (key) {
            case 78: 
            case 110: {
                this.imageArea.addRegion();
                return true;
            }
            case 68: 
            case 100: {
                this.imageArea.deleteActiveRegion();
                return true;
            }
            case 83: 
            case 115: {
                this.imageArea.selectActiveRegion();
                return true;
            }
        }
        return super.keyDown(event, key);
    }

    @Override
    public boolean mouseEnter(Event event, int x, int y) {
        this.showStatus(this.loadingStatus);
        return true;
    }

    private void popup(String message) {
        new WarningDialog(this.holderFrame, message, this.mtaLocale).setVisible(true);
    }

    @Override
    public void run() {
        try {
            this.image = this.getImage(this.completeURL(this.getParameter("imageURL")));
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(this.image, 0);
            while (tracker.statusID(0, true) == 1) {
                this.showStatus(MessageUtilities.getMessage(this.mtaLocale, "ClickableImageCreator.LoadingStatus.LoadingImage"));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.showStatus("");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (tracker.isErrorID(0)) {
                throw new Exception(MessageUtilities.getMessage(this.mtaLocale, "ClickableImageCreator.LoadingStatus.ErrorLoadingImage"));
            }
            this.gotImage = true;
            this.loadingStatus = MessageUtilities.getMessage(this.mtaLocale, "ClickableImageCreator.LoadingStatus.ImageLoaded");
            this.showStatus(this.loadingStatus);
            Image tempImage = this.createImage(this.image.getWidth(this), this.image.getHeight(this));
            tempImage.getGraphics().drawImage(this.image, 0, 0, Color.white, this);
            this.image = tempImage;
            if (this.imageArea != null) {
                this.imageArea.repaint();
            }
        }
        catch (Exception e) {
            this.dialog(e);
        }
    }
}

