/*
 * Decompiled with CFR 0.152.
 */
package applets.util;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class MultiLineLabel
extends Canvas {
    private Vector lines;
    private int textWidth = 0;
    private int textHeight = 0;
    private static int INSET = 20;

    public MultiLineLabel(String text) {
        boolean lastTokenWasLineBreak = false;
        this.lines = new Stack();
        StringTokenizer stz = new StringTokenizer(text, "\n", true);
        while (stz.hasMoreTokens()) {
            String s = stz.nextToken();
            if ("\n".equals(s)) {
                if (lastTokenWasLineBreak) {
                    ((Stack)this.lines).push("");
                }
                lastTokenWasLineBreak = true;
                continue;
            }
            ((Stack)this.lines).push(s);
            lastTokenWasLineBreak = false;
        }
    }

    public void addNotify() {
        super.addNotify();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Enumeration e = this.lines.elements();
        while (e.hasMoreElements()) {
            int width = fm.stringWidth((String)e.nextElement());
            int n = this.textWidth = this.textWidth < width ? width : this.textWidth;
        }
        this.textHeight = this.lines.size() * fm.getHeight();
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.textWidth, this.textHeight);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.textWidth + 2 * INSET, this.textHeight + 2 * INSET);
    }

    public static void main(String[] args) {
        Frame f = new Frame();
        f.add("Center", new MultiLineLabel("Hi there.\nHow are you today?This is a list\n\nof several lines\nof text"));
        f.pack();
        f.show();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics g) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int baseline = fm.getAscent() + INSET;
        int i = 0;
        while (i < this.lines.size()) {
            g.drawString((String)this.lines.elementAt(i), INSET, baseline);
            baseline += fm.getHeight();
            ++i;
        }
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }
}

