<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ page import="com.maplesoft.mapleta.gradebook.struts.app.Constants" %>
<%@page import="com.maplesoft.mapleta.gradebook.struts.app.GradebookConfiguration"%>

<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic" %>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="http://displaytag.sf.net" prefix="display" %>
<%@ taglib uri="http://jakarta.apache.org/taglibs/log-1.0" prefix="log" %>

<%-- log start of jsp --%>

<%--
<c:set var="startTime"><%= System.currentTimeMillis() %></c:set>
<log:debug category="com.maplesoft.mapleta.gradebook.basicGradebookDisplayTable">JSP starting</log:debug>
--%>

<fmt:setBundle
	basename="com.maplesoft.mapleta.application.ApplicationResources"
	scope="request" />

<c:set var="NUMERIC" value="<%= new Integer(Constants.NUMERIC_CODE) %>" scope="page"/>
<c:set var="LETTER" value="<%= new Integer(Constants.LETTER_CODE) %>" scope="page"/>
<c:set var="PERCENTAGE" value="<%= new Integer(Constants.PERCENTAGE_CODE) %>" scope="page"/>
<c:set var="ASSIGNMENT_STATS_ACTION_CODE" value="<%= new Integer(Constants.ASSIGNMENT_STATS_ACTION_CODE) %>" scope="page" />
<c:set var="EDIT_WEIGHTINGS_ACTION_CODE" value="<%= new Integer(Constants.EDIT_WEIGHTINGS_ACTION_CODE) %>" scope="page" />
<c:set var="EDIT_TOTAL_POINTS_ACTION_CODE" value="<%= new Integer(Constants.EDIT_TOTAL_POINTS_ACTION_CODE) %>" scope="page" />

<tiles:useAttribute name="pager" scope="page" />

<c:set var="role"><tiles:getAsString name="role"/></c:set>
<%--
Render the javascript that populates the table header rows  on
the client side from a shadow table where the data is placed by
the server. Insert rows into the header of the main table to
display certain extra data. The taglib that manages
the rendering of the main table does not accommodate
exceptional rows, so we have to add them after the page
has loaded. The data to populate this table is found in 
<div> tags hidden in the text of the column headers when
the table is first rendered.      
--%>
<script type="text/javascript">
	var msgNothingToExport="<fmt:message key='msg.BasicGradebookDisplay.NothingToExport'/>";
	
	function insertSummaryStatisticsHeaderRows(_id) {
		var showAsgnWeighting = <c:out value="${viewSearchForm.showAsgnWeighting}"/>;
		var showAsgnTotalPoints = <c:out value="${viewSearchForm.showAsgnTotalPoints}"/>;
		var showAsgnNumAttempts = <c:out value="${viewSearchForm.showAsgnNumAttempts}"/>;
		var showAsgnAveScore = <c:out value="${viewSearchForm.showAsgnAveScore}"/>;
		var showAsgnAveNumAttempts = <c:out value="${viewSearchForm.showAsgnAveNumAttempts}"/>;
		
        var displayTable = document.getElementById(_id);
        var firstRow = displayTable.rows[0];
        var weightingRow = insertRow('<html:link href="javascript:doSubmit(${EDIT_WEIGHTINGS_ACTION_CODE})"><fmt:message key="label.weighting"/></html:link>', showAsgnWeighting,_id);
        var totalPointsRow = insertRow('<html:link href="javascript:doSubmit(${EDIT_TOTAL_POINTS_ACTION_CODE})"><fmt:message key="label.totalPoints"/></html:link>', showAsgnTotalPoints,_id);
        var numAttemptsRow = insertRow("<fmt:message key="label.numAttempts"/>", showAsgnNumAttempts,_id);
        var aveScoreRow = insertRow("<fmt:message key="label.aveScore"/>", showAsgnAveScore,_id);
        var aveNumAttemptsRow = insertRow("<fmt:message key="label.aveNumAttempts"/>", showAsgnAveNumAttempts,_id);
        
        var rows = [weightingRow, totalPointsRow, numAttemptsRow, aveScoreRow, aveNumAttemptsRow];
        var gchRE = /(\s|^)gradeColumnHeader(\s|$)/;
        var assignmentOrdinal = 0;
        
        for (i=1; i<firstRow.cells.length; i++) {
        	// (Start iterating at i=1 because the first column is empty as
        	// it is set by insertRow())
        	var headerCell = firstRow.cells[i];

        	if (gchRE.test(headerCell.className)) {
				
        		// Assignment grade column
        		assignmentOrdinal++;
        		
        		// The data to populate the cells is in a shadow table
	        	for (j=0; j<rows.length; j++) { 
	        		var row = rows[j];
	        		var cell = insertTh(row, i);
	        		
	        		cell.innerHTML = getSummaryStatistic(_id, j + 1, assignmentOrdinal);
	        	}
	        	
        	} else {
        		// If we're reading from a column heading that isn't for "grade"
        		// then just insert an empty cell to that position, for each of the
        		// extra rows.
        		for (j=0; j<rows.length; j++) {
	        		var row = rows[j];
	        		var cell = insertTh(row, i);
	        	}
        	}	
        }
	}
	// Utility function for insertExtraTableRows(). Create a new row in the main
	// table and initialize it.
	function insertRow(label, visible,_id) {
		return insertRowWh(label, visible, _id, 1);
	}

	function appendRow(label, visible,_id) {
		return insertRowWh(label, visible, _id, -1);
	}
	function insertRowWh(label, visible,_id, wh) {
        var displayTable = document.getElementById(_id);
		var row = displayTable.tHead.insertRow(wh);
		row.className = "extraData";
	    var cell = insertTh(row, 0);
		cell.innerHTML = label;
		cell.className = "title";
		//set display to "" so that browser will use its default. This gets around incompatibilites between browsers 
		row.style.display = visible ? "" : "none";
		return row;
	}
	
	// Read the text for the assignment name headers and string these
	// out along the top row of the table in cells with span wide enough
	// to cover the grade, start, end, etc columns.
	function insertAssignmentsHeaderRow(_id) {
        var displayTable = document.getElementById(_id);
        var tbody = displayTable.getElementsByTagName("tbody")[0];
        var pageSize = tbody.rows.length;
        var totalSize = ${pager.totalItemCount};
        var firstRow = displayTable.rows[0];
        var newFirstRow = displayTable.tHead.insertRow(0);
		newFirstRow.className = "assignmentNamesHeader";
        var span = findColumnSpan(); // How wide the header should be, based on the # of optional columns shown
        var insertPos = 0; // The current insertion position for a new cell
        var gchRE = /(\s|^)gradeColumnHeader(\s|$)/;
        
        for (i=0; i<firstRow.cells.length; i++) {
        	var headerCell = firstRow.cells[i];
        	
        	if (gchRE.test(headerCell.className)) {
        		var data = headerCell.getElementsByTagName("div");
        		var cell = insertTh(newFirstRow, insertPos);
        		if (data.length > 0)
	        		cell.innerHTML = data[0].innerHTML;
	        	cell.colSpan = span;
	        	//cell.className = "assignmentNameCell";
	        	i += (span - 1);
        	} else {
        		var cell = insertTh(newFirstRow, insertPos);
        	}
        	++insertPos;
        }
        
        if (getBrowserCategory() == 'gecko')
        {
	   		var cell = insertTh(newFirstRow, insertPos);
			cell.className="spacer";
		}
		
		//newFirstRow.cells[0].innerHTML = <c:choose><c:when test="${pager.requestedPageScrolling}">"Scrolling "</c:when><c:otherwise>"Showing "</c:otherwise></c:choose> + addCommas(pageSize) + " of " + addCommas(totalSize);
		
		newFirstRow.cells[0].innerHTML = <c:choose><c:when test="${pager.requestedPageScrolling}">"<fmt:message key='AssignmentListTable.Scrolling.Label' />"</c:when><c:otherwise>"<fmt:message key='AssignmentListTable.Showing.Label' />"</c:otherwise></c:choose>.replace("{0}",addCommas(pageSize)).replace("{1}",addCommas(totalSize)); 
	}
	
	// The table body scroll component we use depends on header cells being th.
	// insertCell() has no capability of inserting th elements. 
	// Hence this.
	function insertTh(row, insertPos)
	{
		var th = document.createElement('th');
		var currentCellCount = row.cells.length;
		if (insertPos < currentCellCount)
		{
			var ref = row.cells[insertPos]; 
			row.insertBefore(th, ref);
		}
		else
			row.appendChild(th);
		 
		return th;
	}
	
	function getSummaryStatistic(tableId, statNumber, assignmentOrdinal)
	{
		var shadowTableId = tableId.replace("display", "summary");
		var shadowTable = document.getElementById(shadowTableId);
		var tbody = shadowTable.getElementsByTagName("tbody")[0];
		var tr = tbody.rows[statNumber - 1];
		var td = tr.cells[assignmentOrdinal - 1];
		
		if (document.all)
			return td.innerText;
		else
			return td.textContent;
	}
	
	// From the options selected by ther user, determine how many 
	// columns each assignment's data spans.
	function findColumnSpan() {
		var showStartDate = <c:out value="${viewSearchForm.showStartDate}"/>;
		var showStartTime = <c:out value="${viewSearchForm.showStartTime}"/>;
		var showEndDate = <c:out value="${viewSearchForm.showEndDate}"/>;
		var showEndTime = <c:out value="${viewSearchForm.showEndTime}"/>;
		var showNumAttempts = <c:out value="${viewSearchForm.showNumAttempts}"/>;
		var showDuration = <c:out value="${viewSearchForm.showDuration}"/>;
		
		var n = 1;
		
		if (showStartDate || showStartTime) {
			++n;
		}
		
		if (showEndDate || showEndTime) {
			++n;
		}
		
		if (showNumAttempts) {
			++n;
		}
		
		if (showDuration) {
			++n;
		}
		
		return n;
	}
<%--
	tabShowing="${student}";
	function switchTabs(pre) {

		if( pre != tabShowing ) {
			var sTab = document.getElementById(pre+"GbkTab");
			var sDiv = document.getElementById(pre+"GbkDiv");
			var hTab = document.getElementById(tabShowing+"GbkTab");
			var hDiv = document.getElementById(tabShowing+"GbkDiv");
			
			sTab.className += " showTab";
			sDiv.className = sDiv.className.replace(/hide/,"show");
			hTab.className = hTab.className.replace(/\sshowTab/,"");
			hDiv.className = hDiv.className.replace(/show/,"hide");
			tabShowing = pre;
		}
		
		return false;
	}
--%>	
	function addCommas(nStr) {
		nStr += '';
		x = nStr.split('.');
		x1 = x[0];
		x2 = x.length > 1 ? '.' + x[1] : '';
		var rgx = /(\d+)(\d{3})/;
		while (rgx.test(x1)) {
			x1 = x1.replace(rgx, '$1' + ',' + '$2');
		}
		return x1 + x2;
	}
	

</script>

<c:if test="${GradeExportVisible}">
<c:choose>
	<c:when test="${GradeExportEnabled}">
		<script language="JavaScript">
			element = document.getElementById("GradeExportLink");
			element.href="<c:out value='${pager.gradeExportUri}' escapeXml='false'/>";
			element.title="<c:out value='${pager.gradeExportTitle}' escapeXml='false'/>";
		</script>
	</c:when>
	<c:otherwise>
		<script language="JavaScript">
			element = document.getElementById("GradeExportLink");
			element.href="javascript:{alert(msgNothingToExport);}";
			element.title="<c:out value='${pager.gradeExportTitle}' escapeXml='false'/>";
			
		</script>
	</c:otherwise>
</c:choose>
</c:if>

<%-- summaryTable${role} is a data container. It is hidden, and javascript extracts data from it. --%>
<div style="display:none">
	<table id="summaryTable${role}">
		<tbody>
			<c:forEach var="i" begin="1" end="5">
			<tr>
				<c:forEach var="col" items="${pager.taColumnDescriptors}">
				<td>
					<c:choose>
						<c:when test="${i == 1}"><fmt:formatNumber value="${col.weighting}" type="percent" maxFractionDigits="1"/></c:when>
						<c:when test="${i == 2}"><fmt:formatNumber value="${col.totalPoints}" /></c:when>
						<c:when test="${i == 3}"><fmt:formatNumber value="${col.numAttempts}" /></c:when>
						<c:when test="${i == 4}"><fmt:formatNumber value="${col.aveScore}" maxFractionDigits="2" /></c:when>
						<c:when test="${i == 5}"><fmt:formatNumber value="${col.aveNumAttempts}" maxFractionDigits="2" /></c:when>
					</c:choose>
				</td>
				</c:forEach>
				<c:forEach var="col" items="${pager.externalColumnDescriptors}">
				<td>
						<c:choose>
							<c:when test="${i == 1}"><fmt:formatNumber value="${col.weighting}" type="percent" maxFractionDigits="1"/></c:when>
							<c:when test="${i == 2}"><fmt:formatNumber value="${col.totalPoints}" /></c:when>
							<c:when test="${i == 3}"><fmt:formatNumber value="${col.numAttempts}" /></c:when>
							<c:when test="${i == 4}"><fmt:formatNumber value="${col.aveScore}" maxFractionDigits="2" /></c:when>
							<c:when test="${i == 5}"><fmt:formatNumber value="${col.aveNumAttempts}" maxFractionDigits="2" /></c:when>
						</c:choose>
				</td>
				</c:forEach>
				<td>
					<c:if test="${i == 2}"><fmt:formatNumber value="${pager.totalScore}" /></c:if>
				</td>
				<c:if test="${viewSearchForm.showAsgnWeighting && totalWeighting == 1}">
				<td>
					<c:if test="${i == 1}"><fmt:formatNumber value="${pager.weightedTotalScore}" /></c:if>
				</td>
				</c:if>
			</tr>
			</c:forEach>
		</tbody>
	</table>
</div>
<%-- 
	Render the clickable page labels.
--%>
<c:if test="${pager.pageCount > 1}">
<div>
	<table class="gridpages">
	<c:set var="links" value="${pager.pageLinks}" />
	<c:forEach items="${links}" var="link" varStatus="linkStatus" >
		<c:if test="${(linkStatus.count mod pager.configuredPageLinksRowWidth) == 1}">
		<tr>
		</c:if>
			<td <c:if test="${link.cssClass != ''}"> class="${link.cssClass}"</c:if> title="${link.title}">
				<a href="${link.href}">${link.text}</a>
			</td>	
		<c:if test="${(linkStatus.count mod pager.configuredPageLinksRowWidth) == 0 || linkStatus.last}">
		</tr>
		</c:if>
	</c:forEach>
	</table>
</div>
</c:if>

<div class="scrollableTableWrapper">
	<display:table 
		name="${pager.requestedPageItems}" id="row" htmlId="displayTable${role}"
		requestURI="gradebook/gradebook.do" 
		partialList="false"
		sort="external"
		defaultsort="2"
		cellspacing="0px" cellpadding="2px"
		class="scrollTable"
		export="true">
		
<%
	response.flushBuffer();
 %>		
		
		<%@ include file="/WEB-INF/jsp/displaytag_defaultProperties.jsp" %>
		<%-- <display:setProperty name="export.csv.filename"><fmt:message key='Display.export.csv.filename'/></display:setProperty> --%>
		<display:setProperty name="export.csv.filename" value="gradebook.csv" />
		
		<display:column >
			<%-- Include an empty column for the exta data fields to name --%>
		</display:column> 
		
		<%-- if beanList is empty, row will not be set and this will throw and exception so we need a check --%>
		<%-- because the contents of beanLest are a map, we need to use the bean:write and not ${} --%>
		<c:if test="${not empty row}">
		<c:set var="uid"><bean:write name="row" property="uid"/></c:set>
		</c:if>

		<c:set 
			var="href" 
			value="javascript:doSubmit(${ASSIGNMENT_STATS_ACTION_CODE},0,0,0,'${uid}')" />

		<c:if test="${viewSearchForm.showLastName}">
			<display:column media="html" titleKey="label.lastName" sortable="true" class="leftAlign" sortName="sn" >
				<html:link href="${href}">
					<bean:write name="row" property="sn"/>
				</html:link>
			</display:column>
			<display:column media="csv xml excel" titleKey="label.lastName" property="sn" class="leftAlign"/>
		</c:if>
		<c:if test="${viewSearchForm.showGivenName}">
			<display:column media="html" titleKey="label.firstName" sortable="true" class="leftAlign" sortName="givenName">
				<html:link href="${href}">
					<bean:write name="row" property="givenName"/>
				</html:link>
			</display:column>
			<display:column media="csv xml excel" titleKey="label.firstName" property="givenName" class="leftAlign"/>
		</c:if>
		<c:if test="${viewSearchForm.showMi}">
			<display:column media="html" titleKey="label.mi"class="leftAlign" sortable="true" sortName="mi">
				<html:link href="${href}">
					<bean:write name="row" property="mi"/>
				</html:link>
			</display:column>
			<display:column media="csv xml excel" titleKey="label.mi" property="mi" class="leftAlign"/>
		</c:if>
		<c:if test="${viewSearchForm.showUid}">
			<display:column media="html" titleKey="label.uid" class="leftAlign" sortable="true" sortName="uid" >
				<html:link href="${href}">
					<bean:write name="row" property="uid"/>
				</html:link>
			</display:column>
			<display:column media="csv xml excel" titleKey="label.uid" property="uid" class="leftAlign"/>
		</c:if>
		<c:if test="${viewSearchForm.showEmail}">
			<display:column media="html" titleKey="label.email" class="leftAlign" sortable="true" sortName="email">
				<html:link href="${href}">
					<bean:write name="row" property="email"/>
				</html:link>
			</display:column>
			<display:column media="csv xml excel" titleKey="label.email" property="email" class="leftAlign"/>
		</c:if>
		<c:if test="${viewSearchForm.showStudentId}">
			<display:column media="html" titleKey="label.studentId" class="leftAlign" sortable="true" sortName="studentId">
				<html:link href="${href}">
					<bean:write name="row" property="studentId"/>
				</html:link>
			</display:column>
			<display:column media="csv xml excel" titleKey="label.studentId" property="studentId" class="leftAlign"/>
		</c:if>
		<c:forEach var="col" items="${pager.taColumnDescriptors}">
			<c:set var="abbreviationCutoff" value="8" />
			<c:set var="span" value="${abbreviationCutoff}" />
			<c:if test="${viewSearchForm.showStartDate || viewSearchForm.showStartDate}">
				<c:set var="span" value="${span + abbreviationCutoff}" />
			</c:if>
			<c:if test="${viewSearchForm.showEndDate || viewSearchForm.showEndDate}">
				<c:set var="span" value="${span + abbreviationCutoff}" />
			</c:if>
			<c:if test="${viewSearchForm.showNumAttempts}">
				<c:set var="span" value="${span + abbreviationCutoff}" />
			</c:if>
			<c:if test="${viewSearchForm.showDuration}">
				<c:set var="span" value="${span + abbreviationCutoff}" />
			</c:if>
			<c:set var="abbreviatedTitle">
				<c:choose>
					<c:when test="${fn:length(col.title) < span}">
						<c:out value="${col.title}" escapeXml="false"/>
					</c:when>
					<c:otherwise>
						<c:out value="${fn:substring(col.title,0,span)}..." escapeXml="false"/>
					</c:otherwise>
				</c:choose>
			</c:set>
			<c:set var="gradeColumnTitle">
				<%-- This will be the text inserted into the <TH> elements for the       --%>
				<%-- columns containing the "grade" info. It holds hidden data in <div>s --%>
				<%-- Which the DHTML uses to populute other cells it adds to the table   --%>
				<%-- later.                                                              --%>
				<fmt:message key="label.grade" />
				<div style="display: none;" >
					<html:link href="javascript:viewAsgn(${col.actionId},${col.assignmentId})">
						<span  title="${col.title}"><c:out value="${abbreviatedTitle}"/></span>
					</html:link>
				</div>
			</c:set>
			<c:choose>
				<c:when test="${viewSearchForm.gradingStyle == NUMERIC}">
					<c:set var="decorator" value="com.maplesoft.mapleta.gradebook.displaytag.decorator.NumberDecorator" />
				</c:when>
				<c:when test="${viewSearchForm.gradingStyle == PERCENTAGE}">
					<c:set var="decorator" value="com.maplesoft.mapleta.gradebook.displaytag.decorator.PercentDecorator" />
				</c:when>
				<c:when test="${viewSearchForm.gradingStyle == LETTER}">
					<c:set var="decorator" value="com.maplesoft.mapleta.gradebook.displaytag.decorator.LetterGradeDecorator" />
				</c:when>
				<c:otherwise>
					<c:set var="decorator" value="com.maplesoft.mapleta.gradebook.displaytag.decorator.NumberDecorator" />
				</c:otherwise>
			</c:choose>
			<display:column media="html" property="${col.propertyName}" title="${gradeColumnTitle}" 
				decorator="${decorator}" headerClass="gradeColumnHeader" class="gradeColumn" 
				sortable="true" sortName="${col.propertyName}" />
			<display:column media="csv xml excel" property="${col.propertyName}" title="${col.title}" decorator="${decorator}" />
			
			<logic:notEmpty name="row" property="${col.propertyName}.start">
				<bean:define id="start" name="row" property="${col.propertyName}.start" type="java.util.Date" />
			</logic:notEmpty>
			<logic:empty name="row" property="${col.propertyName}.start">
				<c:set var="start"></c:set>
			</logic:empty>
			
			<c:choose>
				<c:when test="${ (empty start) && (viewSearchForm.showStartTime || viewSearchForm.showStartDate)}">
					<display:column  
						media="html"
						titleKey="label.start" 
						headerClass="startColumnHeader"
	 					sortable="true" sortName="${col.propertyName}.start"
						>
						<fmt:message key="label.decorator.number.empty"/>
					</display:column>
					<display:column  
						media="csv xml excel"
						titleKey="label.start" 
						headerClass="startColumnHeader"
	 					sortable="true" sortName="${col.propertyName}.start"
						>
						<fmt:message key="label.decorator.csv.number.empty"/>
					</display:column>
				</c:when>			
				<c:when test="${viewSearchForm.showStartTime && viewSearchForm.showStartDate}">
					<display:column  
						titleKey="label.start" 
						headerClass="startColumnHeader"
						sortable="true" sortName="${col.propertyName}.start"
						>
						<fmt:formatDate value="${start}" dateStyle="short" type="date"/> 
						<fmt:formatDate value="${start}" timeStyle="short" type="time"/>
					</display:column>
				</c:when>
				<c:when test="${viewSearchForm.showStartTime}">
					<display:column  
						titleKey="label.start" 
						headerClass="startColumnHeader"
						sortable="true" sortName="${col.propertyName}.start"
						>
						<fmt:formatDate value="${start}" timeStyle="short" type="time"/>
					</display:column>
				</c:when>
				<c:when test="${viewSearchForm.showStartDate}">
					<display:column  
						titleKey="label.start" 
						headerClass="startColumnHeader"
						sortable="true" sortName="start"
						>
						<fmt:formatDate value="${start}" dateStyle="short" type="date"/>
					</display:column>
				</c:when>
			</c:choose>
			
			<logic:notEmpty name="row" property="${col.propertyName}.end">
				<bean:define id="end" name="row" property="${col.propertyName}.end" type="java.util.Date" />
			</logic:notEmpty>
			<logic:empty name="row" property="${col.propertyName}.end">
				<c:set var="end"></c:set>
			</logic:empty>

			<c:choose>
				<c:when test="${ (empty end) && (viewSearchForm.showEndTime || viewSearchForm.showEndDate)}">
					<display:column  
						media="html"
						titleKey="label.end" 
						headerClass="endColumnHeader"
						sortable="true" sortName="${col.propertyName}.end"
						 >
						<fmt:message key="label.decorator.number.empty"/>
					</display:column>
					<display:column  
						media="csv xml excel"
						titleKey="label.end" 
						headerClass="endColumnHeader"
						sortable="true" sortName="${col.propertyName}.end"
						 >
						<fmt:message key="label.decorator.csv.number.empty"/>
					</display:column>
				</c:when>
				<c:when test="${viewSearchForm.showEndTime && viewSearchForm.showEndDate}">
					<display:column  
						titleKey="label.end" 
						headerClass="endColumnHeader"
						sortable="true" sortName="${col.propertyName}.end"
						>
						<fmt:formatDate value="${end}" dateStyle="short" type="date"/> <fmt:formatDate value="${end}" timeStyle="short" type="time"/>
					</display:column>
				</c:when>
				<c:when test="${viewSearchForm.showEndTime}">
					<display:column  
						titleKey="label.end" 
						headerClass="endColumnHeader"
						sortable="true" sortName="${col.propertyName}.end"
						>
						<fmt:formatDate value="${end}" timeStyle="short" type="time"/>
					</display:column>
				</c:when>
				<c:when test="${viewSearchForm.showEndDate}">
					<display:column  
						titleKey="label.end" 
						headerClass="endColumnHeader"
						sortable="true" sortName="${col.propertyName}.end"
						>
						<fmt:formatDate value="${end}" dateStyle="short" type="date"/>
					</display:column>
				</c:when>
			</c:choose>
			
			<c:if test="${viewSearchForm.showNumAttempts}">
				<display:column 
					property="${col.propertyName}.numAttempts"  
					titleKey="label.numAttempts" 
					headerClass="numAttemptsColumnHeader"
					sortable="true" sortName="${col.propertyName}.numAttempts"
					/>
			</c:if>
			
			<c:if test="${viewSearchForm.showDuration}">
				<display:column 
					property="${col.propertyName}"  
					titleKey="label.duration" 
					decorator="com.maplesoft.mapleta.gradebook.displaytag.decorator.DurationDecorator"
					sortable="true" sortName="${col.propertyName}.duration"
					/>
			</c:if>
		</c:forEach>
		
		<c:forEach var="col" items="${pager.externalColumnDescriptors}">
			<c:set var="abbreviationCutoff" value="8" />
			<c:set var="span" value="${abbreviationCutoff}" />
			<c:if test="${viewSearchForm.showStartDate || viewSearchForm.showStartDate}">
				<c:set var="span" value="${span + abbreviationCutoff}" />
			</c:if>
			<c:if test="${viewSearchForm.showEndDate || viewSearchForm.showEndDate}">
				<c:set var="span" value="${span + abbreviationCutoff}" />
			</c:if>
			<c:if test="${viewSearchForm.showNumAttempts}">
				<c:set var="span" value="${span + abbreviationCutoff}" />
			</c:if>
			<c:if test="${viewSearchForm.showDuration}">
				<c:set var="span" value="${span + abbreviationCutoff}" />
			</c:if>
			<c:set var="abbreviatedTitle">
				<c:choose>
					<c:when test="${fn:length(col.title) < span}">
						<c:out value="${col.title}"/>
					</c:when>
					<c:otherwise>
						<c:out value="${fn:substring(col.title,0,span)}..."/>
					</c:otherwise>
				</c:choose>
			</c:set>
			<c:set var="gradeColumnTitle">
				<%-- This will be the text inserted into the <TH> elements for the       --%>
				<%-- columns containing the "grade" info. It holds hidden data in <div>s --%>
				<%-- Which the DHTML uses to populute other cells it adds to the table   --%>
				<%-- later.                                                              --%>
				<fmt:message key="label.grade" />
				<div style="display: none;" >
					<html:link href="gradebook/AddExternal.do?asgnId=${col.assignmentId}">
						<span  title="${col.title}"><c:out value="${abbreviatedTitle}"/></span>
					</html:link>
				</div>
			</c:set>
			<c:choose>
				<c:when test="${viewSearchForm.gradingStyle == NUMERIC}">
					<c:set var="decorator" value="com.maplesoft.mapleta.gradebook.displaytag.decorator.NumberDecorator" />
				</c:when>
				<c:when test="${viewSearchForm.gradingStyle == PERCENTAGE}">
					<c:set var="decorator" value="com.maplesoft.mapleta.gradebook.displaytag.decorator.PercentDecorator" />
				</c:when>
				<c:when test="${viewSearchForm.gradingStyle == LETTER}">
					<c:set var="decorator" value="com.maplesoft.mapleta.gradebook.displaytag.decorator.LetterGradeDecorator" />
				</c:when>
				<c:otherwise>
					<c:set var="decorator" value="com.maplesoft.mapleta.gradebook.displaytag.decorator.NumberDecorator" />
				</c:otherwise>
			</c:choose>
			<display:column media="html" 
				property="${col.propertyName}" 
				title="${gradeColumnTitle}" 
				decorator="${decorator}" 
				headerClass="gradeColumnHeader" 
				sortable="true"
				sortName="ext.${col.propertyName}"
				/>
			<display:column media="csv xml excel" property="${col.propertyName}" title="${col.title}" decorator="${decorator}" />

			<logic:notEmpty name="row" property="${col.propertyName}.start">
				<bean:define id="start" name="row" property="${col.propertyName}.start" type="java.util.Date" />
			</logic:notEmpty>
			<logic:empty name="row" property="${col.propertyName}.start">
				<c:set var="start"></c:set>
			</logic:empty>
			
			<c:choose>
				<c:when test="${ (empty start) && (viewSearchForm.showStartTime || viewSearchForm.showStartDate)}">
					<display:column  
						media="html"
						titleKey="label.start" 
						headerClass="startColumnHeader"
						sortable="true" sortName="ext.${col.propertyName}.start"
						>
						<fmt:message key="label.decorator.number.empty"/>
					</display:column>
					<display:column  
						media="csv xml excel"
						titleKey="label.start" 
						headerClass="startColumnHeader"
						sortable="true" sortName="ext.${col.propertyName}.start"
						>
						<fmt:message key="label.decorator.csv.number.empty"/>
					</display:column>
				</c:when>			
				<c:when test="${viewSearchForm.showStartTime && viewSearchForm.showStartDate}">
					<display:column  
						titleKey="label.start" 
						headerClass="startColumnHeader"
						sortable="true" sortName="ext.${col.propertyName}.start"
						>
						<fmt:formatDate value="${start}" dateStyle="short" type="date"/> <fmt:formatDate value="${start}" timeStyle="short" type="time"/>
					</display:column>
				</c:when>
				<c:when test="${viewSearchForm.showStartTime}">
					<display:column  
						titleKey="label.start" 
						headerClass="startColumnHeader"
						sortable="true" sortName="ext.${col.propertyName}.start"
						>
						<fmt:formatDate value="${start}" timeStyle="short" type="time"/>
					</display:column>
				</c:when>
				<c:when test="${viewSearchForm.showStartDate}">
					<display:column  
						titleKey="label.start" 
						headerClass="startColumnHeader"
						sortable="true" sortName="ext.${col.propertyName}.start"
						>
						<fmt:formatDate value="${start}" dateStyle="short" type="date"/>
					</display:column>
				</c:when>
			</c:choose>
			
			<logic:notEmpty name="row" property="${col.propertyName}.end">
				<bean:define id="end" name="row" property="${col.propertyName}.end" type="java.util.Date" />
			</logic:notEmpty>
			<logic:empty name="row" property="${col.propertyName}.end">
				<c:set var="end"></c:set>
			</logic:empty>

			<c:choose>
				<c:when test="${ (empty end) && (viewSearchForm.showEndTime || viewSearchForm.showEndDate)}">
					<display:column  
						media="html"
						titleKey="label.end" 
						headerClass="endColumnHeader"
						sortable="true" sortName="$ext.{col.propertyName}.end"
						>
						<fmt:message key="label.decorator.number.empty"/>
					</display:column>
					<display:column  
						media="csv xml excel"
						titleKey="label.end" 
						headerClass="endColumnHeader"
						sortable="true" sortName="$ext.{col.propertyName}.end"
						>
						<fmt:message key="label.decorator.csv.number.empty"/>
					</display:column>
				</c:when>
				<c:when test="${viewSearchForm.showEndTime && viewSearchForm.showEndDate}">
					<display:column  
						titleKey="label.end" 
						headerClass="endColumnHeader"
						sortable="true" sortName="$ext.{col.propertyName}.end"
						>
						<fmt:formatDate value="${end}" dateStyle="short" type="date"/> <fmt:formatDate value="${end}" timeStyle="short" type="time"/>
					</display:column>
				</c:when>
				<c:when test="${viewSearchForm.showEndTime}">
					<display:column  
						titleKey="label.end" 
						headerClass="endColumnHeader"
						sortable="true" sortName="$ext.{col.propertyName}.end"
						>
						<fmt:formatDate value="${end}" timeStyle="short" type="time"/>
					</display:column>
				</c:when>
				<c:when test="${viewSearchForm.showEndDate}">
					<display:column  
						titleKey="label.end" 
						headerClass="endColumnHeader"
						sortable="true" sortName="$ext.{col.propertyName}.end"
						>
						<fmt:formatDate value="${end}" dateStyle="short" type="date"/>
					</display:column>
				</c:when>
			</c:choose>
			
			<c:if test="${viewSearchForm.showNumAttempts}">
				<display:column 
					property="${col.propertyName}.numAttempts"  
					titleKey="label.numAttempts" 
					headerClass="numAttemptsColumnHeader"
					sortable="true" sortName="$ext.{col.propertyName}.numAttempts"
					/>
			</c:if>
			
			<c:if test="${viewSearchForm.showDuration}">
				<display:column 
					property="${col.propertyName}"  
					titleKey="label.duration" 
					decorator="com.maplesoft.mapleta.gradebook.displaytag.decorator.DurationDecorator"
					headerClass="durationColumnHeader"
					sortable="true" sortName="$ext.{col.propertyName}.duration"
					/>
			</c:if>

		</c:forEach>
		
		<c:set var="gradeColumnTitle">
			<%-- This will be the text inserted into the <TH> elements for the       --%>
			<%-- columns containing the "grade" info. It holds hidden data in <div>s --%>
			<%-- Which the DHTML uses to populute other cells it adds to the table   --%>
			<%-- later.                                                              --%>
			<fmt:message key="label.total" />
		</c:set>
		<display:column 
			property="total"
			title="${gradeColumnTitle}"
			decorator="${decorator}"
			headerClass="gradeColumnHeader"
			sortable="true" sortName="total"
		/>
		<c:if test="${viewSearchForm.showAsgnWeighting && totalWeighting == 1}">
			<c:set var="gradeColumnTitle">
				<%-- This will be the text inserted into the <TH> elements for the       --%>
				<%-- columns containing the "grade" info. It holds hidden data in <div>s --%>
				<%-- Which the DHTML uses to populute other cells it adds to the table   --%>
				<%-- later.                                                              --%>
				<fmt:message key="label.weightedTotal" />
			</c:set>
			<display:column 
				property="weightedTotal"
				title="${gradeColumnTitle}"
				decorator="com.maplesoft.mapleta.gradebook.displaytag.decorator.GradeDecorator"
				headerClass="gradeColumnHeader"
				sortable="true" sortName="weightedTotal"
			/>
		</c:if>

	 </display:table>
	 
	 <%-- 
	 	Write the script to post-process the table 
	 --%>
	 <script>
	 	var tableId = "displayTable${role}";
	 	insertSummaryStatisticsHeaderRows(tableId);
	 	insertAssignmentsHeaderRow(tableId);
	 </script>

<c:if test="${pager.requestedPageScrolling}">

<script>
	var browser = getBrowserCategory();
	if (browser != 'ie')
	{
		var scrollerHeight = ${pager.configuredScrollWindowRowHeight} * ${pager.configuredNonIeEmsPerRow} + 'em'; 
		document.writeln("<style type='text/css'>  div.scrollableTableWrapper tbody { overflow: auto; height: " + scrollerHeight + "; }</style>");
	}
	else if (typeof tableScroll == 'function')
	{
		var _id = 'displayTable${role}';
      	var displayTable = document.getElementById(_id);
        var thead = displayTable.getElementsByTagName("thead")[0];
        var headSize = thead.rows.length;
		var scrollerHeight = ((headSize + ${pager.configuredScrollWindowRowHeight}) * ${pager.configuredIeEmsPerRow}) + 'em'; 
		document.writeln('<style type="text/css">.tableBoxOuter { width: 100%; height: ' + scrollerHeight + '; }</style>');
		
		tableScroll(_id);
	}
</script>
		
</c:if>
</div>
<%-- log end of jsp --%>
<%--
<c:set var="endTime"><%= System.currentTimeMillis() %></c:set>
<c:set var="rowCount" value="${pager.totalItemCount}" />
<log:debug category="com.maplesoft.mapleta.gradebook.basicGradebookDisplayTable">Complete, total time = <fmt:formatNumber value="${(endTime - startTime) / 1000.0}" maxFractionDigits="1" minFractionDigits="1" /> secs, table rows = <fmt:formatNumber value="${rowCount}" groupingUsed="true" /></log:debug>
--%>
