<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles" %>

<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>

<tiles:useAttribute name="subItems" ignore="true"/>
<fmt:bundle basename="com.maplesoft.mapleta.application.ApplicationResources">

<c:forEach var="subItem" items="${subItems}">
	<c:choose>
		<c:when test="${subItem.parent && !subItem.disabled}">
			<span class="parent " onmouseover="hoverRight(this);" onmouseout="hoverRightOff(this);">
			<fmt:message key="${subItem.label}" />
			<div class="subSubMenu1">
			<div class="subSubMenu2">
			<tiles:insert page="/WEB-INF/tiles/mainMenu/subMenu.jsp" flush="false">
				<tiles:put name="subItems" beanName="subItem" beanProperty="subItems" />
			</tiles:insert>
			</div>
			</div>
			</span>
		</c:when>
		<c:otherwise>
			<c:choose>
				<c:when test="${subItem.disabled || subItem.separator || empty subItem.url}">
					<c:set var="class" value=""/>
					<c:if test="${subItem.disabled}">
						<c:set var="class" value="disabled"/>
					</c:if>
					<c:if test="${subItem.separator}">
						<c:set var="class" value="separator disabled"/>
					</c:if>
					<c:choose>
						<c:when test="${subItem.label=='MenuItem.actions.assignment.question_items'}">
							<span class="${class}"><span id="jump"></span></span>
						</c:when >
						<c:when test="${subItem.label=='MenuItem.actions.assignment.hint_items'}">
							<span class="${class}"><span id="hints"></span></span>
						</c:when >
						<c:otherwise>
							<span class="${class}"><fmt:message key="${subItem.label}" /></span>
						</c:otherwise>
					</c:choose>
				</c:when>
				<c:otherwise>
					<a href="${subItem.url}"><fmt:message key="${subItem.label}" /></a>
				</c:otherwise>
			</c:choose>
		</c:otherwise>
	</c:choose>
</c:forEach>

</fmt:bundle>
