<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ page import="com.maplesoft.mapleta.classadmin.Constants" %>
<%@ taglib uri="http://jakarta.apache.org/struts/tags-html" prefix="html"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>

<c:set var="delete"><%= com.maplesoft.mapleta.classadmin.Constants.LIST_DELETE %></c:set>
<c:set var="restore"><%= com.maplesoft.mapleta.classadmin.Constants.LIST_RESTORE %></c:set>
<c:set var="list"><%= com.maplesoft.mapleta.classadmin.Constants.LIST %></c:set>
<c:choose>
	<c:when test="${SearchForm.mode == list}">
		<c:set var="formAction" value="/DisplayClasses"/>
	</c:when>
	<c:when test='${SearchForm.mode == delete}'>
		<c:set var="formAction" value="/ChooseDelete"/>
	</c:when>
	<c:when test='${SearchForm.mode == restore}'>
		<c:set var="formAction" value="/ChooseRestore"/>
	</c:when>
</c:choose>

<%-- Import the JSCalendar --%>
<style type="text/css">@import url(jscalendar-1.0/skins/aqua/theme.css);</style>
<script type="text/javascript" src="jscalendar-1.0/calendar.js"></script>
<script type="text/javascript" src="jscalendar-1.0/lang/calendar-en.js"></script>
<script type="text/javascript" src="jscalendar-1.0/lang/calendar-${MTA_LOCALE}-utf8.js"></script>
<script type="text/javascript" src="jscalendar-1.0/calendar-setup.js"></script>

<fmt:bundle basename="com.maplesoft.mapleta.application.ApplicationResources">

<div class="classSearch">

	<html:form action="${formAction}">
	<html:hidden property="filter" value="<%= Constants.FILTER_FORM %>"/>
	<html:hidden property="mode"/>
		<table>
			<tr>
				<th colspan="3" align="left"><fmt:message key="SearchForm.class.label"/></th>
				<th></th>
				<th colspan="3" align="left"><fmt:message key="SearchForm.instructor.label"/></th>
			</tr>

			<tr>
				<td><strong><fmt:message key="SearchForm.courseid.label"/></strong></td>
				<td><html:text property="courseId" size="20"/></td>
				<td>
					<html:select property="courseIdExact">
						<html:option value="false"><fmt:message key="ClassSearch.anywhere.label" /></html:option>
						<html:option value="true"><fmt:message key="ClassSearch.exact.label" /></html:option>
					</html:select>
				</td>
				<td width="20">&nbsp;</td>
				<td><strong><fmt:message key="SearchForm.sn.label"/></strong></td>
				<td><html:text property="instructor" size="20"/></td>
				<td>
					<html:select property="instructorExact">
						<html:option value="false"><fmt:message key="ClassSearch.anywhere.label" /></html:option>
						<html:option value="true"><fmt:message key="ClassSearch.exact.label" /></html:option>
					</html:select>
				</td>			
			</tr>
			<tr>
				<td><strong><fmt:message key="SearchForm.name.label"/></strong></td>
				<td><html:text property="className" size="20"/></td>
				<td>
					<html:select property="classNameExact">
						<html:option value="false"><fmt:message key="ClassSearch.anywhere.label" /></html:option>
						<html:option value="true"><fmt:message key="ClassSearch.exact.label" /></html:option>
					</html:select>
				</td>
				<td width="20">&nbsp;</td>
				<td><strong><fmt:message key="SearchForm.email.label"/></strong></td>
				<td><html:text property="email" size="20"/></td>
				<td>
					<html:select property="emailExact">
						<html:option value="false"><fmt:message key="ClassSearch.anywhere.label" /></html:option>
						<html:option value="true"><fmt:message key="ClassSearch.exact.label" /></html:option>
					</html:select>
				</td>
			</tr>
			<tr>
				<c:choose>
					<c:when test="${SearchForm.mode == list}">
						<td><strong><fmt:message key="SearchForm.deleted.label"/></strong></td><td><html:checkbox property="deleted"/></td>
					</c:when>
					<c:otherwise>
							<html:hidden property="deleted"/>
					</c:otherwise>
				</c:choose>
			</tr>

			<tr>
				<td><strong><fmt:message key="SearchForm.creationdate.label"/></strong></td>
				<td colspan="5">
					<html:select property="creationDateOption">
						<html:option value="0"><fmt:message key="ClassSearch.before.label" /></html:option>
						<html:option value="1"><fmt:message key="ClassSearch.on.label" /></html:option>
						<html:option value="2"><fmt:message key="ClassSearch.after.label" /></html:option>
					</html:select>
					<html:hidden property="creationDate" styleId="dateRangeStart_if" />
					<input type="text" readonly="true" id="dateRangeStart_da">
					<img src="jscalendar-1.0/img.gif" id="dateRangeStart_trigger">
					<a href="clear" onclick="document.getElementById('dateRangeStart_if').value='';document.getElementById('dateRangeStart_da').value='';return false;"><fmt:message key="ClassSearch.clear.label" /></a>
				</td>
			</tr>
		</table>
		<c:set var="reset_label">
			<fmt:message key="SearchForm.reset_fields.label" />
		</c:set>
		<br />
		<input type="button" class="button" value="${reset_label}" onclick="javascript:this.form.mode.value = 'reset'; this.form.submit();" />
		<html:submit styleClass="button"><fmt:message key="SearchForm.search.label"/></html:submit>
	</html:form>

</div>

</fmt:bundle>

<script type="text/javascript">
	<%-- Simple i18n of date format --%>
	var daFmt=Calendar._TT["DEF_DATE_FORMAT"];

	// Create a Calenar object
	// create this onload so that it works in IE, there is a known race condition
	// with timeouts in IE that throws exception if this is not created on page load
	window.onload=function() {
		window.calendar = new Calendar();
		window.calendar.create();
	}
	
	// When the page is loaded, use the epoch timestamp that was
	// provided by the form bean, if any, to initialize the display. 
	function calInit(ifStr, daStr) {
		var displayArea = document.getElementById(daStr);
		var inputField = document.getElementById(ifStr);
		
		if (inputField.value) {
			var i = parseInt(inputField.value);
			if (i > 0) {
				var d = new Date(parseInt(inputField.value));
				displayArea.value = d.print(daFmt);
			}
		}
	}
	calInit("dateRangeStart_if", "dateRangeStart_da");
	
	// Event handler for when the popup button is clicked
	function calOnClick(clicker, ifStr, daStr) {
		var cal = window.calendar;
		var inputField = document.getElementById(ifStr);
		var displayArea = document.getElementById(daStr);
		
		// Event handler to perform when a date is selected.
		// Note that the action performed will target the 
		// inputField and displayArea of the selector that was
		// last clicked.
		cal.onSelected = function (cal, date) {
		
			inputField.value = cal.date.print("%s") + "000"; // Use milliseconds since Epoch
			displayArea.value = cal.date.print(daFmt);
		
			cal.hide(); // one-click behavior
		};
		
		// Event handler for when the calendar is closed. Since a shared
		// calendar is cached, merely hide it.
		cal.onClose = function (cal) {
			cal.hide();
		};
		
		// Set the calendar to the date carried by the form bean, if any
		if (inputField.value) {
			var i = parseInt(inputField.value);
			if (i > 0) {
				cal.setDate(new Date(i));
			} else {
				cal.setDate(new Date());
			}
		}
		cal.showAtElement(clicker);
	}
	
	document.getElementById("dateRangeStart_trigger").onclick = function () {
		calOnClick(this, "dateRangeStart_if", "dateRangeStart_da");
	};
	

</script>
