<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>

<%@ taglib uri="http://www.rabago.net/tags-valid2" prefix="html2"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>


<style>
	table.hidden tbody {
		display:none;
	}

	table .expand {
		width:10px;
	}
	
	table .date {
		width:250px;
		text-align:left;
	}
	
	table .total, table .max, table .started, table .finished {
		width:30px;
		text-align:center;
	}
	
	table .entries, table .started, table .finished {
		width:60px;
		text-align:center;
	}
	
	table .start, table .end {
		width:50px;
		text-align:center;
	}

	tr .odd {
		background-color: #ffc;
	}

</style>

<script>

function toggle(_id) {
	var table = document.getElementById('table_' + _id);
	var img = document.getElementById('img_' + _id);
	if( table.className == 'hidden' ) {
		table.className = '';
		img.src = "modules/skin/images/misc/collapse.gif";
	}
	else {
		table.className = 'hidden';
		img.src = "modules/skin/images/misc/expand.gif";
	}
}

function submitStart(_start) {
	var start = document.getElementById("start_if");
	var form = document.getElementById("usageForm");
	start.value = _start;
	form.submit();
}
function submitEnd(_end) {
	var end = document.getElementById("end_if");
	var form = document.getElementById("usageForm");
	end.value = _end;
	form.submit();
}function submitView(_view) {
	var view = document.getElementById("view");
	var form = document.getElementById("usageForm");
	view.value = _view;
	form.submit();
}



</script>

<style type="text/css">@import url(jscalendar-1.0/skins/aqua/theme.css);</style>
<script type="text/javascript" src="jscalendar-1.0/calendar.js"></script>
<script type="text/javascript" src="jscalendar-1.0/lang/calendar-en.js"></script>
<script type="text/javascript" src="jscalendar-1.0/lang/calendar-${MTA_LOCALE}-utf8.js"></script>
<script type="text/javascript" src="jscalendar-1.0/calendar-setup.js"></script>

<fmt:bundle	basename="com.maplesoft.mapleta.application.ApplicationResources">

<logic:messagesPresent>
<html:messages id="msg" message="false">
	<span class="errorStyle1"><c:out value='${msg}' escapeXml="false"/></span>
	<br>
</html:messages>
<br/>
</logic:messagesPresent>

<html:form action="Usage.do" method="post" styleId="usageForm">
	<html:hidden property="view" styleId="view"/>

<table>
	<tr>
		<td><fmt:message key="UsageForm.start.date.label"/></td>
		<td>
			<html:hidden property="start" styleId="start_if" />
			<input type="text" readonly="true" id="start_da" size="30">
			<img src="jscalendar-1.0/img.gif" id="start_trigger">
		</td>
		<td>
			<a href="#" onclick="clearDate('start_if','start_da');return false;"><fmt:message key="UsageForm.clear.label"/></a>
		</td>
	
	</tr>
	<tr>
		<td><fmt:message key="UsageForm.end.date.label"/></td>
		<td>
			<html:hidden property="end" styleId="end_if" />
			<input type="text" readonly="true" id="end_da" size="30">
			<img src="jscalendar-1.0/img.gif" id="end_trigger">
		</td>
		<td>
			<a href="#" onclick="clearDate('end_if','end_da');return false;"><fmt:message key="UsageForm.clear.label"/></a>
		</td>
	</tr>
	<tr>
		<td><html:checkbox property="includeZeroValues" styleId="includeZeroValues"/></td>
		<td><label for="includeZeroValues"><fmt:message key="UsageForm.includezeroes.label"/></label></td>
	</tr>
	<tr>
		<td><html:checkbox property="showAllData" styleId="showAllData"/></td>
		<td><label for="showAllData"><fmt:message key="UsageForm.showallentries.label"/></label></td>
	</tr>
</table>
<html:submit styleClass="button"><fmt:message key="JspDefault.Submit.Button"/></html:submit>
<html:submit styleClass="button"><fmt:message key="UsageForm.refresh.label" /></html:submit>
<br/><br/>

<div>
	<fmt:message key="UsageForm.orderby.label"/>:
	<c:choose>
		<c:when test="${UsageForm.view == 'restart'}">
			<fmt:message key="UsageForm.restart.label" />
		</c:when>
		<c:otherwise>
			<html:link href="javascript:submitView('restart');"><fmt:message key="UsageForm.restart.label" /></html:link>
		</c:otherwise>
	</c:choose>
	|
	<c:choose>
		<c:when test="${UsageForm.view == 'hour'}">
			<fmt:message key="UsageForm.hour.label" />
		</c:when>
		<c:otherwise>
			<html:link href="javascript:submitView('hour');"><fmt:message key="UsageForm.hour.label" /></html:link>
		</c:otherwise>
	</c:choose>
	|
	<c:choose>
		<c:when test="${UsageForm.view == 'day'}">
			<fmt:message key="UsageForm.day.label" />
		</c:when>
		<c:otherwise>
			<html:link href="javascript:submitView('day');"><fmt:message key="UsageForm.day.label" /></html:link>
		</c:otherwise>
	</c:choose>
	|
	<c:choose>
		<c:when test="${UsageForm.view == 'week'}">
			<fmt:message key="UsageForm.week.label" />
		</c:when>
		<c:otherwise>
			<html:link href="javascript:submitView('week');"><fmt:message key="UsageForm.week.label" /></html:link>
		</c:otherwise>
	</c:choose>
	|
	<c:choose>
		<c:when test="${UsageForm.view == 'month'}">
			<fmt:message key="UsageForm.month.label" />
		</c:when>
		<c:otherwise>
			<html:link href="javascript:submitView('month');"><fmt:message key="UsageForm.month.label" /></html:link>
		</c:otherwise>
	</c:choose>
	|
	<c:choose>
		<c:when test="${UsageForm.view == 'year'}">
			<fmt:message key="UsageForm.year.label" />
		</c:when>
		<c:otherwise>
			<html:link href="javascript:submitView('year');"><fmt:message key="UsageForm.year.label" /></html:link>
		</c:otherwise>
	</c:choose>
&nbsp;&nbsp;
	<html:select property="useStartDate">
		<html:option value="true"><fmt:message key='UsageForm.usestartdate.label'/></html:option>
		<html:option value="false"><fmt:message key='UsageForm.rounddate.label'/></html:option>
	</html:select>

</div>
</html:form>
<table border="0">
<tr>
	<th class="expand"></th>
	<th class="date"></th>
	<th class="total" colspan="2"><fmt:message key="UsageForm.users.label" /></th>
	<th class="entries"></th>
	<th class="finished" colspan="2"><fmt:message key="UsageForm.assignments.label" /></th>
	<th class="entries"></th>
	<th class="start"></th>
	<th class="end"></th>
</tr>
<tr>
	<th class="expand"></th>
	<th class="date"><fmt:message key="UsageForm.date.label" /></th>
	<th class="total"><fmt:message key="UsageForm.avg.label" /></th>
	<th class="max"><fmt:message key="UsageForm.max.label" /></th>
	<th class="entries"><fmt:message key="UsageForm.logins.label" /></th>
	<th class="started"><fmt:message key="UsageForm.started.label" /></th>
	<th class="finished"><fmt:message key="UsageForm.finished.label" /></th>
	<th class="entries"><fmt:message key="UsageForm.entries.label" /></th>
	<th class="start"></th>
	<th class="end"></th>
</tr>
</table>

<c:set var="totalEntries" value="0"/>
<c:set var="logins" value="0"/>
<c:set var="started" value="0"/>
<c:set var="finished" value="0"/>

<c:set var="count" value="0"/>
<logic:notEmpty name="usage">
<logic:iterate id="node" name="usage" >
<c:set var="count" value="${count+1}"/>

<c:set var="totalEntries" value="${totalEntries+node.size}"/>
<c:set var="logins" value="${logins+node.logins}"/>
<c:set var="started" value="${started+node.startedAssignments}"/>
<c:set var="finished" value="${finished+node.finishedAssignments}"/>


<table id="table_${node.time}" class="hidden" border="0">
<thead>
	<tr>
		<th class="expand">
			<c:choose>
			<c:when test="${fn:length(node.leaves) > 0}">
				<a href="javascript:toggle('${node.time}')" onclick="">
					<img src="modules/skin/images/misc/expand.gif" border="true" id="img_${node.time}"/>
				</a>
			</c:when>
			<c:otherwise>&nbsp;&nbsp;</c:otherwise>
			</c:choose>
		</th>
		<th class="date">
			<fmt:formatDate value="${node.date}" dateStyle="full" type="date"/> <fmt:formatDate value="${node.date}" timeStyle="short" type="time"/>
		</th>
		<th class="total"><fmt:formatNumber value="${node.avgUsers}" /></th>
		<th class="max">${node.max}</th>
		<th class="entries">${node.logins}</th>
		<th class="started">${node.startedAssignments}</th>
		<th class="finished">${node.finishedAssignments}</th>
		<th class="entries">${node.size}</th>
		<th class="start">
			<c:if test="${count < fn:length(usage)}">
				<html:link href="javascript:submitStart('${node.time}');"><fmt:message key="UsageForm.start.label" /></html:link>
			</c:if>
		</th>
		<th class="end">
			<c:if test="${count > 1}">
				<html:link href="javascript:submitEnd('${node.time}');"><fmt:message key="UsageForm.end.label" /></html:link>
			</c:if>
		</th>
	</tr>
</thead>
<tbody>
	<logic:iterate id="row" name="node" property="leaves" indexId="c">
	<c:set var="oddeven">odd</c:set>
	<c:if test="${c % 2 == 0}"><c:set var="oddeven">even</c:set></c:if>
	<tr class="${oddeven}">
		<td class="expand">&nbsp;</td>
		<td class="date">
			<fmt:formatDate value="${row.logTime}" dateStyle="long" type="date"/> <fmt:formatDate value="${row.logTime}" timeStyle="medium" type="time"/>
		</td>
		<td class="total">${row.count}</td>
		<td class="max">&nbsp;</td>
		<td class="entries">${row.logins}</td>
		<td class="started">${row.startedAssignments}</td>
		<td class="finished">${row.finishedAssignments}</td>
		<td class="entries">&nbsp;</td>
		<td class="start">
			<html:link href="javascript:submitStart('${row.logTime.time}');"><fmt:message key="UsageForm.start.label" /></html:link>
		</td>
		<td class="end">
			<html:link href="javascript:submitEnd('${row.logTime.time}');"><fmt:message key="UsageForm.end.label" /></html:link>
		</td>
	</tr>
	</logic:iterate>
</tbody>
</table>
</logic:iterate>
</logic:notEmpty>


</fmt:bundle>

<script type="text/javascript">
	<%-- Simple i18n of date format --%>
//	var daFmt = "%A, %B %e, %Y";
	var daFmt=Calendar._TT["DEF_DATE_FORMAT"];
		
	// Create a Calenar object 
	// create this onload so that it works in IE, there is a known race condition
	// with timeouts in IE that throws exception if this is not created on page load
	window.onload=function() {
		window.calendar = new Calendar();
		window.calendar.create();
	}
	
	// When the page is loaded, use the epoch timestamp that was
	// provided by the form bean, if any, to initialize the display. 
	function calInit(ifStr, daStr) {
		var displayArea = document.getElementById(daStr);
		var inputField = document.getElementById(ifStr);
		
		if (inputField.value) {
			var i = parseInt(inputField.value);
			if (i > 0) {
				var d = new Date(parseInt(inputField.value));
				displayArea.value = d.print(daFmt);
			}
		}
	}
	calInit("start_if", "start_da");
	calInit("end_if", "end_da");
	
	// Event handler for when the popup button is clicked
	function calOnClick(clicker, ifStr, daStr) {
		var cal = window.calendar;
		var inputField = document.getElementById(ifStr);
		var displayArea = document.getElementById(daStr);
		
		// Event handler to perform when a date is selected.
		// Note that the action performed will target the 
		// inputField and displayArea of the selector that was
		// last clicked.
		cal.onSelected = function (cal, date) {
		
			inputField.value = cal.date.print("%s") + "000"; // Use milliseconds since Epoch
			displayArea.value = cal.date.print(daFmt);
		
			cal.hide(); // one-click behavior
		};
		
		// Event handler for when the calendar is closed. Since a shared
		// calendar is cached, merely hide it.
		cal.onClose = function (cal) {
			cal.hide();
		};
		
		// Set the calendar to the date carried by the form bean, if any
		if (inputField.value) {
			var i = parseInt(inputField.value);
			if (i > 0) {
				cal.setDate(new Date(i));
			} else {
				cal.setDate(new Date());
			}
		}
		cal.showAtElement(clicker);
	}
	
	function clearDate(ifStr, daStr) {
		var inputField = document.getElementById(ifStr);
		var displayArea = document.getElementById(daStr);
		inputField.value="";
		displayArea.value="";	
	}
	
	document.getElementById("start_trigger").onclick = function () {
		calOnClick(this, "start_if", "start_da");
	};
	
	document.getElementById("end_trigger").onclick = function () {
		calOnClick(this, "end_if", "end_da");
	};
</script>