<br><%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ page import="com.maplesoft.mapleta.gateway.GatewayService"%>
<%@ page import="com.maplesoft.mapleta.session.Role" %>
<%@ page import="com.maplesoft.mapleta.session.Context" %>
<%@page import="com.maplesoft.mapleta.gbk.Constants"%>

<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic" %>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<tiles:useAttribute name="questionTable"/>
<tiles:useAttribute name="showUserHeaders"/>

<script src="<%=request.getContextPath()%>/modules/scripts/gbk.js"></script>
<script src="<%=request.getContextPath()%>/modules/scripts/ajax.js"></script>

<c:set var="ADMINISTRATOR"><%= Role.ADMINISTRATOR %></c:set>
<c:set var="INSTRUCTOR"><%= Role.INSTRUCTOR %></c:set>
<c:set var="PROCTOR"><%= Role.PROCTOR %></c:set>
<c:set var="role"><%= Context.getContext(request.getSession()).getRole() %></c:set>

<c:set var="SORT_GRADE"><%= Constants.SORT_GRADE %></c:set>
<c:set var="SORT_GRADE_DESC"><%= Constants.SORT_GRADE_DESC %></c:set>
<c:set var="SORT_POSITION"><%= Constants.SORT_POSITION %></c:set>
<c:set var="SORT_POSITION_DESC"><%= Constants.SORT_POSITION_DESC %></c:set>

<script>
function updateItem(_pos) {
	var xmlHttp=GetXmlHttpObject();
	if (xmlHttp==null) {
  		alert ("Your browser does not support AJAX!");
  		return;
	} 
	
	var position = document.getElementById('position' + _pos);
	var grade = document.getElementById('grade' + _pos);
	var comment = document.getElementById('comment' + _pos).value;
	var text = document.getElementById('text' + _pos).value;
	var userId = document.getElementById('studentid' + _pos);
	var trId = document.getElementById('trId' + _pos);
	var classId  = document.getElementById('classId' + _pos);
	var detailView  = document.getElementById('detailView');

	var item = "item"+_pos;

	var img = '<td></td>';
	img = img + '<td><img style="padding:15px;" src="<%=request.getContextPath()%>/modules/skin/images/misc/loading.gif"/></td><td></td><c:if test="${role == ADMINISTRATOR || role==INSTRUCTOR || role == PROCTOR }"><td></td><td></td></c:if>';
	document.getElementById(item).innerHTML = img;

	var url="<%=request.getContextPath()%>/gradebook/UpdateGradeItem.do";
	var params = ""; 
	params += "position="+position.value + "&";
	params += "userId="+userId.value + "&";
	params += "trId="+trId.value + "&";
	params += "classId="+classId.value + "&";
	params += "detailView="+detailView.value + "&";
	if( grade.value ) {
		params += "grade="+ grade.value + "&";
	}

	if( comment ) {
		params += "comment="+ comment + "&";
	}
	if( text ) {
		params += "text="+ text;
	}

	xmlHttp.onreadystatechange=function() {
		if (xmlHttp.readyState==4) { 
			document.getElementById(item).innerHTML=xmlHttp.responseText;
		}
	}
	
	xmlHttp.open("POST",url,true);
	//Send the proper header information along with the request
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", params.length);
	xmlHttp.setRequestHeader("Connection", "close");
	
	xmlHttp.send(params);

}

function submit1() {
	var form = document.getElementById('viewSearchForm');
	form.action = "gradebook/UpdateAllGradeItems.do";
	form.submit();
}

	function verifyGrades() {
		
		var num = ${fn:length(itemDetailList)};
		for( i=0; i<num; i++) {
			var grade = document.getElementById('grade'+i);
			if( !validateNumber(grade) ) {
				return false;
			}
		}
		return true;	
	}

	function enableComment(_id) {
		var grade = document.getElementById('grade'+_id);
		var href = document.getElementById('href'+_id);
		var error = document.getElementById('gradeError'+_id);

		var isNum = validateNumber(grade);
		if( isNum && grade.value) {
			error.style.display="none";
			href.style.display="inline";
		}
		else if( grade.value == '') {
			href.style.display="none";
			error.style.display="none";
		}
		else {
			error.style.display="inline";
			href.style.display="none";
		}
	}

    function validateNumber(field) {
        var fieldValue = getValueFromField(field);
		return !isNaN(fieldValue);
    }

    function getValueFromField(field) {
        var fieldValue = '';
        if (field != null && field.length > 0 && field[0].type == 'radio') {w
            for (var x=0; x < field.length; x++) {
                if (field[x].disabled == false && field[x].checked) {
                    fieldValue = field[x].value;
                    break;
                }
            }
        } else if (field != null && field.disabled == false) {
            if (field.type == 'hidden' || field.type == 'password' ||
                field.type == 'text'   || field.type == 'textarea' ||
                field.type == 'radio'  || field.type == 'file') {
                fieldValue = field.value;
            }
            if (field.type == 'select-one') {
                var si = field.selectedIndex;
                if (si >= 0) {
                    fieldValue = field.options[si].value;
                }
            }
        }
        return fieldValue == null ? '' : fieldValue;
    }

function reverseItems(name) {
	var boxes = document.getElementsByName(name);
	for (i = 0; i < boxes.length; i++) {
		boxes[i].checked = !boxes[i].checked;
	}
}

function changeGradeValues(name) {

	var boxes = document.getElementsByName(name);
	var newValue = document.getElementById('newGradeValue');
	var error = document.getElementById('newGradeError');

	var isNum = validateNumber(newValue);
	if( !isNum ) {
		error.style.display="inline";
		return false;
	}
	error.style.display="none";

	for (i = 0; i < boxes.length; i++) {
		if( boxes[i].checked ) {
			var tmp = boxes[i].value;
			document.getElementById('grade' + tmp).value = newValue.value;
		}
	}
}

function updateGrades() {
	var boxes = document.getElementsByName('questions');
	for (i = 0; i < boxes.length; i++) {
		if( boxes[i].checked ) {
			var tmp = boxes[i].value;
			updateItem(tmp);
		}
	}

}

</script>
<fmt:setBundle 
	basename="com.maplesoft.mapleta.application.ApplicationResources" 
	scope="request"/>


<logic:messagesPresent>
<html:messages id="msg" message="false">
	<span class="errorStyle1"><c:out value='${msg}' escapeXml="false"/></span>
	<br>
</html:messages>
<br/>
</logic:messagesPresent>


<!-- ** put the Labels onto the screen ** -->
<tiles:insert definition=".gbk.page.labels">
	<tiles:put name="gradesTable" beanName="questionTable"/>
</tiles:insert>


<c:if test="${ questionTable.maxAttemptsPerPage >0 && (role == ADMINISTRATOR || role==INSTRUCTOR || role == PROCTOR) }">

<style>
      .containingbox{
      width:80%;
      }
      .floatright{
      float: right;
      }
      .floatleft{
      float: left;
      }
</style>       

      <div class="containingbox">&nbsp;
	      <div class="floatleft">
<fmt:message key="label.updateGrades.msg"/><input id="newGradeValue" type="text" size="3"/> 
<input type="button" value="<fmt:message key='label.updateGrades'/>" class="button" onclick="changeGradeValues('questions');"/>
<span style="display:none;" class="errorStyle1" id="newGradeError"><fmt:message key="label.newgrade.invalid.msg"/></span>
	      </div>
	      <div class="floatright">
<input type="button" value="<fmt:message key='label.editItemDetail.updateQuestion'/>" class="button" onclick="updateGrades('questions');"/>		      
	      </div>
      </div>
<br/>
</c:if>
<br/>

<table class="detailsTable" border="0" cellpadding="0" cellspacing="0">
	<tr class="header">
	
			<th>
				<table cellpadding="0" cellspacing="0">
					<tr>
						<td><input type="checkbox" onclick="selectAllItems(this);"/></td>
<%--
						<td><img width="15px" height="15px" class="question" src="<%=request.getContextPath()%>/modules/gbk/images/invert.jpg" title="<fmt:message key='label.invertSelection'/>" alt="<fmt:message key='label.invertSelection'/>"  onclick="reverseItems('questions');return false;"/></td>
 --%>
					</tr>
				</table>
			</th>
	<c:if test="${showUserHeaders}">
		<tiles:insert definition=".gbk.common.userheaders"/>
	</c:if>
	
			<tiles:insert definition=".gbk.common.gradeDataHeader">
				<tiles:put name="id" value="3"/>
			</tiles:insert>
	
	<c:choose>
		<c:when test="${viewSearchForm.sort eq SORT_POSITION}">
			<th colspan="2" class="header gradeDataTitle "><a class="sort " href="javascript:sort('<%= Constants.SORT_POSITION_DESC %>')"><fmt:message key="label.question"/></a></td>
		</c:when>
		<c:when test="${viewSearchForm.sort eq SORT_POSITION_DESC}">
			<th colspan="2" class="header gradeDataTitle "><a class="sort " href="javascript:sort('<%= Constants.SORT_POSITION %>')"><fmt:message key="label.question"/></a></td>
		</c:when>
<%--
		<c:otherwise>
			<th colspan="2" class="header gradeDataTitle"><a class="sort" href="javascript:sort('<%= Constants.SORT_POSITION %>')"><fmt:message key="label.question"/></a></td>
		</c:otherwise>
	</c:choose>
	<c:choose>
 --%>
 		<c:when test="${viewSearchForm.sort eq SORT_GRADE}">
			<th colspan="3" class="header gradeDataTitle sorted" style="min-width: 115px;"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_GRADE_DESC %>')"><fmt:message key="label.grade"/></a></td>
		</c:when>
		<c:when test="${viewSearchForm.sort eq SORT_GRADE_DESC}">
			<th colspan="3" class="header gradeDataTitle sorted" style="min-width: 115px;"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_GRADE %>')"><fmt:message key="label.grade"/></a></td>
		</c:when>
		<c:otherwise>
			<th colspan="3" class="header gradeDataTitle" style="min-width: 115px;"><a class="sort" href="javascript:sort('<%= Constants.SORT_GRADE %>')"><fmt:message key="label.grade"/></a></td>
		</c:otherwise>
	</c:choose>
	</tr>
	
 	<c:forEach var="line" items="${questionTable.questionLines}" varStatus="c">
	<c:set var="rowClass">
		<c:choose>
			<c:when test="${c.count mod 2 == 0}">even</c:when>
			<c:otherwise>odd</c:otherwise>
		</c:choose>
	</c:set>
	
		<c:set var="attempts">${fn:length(line.questionDetails)}</c:set>
		<c:set var="attempt">0</c:set>
	
		<c:forEach var="questionDetail" items="${line.questionDetails}" varStatus="c">
			<tr class="${rowClass}" style="text-align: center;">
<%--			<c:if test="${not empty line.user && c.count == 1}">	 --%>
				<c:choose>
					<c:when test="${empty questionDetail || questionDetail.emptyQuestionDetail}">
						<td style="text-align:center;"><fmt:message key="label.decorator.number.empty"/></td>
					</c:when>
					<c:otherwise>
						<td style="text-align:center;"><input type="checkbox" name="questions" value="${questionDetail.position}_${questionDetail.trId}"/></td>
					</c:otherwise>
				</c:choose>			
			<c:if test="${showUserHeaders}">
				<c:if test="${attempt == 0}">
					<c:if test="${viewSearchForm.showClassName}"><td rowspan="${line.numAttempts}" class="top className">${questionDetail.className}</td></c:if>	
					<c:if test="${viewSearchForm.showUid}"><td rowspan="${line.numAttempts}" class="top userInfo"><a class="block userLink" href="javascript:action('User','userId=${line.user.uid}')">${line.user.uid}</a></td></c:if>
					<c:if test="${viewSearchForm.showLastName}"><td rowspan="${line.numAttempts}" class="top userInfo"><a class="block userLink" href="javascript:action('User','userId=${line.user.uid}')">${line.user.sn}</a></td></c:if>
					<c:if test="${viewSearchForm.showMi}"><td rowspan="${line.numAttempts}" class="top userInfo"><a class="block userLink" href="javascript:action('User','userId=${line.user.uid}')">${line.user.mi}</a></td></c:if>
					<c:if test="${viewSearchForm.showGivenName}"><td rowspan="${line.numAttempts}" class="top userInfo"><a class="block userLink" href="javascript:action('User','userId=${line.user.uid}')">${line.user.givenName}</a></td></c:if>
					<c:if test="${viewSearchForm.showEmail}"><td rowspan="${line.numAttempts}" class="top userInfo"><a class="block userLink" href="javascript:action('User','userId=${line.user.uid}')">${line.user.email}</a></td></c:if>
					<c:if test="${viewSearchForm.showStudentId}"><td rowspan="${line.numAttempts}" class="top userInfo"><a class="block userLink" href="javascript:action('User','userId=${line.user.uid}')">${line.user.studentId}</a></td></c:if>		
				</c:if>
			</c:if>
						<tiles:insert definition=".gbk.common.gradeData">
							<tiles:put name="grade" beanName="questionDetail"/>
							<tiles:put name="attempt" value="${attempt}"/>
							<tiles:put name="attempts" value="${attempts}"/>
						</tiles:insert>
			
				<td id="item${questionDetail.position}_${questionDetail.trId}">
				<tiles:insert definition=".gbk.details.itemdetail.page">
					<tiles:put name="questionDetail" beanName="questionDetail" />
					<tiles:put name="asgn" beanName="asgn" />
					<tiles:put name="selectedUser" beanName="selectedUser" />
				</tiles:insert>
				</td>
			</tr>
			<c:set var="attempt">${attempt+1}</c:set>
		</c:forEach>
	</c:forEach>
</table>
