<br><%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ page import="com.maplesoft.mapleta.gateway.GatewayService"%>
<%@ page import="com.maplesoft.mapleta.session.Role" %>
<%@ page import="com.maplesoft.mapleta.session.Context" %>
<%@ page import="com.maplesoft.mapleta.gbk.Constants"%>

<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic" %>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<link rel="stylesheet" type="text/css" href="<%=GatewayService.getServerURL()%>modules/skin/css/gbk.css">
<link rel="stylesheet" type="text/css" href="<%=request.getContextPath()%>/modules/skin/css/repository.css">
<script src="<%=request.getContextPath()%>/modules/scripts/gbk.js"></script>
<script src="<%=request.getContextPath()%>/modules/scripts/ajax.js"></script>

<tiles:useAttribute name="selectedUser" ignore="true"/>
<tiles:useAttribute name="asgnDetail" ignore="true"/>

<c:set var="NUMERIC" value="<%= new Integer(Constants.NUMERIC_CODE) %>" scope="page"/>
<c:set var="LETTER" value="<%= new Integer(Constants.LETTER_CODE) %>" scope="page"/>
<c:set var="PERCENTAGE" value="<%= new Integer(Constants.PERCENTAGE_CODE) %>" scope="page"/>

<c:set var="ADMINISTRATOR"><%= Role.ADMINISTRATOR %></c:set>
<c:set var="INSTRUCTOR"><%= Role.INSTRUCTOR %></c:set>
<c:set var="PROCTOR"><%= Role.PROCTOR %></c:set>

<c:set var="role"><%= Context.getContext(request.getSession()).getRole() %></c:set>

<c:choose>
<c:when test="${role == ADMINISTRATOR || role==INSTRUCTOR || role == PROCTOR }">
	<em class="divider"><fmt:message key="label.details.instructor"/></em>
</c:when>
<c:otherwise>
	<em class="divider"><fmt:message key="label.details.student"/></em>
</c:otherwise>
</c:choose>
<br/>

<logic:messagesPresent>
<html:messages id="msg" message="false">
	<span class="errorStyle1"><c:out value='${msg}' escapeXml="false"/></span>
	<br>
</html:messages>
<br/>
</logic:messagesPresent>

<input type="hidden" id="refreshView" value="refresh.details.instructor"/>
<input type="hidden" id="detailView" value="view.instructor.details"/>
<%--
<html:hidden styleId="viewSearchFormQuGroup" property="quGroup"/>
 --%>

<div class="gbkInfo">
	<a href="#"
		onClick="toggleItem('gbkTRInfo'); this.blur(); return false;"> <span>
			<img src="modules/configureClasses/images/closeDirIcon.gif"
				border="0" id="gbkTRInfoTwisty"> 
${asgnDetail.asgnName}</span> </a>
	<div id="gbkTRInfoTable">

<table cellpadding="0" cellspacing="0">
	<tr>
		<td class="userInfoTitle"><strong><fmt:message key="label.score"/>:</strong></td>
		<td class="userInfoTitle"><strong><fmt:message key="label.duration"/>:</strong></td>
		<td>${asgnDetail.duration}</td>
	</tr>
	<tr>
		<td rowspan="2" title="${asgnDetail.score}" style="font-size:20px; text-align:center; width:120px; border:1px solid #ccc;">
		<span id="asgnDetailTotalScore">
	<c:choose>
		<c:when test="${viewSearchForm.gradingStyle == PERCENTAGE}">
			${asgnDetail.score.percent}
		</c:when>
		<c:when test="${viewSearchForm.gradingStyle == LETTER}">
			${asgnDetail.score.letter}
		</c:when>
		<c:otherwise>
			${asgnDetail.score}/${asgnDetail.score.total}
		</c:otherwise>
	</c:choose>
		</span>
		</td>
		
		<td class="userInfoTitle"><strong><fmt:message key="label.started"/>:</strong></td>
		<td>
			<fmt:formatDate value="${asgnDetail.start}" dateStyle="short" type="date" timeZone="${asgnDetail.timeZone}"/> <fmt:formatDate value="${asgnDetail.start}" timeStyle="medium" type="time" timeZone="${asgnDetail.timeZone}"/>
		</td>
	</tr>
	<tr>
		<td class="userInfoTitle"><strong><	fmt:message key="label.finished"/>:</strong></td>
		<td>
			<fmt:formatDate value="${asgnDetail.end}" dateStyle="short" type="date" timeZone="${asgnDetail.timeZone}"/> <fmt:formatDate value="${asgnDetail.end}" timeStyle="medium" type="time" timeZone="${asgnDetail.timeZone}"/>
		</td>
	</tr>
</table>
</div>
</div>

<div>
<tiles:insert definition=".gbk.info.userinfo" flush="false">
	<tiles:put name="selectedUser" beanName="selectedUser" />
</tiles:insert>
</div>
<br/>

<tiles:insert definition=".gbk.question.table.details" flush="false"/>

