<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://jakarta.apache.org/struts/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles" %>

<fmt:setBundle 
       basename="com.maplesoft.mapleta.application.ApplicationResources" 
	   scope="request"/>

<html>
<head>
	<script language="JavaScript">
		
		var baseURL = null;
		
		// update the hidden fields in the display pane and re-run the servlet
		function refresh() {
			// set the array item at this index to the new value
			var mathml = document.mathEditor.getPresentationMathML();

			// clear the 2D editor
			document.mathEditor.setMathML("");
			
			// update the display frame's value
			parent.frames["displayPane"].setNewValue(mathml);
			
			// submit the form to regenerate itself
//			parent.frames["displayPane"].document.forms["editor_form"].submit();
		}
		
		// clears the contents of the 2D editor and resets the index pointer in the view
		function clear() {
			parent.frames["displayPane"].updatePointer();
			document.mathEditor.setMathML("");
		}
		
		// displays help
		function help() {		
			baseURL = parent.frames["displayPane"].baseURL;
			getHelp('instructor_math_editor');			
		}
		
		function getBaseuURL() {
			var components = window.location.pathname.split("/");
			var context = components[1];
			var url = window.location.protocol + "//" + window.location.host + "/" + context + "/";
			return url;
		}
		
		function getContext() {
			var components = window.location.pathname.split("/");
			var context = components[1];
			return context;
		}
		
	</script>
</head>

<script language="JavaScript">
// strings for main.js
var msgMainScriptImminentSessionTimeoutWarningPart1 = "<fmt:message key='msg.Main.Script.ImminentSessionTimeoutWarning.Part1' />";
var msgMainScriptImminentSessionTimeoutWarningPart2 = "<fmt:message key='msg.Main.Script.ImminentSessionTimeoutWarning.Part2' />";
var msgMainScriptTimedAssignmentWarning = "<fmt:message key='msg.Main.Script.TimedAssignmentWarning' />";
var msgMainScriptFinishOtherAssignmentFirst = "<fmt:message key='msg.Main.Script.FinishOtherAssignmentFirst' />";
</script>

<tiles:insert page="/WEB-INF/tiles/javascript.jsp" beanScope="request" flush="false" />

<script language="JavaScript" src="../scripts/buttons.js"></script>
<script language="JavaScript" src="../scripts/main.js"></script>
<script language="JavaScript" src="../scripts/helpURLs.js"></script>

<LINK href="../skin/css/main.css" rel="stylesheet" type="text/css">
	

<div align="center">
	<table>
		<tr border=1>
			<td><script language="JavaScript">drawCSSButton("cancelButton", "<fmt:message key='JspDefault.Update.Button'/>", "refresh();", "button");</script></td>
			<td><script language="JavaScript">drawCSSButton("cancelButton", "<fmt:message key='JspDefault.Clear.Button'/>", "clear();", "button");</script></td>			
		</tr>
	</table>
	
	<p><fmt:message key="MathEditor.RightClickForSymbols.Label" /></p>
	<table cellpadding=2 class="mathedittable">
		<tr>
			<td valign=top>
				<span class="mathedit"><fmt:message key="Common.EquationEditor.Label" /></span></td><td align=right class="mathedithelp"></td>
				</tr><tr><td colspan=2 valign=top>
					<script type="text/javascript">
						var s="<applet code='applets.twodeeeditor.mathEditor' name='mathEditor' width='500' height='120' id='mathEditor' archive='/" + getContext() + "/modules/applets.jar, /" + getContext() + "/modules/MapleViewer11.jar'>";
						document.write(s);
					</script>
						<PARAM NAME="codebase_lookup" value="false" />
						<PARAM NAME="scriptable" VALUE="true"> 
						<PARAM NAME="mathmlWidth" value="480"> 
						<PARAM NAME="mathmlHeight" value="110">
						<PARAM NAME="application" VALUE="mapleta">
						<PARAM NAME="tooltip" VALUE="Right click to access the symbol palette.">
						<PARAM NAME="INPUT_TYPE" value="MathML Content">
						<PARAM NAME="VERTICAL_OFFSET" value="0"> 
						<PARAM NAME="palette" value="basic">
						<PARAM NAME="paletteContent" value="
		<tb>
		   <btn>LAYOUTPALETTE</btn>
		   <sub cols=3>
		     <btn>LAYOUTPALETTE</btn><sub cols=3><incl name=#layout/></sub>
		     <btn>ACCENTPALETTE</btn><sub cols=2><incl name=#accents/></sub>
		     <btn>FENCEPALETTE</btn><sub cols=2><incl name=#fences/></sub>
		   </sub>
		   <btn>CALCPALETTE</btn>
		   <sub cols=3>
		     <btn>CALCPALETTE</btn><sub cols=3><incl name=#calculus/></sub>
		     <btn>TRIGPALETTE</btn><sub cols=3><incl name=#trig/></sub>
		     <btn>MATRIXPALETTE</btn><sub cols=4><incl name=#matrix/></sub>
		   </sub>
		   
		   <btn>OPERATORPALETTE</btn>
		   <sub cols=4>
		     <btn>OPERATORPALETTE</btn>
		     <sub cols=2>
		       <btn>OPERATORPALETTE</btn><sub cols=4><incl name=#operators/></sub>
		       <btn>EXOPPALETTE</btn><sub cols=4><incl name=#exop/></sub>
		     </sub>
		     <btn>ARROWPALETTE</btn>
		     <sub cols=1>
		       <sub cols=3><incl name=#arrows/></sub>
		     </sub>
		     <btn>RELATIONPALETTE</btn>
		     <sub cols=3>
		       <btn>RELATIONPALETTE</btn><sub cols=4><incl name=#relations/></sub>
		       <btn>EXRELPALETTE</btn><sub cols=4><incl name=#exrel/></sub>
		       <btn>EQUIVPALETTE</btn><sub cols=2><incl name=#equiv/></sub>
		     </sub>
		     <btn>SETTHEORYPALETTE</btn>
		     <sub cols=2>
		       <btn>SETTHEORYPALETTE</btn><sub cols=4><incl name=#settheory/></sub>
		       <btn>LOGICPALETTE</btn><sub cols=3><incl name=#logic/></sub>
		     </sub>
		   </sub>
		   
		   
		   <btn>SYMBOLPALETTE</btn>
		   <sub cols=3>
		     <btn>LCGREEKPALETTE</btn><sub cols=4><incl name=#greek/></sub>
		     <btn>UCGREEKPALETTE</btn><sub cols=4><incl name=#Greek/></sub>
		     <btn>VARIANTPALETTE</btn><sub cols=4>
		       <btn>infin</btn>
		       <btn>reals</btn>
		       <btn>rationals</btn>
		       <btn>integers</btn>
		       <incl name=#variants/>
		     </sub>
		   </sub>
		   <sep/>
		   <btn>TOOLBOX</btn><sub cols=3><incl name=#toolbox/></sub>
		   <btn>HELP</btn>
		</tb>">
		
									
					</applet>
			</td>
		</tr>
	</table>
</div>

</html>
